/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crGFX.h"

#include <string.h> // memset

// ----------------------------------------------------------------------------
#define TEXWIDTH 32
#define TEXHEIGHT 32

#define WIDTH 30 // 48
#define HEIGHT 33 // 48

// ----------------------------------------------------------------------------
unsigned int g_frameTunnel2Ptr;

unsigned int offsetY;

unsigned char texel;

unsigned int lut;
unsigned char lutx;
unsigned char luty;

unsigned int cy;
unsigned int cx;

// ----------------------------------------------------------------------------
void __LIB__ crGFXCreateMonoTunnelFrame(	unsigned char *screenPtr, // 10
											unsigned char *imagePtr, // 8
											unsigned int *fxPtr, // 6
											unsigned int offsetX, // 4
											unsigned int offsetY ) // 2
{
	/*unsigned int offsetY = 0;

	for ( cy = 0; cy < HEIGHT; cy++ )
	{
		for ( cx = 0; cx < WIDTH; cx++)
		{
			lut = fxPtr[ offsetY + cx ];

			lutx = ( lut + offset ) & ( TEXWIDTH - 1 );
			luty = ( ( lut >> 8 ) + offset ) & ( TEXHEIGHT - 1 );

			if ( lut != 0 )
			{
				texel = imagePtr[ lutx + ( luty << 5 ) ];

				crGFXDrawPixel( cx<<3, cy, texel );
			}
		}

		offsetY += WIDTH;
	}*/


#asm
	ld ix, 0;
	add	ix, sp;

	ld h, ( ix + 9 ); // hl = imagePtr
	ld l, ( ix + 8 );
	ld ( baseImage + 1 ), hl;

	ld h, ( ix + 7 ); // hl = fxPtr
	ld l, ( ix + 6 );
	ld ( fxPtrLine + 1 ), hl;

	ld h, ( ix + 5 ); // hl = offsetX
	ld l, ( ix + 4 );
	ld ( offsetX ), hl;

	ld h, ( ix + 3 ); // hl = offsetY
	ld l, ( ix + 2 );
	ld ( offsetY ), hl;

	exx;
	ld d, ( ix + 11 ); // de = screenPtr
	ld e, ( ix + 10 );
	exx;

	ld a, ( table + 2 );
	or a;
	jp nz, noPreca;
	ld ix, table;
.baseImage
	ld hl,0;
	ld bc, 64;
	ld a, 64;
.preca
	ld ( ix + 0 ), l;
	ld ( ix + 1 ), h;
	inc ix;
	inc ix;
	add hl, bc;
	dec a;
	jp nz, preca;
.noPreca

	ld h, HEIGHT;
	ld l, WIDTH;

.startloop
	ld a, l;
	exx;
.fxPtrLine
	ld hl, 0; // hl = offsetY * 2

	dec a;
	rla;
	ld c, a;
	xor a;
	ld b, a;

	add hl, bc; // fxPtr[ offsetY + cx ];

	ld a, ( hl );
	cp 255;
	jp nz, ok;
.holePixel
	ld a, $c5;
	ld ( de ), a;
	inc de;
	jp endloop_cx;
.ok
	inc hl;
	ld h, ( hl );
	ld l, a; // hl = lut

	ld a, ( offsetX ); // lutx (offset+1 ??)  ( lut + offset ) & ( TEXWIDTH - 1 );
	add a, l;
	and 63;
	ex af, af;

	ld a, ( offsetY ); // luty (offset+1 ??)  ( ( lut >> 8 ) + offset ) & ( TEXHEIGHT - 1 );
	add a, h;
	and 63;
	
	ld h, 0;
	rla;
	ld l, a;

	ld bc, table;
	add hl, bc;
	ld a, ( hl );
	inc hl;
	ld h, ( hl );
	ld l, a;

	ex af, af;
	ld c, a;
	ld b, 0; // bc = lutx
	add hl, bc;

	ldi;

.endloop_cx
	exx;
	dec l;
	jp nz, startloop;

	ld l, WIDTH;
	exx;

	ld hl, ( fxPtrLine + 1 );
	ld bc, 48*2; // WIDTH * 2;
	add hl, bc;
	ld ( fxPtrLine + 1 ), hl;

	exx;

	dec h;
	jp nz, startloop;

	exx;

	jp end;

.offsetX
	defw 0;

.offsetY
	defw 0;

.table
	defs 64 * 2, 0;

.end
	ld ( _g_frameTunnel2Ptr ), de;
#endasm
}
