/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crTEXT.h"
#include "crCRTC.h"
#include "crBANK.h"

#include <string.h> // memcpy

// ----------------------------------------------------------------------------
unsigned char fontCharWidth;
unsigned char fontCharHeight;

unsigned int fontAdress;
unsigned char fontCharsPerLine;

unsigned int iTextAdress;

unsigned int basePosY;

unsigned char pixel;

unsigned char *fontCharSet;

unsigned char *scanline;
unsigned int posY;
unsigned char iChar;
unsigned int *fontCharAdress;
unsigned int fontCharAdressOffset;
unsigned char *src;

// ----------------------------------------------------------------------------
void __LIB__ crTEXTDrawScrollerY( struct SFont *font, unsigned int text, struct SScroll *scroll )
{
	switch( font->fontBank )
	{
		case 0xC4: crBANKSetC4( ); break;
		case 0xC5: crBANKSetC5( ); break;
		case 0xC6: crBANKSetC6( ); break;
		case 0xC7: crBANKSetC7( ); break;

		default:
		case 0xC0: crBANKSetC0( ); break;
	}

	iTextAdress = text + scroll->textOffset;

	posY = scroll->posY + scroll->charOffset;

	scanline = scroll->posX + crCRTCGetScanline( posY );

	fontCharAdressOffset = scroll->charOffset * font->fontPitch;
	fontCharAdress = font->fontCharAdress;
	fontCharWidth = font->fontCharWidth;

	for ( iChar = 0; iChar < 12; iChar++ )
	{
		src = fontCharAdress[ *(unsigned char *) iTextAdress ] + fontCharAdressOffset;
		memcpy( scanline, src, fontCharWidth );

		scanline += fontCharWidth;
		iTextAdress++;
	}

	scroll->charOffset++;
	if ( scroll->charOffset == font->fontCharHeight )
	{
		scroll->charOffset = 0;

		scroll->posY += font->fontCharHeight;

		scroll->textOffset += 12;
		if ( *(unsigned char *)( text + scroll->textOffset ) == 0 )
		{
			scroll->textOffset = 0;
		}
	}

	if ( scroll->posY > font->fontCharHeight * 3 )
	{
		scroll->posY = 0;
	}

	crBANKSetC0( );
}
