/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crTEXT.h"
#include "crCRTC.h"
#include "crBANK.h"

#include <string.h> // memcpy

unsigned int fontAdress;
unsigned char *fontCharSet;
unsigned int fontCharsPerLine;
unsigned char fontCharWidth;
unsigned char fontCharHeight;
unsigned int iTextAdress;
unsigned int basePosY;

unsigned char *scanline;
unsigned int fontCharAdress;
unsigned int iFontCharY;

// ----------------------------------------------------------------------------
void __LIB__ crTEXTDrawString( struct SFont *font, unsigned int text, unsigned int screenPage, unsigned int posX, unsigned int posY )
{
	fontAdress = font->fontAdress;
	fontCharSet = font->fontCharSet;
	fontCharsPerLine = font->fontCharsPerLine;
	fontCharWidth = font->fontCharWidth;
	fontCharHeight = font->fontCharHeight;
	iTextAdress = text;
	basePosY = posY;

	switch( font->fontBank )
	{
		case 0xC4: crBANKSetC4( ); break;
		case 0xC5: crBANKSetC5( ); break;
		case 0xC6: crBANKSetC6( ); break;
		case 0xC7: crBANKSetC7( ); break;

		default:
		case 0xC0: crBANKSetC0( ); break;
	}

	while ( ( *(unsigned char *) iTextAdress ) != 0 )
	{
		fontCharAdress = font->fontCharAdress[ *(unsigned char *) iTextAdress ];
		
		for ( iFontCharY = 0; iFontCharY < fontCharHeight; iFontCharY++ )
		{
			scanline = posX + crCRTCGetScanline( posY );

			memcpy( scanline, fontCharAdress, fontCharWidth );
			fontCharAdress += font->fontPitch;

			posY++;
		}

		iTextAdress++;

		posX += fontCharWidth;
		posY = basePosY;
	}

	crBANKSetC0( );
}
