/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crTEXT.h"

// ----------------------------------------------------------------------------
void __LIB__ crTEXTInitFont( struct SFont *font )
{
	unsigned char found;
	unsigned char *fontCharSet;
	unsigned int iChar;
	unsigned int iX;
	unsigned int iY;
	
	font->fontPitch = font->fontCharsPerLine * font->fontCharWidth;
	
	fontCharSet = font->fontCharSet;
	
	iX = 0;
	iY = 0;

	while ( ( *fontCharSet ) != 0 )
	{
		font->fontCharAdress[ *fontCharSet ] = font->fontAdress + iX + iY;

		iX += font->fontCharWidth;
		if ( iX >= font->fontPitch )
		{
			iX = 0;
			iY += font->fontCharHeight * font->fontPitch;
		}

		fontCharSet++;
	}
}
