/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include <string.h> // memset

#include "Demo.h"

#include "Interference.h"

// ----------------------------------------------------------------------------
unsigned char *s_dataPtr = (unsigned char *) 0x3600; 
#define GETDATAPTR( offset ) ( (unsigned char *) ( s_dataPtr + offset ) )

// ----------------------------------------------------------------------------
static void init( );
static void frameUpdate( );
static int isFinished( );

// ----------------------------------------------------------------------------
void main( )
{
#asm
	ei;
	ld sp, $1500 - 2;
#endasm

	crASICIsBegin( );
	crBANKGetBank( );

	playMusic( );

	init( );

	playMusic( );

	while ( isFinished( ) == 0 )
	{
		frameUpdate( );

		playMusic( );
	}

#asm
	ld hl, ( $1500 - 2);
	jp ( hl );
#endasm
}

// ----------------------------------------------------------------------------
static unsigned int s_palette[ 17 ];

// ----------------------------------------------------------------------------
#define BITMAP_PTR					( 0x3C00 ) 
#define BITMAP_WIDTH				96
#define BITMAP_HEIGHT				96

#define FRAMETIME					170

#define RENDER_BUFFER				( 0x7000 )

#define MAXSINCOS					360
#define MEM_COSX					( 0x6000 )
#define MEM_COSY					( MEM_COSX + MAXSINCOS * 2 )

// ----------------------------------------------------------------------------
static int s_interVBLCount;
static int s_isInterFinished;

static int *s_cosX = (int *) ( MEM_COSX );
static int *s_cosY = (int *) ( MEM_COSY );

static int s_moveX = 0;
static int s_moveY = 0;
static int s_moveX2 = 0;
static int s_moveY2 = 0;

static unsigned char *ptr1;
static unsigned char *ptr2;

// ----------------------------------------------------------------------------
void init( )
{
	s_interVBLCount = 0;
	s_isInterFinished = 0;

	crPACKERUnpack( BITMAP_PTR, GETDATAPTR( DATA_INTER ) );
	
	playMusic( );

	crCRTCSetupScreen( CRTC_OVERSCAN_VERTICAL, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGESIZE_16KB );

	playMusic( );

	memset( 0x8000, 0, 0x8000 );

	playMusic( );

	{
		int i;

		long sx = ( 96 - 30 ) / 2;
		long sy = ( 96 - 33 ) / 2;

		for ( i = 0; i < MAXSINCOS; i++ )
		{
			playMusic( );

			s_cosX[ i ] = div16384( (long) isin( i ) * sx );
			s_cosY[ i ] = div16384( (long) icos( i ) * sy );

			s_cosX[ i ] += ( 96 - 30 ) / 2;
			s_cosY[ i ] += ( 96 - 33 ) / 2;
		}

		s_moveX = 23;
		s_moveY = 23;
		s_moveX2 = 234;
		s_moveY2 = 234;
	}

	playMusic( );

	memset( s_palette, 0, 16 * 2 );
	crASICSetPalette( s_palette );

	crGASetMode( 1 );
}

// ----------------------------------------------------------------------------
void frameUpdate( )
{	
	crCRTCFlipScreen( );

	if ( s_interVBLCount < 7 )
	{
		s_palette[ 0 ] += 0x000;
		s_palette[ 1 ] += 0x011;
		s_palette[ 2 ] += 0x011;
		s_palette[ 3 ] += 0x012;

		crASICSetPalette( s_palette );
	}
	else
	if ( s_interVBLCount >= (FRAMETIME - 7 ) )
	{
		s_palette[ 0 ] -= 0x000;
		s_palette[ 1 ] -= 0x011;
		s_palette[ 2 ] -= 0x011;
		s_palette[ 3 ] -= 0x012;

		crASICSetPalette( s_palette );
	}

	s_moveX += 5;
	while ( s_moveX >= MAXSINCOS )
	{
		s_moveX -= MAXSINCOS;
	}
	s_moveY += 3;
	while ( s_moveY >= MAXSINCOS )
	{
		s_moveY -= MAXSINCOS;
	}

	s_moveX2 -= 8;
	if ( s_moveX2 < 0 )
	{
		s_moveX2 += MAXSINCOS;
	}
	s_moveY2 -= 6;
	if ( s_moveY2 < 0 )
	{
		s_moveY2 += MAXSINCOS;
	}

	ptr1 = BITMAP_PTR;
	ptr1 += s_cosX[ s_moveX ];
	ptr1 += ( s_cosY[ s_moveY ] * 96 );

	ptr2 = BITMAP_PTR;
	ptr2 += s_cosX[ s_moveX2 ];
	ptr2 += ( s_cosY[ s_moveY2 ] * 96 );
	
	playMusic( );

	crGFXCreateMonoInterFrame( RENDER_BUFFER, ptr1, ptr2 );
	
	playMusic( );

	crGFXDrawMonoFrame( crCRTCGetScanline( 0 ), RENDER_BUFFER, g_frameInterPtr );
	
	s_interVBLCount++;
	if ( s_interVBLCount > (FRAMETIME-1) )
	{		
		s_isInterFinished = 1;
	}
}

// ----------------------------------------------------------------------------
int isFinished( )
{
	return s_isInterFinished;
}
