/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include <string.h> // memset

#include "Demo.h"

#include "Nuages2.h"

// ----------------------------------------------------------------------------
unsigned char *s_dataPtr = (unsigned char *) 0x3600;
#define GETDATAPTR( offset ) ( (unsigned char *) ( s_dataPtr + offset ) )

// ----------------------------------------------------------------------------
static void init( );
static void frameUpdate( );
static int isFinished( );

// ----------------------------------------------------------------------------
void main( )
{
#asm
	ei;
	ld sp, $1500 - 2;
#endasm

	crASICIsBegin( );
	crBANKGetBank( );

	playMusic( );

	init( );
	
	playMusic( );

	while ( isFinished( ) == 0 )
	{
		frameUpdate( );

		playMusic( );
	}

#asm
	ld hl, ( $1500 - 2);
	jp ( hl );
#endasm
}

// ----------------------------------------------------------------------------
static unsigned int s_palette[ 17 ];

// ----------------------------------------------------------------------------
#define NUAGES1_PTR		0x7000
#define NUAGES2_PTR		0x7A00

#define FRAMETIME 600

// ----------------------------------------------------------------------------
static unsigned char *s_screen;

static int s_compareValue;
static unsigned char s_doClear;

static int s_isFinished;

static int s_VBLCount;

static int posY;
static int height;

// ----------------------------------------------------------------------------
static void init( )
{
	s_isFinished = 0;
	s_VBLCount = 0;

	/*s_compareValue = 0;
	s_doClear = 0;
	
	crPACKERUnpack( 0x8000, GETDATAPTR( DATA_VISAGE ) );
	crPACKERUnpack( NUAGES2_PTR, GETDATAPTR( DATA_NUAGES_2 ) );
	crPACKERUnpack( NUAGES1_PTR, GETDATAPTR( DATA_NUAGES2_2 ) );
	
	s_screen = 0xC000;
	memset( s_screen, 0, 0x4000 );

	crSYNCWaitVBL( );
	crGASetMode( 0 );
	crGASetColor( BORDER, COLOR_BLACK );
	crGASetColor( BKGRD, COLOR_BLACK );

	crSYNCWaitVBL( );
	crCRTCSetupScreen( CRTC_OVERSCAN_VERTICAL, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGESIZE_16KB );

	memcpy( s_palette, GETDATAPTR( DATA_VISAGE_PAL ) + 8, 16 * 2 );
	s_palette[ 16 ] = 0;*/

	memset( s_palette, 0, 16 * 2 );
	crSYNCWaitVBL( );
	crGASetColor( BORDER, COLOR_BLACK );
	crASICSetPalette( s_palette );

	crSYNCWaitVBL( );
	crCRTCSetupScreen( CRTC_OVERSCAN_FULLSCREEN_CONVIMGCPC, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGESIZE_32KB );

	playMusic( );

	crPACKERUnpack( 0x8000, GETDATAPTR( DATA_CHAOS ) );
	
	playMusic( );

	crGASetMode( 0 );

	memcpy( s_palette, GETDATAPTR( DATA_CHAOS_PAL ) + 8, 16 * 2 );
	s_palette[ 16 ] = 0;

	posY = 34;
	height = 0;
}

// ----------------------------------------------------------------------------
static void frameUpdate( )
{
	crSYNCWaitVBL( );
	crSYNCWaitVBL( );

	if ( s_VBLCount < 34 )
	{
		posY--;
		height++;
	}
	if ( s_VBLCount >= FRAMETIME-34 )
	{
		posY++;
		height--;
	}

	//crCRTCSetPosY( 34 + posY );
	crCRTCSetHeight( height );

	s_VBLCount++;
	if ( s_VBLCount == FRAMETIME )
	{
		s_isFinished = 1;
	}

	crASICSetPalette( s_palette );
}

// ----------------------------------------------------------------------------
static int isFinished( )
{
	return s_isFinished;
}
