/*
This file is part of CrocoLib.

CrocoLib is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

CrocoLib is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include <string.h> // memset

#include "Demo.h"

#include "RotoZoom.h"

// ----------------------------------------------------------------------------
unsigned char *s_dataPtr = (unsigned char *) 0x3600; 
#define GETDATAPTR( offset ) ( (unsigned char *) ( s_dataPtr + offset ) )

// ----------------------------------------------------------------------------
static void init( );
static void frameUpdate( );
static int isFinished( );

// ----------------------------------------------------------------------------
void main( )
{
#asm
	ei;
	ld sp, $1500 - 2;
#endasm

	crASICIsBegin( );
	crBANKGetBank( );

	playMusic( );

	init( );

	playMusic( );

	while ( isFinished( ) == 0 )
	{
		frameUpdate( );

		playMusic( );
	}

#asm
	ld hl, ( $1500 - 2);
	jp ( hl );
#endasm
}

// ----------------------------------------------------------------------------
static unsigned int s_palette[ 17 ];

// ----------------------------------------------------------------------------
#define PACKED_ROTOBITMAP			( 0x4000 + 11997 ) 
#define UNPACKED_ROTOBITMAP_SIZE	( 64 * 64 )
#define UNPACKED_ROTOBITMAP_PTR		( 0x4000 )

#define ROTOZOOM_BUFFER				( 0x5300 ) // ( UNPACKED_ROTOBITMAP_PTR + UNPACKED_ROTOBITMAP_SIZE )
#define ROTOZOOM_WIDTH				30 
#define ROTOZOOM_HEIGHT				33

#define ROTOZOOM_BUFFER_SIZE		( ( ROTOZOOM_WIDTH * ROTOZOOM_HEIGHT * 4 ) + 3 ) // ld bc, 0 (=3) push bc (=1) +jp (=3)
#define ROTOZOOM_BUFFER_END			( ROTOZOOM_BUFFER + ROTOZOOM_BUFFER_SIZE )

#define ROTOZOOM_RATIOBUFFER		( ROTOZOOM_BUFFER + ROTOZOOM_BUFFER_SIZE )
#define ROTOZOOM_XXBUFFER			( ROTOZOOM_RATIOBUFFER + 360*2 )
#define ROTOZOOM_YYBUFFER			( ROTOZOOM_XXBUFFER + 360*2 )
#define ROTOZOOM_MOVEXBUFFER		( ROTOZOOM_YYBUFFER + 360*2 )
#define ROTOZOOM_MOVEYBUFFER		( ROTOZOOM_MOVEXBUFFER + 360*2 )

#define ROTOZOOM_FRAMETIME			(65*2) //( 86 * 2 )

// ----------------------------------------------------------------------------
static int s_rotozoomVBLCount;
static int s_isRotozoomFinished;

static unsigned int s_alpha;
static unsigned int s_scale;

unsigned int x;
unsigned int y;
unsigned char *ptr = (unsigned char*) UNPACKED_ROTOBITMAP_PTR;

int i;
int _i;
int *ratioBuffer = (int *) ROTOZOOM_RATIOBUFFER;
int *xxBuffer = (int *) ROTOZOOM_XXBUFFER;
int *yyBuffer = (int *) ROTOZOOM_YYBUFFER;

int *moveXBuffer = (int *) ROTOZOOM_MOVEXBUFFER;
int *moveYBuffer = (int *) ROTOZOOM_MOVEYBUFFER;

int xx;
int yy;

int xSin;
int ySin;

int iMoveX;
int iMoveY;

long ratioLong;

unsigned int u
unsigned int v;
unsigned int _u;
unsigned int _v;

unsigned char texel;

int ratio;

unsigned char *dest;
unsigned char *source;

// ----------------------------------------------------------------------------
void init( )
{
	s_rotozoomVBLCount = 0;
	s_isRotozoomFinished = 0;

	s_alpha = 0;
	s_scale = 0;

	// crPACKERUnpack( UNPACKED_ROTOBITMAP_PTR, GETDATAPTR( DATA_IMAGE ) );
	{
		for ( y = 0; y < 64; y++ )
		{
			playMusic( );

			for ( x = 0; x < 64; x++ )
			{
				*ptr = ( y & 31 ) >= 16 ? ( ( x & 31 ) < 16 ? 0xC5 : 0xE5 ) : ( ( x & 31 ) < 16 ? 0xE5 : 0xC5 );

				ptr++;
			}
		}

	}
	
	memset( 0x8000, 0, 0x8000 );

	playMusic( );

	crCRTCSetupScreen( CRTC_OVERSCAN_VERTICAL, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGESIZE_16KB );

	{
		ratioBuffer = (int *) ROTOZOOM_RATIOBUFFER;
		xxBuffer = (int *) ROTOZOOM_XXBUFFER;
		yyBuffer = (int *) ROTOZOOM_YYBUFFER;

		moveXBuffer = (int *) ROTOZOOM_MOVEXBUFFER;
		moveYBuffer = (int *) ROTOZOOM_MOVEYBUFFER;

		//crBANKSetC4( );

		for ( i = 180; i < 360+180; i++ )
		{
			playMusic( );
			
			_i = i;
			if ( _i >= 360 )
			{
				_i -= 360;
			}

			ratioLong = 300 + (int) ( div16384( (long) icos( _i ) * (long)( 280 ) ) );

			xx = (int) ( div16384( (long) icos( _i ) * (long)( ratioLong ) ) );
			
			playMusic( );

			yy = (int) ( div16384( (long) isin( _i ) * (long)( ratioLong ) ) );
			
			playMusic( );

			xxBuffer[ i - 180 ] = xx;
			yyBuffer[ i - 180 ] = yy;

			iMoveX = _i * 2 + 0;
			while ( iMoveX >= 360 )
			{
				iMoveX -= 360;
			}

			iMoveY = _i * 2 + 90;
			while ( iMoveY >= 360 )
			{
				iMoveY -= 360;
			}

			playMusic( );

			xSin = ( ( ROTOZOOM_WIDTH / 2 ) + 1 ) + (int) ( div16384( (long) icos( iMoveX ) * (long)( ( ROTOZOOM_WIDTH / 2 ) ) ) );
			
			playMusic( );

			ySin = ( ( ROTOZOOM_HEIGHT / 2 ) + 1 ) + (int) ( div16384( (long) isin( iMoveY ) * (long)( ( ROTOZOOM_HEIGHT / 2 ) ) ) );

			moveXBuffer[ i - 180 ] = ( xSin * xx ) - ( ySin * yy );
			moveYBuffer[ i - 180 ] = ( xSin * yy ) + ( ySin * xx );
		}

		//crBANKSetC0( );
	}

	// crGFXCreateFrame( (unsigned char *) ROTOZOOM_BUFFER );
	
	playMusic( );

	memset( s_palette, 0, 16 * 2 );
	crASICSetPalette( s_palette );

	crGASetMode( 1 );
}

// ----------------------------------------------------------------------------
void frameUpdate( )
{	
	crCRTCFlipScreen( );

	if ( s_rotozoomVBLCount < 7 )
	{
		s_palette[ 0 ] += 0x000;
		s_palette[ 1 ] += 0x001;
		s_palette[ 2 ] += 0x001;
		s_palette[ 3 ] += 0x002;

		crASICSetPalette( s_palette );
	}
	else
	if ( s_rotozoomVBLCount >= (ROTOZOOM_FRAMETIME-7 ) )
	{
		s_palette[ 0 ] -= 0x000;
		s_palette[ 1 ] -= 0x001;
		s_palette[ 2 ] -= 0x001;
		s_palette[ 3 ] -= 0x002;

		crASICSetPalette( s_palette );
	}

	{
		u = 0;
		v = 0;
		
		source = (unsigned char *) UNPACKED_ROTOBITMAP_PTR;

		xxBuffer = (int *) ROTOZOOM_XXBUFFER;
		yyBuffer = (int *) ROTOZOOM_YYBUFFER;

		dest = (unsigned char *) ( ROTOZOOM_BUFFER );
		source = (unsigned char *) UNPACKED_ROTOBITMAP_PTR;

		moveXBuffer = (int *) ROTOZOOM_MOVEXBUFFER;
		moveYBuffer = (int *) ROTOZOOM_MOVEYBUFFER;

		s_alpha += 4;
		if ( s_alpha >= 360 )
		{
			s_alpha -= 360;
		}

		s_scale += 1;
		if ( s_scale >= 360 )
		{
			s_scale -= 360;
		}

		xx = xxBuffer[ s_alpha ];
		yy = yyBuffer[ s_alpha ];

		u -= moveXBuffer[ s_alpha ];
		v -= moveYBuffer[ s_alpha ];

		playMusic( );

		crGFXCreateMonoRotoZoomFrame( dest, source, u, v, xx, yy );
	}

	playMusic( );

	crGFXDrawMonoFrame3( crCRTCGetScanline( 0 ), ROTOZOOM_BUFFER, g_framePtr );

	s_rotozoomVBLCount++;
	if ( s_rotozoomVBLCount > (ROTOZOOM_FRAMETIME-1) )
	{
		s_isRotozoomFinished = 1;
	}
}

// ----------------------------------------------------------------------------
int isFinished( )
{
	return s_isRotozoomFinished;
}
