/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include <string.h> // memset

#include "Demo.h"

#include "Solar.h"

// ----------------------------------------------------------------------------
unsigned char *s_dataPtr = (unsigned char *) 0x3600; 
#define GETDATAPTR( offset ) ( (unsigned char *) ( s_dataPtr + offset ) )

// ----------------------------------------------------------------------------
static void init( );
static void frameUpdate( );
static int isFinished( );

// ----------------------------------------------------------------------------
void main( )
{
#asm
	ei;
	ld sp, $1500 - 2;
#endasm

	crASICIsBegin( );
	crBANKGetBank( );

	playMusic( );

	init( );

	playMusic( );

	while ( isFinished( ) == 0 )
	{
		frameUpdate( );

		playMusic( );
	}

#asm
	ld hl, ( $1500 - 2);
	jp ( hl );
#endasm
}

// ----------------------------------------------------------------------------
static unsigned int s_palette[ 17 ];

// ----------------------------------------------------------------------------
static int s_solarVBLCount;
static int s_isSolarFinished;

struct SFont s_solarFont;
struct SFont s_solar2Font;

static int s_initCount;
static int s_bgCount;
static int s_textCount;

static int s_SOLARIndex;

int i;

unsigned char *t2[ ] =
{
	"NOW", "SOME", "COOL", "FACTS", "ABOUT", "THIS", "PROD",
	"WRITTEN", "IN", "C", "LANGUAGE", "USING", "Z88DK.ORG", "COMPILER",
	"DEMO", "CREATED", "AT", "MONTREAL", "CANADA",
	"CODE", "NORECESS", "MUSIC", "FATAL", "SNIPE", "TECHNICAL", "SUPPORT", "GRIM", "RIPPED", "GRAPHICS", "RAZORBACK", "MUSTAFA",
	"I", "LOVE", "YOU", "ALL",
};
unsigned char pos1[] = { 12,6, 11,9, 13,12, 14,15, 11,18, 13,21, 12,24 };
unsigned char pos2[] = { 12,6, 14,9, 14,12, 11,15, 14,18, 12,21, 11,24 };
unsigned char pos3[] = { 10,10, 12,13, 11,16, 9,19, 12, 22 };
unsigned char pos4[] = { 8,4, 9,6, 11,10, 10,12, 10+6,12, 5,16, 5+10,16, 11,18, 6,22, 6+7,22, 11,24, 14,26 };
unsigned char pos5[] = { 15,12, 13,15, 13,18, 15,21 };

unsigned char *t[ ] =
{
	"I", "HAVE", "AN", "ANNOUNCE", "TODAY", "FOR", "YOU", "GUYS",
	"NORECESS", "IS", "BACK",
	"LOOKS", "LIKE", "I", "DID", "MISS", "YOU", "EHEHE"
}

unsigned char first1[] = { 11,4, 10,7, 13,10, 11,13, 8,16, 12,19, 14,22, 16,25 };
unsigned char first2[] = { 11,13, 12,16, 13,19 };
unsigned char first3[] = { 13,7, 12,10, 11,13, 12,16, 11,19, 13,22, 14,25 };

unsigned char tCount = 0;

int isSecondTime;

int maxText = 2;

// ----------------------------------------------------------------------------
#define TEXTCOUNT 70

// ----------------------------------------------------------------------------
#define TEXT( x, y ) \
	crTEXTDrawString( (struct SFont *) &s_solar2Font, (unsigned int) t[tCount++], crCRTCGetScanline( 0 ), x*2, y*8 );

#define TEXT2( x, y ) \
	crTEXTDrawString( (struct SFont *) &s_solar2Font, (unsigned int) t2[tCount++], crCRTCGetScanline( 0 ), x*2, y*8 );

// ----------------------------------------------------------------------------
void SOLAR_initTimers( )
{
	memset( s_palette, 0, 16 * 2 );
	s_initCount = -1;
	s_bgCount = 16 * 4;
	s_textCount = TEXTCOUNT;
}

// ----------------------------------------------------------------------------
void SOLAR_initBackground( int textIndex )
{
	playMusic( );

	memset( crCRTCGetScanline( 0 ), 0, 0x4000 );
	
	playMusic( );

	crTEXTDrawStringRandomScreen( (unsigned int *) crCRTCGetScanline( 0 ), (struct SFont *) &s_solarFont, (struct SFont *) &s_solarFont, (struct SFont *) &s_solarFont, 0 );

	playMusic( );

	if ( isSecondTime == 1 )
	{
		if ( textIndex == 0 )
		{
			for ( i = 0; i < 7; i++ )
			{
				TEXT2( pos1[i*2], pos1[i*2+1]);
			}
		}
		else
		if ( textIndex == 1 )
		{
			for ( i = 0; i < 7; i++ )
			{
				TEXT2( pos2[i*2], pos2[i*2+1]);
			}			
		}
		else
		if ( textIndex == 2 )
		{
			for ( i = 0; i < 5; i++ )
			{
				TEXT2( pos3[i*2], pos3[i*2+1]);
			}
		}
		else
		if ( textIndex == 3 )
		{
			for ( i = 0; i < 9+3; i++ )
			{
				TEXT2( pos4[i*2], pos4[i*2+1]);
			}
		}
		else
		if ( textIndex == 4 )
		{
			for ( i = 0; i < 4; i++ )
			{
				TEXT2( pos5[i*2], pos5[i*2+1]);
			}
		}
	}
	else
	{
		if ( textIndex == 0 )
		{
			for ( i = 0; i < 8; i++ )
			{
				TEXT( first1[i*2], first1[i*2+1]);
			}
		}
		else
		if ( textIndex == 1 )
		{
			for ( i = 0; i < 3; i++ )
			{
				TEXT( first2[i*2], first2[i*2+1]);
			}
		}
		else
		if ( textIndex == 2 )
		{
			for ( i = 0; i < 7; i++ )
			{
				TEXT( first3[i*2], first3[i*2+1]);
			}
		}
	}
}

// ----------------------------------------------------------------------------
void init( )
{
	unsigned char *pSecondTime = 0x812;	

	if ( *pSecondTime == 255 )
	{
		isSecondTime = 0;
	}
	else
	{
		isSecondTime = 1;

		maxText = 4;
	}

	memset( s_palette, 0, 16 * 2 );
	crASICSetPalette( s_palette );

	playMusic( );

	crPACKERUnpack( 0x7900, GETDATAPTR( DATA_SOLAR ) );
	strcpy( s_solarFont.fontCharSet, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.,;:!?#-c " );
	s_solarFont.fontAdress = 0x7900;
	s_solarFont.fontBank = 0xC0;
	s_solarFont.fontCharWidth = 8 / 4;
	s_solarFont.fontCharHeight = 8;
	s_solarFont.fontCharsPerLine = 26;
	crTEXTInitFont( s_solarFont );

	playMusic( );

	crPACKERUnpack( 0x7000, GETDATAPTR( DATA_SOLAR2 ) );
	strcpy( s_solar2Font.fontCharSet, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.,;:!?#-c " );
	s_solar2Font.fontAdress = 0x7000;
	s_solar2Font.fontBank = 0xC0;
	s_solar2Font.fontCharWidth = 8 / 4;
	s_solar2Font.fontCharHeight = 8;
	s_solar2Font.fontCharsPerLine = 26;
	crTEXTInitFont( s_solar2Font );

	memset( s_palette, 0, 16 * 2 );

	crCRTCSetupScreen( CRTC_OVERSCAN_VERTICAL, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGESIZE_32KB );
	
	crGASetMode( 1 );
	
	s_solarVBLCount = 0;
	s_isSolarFinished = 0;

	playMusic( );

	s_SOLARIndex = 0;
	SOLAR_initBackground( s_SOLARIndex );

	crCRTCFlipScreen( );

	SOLAR_initTimers( );
}

// ----------------------------------------------------------------------------
void frameUpdate( )
{
	crSYNCWaitVBL( );
	
	crASICSetPalette( s_palette );

	s_initCount++;
	if ( s_initCount < 15 )
	{
		s_palette[ 1 ] += 0x111;
		s_palette[ 2 ] += 0x111;
	}
	else
	{
		s_bgCount--;
		if ( s_bgCount < 15 )
		{
			if ( s_bgCount >= 0 )
			{
				s_palette[ 1 ] -= 0x111;
			}
			else
			{
				if ( s_textCount == TEXTCOUNT )
				{
					s_SOLARIndex++;
					SOLAR_initBackground( s_SOLARIndex );
				}
				
				s_textCount--;
				if ( s_textCount < 15 )
				{
					if ( s_textCount >= 0 )
					{
						s_palette[ 2 ] -= 0x111;
					}
					else
					{
						SOLAR_initTimers( );

						crSYNCWaitVBL( );
						crCRTCFlipScreen( );
						crASICSetPalette( s_palette );
						
						playMusic( );

						memset( crCRTCGetScanline( 0 ), 0, 0x4000 );
						
						if ( isSecondTime == 1 )
						{
							if ( s_SOLARIndex > maxText )
							{
								s_SOLARIndex--;

								s_isSolarFinished = 1;
							}
						}
						else
						{
							if ( s_SOLARIndex > maxText )
							{
								s_isSolarFinished = 1;
#asm
								ld hl, $812;
								ld ( hl ), 0;
#endasm
							}
						}						
					}
				}
			}
		}
	}
}

// ----------------------------------------------------------------------------
int isFinished( )
{
	return s_isSolarFinished;
}
