/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include <string.h> // memset

#include "Demo.h"

#include "Tunnel2.h"

// ----------------------------------------------------------------------------
unsigned char *s_dataPtr = (unsigned char *) 0x3600; 
#define GETDATAPTR( offset ) ( (unsigned char *) ( s_dataPtr + offset ) )

// ----------------------------------------------------------------------------
static void init( );
static void frameUpdate( );
static int isFinished( );

// ----------------------------------------------------------------------------
void main( )
{
#asm
	ei;
	ld sp, $1500 - 2;
#endasm

	crASICIsBegin( );
	crBANKGetBank( );

	playMusic( );

	init( );

	playMusic( );

	while ( isFinished( ) == 0 )
	{
		frameUpdate( );

		playMusic( );
	}

#asm
	ld hl, ( $1500 - 2);
	jp ( hl );
#endasm
}

// ----------------------------------------------------------------------------
static unsigned int s_palette[ 17 ];

// ----------------------------------------------------------------------------
#define TEXWIDTH 64
#define TEXHEIGHT 64

#define WIDTH 48
#define HEIGHT 48

#define BITMAP_SIZE					( TEXWIDTH * TEXHEIGHT )
#define BITMAP_PTR					( ( unsigned char * ) ( 0x7000 ) )

#define FX_WIDTH					96
#define FX_HEIGHT					96

#define FRAMETIME					120

#define RENDER_BUFFER				( 0x6000 )

// ----------------------------------------------------------------------------
static int s_VBLCount;
static int s_isFinished;

static unsigned int x;
static unsigned int y;

unsigned char *bitmap = BITMAP_PTR;
unsigned int *fx;
unsigned char *renderBuffer = RENDER_BUFFER;

extern unsigned int g_frameTunnel2Ptr;

int offsetX;
int offsetY;

unsigned int addX;
unsigned int addY;

unsigned char fxNumber = 0;

unsigned int curX;
unsigned int curY;

unsigned int *t;


#define MAXSINCOS					360
#define MEM_COSX					( 0x5000 )
#define MEM_COSY					( MEM_COSX + MAXSINCOS * 2 )


static int *s_cosX = (int *) ( MEM_COSX );
static int *s_cosY = (int *) ( MEM_COSY );

// ----------------------------------------------------------------------------
void init( )
{
	s_VBLCount = 0;
	s_isFinished = 0;

	crCRTCSetupScreen( CRTC_OVERSCAN_VERTICAL, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGESIZE_16KB );

	memset( 0x8000, 0, 0x8000 );

	memset( s_palette, 0, 16 * 2 );
	crASICSetPalette( s_palette );

	crGASetMode( 1 );

	{
		unsigned char *ptr = bitmap;
		unsigned char pen;
		
		for ( y = 0; y < TEXHEIGHT; y++ )
		{
			playMusic( );

			for ( x = 0; x < TEXWIDTH; x++ )
			{
				if ( y < TEXHEIGHT/2 )
				{
					if ( x < TEXWIDTH/2 )
					{
						pen = 0xE5;
					}
					else
					{
						pen = 0xD5;
					}
				}
				else
				{
					if ( x < TEXWIDTH/2 )
					{
						pen = 0xD5;
					}
					else
					{
						pen = 0xE5;
					}
				}

				ptr[ y * TEXWIDTH + x ] = pen;
			}
		}
	}

	fxNumber = 0;

	fx = GETDATAPTR( DATA_ROUND );

	playMusic( );

	offsetX = 0;
	offsetY = 0;

	{
		int i;

		long sx = ( 48 - 32 ) / 2;
		long sy = ( 48 - 33 ) / 2;

		for ( i = 0; i < MAXSINCOS; i++ )
		{
			playMusic( );

			s_cosX[ i ] = div16384( (long) isin( i ) * sx );
			
			playMusic( );

			s_cosY[ i ] = div16384( (long) icos( i ) * sy );

			playMusic( );

			s_cosX[ i ] += 1 + ( 48 - 30 ) / 2;
			s_cosY[ i ] += 1 + ( 48 - 33) / 2;

			s_cosY[ i ] *= HEIGHT;
		}
	}
}

// ----------------------------------------------------------------------------
void frameUpdate( )
{	
	crSYNCWaitVBL( );
	crCRTCFlipScreen( );

	if ( s_VBLCount < 12 )
	{
		s_palette[ 1 ] += 0x010;
		s_palette[ 2 ] += 0x000;
		s_palette[ 3 ] += 0x001;

		crASICSetPalette( s_palette );
	}
	else
	if ( s_VBLCount > (FRAMETIME - 12 ) )
	{
		s_palette[ 1 ] -= 0x010;
		s_palette[ 2 ] -= 0x000;
		s_palette[ 3 ] -= 0x001;

		crASICSetPalette( s_palette );
	}

	if ( s_VBLCount >= ( FRAMETIME ) )
	{
		s_isFinished = 1;
	}

	addX = s_cosX[ offsetX ];
	addY = s_cosY[ offsetY ];

	offsetX += 11;
	while ( offsetX >= 360 )
	{
		offsetX -= 360;
	}
	
	offsetY += 15;
	while ( offsetY >= 360 )
	{
		offsetY -= 360;
	}

	curX += 4;
	curY += 3;

	playMusic( );

	crGFXCreateMonoTunnelFrame( renderBuffer, bitmap, &fx[ addX + addY ], curX, curY );
	
	playMusic( );

	crGFXDrawMonoFrame3( crCRTCGetScanline( 0 ), renderBuffer, g_frameTunnel2Ptr );

	s_VBLCount++;
}

// ----------------------------------------------------------------------------
int isFinished( )
{
	return s_isFinished;
}
