#include  <afxwin.h>

#include  "Constantes.h"
#include  "BitmapCPC.h"
#include  "SauveCPC.h"
#include  "Conversion.h"
#include  "Pack.h"


CBitmapCPC::CBitmapCPC()
{
    NbCol = 80;
    NbLig = 200;
    ModeCPC = 1;
    Plus = FALSE;
    memcpy( Palette, PaletteStandardCPC, sizeof( Palette ) );
}


CBitmapCPC::~CBitmapCPC()
{
}


SIZE CBitmapCPC::GetImageSize( void )
{
    SIZE sz = { NbCol << 2, NbLig };
    return( sz );
}


void CBitmapCPC::SetPalette( BYTE * PalStart, BOOL Plus )
{
    ModeCPC = PalStart[ 0 ] & 0x03;
    if ( Plus )
        for ( int i = 0; i < 16; i++ )
            Palette[ i ] = PalStart[ 1 + i * 2 ] + 256 * PalStart[ 2 + i * 2 ];
    else
        for ( int i = 0; i < 16; i++ )
            Palette[ i ] = PalStart[ i + 1 ];
}


BOOL CBitmapCPC::InitDatas( int * Mode )
{
    BOOL Ret = FALSE;
    // Valeurs par dfaut
    Plus = FALSE;
    NbCol = 80;
    NbLig = 200;

    /*
    Si sauvegard avec ConvImgCpc, alors la palette se trouve
    dans l'image...
    */
    if (  BitmapCPC[ 0x7D0 ] == 0x3A
       && BitmapCPC[ 0x7D1 ] == 0xD0
       && BitmapCPC[ 0x7D2 ] == 0xD7
       && BitmapCPC[ 0x7D3 ] == 0xCD
       )
        {
        // CPC OLD, cran standard
        SetPalette( &BitmapCPC[ 0x17D0 ], Plus );
        * Mode = ModeCPC;
        Ret = TRUE;
        }
    else
        // CPC +, cran standard
        if (  BitmapCPC[ 0x7D0 ] == 0xF3
           && BitmapCPC[ 0x7D1 ] == 0x01
           && BitmapCPC[ 0x7D2 ] == 0x11
           && BitmapCPC[ 0x7D3 ] == 0xBC
           )
            {
            Plus = TRUE;
            NbCol = 80;
            NbLig = 200;
            SetPalette( &BitmapCPC[ 0x17D0 ], Plus );
            * Mode = ModeCPC;
            Ret = TRUE;
            }
        else
            // CPC OLD, cran overscan
            if (  BitmapCPC[ 0x611 ] == 0x21
               && BitmapCPC[ 0x612 ] == 0x47
               && BitmapCPC[ 0x613 ] == 0x08
               && BitmapCPC[ 0x614 ] == 0xCD
               )
                {
                Plus = FALSE;
                NbCol = MAX_COLS_CPC;
                NbLig = MAX_LIGNES_CPC;
                SetPalette( &BitmapCPC[ 0x600 ], Plus );
                * Mode = ModeCPC;
                Ret = TRUE;
                }
            else
                // CPC +, cran overscan
                if (  BitmapCPC[ 0x621 ] == 0xF3
                   && BitmapCPC[ 0x622 ] == 0x01
                   && BitmapCPC[ 0x623 ] == 0x11
                   && BitmapCPC[ 0x624 ] == 0xBC
                   )
                    {
                    Plus = TRUE;
                    NbCol = MAX_COLS_CPC;
                    NbLig = MAX_LIGNES_CPC;
                    SetPalette( &BitmapCPC[ 0x600 ], Plus );
                    * Mode = ModeCPC;
                    Ret = TRUE;
                    }
    return( Ret );
}


void CBitmapCPC::DepactPK( void )
{
    static BYTE BufTmp[ 0x8000 ];

    // Valeurs par dfaut
    Plus = FALSE;
    NbCol = 80;
    NbLig = 200;

    /*
    PKSL -> 320x200 STD
    PKS3 -> 320x200 Mode 3
    PKSP -> 320x200 PLUS
    PKVL -> Overscan STD
    PKVP -> Overscan PLUS
    */

    Plus = ( BitmapCPC[ 3 ] == 'P' ) || ( BitmapCPC[ 2 ] == 'O' );
    BOOL Overscan = ( BitmapCPC[ 2 ] == 'V' ) || ( BitmapCPC[ 3 ] == 'V' );
    Depack( &BitmapCPC[ 4 ], BufTmp );
    memcpy( BitmapCPC, BufTmp, sizeof( BufTmp ) );
    if ( Overscan )
        {
        NbCol = MAX_COLS_CPC;
        NbLig = MAX_LIGNES_CPC;
        SetPalette( &BitmapCPC[ 0x600 ], Plus );
        }
    else
        SetPalette( &BitmapCPC[ 0x17D0 ], Plus );

}


void CBitmapCPC::DepactOCP( void )
{
    static BYTE BufTmp[ 0x4000 ];
    int PosIn = 0, PosOut = 0;
    int LgOut, CntBlock = 0;

    memcpy( BufTmp, BitmapCPC, sizeof( BufTmp ) );
    memset( BitmapCPC, 0, 0x4000 );
    while( PosOut < 0x4000 )
        {
        if ( ! strncmp( ( char * )&BufTmp[ PosIn ], "MJH", 3 ) )
            {
            PosIn += 3;
            LgOut = BufTmp[ PosIn++ ];
            LgOut += ( BufTmp[ PosIn++ ] << 8 );
            CntBlock = 0;
            while( CntBlock < LgOut )
                {
                if ( ! strncmp( ( char * )&BufTmp[ PosIn ], "MJH", 3 ) )
                    break;

                BYTE a = BufTmp[ PosIn++ ];
                if ( a == MARKER_OCP )
                    {
                    int c = BufTmp[ PosIn++ ];
                    a = BufTmp[ PosIn++ ];
                    if ( ! c )
                        c = 0x100;

                    for ( int i = 0; i < c && CntBlock < LgOut; i++ )
                        {
                        BitmapCPC[ PosOut++ ] = a;
                        CntBlock++;
                        }
                    }
                else
                    {
                    BitmapCPC[ PosOut++ ] = a;
                    CntBlock++;
                    }
                }
            }
        else
            PosOut = 0x4000;
        }
}


BOOL CBitmapCPC::CreateImageFile( char * Nom
                                , int * Mode
                                , int * p
                                , BOOL GetPalMode
                                )
{
    static BYTE Entete[ 0x80 ];
    BOOL Ret = FALSE;
    DWORD Nb;

    HANDLE hFile = CreateFile( Nom
                             , FILE_READ_DATA
                             , FILE_SHARE_READ
                             , NULL
                             , OPEN_EXISTING
                             , FILE_ATTRIBUTE_NORMAL
                             , NULL
                             );
    if ( hFile )
        {
        ReadFile( hFile, Entete, sizeof( Entete ), &Nb, NULL );
        if ( CheckAmsdos( Entete ) )
            {
            ReadFile( hFile, BitmapCPC, sizeof( BitmapCPC ), &Nb, NULL );
            if ( ! strncmp( ( char * )BitmapCPC, "MJH", 3 ) )
                DepactOCP();
            else
                if (  ! strncmp( ( char * )BitmapCPC, "PKV", 3 )
                   || ! strncmp( ( char * )BitmapCPC, "PKS", 3 )
                   || ! strncmp( ( char * )BitmapCPC, "PKO", 3 )
                   )
                    {
                    DepactPK();
                    GetPalMode = 0;
                    memcpy( p, Palette, sizeof( Palette ) );
                    }

            memcpy( Palette, p, sizeof( Palette ) );
            if ( GetPalMode )
                {
                if ( InitDatas( Mode ) )
                    memcpy( p, Palette, sizeof( Palette ) );
                }

            Ret = TRUE;
            }
        CloseHandle( hFile );
        }
    return( Ret );

}


void CBitmapCPC::Render( StRVB * Bitmap, int Mode, BOOL GetPalMode )
{
    int i, p0, p1, p2, p3;

    if ( GetPalMode )
        InitDatas( &Mode );

    for ( int y = 0; y < TailleY; y += 2 )
        {
        int AdrCPC = ( y >> 4 ) * NbCol + ( y & 14 ) * 0x400;
        if ( ( y > 255 ) && ( NbCol == MAX_COLS_CPC ) )
            AdrCPC += 0x3800;

        int AdrBitmap = BITMAP_X * y;
        for ( int x = 0; x < NbCol; x++ )
            {
            BYTE Octet = BitmapCPC[ AdrCPC + x ];
            switch( Mode )
                {
                case 0 :
                    p0 = ( Octet >> 7 )
                       + ( ( Octet & 0x20 ) >> 3 )
                       + ( ( Octet & 0x08 ) >> 2 )
                       + ( ( Octet & 0x02 ) << 2 );
                    p1 = ( ( Octet & 0x40 ) >> 6 )
                       + ( ( Octet & 0x10 ) >> 2 )
                       + ( ( Octet & 0x04 ) >> 1 )
                       + ( ( Octet & 0x01 ) << 3 );
                    Bitmap[ AdrBitmap ] = GetPalCPC( Palette[ p0 ], Plus );
                    AdrBitmap += 4;
                    Bitmap[ AdrBitmap ] = GetPalCPC( Palette[ p1 ], Plus );
                    AdrBitmap += 4;
                    break;

                case 1 :
                case 3 :
                    p0 = ( ( Octet >> 7 ) & 1 ) + ( ( Octet >> 2 ) & 2 );
                    p1 = ( ( Octet >> 6 ) & 1 ) + ( ( Octet >> 1 ) & 2 );
                    p2 = ( ( Octet >> 5 ) & 1 ) + ( ( Octet >> 0 ) & 2 );
                    p3 = ( ( Octet >> 4 ) & 1 ) + ( ( Octet << 1 ) & 2 );
                    Bitmap[ AdrBitmap++ ] = GetPalCPC( Palette[ p0 ], Plus );
                    AdrBitmap++;
                    Bitmap[ AdrBitmap++ ] = GetPalCPC( Palette[ p1 ], Plus );
                    AdrBitmap++;
                    Bitmap[ AdrBitmap++ ] = GetPalCPC( Palette[ p2 ], Plus );
                    AdrBitmap++;
                    Bitmap[ AdrBitmap++ ] = GetPalCPC( Palette[ p3 ], Plus );
                    AdrBitmap++;
                    break;

                case 2 :
                    for ( i = 8; i--; )
                        Bitmap[ AdrBitmap++ ] = GetPalCPC( Palette[ ( Octet >> i ) & 1 ]
                                                         , Plus
                                                         );
                    break;
                }
            }
        }
    LisseBitmap( Bitmap, 4 >> ( Mode == 3 ? 1 : Mode ) );
}
