#include  <windows.h>

#include  "constantes.h"


#define     SEEKBACK            0x1000

#define     MAXSTRING           256


/********************************************************* !NAME! **************
* Nom : Depack
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Dcompacte un buffer d'entre (BufIn) dans un buffer de sortie
*               (BufOut)
*
* Rsultat    : Longueur du buffer dcompact
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
int Depack( BYTE * BufIn, BYTE * BufOut )
{
    BYTE a, DepackBits = 0;
    int Bit, InBytes = 0, Longueur, Delta, OutBytes = 0;

    for ( ;; )
        {
        Bit = DepackBits & 1;
        DepackBits >>= 1;
        if ( !DepackBits )
            {
            DepackBits = BufIn[ InBytes++ ];
            Bit = DepackBits & 1;
            DepackBits >>= 1;
            DepackBits |= 0x80;
            }
        if ( ! Bit )
            BufOut[ OutBytes++ ] = BufIn[ InBytes++ ];
        else
            {
            if ( ! BufIn[ InBytes ] )
                break; /* EOF */

            a = BufIn[ InBytes ];
            if ( a & 0x80 )
                {
                Longueur = 3 + ( ( BufIn[ InBytes ] >> 4 ) & 7 );
                Delta = ( BufIn[ InBytes++ ] & 15 ) << 8;
                Delta |= BufIn[ InBytes++ ];
                Delta++;
                }
            else
                if ( a & 0x40 )
                    {
                    Longueur = 2;
                    Delta = BufIn[ InBytes++ ] & 0x3f;
                    Delta++;
                    }
                else
                    if ( a & 0x20 )
                        {
                        Longueur = 2 + ( BufIn[ InBytes++ ] & 31 );
                        Delta = BufIn[ InBytes++ ];
                        Delta++;
                        }
                    else
                        if ( a & 0x10 )
                            {
                            Delta = ( BufIn[ InBytes++ ] & 15 ) << 8;
                            Delta |= BufIn[ InBytes++ ];
                            Longueur = BufIn[ InBytes++ ] + 1;
                            Delta++;
                            }
                        else
                            {
                            if ( BufIn[ InBytes ] == 15 )
                                {
                                Longueur = Delta = BufIn[ InBytes+1 ] + 1;
                                InBytes += 2;
                                }
                            else
                                {
                                if ( BufIn[ InBytes ] > 1 )
                                    Longueur = Delta = BufIn[ InBytes ];
                                else
                                    Longueur = Delta = 256;

                                InBytes++;
                                }
                            }
            for ( ; Longueur--; )
                {
                BufOut[ OutBytes ] = BufOut[ OutBytes - Delta ];
                OutBytes++;
                }
            }
        }
    return( OutBytes );
}


/********************************************************* !NAME! **************
* Nom : Pack
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Compacte le buffer d'entre (BufIn) dans le buffer de sortie
*               (BufOut)
*
* Rsultat    : Longueur du buffer compact
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
int Pack( BYTE * BufIn, int LengthIn, BYTE * BufOut )
{
    static int matches[ MAXSTRING ];
    static int matchtable[ MAXSTRING ][ SEEKBACK ];
    BYTE codebuffer[ 24 ];
    BYTE bits = 0;
    int count = 0, bitcount = 0, codecount = 0;
    int matchtablestart = 0, matchtableend = 0, oldmatchtablestart;
    int start, end, max, b, c, d, LengthOut = 0;

    memset( matches, 0, sizeof( matches ) );
    for ( ;; )
        {
        for ( c = matchtableend; c < count; c++ )
            {
            b = BufIn[ c ];
            matchtable[ b ][ matches[ b ] ] = c;
            matches[ b ]++;
            }
        matchtableend = count;

        if ( count >= 2 )
            {
            int stlen = 0;
            int stpos = 0;
            int stlen2 = 0;
            int bb = BufIn[ count ];
            for ( c = matches[ bb ] - 1; c >= 0; c-- )
                {
                start = matchtable[ bb ][ c ];
                end = start + MAXSTRING;
                if ( end > count )
                    end = count;

                max = end - start;
                if ( max >= stlen )
                    {
                    for ( d = 1; d < max; d++ )
                        if ( BufIn[ start+d ] != BufIn[ count + d ] ) 
                            break;

                    if ( ( d >= 2 ) && ( d > stlen ) )
                        {
                        stlen = d;
                        stpos = count - start;
                        }
                    if ( ( d == stlen ) && ( count - start < stpos ) )
                        stpos = count - start;
                    }

                if ( ( stlen == MAXSTRING ) && ( stpos == stlen ) ) 
                    break;
                }
            if ( count + 1 < LengthIn )
                {
                bb = BufIn[ count + 1 ];
                for ( c = matches[ bb ] - 1; c >= 0; c-- )
                    {
                    start = matchtable[ bb ][ c ];
                    end = start + MAXSTRING;
                    if ( end > count + 1 )
                        end = count + 1;

                    max = end - start;
                    if ( max >= stlen2 )
                        {
                        for ( d = 1; d < max; d++ )
                            if ( BufIn[ start+d ] != BufIn[ count + d + 1 ] )
                                break;

                        if ( ( d >= 2 ) && ( d >= stlen2 ) )
                            stlen2 = d;
                        }
                    if ( stlen2 == MAXSTRING )
                        break;
                    }
                if ( stlen2-1 > stlen )
                    stlen = 0;
                }

            if ( stlen > 1 )
                {
                if ( ( stlen == 2 ) && ( stpos >= MAXSTRING ) )
                    {
                    codebuffer[ codecount++ ] = BufIn[ count++ ];
                    bitcount++;
                    }
                else
                    {
                    if ( stpos == stlen )
                        {
                        if ( stlen == MAXSTRING )
                            codebuffer[ codecount++ ] = 0x1;
                        else
                            {
                            if ( stlen <= 14 )
                                codebuffer[ codecount++ ] = ( BYTE )stlen;
                            else
                                {
                                codebuffer[ codecount++ ] = 0x0F;
                                codebuffer[ codecount++ ] = ( BYTE )( stlen - 1 );
                                }
                            }
                        }
                    else
                        {
                        if ( ( stlen == 2 ) && ( stpos < 65 ) )
                            codebuffer[ codecount++ ] = ( BYTE )( 0x40 + stpos - 1 );
                        else
                            {
                            if ( ( stlen <= 33 ) && ( stpos < 257 ) )
                                {
                                codebuffer[ codecount++ ] = ( BYTE )( 0x20 + stlen - 2 );
                                codebuffer[ codecount++ ] = ( BYTE )( stpos - 1 );
                                }
                            else
                                {
                                if ( ( stlen >= 3 ) && ( stlen <= 10 ) )
                                    {
                                    codebuffer[ codecount++ ] = ( BYTE )( 0x80 + ( ( stlen - 3 ) << 4 ) + ( ( stpos-1 ) >> 8 ) );
                                    codebuffer[ codecount++ ] = ( BYTE )( stpos - 1 );
                                    }
                                else
                                    {
                                    codebuffer[ codecount++ ] = ( BYTE )( 0x10 + ( ( stpos-1 ) >> 8 ) );
                                    codebuffer[ codecount++ ] = ( BYTE )( stpos - 1 );
                                    codebuffer[ codecount++ ] = ( BYTE )( stlen - 1 );
                                    }
                                }
                            }
                        }
                    bits |= 1 << bitcount;
                    bitcount++;
                    count += stlen;
                    }
                }
            else
                {
                codebuffer[ codecount++ ] = BufIn[ count++ ];
                bitcount++;
                }
            }
        else
            {
            codebuffer[ codecount++ ] = BufIn[ count++ ];
            bitcount++;
            }
        if ( bitcount == 8 )
            {
            BufOut[ LengthOut++ ] = bits;
            memcpy( &BufOut[ LengthOut ], codebuffer, codecount );
            LengthOut += codecount;
            bitcount = codecount = 0;
            bits = 0;
            }
        if ( count >= LengthIn )
            break;

        oldmatchtablestart = matchtablestart;
        matchtablestart = count - SEEKBACK;
        if ( matchtablestart < 0 )
            matchtablestart = 0;

        for ( c = oldmatchtablestart; c < matchtablestart; c++ )
            {
            b = BufIn[ c ];
            for ( d = 0; d < matches[ b ]; d++ )
                if ( matchtable[ b ][ d ] >= matchtablestart )
                    {
                    memmove( &matchtable[ b ][ 0 ]
                           , &matchtable[ b ][ d ]
                           , ( matches[ b ] - d ) * sizeof( int )
                           );
                    break;
                    }

            matches[ b ] -= d;
            }
        }
    codebuffer[ codecount++ ] = 0;
    bits |= 1 << bitcount;
    BufOut[ LengthOut++ ] = bits;
    memcpy( &BufOut[ LengthOut ], codebuffer, codecount );
    LengthOut += codecount;
    return( LengthOut );
}


/********************************************************* !NAME! **************
* Nom : ConvertBuffScreenCol
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Conversion mmoire cran CPC -> mmoire cran linaire
*               (Linarisation par colonnes)
*
* Rsultat    : Longueur buffer converti
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
static int ConvertBuffScreenCol( BYTE xDeb
                               , BYTE yDeb
                               , BYTE xFin
                               , BYTE yFin
                               , BYTE * BufIn
                               )
{
    static BYTE BLigne[ 0x4000 ];
    int c, l, adr = 0, PosReel = 0;
    int Length = ( xFin + 1 - xDeb ) * ( yFin + 1 - yDeb );

    for ( c = xDeb; c <= xFin; c++ )
        {
        for ( l = 0; l < 200; l++ )
            {
            if ( l >= yDeb && l <= yFin )
                {
                adr = ( l >> 3 ) * 80 + ( l & 7 ) * 0x800;
                BLigne[ PosReel++ ] = BufIn[ adr + c ];
                }
            }
        }
    memcpy( BufIn, BLigne, Length );
    return( Length );
}


/********************************************************* !NAME! **************
* Nom : PackImgSlide
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Conversion d'une image CPC en image compacte pour lecture avec
*               le loader type "slide-show"
*
* Rsultat    : Longueur image compacte
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
int PackImgSlide( BYTE * BufImg
                , BYTE * BufRet
                , BYTE * ModeCouleur
                , int Mode
                , BYTE * TabVGA
                , BOOL CpcPlus
                , BOOL Overscan
                )
{
    int lcmp, l;

#ifndef PASSE_3_OVS
    if ( ! Overscan )
#endif
        {
        l = ConvertBuffScreenCol( 0, 0, 79, 199, BufImg );
        if ( Mode < 3 )
            {
            if ( CpcPlus )
                {
                lcmp = Pack( BufImg, l, &BufRet[ 37 ] );
                memcpy( BufRet, "PKSP", 4 );
                memcpy( &BufRet[ 4 ], ModeCouleur, 33 );
                return( lcmp + 37 );
                }
            else
                {
                lcmp = Pack( BufImg, l, &BufRet[ 21 ] );
                memcpy( BufRet, "PKSL", 4 );
                memcpy( &BufRet[ 4 ], ModeCouleur, 17 );
                return( lcmp + 21 );
                }
            }
        else
            {
#ifdef NEW_PASSE_3
            lcmp = Pack( BufImg, l, &BufRet[ 1606 ] );
            memcpy( BufRet, "PKS3", 4 );
            BufRet[ 4 ] = ModeCouleur[ 1 ];         // Couleur 0
            BufRet[ 5 ] = ModeCouleur[ 2 ];         // Couleur 1
            BufRet[ 6 ] = ModeCouleur[ 3 ];         // Couleur 2
            memcpy( &BufRet[ 7 ], TabVGA, 1600 );
            BufRet[ 1607 ] = 0;
            return( lcmp + 1608 );
#else
#ifdef PASSE_3_OVS
            lcmp = Pack( BufImg, 0x7CC0, &BufRet[ 551 ] );
            memcpy( BufRet, "PKS3", 4 );
            BufRet[ 4 ] = ModeCouleur[ 1 ];         // Couleur 0
            BufRet[ 5 ] = ModeCouleur[ 2 ];         // Couleur 1
            memcpy( &BufRet[ 6 ], TabVGA, 544 );
            BufRet[ 550 ] = 0;
            return( lcmp + 551 );
#else
            lcmp = Pack( BufImg, l, &BufRet[ 1206 ] );
            memcpy( BufRet, "PKS3", 4 );
            BufRet[ 4 ] = ModeCouleur[ 1 ];         // Couleur 0
            memcpy( &BufRet[ 5 ], TabVGA, 1200 );
            BufRet[ 1205 ] = 0;
            return( lcmp + 1206 );
#endif
#endif
            }
        }
#ifndef PASSE_3_OVS
    else
        {
        //
        // Pas de conversion de format, compactage direct du buffer
        // Contenant l'image, le mode et la palette
        //
        lcmp = Pack( BufImg, 0x7CC0, &BufRet[ 4 ] );
        memcpy( BufRet, "PKVL", 4 );
        if ( CpcPlus )
            BufRet[ 3 ] = 'P';

        return( lcmp + 4 );
        }
#endif
}

