#include  <afxwin.h>

#include  "Conversion.h"
#include  "Constantes.h"
#include  "SauveCPC.h"
#include  "Locale.h"
#include  "Pack.h"


#define     NB_OCT_LIGNE_DB     8   // Une ligne DB = 8 octets de donnes


//
// Structure d'une entre AMSDOS
//
typedef struct
    {
    BYTE    UserNumber;             // User
    BYTE    FileName[ 15 ];         // Nom + extension
    BYTE    BlockNum;               // Numro du premier bloc (disquette)
    BYTE    LastBlock;              // Numro du dernier bloc (disquette)
    BYTE    FileType;               // Type de fichier
    WORD    Length;                 // Longueur
    WORD    Adress;                 // Adresse
    BYTE    FirstBlock;             // Premier bloc de fichier (disquette)
    WORD    LogicalLength;          // Longueur logique
    WORD    EntryAdress;            // Point d'entre
    BYTE    Unused[ 0x24 ];
    WORD    RealLength;             // Longueur relle
    BYTE    BigLength;              // Longueur relle (3 octets)
    WORD    CheckSum;               // CheckSum Amsdos
    BYTE    Unused2[ 0x3B ];
    } StAmsdos;


//
// Structure palette (comme OCP art studio)
//
typedef struct
    {
    BYTE    Mode;
    BYTE    AnimFlag;
    BYTE    AnimDelay;
    BYTE    Palette[ 16 ][ 12 ];
    BYTE    Border[ 12 ];
    BYTE    ExcludedInk[ 16 ];
    BYTE    ProtectedInk[ 16 ];
    } StPal;


static BYTE CodeStd[ 48 ] =  // Routine  mettre en #C7D0
    {
    0x3A, 0xD0, 0xD7,               //      LD      A,  (#D7D0)
    0xCD, 0x1C, 0xBD,               //      CALL    #BD1C
    0x21, 0xD1, 0xD7,               //      LD      HL, #D7D1
    0x46,                           //      LD      B,  (HL)
    0x48,                           //      LD      C,  B
    0xCD, 0x38, 0xBC,               //      CALL    #BC38
    0xAF,                           //      XOR     A
    0x21, 0xD1, 0xD7,               //      LD      HL, #D7D1
    0x46,                           // BCL: LD      B,  (HL)
    0x48,                           //      LD      C,  B
    0xF5,                           //      PUSH    AF
    0xE5,                           //      PUSH    HL
    0xCD, 0x32, 0xBC,               //      CALL    #BC32
    0xE1,                           //      POP     HL
    0xF1,                           //      POP     AF
    0x23,                           //      INC     HL
    0x3C,                           //      INC     A
    0xFE, 0x10,                     //      CP      #10
    0x20, 0xF1,                     //      JR      NZ,BCL
    0xC3, 0x18, 0xBB,               //      JP      #BB18
    };


static BYTE CodeP0[ 48 ] =
    {
    0xF3, 0x01, 0x11, 0xBC, 0x21, 0xD0, 0xDF, 0x7E,
    0xED, 0x79, 0x23, 0x0D, 0x20, 0xF9, 0x01, 0xA0,
    0x7F, 0x3A, 0xD0, 0xD7, 0xED, 0x79, 0xED, 0x49,
    0x01, 0xB8, 0x7F, 0xED, 0x49, 0x21, 0xD1, 0xD7,
    0x11, 0x00, 0x64, 0x01, 0x22, 0x00, 0xED, 0xB0,
    0xCD, 0xD0, 0xCF, 0x38, 0xFB, 0xFB, 0xC9
    };

static BYTE CodeP1[ 48 ] =
    {
    0x01, 0x0E, 0xF4, 0xED, 0x49, 0x01, 0xC0, 0xF6,
    0xED, 0x49, 0xAF, 0xED, 0x79, 0x01, 0x92, 0xF7,
    0xED, 0x49, 0x01, 0x45, 0xF6, 0xED, 0x49, 0x06,
    0xF4, 0xED, 0x78, 0x01, 0x82, 0xF7, 0xED, 0x49,
    0x01, 0x00, 0xF6, 0xED, 0x49, 0x17, 0xC9
    };

static BYTE CodeP3[ 48 ] =
    {
    0xFF, 0x00, 0xFF, 0x77, 0xB3, 0x51, 0xA8, 0xD4,
    0x62, 0x39, 0x9C, 0x46, 0x2B, 0x15, 0x8A, 0xCD,
    0xEE
    };

static BYTE CodeOv[] =
    {
    0x21, 0x47, 0x08, 0xCD, 0x36, 0x08, 0x3A, 0x00,
    0x08, 0xCD, 0x1C, 0xBD, 0x21, 0x01, 0x08, 0xAF,
    0x4E, 0x41, 0xF5, 0xE5, 0xCD, 0x32, 0xBC, 0xE1,
    0xF1, 0x23, 0x3C, 0xFE, 0x10, 0x20, 0xF1, 0xCD,
    0x18, 0xBB, 0x21, 0x55, 0x08, 0x01, 0x00, 0xBC,
    0x7E, 0xA7, 0xC8, 0xED, 0x79, 0x04, 0x23, 0x7E,
    0xED, 0x79, 0x23, 0x05, 0x18, 0xF2, 0x01, 0x30,
    0x02, 0x32, 0x06, 0x22, 0x07, 0x23, 0x0C, 0x0D,
    0x0D, 0x00, 0x00, 0x00, 0x01, 0x28, 0x02, 0x2E,
    0x06, 0x19, 0x07, 0x1E, 0x0C, 0x30
    };

static BYTE CodeOvP[] =
    {
    0xF3, 0x01, 0x11, 0xBC, 0x21, 0x86, 0x08, 0x04,
    0xED, 0xA3, 0x0D, 0x20, 0xFA, 0x21, 0x97, 0x08,
    0xCD, 0x75, 0x08, 0x01, 0xB8, 0x7F, 0x3A, 0x00,
    0x08, 0xED, 0x49, 0xED, 0x79, 0x21, 0x01, 0x08,
    0x11, 0x00, 0x64, 0x01, 0x20, 0x00, 0xED, 0xB0,
    0xAF, 0x01, 0x0E, 0xF4, 0xED, 0x49, 0x01, 0xC0,
    0xF6, 0xED, 0x49, 0xED, 0x79, 0x01, 0x92, 0xF7,
    0xED, 0x49, 0x01, 0x45, 0xF6, 0xED, 0x49, 0x06,
    0xF4, 0xED, 0x78, 0x01, 0x82, 0xF7, 0xED, 0x49,
    0x17, 0x38, 0xDD, 0x01, 0xA0, 0x7F, 0xED, 0x49,
    0xFB, 0x21, 0xA5, 0x08, 0x01, 0xBC, 0x00, 0x7E,
    0xA7, 0xC8, 0xED, 0x79, 0x04, 0x23, 0x7E, 0xED,
    0x79, 0x23, 0x05, 0x18, 0xF2, 0xFF, 0x00, 0xFF,
    0x77, 0xB3, 0x51, 0xA8, 0xD4, 0x62, 0x39, 0x9C,
    0x46, 0x2B, 0x15, 0x8A, 0xCD, 0xEE, 0x01, 0x30,
    0x02, 0x32, 0x06, 0x22, 0x07, 0x23, 0x0C, 0x0D,
    0x0D, 0x00, 0x00, 0x00, 0x01, 0x28, 0x02, 0x2E,
    0x06, 0x19, 0x07, 0x1E, 0x0C, 0x30
    };

static BYTE ModePal[ 48 ];

static BYTE CpcVGA[ 28 ] = "TDU\\X]LEMVFW^@_NGORBSZY[ICK";

static StPal Pal;

static BYTE ImgCPC[ 0x8000 ];

static BYTE BufCmp[ 0xA000 ];

static StAmsdos Entete;

extern BYTE TabVGA[ 2720 ];


//
// Cre l'en-tte Amsdos d'un fichier
//
static void CreeEntete( FILE * fp
                      , char * NomFic       // Nom du fichier
                      , WORD Start          // Adresse de dbut
                      , WORD Length         // Longueur
                      , WORD Entry          // Point d'entre
                      )
{
    static char Nom[ 12 ];
    int i, l, CheckSum = 0;
    char * p;

    memset( &Entete, 0, sizeof( Entete ) );

    // Convertir le nom du fichie au format "AMSDOS" 8.3
    memset( Nom, ' ', sizeof( Nom ) );
    do
        {
        p = strchr( NomFic, '\\' );
        if ( p )
            NomFic = ++p;
        }
    while( p );
    p = strchr( NomFic, '.' );
    if ( p )
        * p++ = 0;

    l = strlen( NomFic );
    if ( l > 8 )
        l = 8;

    for ( i = 0; i < l; i++ )
        Nom[ i ] = ( char )( NomFic[ i ] & 0xDF );

    if ( p )
        for ( i = 0; i < 3; i++ )
            Nom[ i + 8 ] = ( char )( p[ i ] & 0xDF );

    // Initialisation de l'en-tte avec les valeurs passes en paramtre
    memcpy( Entete.FileName, Nom, 11 );
    BYTE * pEntete = ( BYTE * )&Entete;
    Entete.Adress = Start;
    Entete.Length = Entete.RealLength = Entete.LogicalLength = Length;
    Entete.FileType = 2;
    Entete.EntryAdress = Entry;

    // Calcul du checksum
    for ( i = 0; i < 67; i++ )
        CheckSum += * pEntete++;

    Entete.CheckSum = ( WORD )CheckSum;
    fwrite( &Entete, sizeof( Entete ), 1, fp );
}


static int CreeBitmapCPC( StRVB * Bitmap
                        , int Cmp
                        , int Mode
                        , BOOL CpcPlus
                        , BOOL Overscan
                        , BOOL ModeLigne
                        , int NbLig
                        , int NbCol
                        )
{
    BYTE Pix0, Pix1, Pix2, Pix3, Pix4, Pix5, Pix6, Pix7;
    int LgCmp, pos = 0;
    int x, y, l, Oct = 0;

    int sizeOfImgCPC = sizeof( ImgCPC );
	memset( ImgCPC, 0, sizeOfImgCPC );
    for ( y = 0; y < NbLig; y++ )
        {
        if ( ModeLigne )
            pos = y * NbCol;
        else
            {
            pos = ( y >> 3 ) * NbCol + ( y & 7 ) * 0x800;
            if ( ( y >= (40+128) ) && Overscan )
                pos += 0x3800;
            }
        l = BITMAP_X * y * 2;
        for ( x = 0; x < NbCol; x++ )
            {
				

            //
            // Conversion pixels en fonction du mode CPC
            //
            Pix0 = Bitmap[ l ].a;
            switch( Mode )
                {
                case 0 :
                    Pix1 = Bitmap[ 4 + l ].a;
                    Oct = ( ( Pix0 & 1 ) << 7 ) +
                          ( ( Pix0 & 2 ) << 2 ) +
                          ( ( Pix0 & 4 ) << 3 ) +
                          ( ( Pix0 & 8 ) >> 2 ) +
                          ( ( Pix1 & 1 ) << 6 ) +
                          ( ( Pix1 & 2 ) << 1 ) +
                          ( ( Pix1 & 4 ) << 2 ) +
                          ( ( Pix1 & 8 ) >> 3 );
                    break;

                case 1 :
                case 3 :
                    Pix1 = Bitmap[ 2 + l ].a;
                    Pix2 = Bitmap[ 4 + l ].a;
                    Pix3 = Bitmap[ 6 + l ].a;
                    Oct = ( ( Pix0 & 1 ) << 7 ) +
                          ( ( Pix0 & 2 ) << 2 ) +
                          ( ( Pix1 & 1 ) << 6 ) +
                          ( ( Pix1 & 2 ) << 1 ) +
                          ( ( Pix2 & 1 ) << 5 ) +
                          ( Pix2 & 2 ) +
                          ( ( Pix3 & 1 ) << 4 ) +
                          ( ( Pix3 & 2 ) >> 1 );
                    break;

                case 2 :
                    Pix1 = Bitmap[ 1 + l ].a;
                    Pix2 = Bitmap[ 2 + l ].a;
                    Pix3 = Bitmap[ 3 + l ].a;
                    Pix4 = Bitmap[ 4 + l ].a;
                    Pix5 = Bitmap[ 5 + l ].a;
                    Pix6 = Bitmap[ 6 + l ].a;
                    Pix7 = Bitmap[ 7 + l ].a;
                    Oct = ( Pix0 << 7 ) +
                          ( Pix1 << 6 ) +
                          ( Pix2 << 5 ) +
                          ( Pix3 << 4 ) +
                          ( Pix4 << 3 ) +
                          ( Pix5 << 2 ) +
                          ( Pix6 << 1 ) +
                          Pix7;
                    break;
                }
			
			if ( ( x < 32 ) && ( y >= (40+128) ) && ( y < (48+128) ) && Overscan )
			{
				ImgCPC[ pos++ - 0x3800 ] = ( BYTE )Oct;
			}
			else
			{
				ImgCPC[ pos++ ] = ( BYTE )Oct;
			}
            l += 8;
            }
        }
    if ( ! ModeLigne )
        {
        // Ajout information mode, couleurs et routine d'affichage
        if ( ! Overscan )
            {
            if ( Mode < 3 )
                {
                memcpy( &ImgCPC[ 0x17D0 ], ModePal, sizeof( ModePal ) );
                if ( CpcPlus )
                    {
                    memcpy( &ImgCPC[ 0x7D0 ], CodeP0, sizeof( CodeP0 ) );
                    memcpy( &ImgCPC[ 0xFD0 ], CodeP1, sizeof( CodeP1 ) );
                    memcpy( &ImgCPC[ 0x1FD0 ], CodeP3, sizeof( CodeP3 ) );
                    }
                else
                    memcpy( &ImgCPC[ 0x7D0 ], CodeStd, sizeof( CodeStd ) );
                }
            else
                ImgCPC[ 0x7D1 ] = ModePal[ 1 ];
            }
        else
            {
            if ( NbLig == MAX_LIGNES_CPC && NbCol == MAX_COLS_CPC )
                {
                //memcpy( &ImgCPC[ 0x600 ], ModePal, sizeof( ModePal ) );
                if ( ! Cmp )
                    {
                    //if ( CpcPlus )
                    //    memcpy( &ImgCPC[ 0x621 ], CodeOvP, sizeof( CodeOvP ) );
                    //else
                    //    memcpy( &ImgCPC[ 0x611 ], CodeOv, sizeof( CodeOv ) );
                    }
                }
            }
        if ( Cmp )
            {
            LgCmp = PackImgSlide( ImgCPC
                                , BufCmp
                                , ModePal
                                , Mode
                                , TabVGA
                                , CpcPlus
                                , Overscan
                                );
            memcpy( ImgCPC, BufCmp, LgCmp );
            pos = LgCmp;
            }
        }
    return( pos );
}



static int CreeBitmapModeX( StRVB * Bitmap
                          , int NbLig
                          , int NbCol
                          )
{
    int pos = 0;

    memset( ImgCPC, 0, sizeof( ImgCPC ) );
    for ( int y = 0; y < NbLig; y += 2 )
        {
        int l1 = BITMAP_X * y * 2;
        int l2 = BITMAP_X * ( y + 1 ) * 2;
        for ( int x = 0; x < NbCol << 2 ; x++ )
            {
            //
            // Conversion pixels en fonction du mode CPC
            //
            BYTE Pix0 = Bitmap[ l1 ].a;
            BYTE Pix1 = Bitmap[ l2 ].a;
            ImgCPC[ pos++ ] = ( BYTE )( Pix1 + ( Pix0 << 4 ) );
            l1 += 2;
            l2 += 2;
            }
        }
    return( pos );
}


static void GenereAsm( FILE * fp, BYTE * Buffer, int Longueur )
{
    for ( int i = 0; i < Longueur; i += NB_OCT_LIGNE_DB )
        {
        int l = min( ( Longueur - i ), NB_OCT_LIGNE_DB );
        if ( l )
            {
            fprintf( fp, "        DB      " );
            for ( int j = 0; j < l; j++ )
                {
                fprintf( fp, "#%02X", Buffer[ i + j ] );
                if ( j < l - 1 )
                    fprintf( fp, ", " );
                }
            fprintf( fp, "\n" );
            }
        }
}


int SauveEcran( char * NomFic
              , StRVB * Bitmap
              , int Cmp
              , int Mode
              , int Palette[ 16 ]
              , BOOL CpcPlus
              , int NbLig
              , int NbCol
              , BOOL ModeLigne
              , BOOL ModeAsm
              , int Locale
              )
{
    int i, Lg;
    BOOL Overscan = ( NbLig * NbCol > 0x3F00 );

    if ( CpcPlus )
        {
        ModePal[ 0 ] = ( BYTE )( Mode | 0x8C );
        int k = 1;
        for ( i = 0; i < 16; i++ )
            {
            ModePal[ k++ ] = ( BYTE )Palette[ i ];
            ModePal[ k++ ] = ( BYTE )( Palette[ i ] >> 8 );
            }
        ModePal[ k++ ] = ModePal[ 1 ];
        ModePal[ k++ ] = ModePal[ 2 ];
        }
    else
        {
        ModePal[ 0 ] = ( BYTE )Mode;
        for ( i = 0; i < 16; i++ )
            if ( Mode < 3 )
                ModePal[ 1 + i ] = ( BYTE )Palette[ i ];
            else
                ModePal[ 1 + i ] = CpcVGA[ Palette[ i ] ];
        }

    FILE * fp = fopen( NomFic, ModeAsm ? "wt" : "wb" );
    if ( fp )
        {
        if ( Mode < 4 )
            Lg = CreeBitmapCPC( Bitmap
                              , Cmp
                              , Mode
                              , CpcPlus
                              , Overscan
                              , ModeLigne
                              , NbLig
                              , NbCol
                              );
        else
            Lg = CreeBitmapModeX( Bitmap, NbLig, NbCol );

        if ( ModeAsm )
            {
            fprintf( fp, ";\n; '%s'\n", NomFic );
            if ( Cmp )
                fprintf( fp, "; %s\n", GetTexteLoc( 50, Locale ) );

            fprintf( fp,"; Mode %d\n; %dx%d\n", Mode, NbCol, NbLig );

            if ( ModeLigne )
                fprintf( fp, "; %s\n", GetTexteLoc( 59, Locale ) );

            fprintf( fp, ";\n");
            GenereAsm( fp, ImgCPC, Lg );
            }
        else
            {
            CreeEntete( fp
                      , NomFic
                      , ( WORD )( Overscan ? 0x200 : 0xC000 )
                      , ( WORD )Lg
                      , ( WORD )( Overscan ? CpcPlus ? 0x821 : 0x811 : 0xC7D0 )
                      );
            fwrite( ImgCPC, Lg, 1, fp );
            }

        fclose( fp );
        return( Lg );
        }
    return( 0 );
}


BOOL SauvePalette( char * NomFic, int Mode, int Palette[ 16 ], BOOL CpcPlus )
{
    if ( CpcPlus )
        {
        memcpy( ModePal, "PAL_CPC+", 8 );
        int k = 8;
        for ( int i = 0; i < 16; i++ )
            {
            ModePal[ k++ ] = ( BYTE )Palette[ i ];
            ModePal[ k++ ] = ( BYTE )( Palette[ i ] >> 8 );
            }
        ModePal[ k++ ] = ModePal[ 1 ];
        ModePal[ k++ ] = ModePal[ 2 ];

        FILE * fp = fopen( NomFic, "wb" );
        if ( fp )
            {
            CreeEntete( fp, NomFic, 0x8809, sizeof( ModePal ), 0x8809 );
            fwrite( &ModePal, sizeof( ModePal ), 1, fp );
            fclose( fp );
            return( TRUE );
            }
        }
    else
        {
        memset( &Pal, 0, sizeof( Pal ) );
        Pal.Mode = ( BYTE )Mode;
        for ( int i = 0; i < 16; i++ )
            for ( int j = 0; j < 12; j++ )
                Pal.Palette[ i ][ j ] = CpcVGA[ Palette[ i ] ];

        for ( int i = 0; i < 12; i++ )
            Pal.Border[ i ] = Pal.Palette[ 0 ][ i ];

        FILE * fp = fopen( NomFic, "wb" );
        if ( fp )
            {
            CreeEntete( fp, NomFic, 0x8809, sizeof( Pal ), 0x8809 );
            fwrite( &Pal, sizeof( Pal ), 1, fp );
            fclose( fp );
            return( TRUE );
            }
        }
    return( FALSE );
}


BOOL CheckAmsdos( BYTE * Buf )
{
    int i, Checksum = 0;
    BOOL ModeAmsdos = FALSE;
    StAmsdos * pEntete = ( StAmsdos * )Buf;

    for ( i = 0; i < 67; i++ )
        Checksum += Buf[ i ];

    if ( pEntete->CheckSum == ( WORD )Checksum )
        ModeAmsdos = TRUE;

    return( ModeAmsdos );
}


BOOL LirePalette( char * NomFic, int Palette[ 16 ], BOOL CpcPlus )
{
    if ( CpcPlus )
        {
        FILE * fp = fopen( NomFic, "rb" );
        if ( fp )
            {
            fread( &Entete, sizeof( Entete ), 1, fp );
            fread( &ModePal, sizeof( ModePal ), 1, fp );
            fclose( fp );
            if ( CheckAmsdos( ( BYTE * )&Entete ) )
                {
                if ( ! strncmp( ( char * )ModePal, "PAL_CPC+", 8 ) )
                    {
                    int k = 8;
                    for ( int i = 0; i < 16; i++ )
                        {
                        Palette[ i ] = ModePal[ k ] + ( ModePal[ k + 1 ] << 8 );
                        k += 2;
                        }
                    return( TRUE );
                    }
                }
            }
        }
    else
        {
        FILE * fp = fopen( NomFic, "rb" );
        if ( fp )
            {
            fread( &Entete, sizeof( Entete ), 1, fp );
            fread( &Pal, sizeof( Pal ), 1, fp );
            fclose( fp );
            if ( CheckAmsdos( ( BYTE * )&Entete ) )
                {
                if ( Pal.Mode < 3 )
                    {
                    for ( int i = 0; i < 16; i++ )
                        for ( int j = 0; j < 27; j++ )
                            if ( Pal.Palette[ i ][ 0 ] == CpcVGA[ j ] )
                                Palette[ i ] = j;

                    return( TRUE );
                    }
                }
            }
        }
    return( FALSE );
}
