// delAmsHeader.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <iostream>

#define AMSDOS_HEADER_SIZE 128

int main( int argc, char *argv[ ] )
{
	if ( argc != 3 )
	{
		std::cout << "delAmsHeader version 1.0 -- AMSDOS Header Deleter  (crocolib)" << std::endl;

		std::cerr << "Not enough parameters !" << std::endl << std::endl;

		std::cout << "Usage:" << std::endl;
		std::cout << "  ARG1 = source filename with AMSDOS Header" << std::endl;
		std::cout << "  ARG2 = destination filename with AMSDOS Header to be removed" << std::endl;
		
		std::cout << std::endl;
		
		return 1;
	}

	FILE *intHandle = fopen( argv[ 1 ], "rb" );
	if ( !intHandle )
	{
		std::cerr << "Can't open " << argv[ 1 ] << " !" << std::endl;
		return 1;
	}

	fseek( intHandle, 0, SEEK_END );
	int inSize = ftell( intHandle );
	fseek( intHandle, 0, SEEK_SET );

	std::cout << std::endl << "Input size = " << inSize << " bytes, ";

	int outSize = inSize - AMSDOS_HEADER_SIZE;
	
	fseek( intHandle, AMSDOS_HEADER_SIZE, SEEK_SET );

	std::cout << "output size = " << outSize << " bytes, ";
	
	char *outImage = new char[ outSize ];
	fread( outImage, outSize, 1, intHandle );

	fclose( intHandle );

	FILE *outHandle = fopen( argv[ 2 ], "wb" );
	fwrite( outImage, outSize, 1, outHandle );
	fclose( outHandle );

	delete [] outImage;

	std::cout << "OK.";

	return 0;
}

