.386P
.MODEL FLAT,C

_TEXT SEGMENT DWORD PUBLIC 'CODE'
        ASSUME CS:_TEXT,DS:_DATA

; - interface ---------------------------------------------------------------
public  DrawString_ASM

public  InterpolateFrameBuffer_ASM
public  FadeFrameBuffer_ASM
public  CrossFadeFrameBuffer_ASM

public  BlurFrameBuffer_ASM
public  ScaleFrameBuffer_ASM
extrn   xscalingtable,yscalingtable:dword
public  DrawParticle_ASM
extrn   motionblurtable3:byte

public  DrawBackGround_ASM

public  DrawFlower_ASM
extrn   flowertable:dword
extrn   amptable:byte
extrn   motionblurtable31:byte

public  DrawRays_ASM
extrn   shadetable:byte

public  ExtractTransparentPicture_ASM
; - implementacio -----------------------------------------------------------
cadder            dd 0
charcounter       db 0

; - string rajzolo mag ------------------------------------------------------
DrawString_ASM      PROC NEAR
                    ; parameterek: EBX -> string, AL:= hossz,
                    ;              EDI:= destptr, ESI:= fontptr,
                    ;              ECX:= X, EDX:= Y

                    push ebp
                    inc al
                    mov [charcounter],al        ; charcounter++ (DEC miatt novelve)
                    mov ebp,ebx
                    imul edx,320
                    shl ecx,2
                    shl edx,2
                    add edi,ecx
                    add edi,edx                 ; EDI:= destptr + 4*(320*Y + X)

NxtChar:            movzx ecx,byte ptr [ebp]    ; soron kovetkezo karakter
                    dec [charcounter]
                    jz StringEnd                ; ha nem kell vegig kiirni
                    cmp cl,0
                    je StringEnd                ; ha sztringvege jelet kap

                    cmp cl,' '
                    jne NotSpace
                    inc ebp
                    add edi,4*6                 ; 6 pixel szeles space
                    jmp NxtChar

NotSpace:           push edi                    ; videoptr elmentese
                    sub cl,'a'                  ; indexre konvertalas
                    imul ecx,241                ; egy karakter merete [byte]

                    mov eax,320
                    sub al,byte ptr [esi + ecx]
                    shl eax,2
                    mov [cadder],eax            ; cadder:= 4*(320 - szelesseg)

                    mov bh,21;22                   ; konstans karaktermagassag
                    mov edx,ecx
                    inc edx                     ; EDX -> data
NxtRow:             mov bl,byte ptr [esi + ecx] ; EDX:= szelesseg
NxtPixel:           mov al,byte ptr [esi + edx]
                    cmp al,0
                    je Transparent              ; a 0-as pixel atlatszo
                    mov ah,al
                    shl eax,8
                    mov al,ah
                    mov dword ptr [edi],eax
Transparent:        inc edx
                    add edi,4                   ; kovetkezo pixel
                    dec bl
                    jnz NxtPixel
                    add edi,[cadder]
                    dec bh
                    jnz NxtRow

                    pop edi                     ; videoptr visszakerese
                    inc ebp                     ; kovetkezo karakter
                    movzx eax,byte ptr [esi + ecx]
                    add eax,2
                    shl eax,2
                    add edi,eax                 ; EDI:= oldvideoptr + 4*(szelesseg + 2)
                    jmp NxtChar

StringEnd:          pop ebp
                    ret

DrawString_ASM      ENDP

; - kepernyo interpolator (1-1 pixel vizszintesen es fuggolegesen) mag ------
InterpolateFrameBuffer_ASM     PROC NEAR
                ; parameter: EDI -> framebuffer

                push ebp

                ; vizszintes interpolacio
                push edi
                mov ebp,46 ; sorok
NxtLine:        mov esi,80 ; interpolalando pixelek
NxtTriplet:     xor eax,eax ; pixeltarolok es deltak uritese
                xor ebx,ebx
                xor ecx,ecx
                xor edx,edx

                mov ah,byte ptr [edi] ; B1 be
                mov ch,byte ptr [edi + 1] ; G1 be
                mov bh,byte ptr [edi + 4*4] ; B2 be
                mov dh,byte ptr [edi + 4*4 + 1] ; G2 be

                sub ebx,eax ; B2 - B1
                sub edx,ecx ; G2 - G1
                sar ebx,2 ; BX:= ((B2 - B1)<<8)/4
                sar edx,2 ; DX:= ((G2 - G1)<<8)/4

                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 4],ah
                mov byte ptr [edi + 4 + 1],ch
                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 2*4],ah
                mov byte ptr [edi + 2*4 + 1],ch
                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 3*4],ah
                mov byte ptr [edi + 3*4 + 1],ch

                xor eax,eax
                xor ebx,ebx
                mov ah,byte ptr [edi + 2] ; R1 be
                mov bh,byte ptr [edi + 4*4 + 2] ; R2 be
                sub ebx,eax ; R2 - R1
                sar ebx,2 ; BX:= ((R2 - R1)<<8)/4

                add eax,ebx
                mov byte ptr [edi + 4 + 2],ah
                add eax,ebx
                mov byte ptr [edi + 2*4 + 2],ah
                add eax,ebx
                mov byte ptr [edi + 3*4 + 2],ah

                add edi,4*4 ; kovetkezo pixel 4-gyel jobbra
                dec esi
                jnz NxtTriplet
                add edi,3*4*320 ; kovetkezo sor 4-gyel lejjebb
                dec ebp
                jnz NxtLine

                ; fuggoleges interpolacio
                pop edi
                mov ebp,45
NxtHLine:       mov esi,320 ; interpolalando pixelek
NxtHTriplet:    xor eax,eax ; pixeltarolok es deltak uritese
                xor ebx,ebx
                xor ecx,ecx
                xor edx,edx

                mov ah,byte ptr [edi] ; B1 be
                mov ch,byte ptr [edi + 1] ; G1 be
                mov bh,byte ptr [edi + 4*4*320] ; B2 be
                mov dh,byte ptr [edi + 4*4*320 + 1] ; G2 be

                sub ebx,eax ; B2 - B1
                sub edx,ecx ; G2 - G1
                sar ebx,2 ; BX:= ((B2 - B1)<<8)/4
                sar edx,2 ; DX:= ((G2 - G1)<<8)/4

                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 4*320],ah
                mov byte ptr [edi + 4*320 + 1],ch
                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 2*4*320],ah
                mov byte ptr [edi + 2*4*320 + 1],ch
                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 3*4*320],ah
                mov byte ptr [edi + 3*4*320 + 1],ch

                xor eax,eax
                xor ebx,ebx
                mov ah,byte ptr [edi + 2] ; R1 be
                mov bh,byte ptr [edi + 4*4*320 + 2] ; R2 be
                sub ebx,eax ; R2 - R1
                sar ebx,2 ; BX:= ((R2 - R1)<<8)/4

                add eax,ebx
                mov byte ptr [edi + 4*320 + 2],ah
                add eax,ebx
                mov byte ptr [edi + 2*4*320 + 2],ah
                add eax,ebx
                mov byte ptr [edi + 3*4*320 + 2],ah

                add edi,4 ; kovetkezo pixel 1-el jobbra
                dec esi
                jnz NxtHTriplet
                add edi,3*4*320 ; kovetkezo sor 4-gyel lejjebb
                dec ebp
                jnz NxtHLine

                pop ebp
                ret

InterpolateFrameBuffer_ASM     ENDP

; - kepernyo fader mag ------------------------------------------------------
FadeFrameBuffer_ASM       PROC NEAR
                ; parameter: EDI -> framebuffer, ESI -> shadetable,
                ;            EAX:= factor

                shl eax,8
                xor ebx,ebx
                xor edx,edx
                mov bh,ah
                mov dh,ah ;AH:= BH:= DH:= fadefactor
                mov ecx,320*200
NxtFPix:        mov al,byte ptr [edi] ; B be
                mov bl,byte ptr [edi + 1] ;  G be
                mov dl,byte ptr [edi + 2] ;  R be
                mov al,byte ptr [esi + eax]
                mov bl,byte ptr [esi + ebx]
                mov dl,byte ptr [esi + edx]
                mov byte ptr [edi],al ; B ki
                mov byte ptr [edi + 1],bl ; G ki
                mov byte ptr [edi + 2],dl ; R ki
                add edi,4 ; kovetkezo pixel
                dec ecx
                jnz NxtFPix

                ret

FadeFrameBuffer_ASM       ENDP

; - kepernyo crossfader mag -------------------------------------------------
CrossFadeFrameBuffer_ASM    PROC NEAR

                ; parametek: EDI:= destptr, ESI:= srcptr,
                ;            EBX:= shadetable, EDX:= factor;

                push ebp
                mov ebp,ebx ; EBP -> shadetable

                mov ecx,320*200
                shl eax,8 ; AH:= factor
                xor ebx,ebx
                neg ah
iNxtPix:        neg ah ; AH:= factor
                mov al,byte ptr [edi] ; B1 be
                mov bl,[ebp + eax] ; BL:= B1 factor arnyalatban
                neg ah ; AH:= (255 - factor)
                mov al,byte ptr [esi] ; B2
                add bl,[ebp + eax] ; BL:= B1 factor arnyalatban + B2 (255 - factor) arnyalatban
                mov byte ptr [edi],bl

                neg ah ; AH:= factor
                mov al,byte ptr [edi + 1] ; G1 be
                mov bl,[ebp + eax] ; BL:= G1 factor arnyalatban
                neg ah ; AH:= (255 - factor)
                mov al,byte ptr [esi + 1] ; G2 be
                add bl,[ebp + eax] ; BL:= G1 factor arnyalatban + G2 (255 - factor) arnyalatban
                mov byte ptr [edi + 1],bl

                neg ah ; AH:= factor
                mov al,byte ptr [edi + 2] ; R1 be
                mov bl,[ebp + eax] ; BL:= R1 factor arnyalatban
                neg ah ; AH:= (255 - factor)
                mov al,byte ptr [esi + 2] ; R2 be
                add bl,[ebp + eax] ; BL:= R1 factor arnyalatban + R2 (255 - factor) arnyalatban
                mov byte ptr [edi + 2],bl

                add edi,4 ; kovetkezo pixel
                add esi,4
                dec ecx
                jnz iNxtPix

                pop ebp

                ret

CrossFadeFrameBuffer_ASM    ENDP

; - particle system rutinok magjai ------------------------------------------
BlurFrameBuffer_ASM   PROC NEAR
                ; parametek: EDI:= destptr, ESI:= srcptr

                mov ecx,320*180
                xor eax,eax ; pixeltarolok nullazasa
                xor ebx,ebx
                xor edx,edx
                add esi,4*320 ; 2. sortol kezdunk
                add edi,4*320
bNxtPix:        mov al,byte ptr [esi - 4*320] ; B felette
                mov bl,byte ptr [esi - 4*320 + 1]; G felette
                mov dl,byte ptr [esi - 4*320 + 2]; R felette

                add al,byte ptr [esi - 4] ; B balra
                adc ah,0
                add bl,byte ptr [esi - 4 + 1] ; G balra
                adc bh,0
                add dl,byte ptr [esi - 4 + 2] ; R balra
                adc dh,0

                add al,byte ptr [esi + 4] ; B jobbra
                adc ah,0
                add bl,byte ptr [esi + 4 + 1] ; G jobbra
                adc bh,0
                add dl,byte ptr [esi + 4 + 2] ; R jobbra
                adc dh,0

                add al,byte ptr [esi + 4*320] ; B alatta
                adc ah,0
                add bl,byte ptr [esi + 4*320 + 1] ; G alatta
                adc bh,0
                add dl,byte ptr [esi + 4*320 + 2] ; R alatta
                adc dh,0

                shr eax,2 ; B/4
                shr ebx,2 ; G/4
                shr edx,2 ; R/4
                mov byte ptr [edi],al ; B ki
                mov byte ptr [edi + 1],bl ; G ki
                mov byte ptr [edi + 2],dl ; R ki
                add esi,4 ; kovetkezo pixel
                add edi,4
                dec ecx
                jnz bNxtPix

                ret

BlurFrameBuffer_ASM  ENDP

ScaleFrameBuffer_ASM  PROC NEAR
                ; parameterek: EDI:= destptr, ESI:= srcptr, ECX:= kezdo_entry

cNxtRow:        xor edx,edx ; oszlopok
                mov ebx,dword ptr [yscalingtable + 4*ecx]
                imul ebx,320
cNxtPix:        push ebx
                add ebx,dword ptr [xscalingtable + 4*edx] ; EBX:= 320*yscalingtable[y] + xscalingtable[x]
                mov eax,dword ptr [esi + 4*ebx] ; pixel be
                inc edx ; kovetkezo xscalingtable bejegyzes
                pop ebx
                cmp edx,320
                stosd ; pixel ki
                jb cNxtPix
                inc ecx ; kovetkezo yscalingtable bejegyzes
                cmp ecx,200
                jb cNxtRow

                ret

ScaleFrameBuffer_ASM  ENDP

PARTICLESIZE      EQU 12
particlebitmap    db    0,0,0,0,1,1,1,1,0,0,0,0 ; 12x12-es
                  db    0,0,1,1,1,1,1,1,1,1,0,0
                  db    0,1,1,1,1,1,1,1,1,1,1,0
                  db    0,1,1,1,1,1,1,1,1,1,1,0
                  db    1,1,1,1,1,1,1,1,1,1,1,1
                  db    1,1,1,1,1,1,1,1,1,1,1,1
                  db    1,1,1,1,1,1,1,1,1,1,1,1
                  db    1,1,1,1,1,1,1,1,1,1,1,1
                  db    0,1,1,1,1,1,1,1,1,1,1,0
                  db    0,1,1,1,1,1,1,1,1,1,1,0
                  db    0,0,1,1,1,1,1,1,1,1,0,0
                  db    0,0,0,0,1,1,1,1,0,0,0,0

DrawParticle_ASM    PROC NEAR
                ; parameterek: EDI:=destptr, EBX:=X, ECX:=Y, EAX:=color

                imul ecx,320
                shl ebx,2
                shl ecx,2
                add edi,ebx
                add edi,ecx
                mov esi,offset particlebitmap ; ESI -> bitmap
                sub edi,4*((320 * PARTICLESIZE/2) + PARTICLESIZE/2)

                mov ch,PARTICLESIZE ; fuggoleges meret
NxtPRow:        mov cl,PARTICLESIZE ; vizszintes meret
NxtPPix:        cmp byte ptr [esi],1
                jne NoDraw

                xor ebx,ebx
                mov bl,byte ptr [edi] ; B_old be
                mov edx,eax
                shr edx,16
                mov bh,dl ; B_new be
                mov bl,motionblurtable3[ebx]
                mov byte ptr [edi],bl ; B ki

                mov bl,byte ptr [edi + 1] ; G_old be
                mov bh,ah ; G_new be
                mov bl,motionblurtable3[ebx]
                mov byte ptr [edi + 1],bl ; G ki

                mov bl,byte ptr [edi + 2] ; R_old be
                mov bh,al ; R_new be
                mov bl,motionblurtable3[ebx]
                mov byte ptr [edi + 2],bl ; B ki

NoDraw:         inc esi ; kovetkezo pixel
                add edi,4
                dec cl
                jnz NxtPPix
                add edi,4*(320 - PARTICLESIZE)
                dec ch
                jnz NxtPRow

                ret

DrawParticle_ASM    ENDP

; - hatterrajzolo mag -------------------------------------------------------
DrawBackGround_ASM  PROC NEAR
                    ; parameterek: EDI:= destptr, ESI:= fontptr,

                    mov ebx,6 ; kockasorok szama
NxtCRow:            mov edx,8
NxtCCube:           mov ah,byte ptr [esi + 2]
                    mov al,byte ptr [esi + 1]
                    shl eax,16
                    mov ah,byte ptr [esi] ; EAX:= pixel
                    mov ch,40 ; kockaszelesseg
NxtCPix:            push edi
                    mov cl,20 ; kockamagassag
NxtCPixDown:        mov dword ptr [edi],eax
                    add edi,4*320
                    dec cl
                    jnz NxtCPixDown
                    pop edi
                    stosd
                    dec ch ; kovetkezo pixel
                    jnz NxtCPix
                    add esi,3 ; kovetkezo kocka
                    dec edx
                    jnz NxtCCube
                    add edi,19*4*320
                    dec ebx ; kovetkezo kockasor
                    jnz NxtCRow

                    ret

DrawBackGround_ASM  ENDP

; - viragrajzolo mag --------------------------------------------------------
paletteptr       dd 0

DrawFlower_ASM   PROC NEAR
                    ; parametek: EDI:= destptr, EAX:= palette

                    lea esi,amptable ; ESI -> amptable
                    lea ebx,flowertable ; EBX -> flowertable
                    mov ecx,320*10 ; 10 sor kihagyasa felul
                    mov [paletteptr],eax ; paletteptr elmentese

fNxtPix:            xor eax,eax
                    xor edx,edx
                    mov al,[ebx + ecx*2 + 1] ; EAX:= flowertable[2*i + 1]
                    mov dl,[esi + eax]
                    sub dl,[ebx + ecx*2] ; DL:= amptable[EAX] - flowertable[2*i]
                    jnc NoUrfw
                    mov dl,0
NoUrfw:             mov al,[ebx + ecx*2 + 1 + 2] ; EAX:= flowertable[2*i + 1 + 2]
                    mov dh,[esi + eax]
                    sub dh,[ebx + ecx*2 + 2] ; DH:= amptable[EAX] - flowertable[2*i + 2]
                    jnc NoUfw2
                    mov dh,0
NoUfw2:             mov al,dl ; pixel#1 indexe: DL, pixel#2-e: DH
                    shr edx,10 ; tovabbosztas 4-gyel (64 paletteentry-nk van)
                    shr eax,2
                    add ecx,2 ; kovetkezo pixel

                    push ebx
                    push ecx
                    mov ebx,eax
                    push esi
                    xor eax,eax ; pixeltarolok nullazasa
                    xor ecx,ecx
                    mov esi,paletteptr ; ESI -> palette

                    mov ah,byte ptr [esi + 4*ebx] ; B1_new be
                    mov ch,byte ptr [esi + 4*ebx + 1] ; G1_new be
                    mov al,byte ptr [edi] ; B1_old be
                    mov cl,byte ptr [edi + 1] ; G1_old be
                    mov al,motionblurtable31[eax]
                    mov cl,motionblurtable31[ecx]
                    mov byte ptr [edi],al ; B1 ki
                    mov byte ptr [edi+ 1],cl ; G1 ki

                    mov ah,byte ptr [esi + 4*ebx + 2] ; R1_new be
                    mov ch,byte ptr [esi + 4*edx] ; B2_new be
                    mov al,byte ptr [edi + 2] ; R1_old be
                    mov cl,byte ptr [edi + 4] ; B2_old be
                    mov al,motionblurtable31[eax]
                    mov cl,motionblurtable31[ecx]
                    mov byte ptr [edi + 2],al ; R1 ki
                    mov byte ptr [edi + 4],cl ; B2 ki

                    mov ah,byte ptr [esi + 4*edx + 1] ; G2_new be
                    mov ch,byte ptr [esi + 4*edx + 2] ; R2_new be
                    mov al,byte ptr [edi + 5] ; G2_old be
                    mov cl,byte ptr [edi + 6] ; R2_old be
                    mov al,motionblurtable31[eax]
                    mov cl,motionblurtable31[ecx]
                    mov byte ptr [edi+ 5],al ; G2 ki
                    mov byte ptr [edi + 6],cl ; R2 ki

                    pop esi
                    pop ecx
                    pop ebx
                    add edi,8 ; kovekezo pixel
                    cmp ecx,320*190
                    jb fNxtPix

                    ret

DrawFlower_ASM  ENDP

; - sugarrajzolo mag --------------------------------------------------------
tempptr dd 0

DrawRays_ASM    PROC NEAR
        ; parameterek: EDI:= destptr, ESI:= srcptr, ECX:= gorbulesi faktor
                    mov [tempptr],eax ; !!!!!!
                    push ebp
                    xor ebx,ebx
                    mov ebp,320*10*2 ; 10 sor kimarad

aNxtPix:            movzx edx,byte ptr flowertable[ebp] ; DL:= distance
                    mov bl,byte ptr flowertable[ebp + 1] ; BL:= angle
                    mov dh,cl

                    push esi
                    mov esi,tempptr
                    mov dl,[esi + edx] ; EDX:= korrigalt distance
                    pop esi

                    cmp cl,0
                    jge aNoNeg
                    neg dl ; EDX= -korrigalt distance

aNoNeg:             push ecx ; faktor elmentese
                    add bl,dl
                    and ebx,0FFh ; EBX:= (angle + (distance>>factor)) & 256

                    movzx eax,byte ptr [edi] ; B_old be
                    movzx ecx,byte ptr [edi + 1] ; G_old be
                    movzx edx,byte ptr [edi + 2] ; R_old be
                    mov ah,byte ptr [esi + 4*ebx] ; B be
                    mov ch,byte ptr [esi + 4*ebx + 1] ; G be
                    mov dh,byte ptr [esi + 4*ebx + 2] ; R be
                    mov al,motionblurtable31[eax]
                    mov cl,motionblurtable31[ecx]
                    mov dl,motionblurtable31[edx]
                    mov byte ptr [edi],al ; B_blur ki
                    mov byte ptr [edi + 1],cl ; G_blur ki
                    mov byte ptr [edi + 2],dl ; R_blur ki

                    add ebp,2 ; kovetkezo tablabejegyzes
                    add edi,4 ; kovetkezo pixel
                    pop ecx ; faktor vissza
                    cmp ebp,320*190*2
                    jb aNxtPix

                    pop ebp
                    ret

DrawRays_ASM    ENDP

; - transzparens grafikakitomorito mag --------------------------------------
nextlineESIadder  dd 0
nextlineEDIadder  dd 0

ExtractTransparentPicture_ASM   PROC NEAR
                    ; parameterek: EDI:= destptr, ESI:= texture_srcptr
                    ;              EDX:= width

                    push ebp
                    mov ebp,esi ; EBP -> paletta
                    add esi,3*256 ; ESI -> pixel data
                    cmp edx,64
                    jbe NoTruncWidth
                    mov edx,64 ; if(width > 64) width= 64
NoTruncWidth:       mov eax,320
                    mov ebx,64
                    sub eax,edx
                    sub ebx,edx
                    shl eax,2
                    mov [nextlineESIadder],ebx ; EBX:= 64 - width
                    mov [nextlineEDIadder],eax ; EAX:= 4*(320 - width)

                    mov ch,64 ; sorok
NxtConvRow:         mov cl,dl ; pixelek
NxtConvPix:         lodsb ; AL:= szin indexe
                    cmp al,0
                    je TransparentPix ; 0-as szin az atlatszo
                    and eax,0FFh
                    imul eax,3
                    movzx ebx,byte ptr [ebp + eax + 0] ; B_above be
                    mov bh,byte ptr [edi + 2] ; B_below be
                    mov bl,motionblurtable3[ebx]
                    mov byte ptr [edi + 2],bl ; B ki

                    movzx ebx,byte ptr [ebp + eax + 1] ; G_above be
                    mov bh,byte ptr [edi + 1] ; G_below be
                    mov bl,motionblurtable3[ebx]
                    mov byte ptr [edi + 1],bl ; G ki

                    movzx ebx,byte ptr [ebp + eax + 2] ; R_above be
                    mov bh,byte ptr [edi + 0] ; R_below be
                    mov bl,motionblurtable3[ebx]
                    mov byte ptr [edi + 0],bl ; B ki

TransparentPix:     add edi,4 ; kovetkezo 32bit-es pixel
                    dec cl
                    jnz NxtConvPix
                    add esi,[nextlineESIadder] ; kovetkezo sor
                    add edi,[nextlineEDIadder]
                    dec ch
                    jnz NxtConvRow

                    pop ebp
                    ret

ExtractTransparentPicture_ASM   ENDP
; - vege --------------------------------------------------------------------

_TEXT ENDS

END