.386P
.MODEL FLAT,C

_TEXT SEGMENT DWORD PUBLIC 'CODE'
        ASSUME CS:_TEXT,DS:_DATA

; - interface ---------------------------------------------------------------
public  GetVESAInfo_ASM
public  Detect320x200Mode_ASM

; - implementacio -----------------------------------------------------------
modenr dd 0
bitsperpixelwanted db 0

; - VESA informaciot lekero mag ---------------------------------------------
GetVesaInfo_ASM PROC NEAR

                ; real mode memoriafoglalas a VESAInfoBlock-nak:
                mov ax,0100h
                mov bx,512/16               ; blokk merete paragraph-ban
                int 31h
                mov ecx,eax                 ; blockpointer elmentese
                and ecx,0FFFFh
                shl ecx,4
                mov [dosmem_address],ecx
                mov [dosmem_segment],ax
                mov [dosmem_selector],dx

                ; GetVesaInfo VBE hivas:
                mov edi,offset RMREGS
                mov [rm_eax],4F00h
                mov [rm_es],ax
                mov [rm_edi],0
                mov eax,0300h               ; DPMI realmode interrupt hivas
                mov bx,010h
                mov cx,0
                int 031h

                mov ecx,[dosmem_address]    ; visszateresi ertek: VBE verzio
                movzx eax,[ecx.VBEINFOBLOCK.VbeVersion]

                ret

GetVesaInfo_ASM ENDP

Detect320x200Mode_ASM     PROC NEAR
                ; parameter: EBX:= kivant bpp, ESI:= LFB tarolo cime

                push esi
                mov [bitsperpixelwanted],bl
                mov [modenr],04100h

                ; GetVesaModeInfo VBE hivas:
TestNxtMode:    mov edi,offset RMREGS
                mov [rm_eax],04F01h
                mov eax,[modenr]
                mov [rm_ecx],eax            ; videomod kodja
                mov ax,[dosmem_segment]
                mov [rm_es],ax
                mov [rm_edi],0
                mov eax,0300h               ; DPMI realmode interrupt hivas
                mov ebx,010h
                mov cx,0
                int 31h

                mov ecx,[dosmem_address]    ; a videomod 320x200xbppwanted?
                cmp [ecx.VBEINFOBLOCK.XResolution],320
                jne NxtVidMode
                cmp [ecx.VBEINFOBLOCK.YResolution],200
                jne NxtVidMode
                mov al,[bitsperpixelwanted]
                cmp [ecx.VBEINFOBLOCK.BitsPerPixel],al
                jne NxtVidMode

                mov ebx,[modenr]            ; visszateresi ertek: detektalt videomod
                pop esi
                mov eax,[ecx.VBEINFOBLOCK.PhysBasePtr]
                mov dword ptr [esi],eax     ; LFB cimenek bemasolasa
                jmp FreeBuffer

NxtVidMode:     inc [modenr]                ; kovetkezo videomod
                cmp [modenr],04100h + 256   ; 256-ot probalunk vegig
                jb TestNxtMode

                xor ebx,ebx                 ; visszateresi ertek: 0
                pop esi
                mov dword ptr [esi],0       ; LFB cime is 0
FreeBuffer:     mov ax,0101h                ; DOS buffer felszabaditasa
                mov dx,[dosmem_selector]
                int 031h

                ret

Detect320x200Mode_ASM     ENDP

_TEXT ENDS

_DATA   SEGMENT use32 DWORD PUBLIC 'DATA'
          ASSUME DS:_DATA

RMREGS    label   dword
          rm_edi            dd      0
          rm_esi            dd      0
          rm_ebp            dd      0
          rm_esp            dd      0
          rm_ebx            dd      0
          rm_edx            dd      0
          rm_ecx            dd      0
          rm_eax            dd      0
          rm_flags          dw      0
          rm_es             dw      0
          rm_ds             dw      0
          rm_fs             dw      0
          rm_gs             dw      0
          rm_ip             dw      0
          rm_cs             dw      0
          rm_sp             dw      0
          rm_ss             dw      0
          rm_sparedata      dd      20 dup (0)

; ---

VBEINFOBLOCK    STRUC

VbeSignature        db 'VESA'        ; VBE Signature
VbeVersion          dw 0200h         ; VBE Version
OemStringPtr        dd ?             ; Pointer to OEM String
Capabilities        db 4 dup (?)     ; Capabilities of graphics cont.
VideoModePtr        dd ?             ; Pointer to Video Mode List
TotalMemory         dw ?             ; Number of 64kb memory blocks

        ; Added for VBE 2.0

OemSoftwareRev      dw ?             ; VBE implementation Software revision
OemVendorNamePtr    dd ?             ; Pointer to Vendor Name String
OemProductNamePtr   dd ?             ; Pointer to Product Name String
OemProductRevPtr    dd ?             ; Pointer to Product Revision String
_Reserved_          db 222 dup (?)   ; Reserved for VBE implementation

        ; scratch area

OemData             db   256 dup (?) ; Data Area for OEM Strings

VBEINFOBLOCK    ENDS

;---

MODEINFOBLOCK   STRUC

        ; Mandatory information for all VBE revisions:

ModeAttributes      dw ?        ; mode attributes
WinAAttributes      db ?        ; window A attributes
WinBAttributes      db ?        ; window B attributes
WinGranularity      dw ?        ; window granularity
WinSize             dw ?        ; window size
WinASegment         dw ?        ; window A start segment
WinBSegment         dw ?        ; window B start segment
WinFuncPtr          dd ?        ; pointer to window function
BytesPerScanLine    dw ?        ; bytes per scan line

        ; Mandatory information for VBE 1.2 and above:

XResolution         dw ?        ; horizontal resolution in pixels or chars
YResolution         dw ?        ; vertical resolution in pixels or chars
XCharSize           db ?        ; character cell width in pixels
YCharSize           db ?        ; character cell height in pixels
NumberOfPlanes      db ?        ; number of memory planes
BitsPerPixel        db ?        ; bits per pixel
NumberOfBanks       db ?        ; number of banks
MemoryModel         db ?        ; memory model type
BankSize            db ?        ; bank size in KB
NumberOfImagePages  db ?        ; number of images
_Reserved           db ?        ; reserved for page function

        ; Direct Color fields (required for direct/6 and YUV/7 memory models)

RedMaskSize         db ?        ; size of direct color red mask in bits
RedFieldPosition    db ?        ; bit position of lsb of red mask
GreenMaskSize       db ?        ; size of direct color green mask in bits
GreenFieldPosition  db ?        ; bit position of lsb of green mask
BlueMaskSize        db ?        ; size of direct color blue mask in bits
BlueFieldPosition   db ?        ; bit position of lsb of blue mask
RsvdMaskSize        db ?        ; size of direct color reserved mask in bits
RsvdFieldPosition   db ?        ; bit position of lsb of reserved mask
DirectColorModeInfo db ?        ; direct color mode attributes

        ; Mandatory information for VBE 2.0 and above:

PhysBasePtr         dd ?        ; physical address for flat frame buffer
OffScreenMemOffset  dd ?        ; pointer to start of off screen memory
OffScreenMemSize    dw ?        ; amount of off screen memory in 1k units
__Reserved          db 206 dup (?)

MODEINFOBLOCK   ENDS

; ---

dosmem_address dd 0
dosmem_segment dw 0
dosmem_selector dw 0

_DATA ENDS

END