from setuptools import setup, find_namespace_packages

setup(
    name="demosys-py",
    version="2.1.1",
    description="Modern OpenGL 3.3+ Framework inspired by Django",
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    url="https://github.com/Contraz/demosys-py",
    author="Einar Forselv",
    author_email="eforselv@gmail.com",
    maintainer="Einar Forselv",
    maintainer_email="eforselv@gmail.com",
    packages=find_namespace_packages(include=['demosys', 'demosys.*']),
    include_package_data=True,
    keywords = ['opengl', 'framework', 'demoscene'],
    classifiers=[
        'Programming Language :: Python',
        'Environment :: MacOS X',
        'Environment :: X11 Applications',
        'Intended Audience :: Developers',
        'Topic :: Multimedia :: Graphics',
        'License :: OSI Approved :: ISC License (ISCL)',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Topic :: Software Development :: Libraries :: Application Frameworks',
    ],
    install_requires=[
        'moderngl==5.5.4',
        'pyrr>=0.10.3',
        'Pillow>=7.1.2',
        'pyrocket==0.2.8',
        'PyWavefront==1.3.2',
        'PyQt5>=5.14.2 ',
        'trimesh>=2.38',
    ],
    extras_require={
        "glfw": ['glfw==1.7.0'],
        "pyglet": ['pyglet==1.3.2'],
        "python-vlc": ['python-vlc==3.0.102'],
        "PySDL2": ['PySDL2==0.9.6'],
    },
    entry_points={'console_scripts': [
        'demosys-admin = demosys.management:execute_from_command_line',
    ]},
)
