
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; TED chip Music Player (C16/Plus4 music driver) by 4Mat - 13/06/2004
;;
;;
;; Player Test Code:
;;

* = $1001

.WORD start - 2
.WORD 0
.BYTE $9e
.TEXT " 4110"
.BYTE 0
.WORD 0

start
sei

jsr init

clc
ldy #49
ldx #$60
rastertime tya
sta $0d80,x
iny
txa
adc #$28
tax
cpy #52
bne rastertime
lda #$00
sta $f8

loop ldy #$63
rast cpy $ff1d
bne  rast
lda #$66
sta $ff15
jsr  playframe

lda #$71
sta $ff15

jmp  loop

;; 
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Music Driver Code:
;; 
;; Compile address     = driver init
;; Compile address+$03 = driver play (call once per frame)

;; * = $1001 

jmp init
jmp playframe

init
lda #$01
sta tempocnt
ldx #$00
init2
lda songstart,x
sta songpos,x
jsr getpat
inx
cpx #$02
bne init2
rts

playframe

ldx #$00
stx thevol

noteloop
lda ticks
beq dothis
jmp update

dothis
dec delay,x
bmi newnote
jmp update



newnote

lda pattpos,x
tay
lda patttab,y

nonewpat
inc pattpos,x
cmp #$ef
bcc noinst
and #$0f
sta currinst,x
jmp newnote

noinst
bpl justnote
and #$0f
sta delayval,x
jmp newnote

justnote cmp #$00
bne notsilence
lda delayval,x
sta delay,x
lda prevnote,x
sta note,x
jmp update

notsilence
sta note,x
sta prevnote,x

lda delayval,x
sta delay,x

asnormal

lda transtemp,x
sta transpose,x
ldy currinst,x
lda inststr,y
sta instpos,x
lda volpri,y
and #$0f
cmp priority
bcs dovol
jmp novol
dovol
sta priority
lda volstrt,y
and #$0f
sta volmast
sty volnum
novol

ldy currinst,x
lda notelen,y
and #$7f
sta notewait,x
update
lda notewait,x
bpl playusual
lda #$00
sta notewait,x
jmp playnowt

playusual
lda #$00
sta temp3
ldy instpos,x

lda insttab,y
sta temp2

cmp #$f0
bcs repeat
cmp #$e0
bcs playarp
cmp #$00
beq playcont

jmp playnowt 

playarp

and #$0f
sta temp2
jmp playcont

repeat
and #$0f
sta temp2
tya
clc
sbc temp2
sta instpos,x
jmp playusual

playcont
lda note,x
beq playnowt

clc
adc transpose,x
adc temp2
tay
lda freqhi,y
sta temp3
lda freqlo,y

pha 
ldy currinst,x
lda volpri,y
bpl novibrato
lda insvibc
and #$07 
cmp #$04 
bcc novibres
eor #$07 
novibres 
clc
sbc #$01
sta temp2 
pla 
sbc temp2
jmp playnowt
novibrato
pla 

playnowt
sta $ff0e,x 
beq decdelay

checkchan
lda temp3
cpx #$01
bne otherchan
sta $ff10 
clc
lda thevol
adc #$20
sta thevol
jmp decdelay
otherchan 

lda $ff12
and #$fc
eor temp3
sta $ff12
clc
lda thevol
adc #$10
sta thevol  
 
decdelay 
dec notewait,x
bmi nonoise

ldy currinst,x
lda notelen,y
and #$80
cmp #$00
beq nonoise

inc instpos,x
ldy instpos,x
lda insttab,y 
cmp #$00
beq nonoise

sta $ff0f
lda #$03
sta $ff10
clc
lda thevol
adc #$20
sta thevol

nonoise
inc instpos,x
inx
cpx #$02
beq dothevol
jmp noteloop

dothevol

clc
lda volmast
adc thevol
sta $ff11 

ldy volnum

lda volstrt,y
lsr
lsr
lsr
lsr
sta temp2

lda volmast
cmp temp2 
bcc novolfix 
sbc voldec,y
sta volmast

jmp volfixok
novolfix

lda #$00
sta priority


volfixok 

inc insvibc

dec ticks
lda ticks
bmi reset 

cmp #$02
bcc pcheck
rts

pcheck tax
lda pattpos,x
tay
lda patttab,y
cmp #$7f
bne nonewone
jsr getpat

nonewone rts 

reset
inc tempocnt
lda tempocnt
and #$01
sta tempocnt
tay
lda tempo,y
sta ticks 

rts

getpat
lda songpos,x
tay
lda songtab,y
cmp #$ff
bne nopatreset

lda songstart,x
sta songpos,x
jmp getpat

nopatreset 

cmp #$df
bcc norepeat
 
cmp #$f0
bcs yesrepeat

ldy repeaty,x
beq repeatthis
lda #$00
sta repeaty,x
jmp songskip

repeatthis
and #$0f
sta repeaty,x

clc
lda songpos,x
sbc repeaty,x
sta songpos,x

jmp songskip

yesrepeat
and #$0f
sta patwait,x
songskip
inc songpos,x
jmp getpat

norepeat
pha 
and #$0f
tay 
lda pattstart,y
sta pattpos,x
pla 
lsr
lsr
lsr
lsr
sta transtemp,x

dec patwait,x
lda patwait,x

bpl notfin
inc songpos,x
lda #$00
sta patwait,x
notfin
rts

freqhi  

.byte $00,$00,$00,$00
.byte $00,$00,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02
.byte $02,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03
.byte $03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03
.byte $03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03

freqlo

.byte $00,$07,$40,$76
.byte $A9,$D9,$06,$31,$59,$7F,$A3,$C5,$E5,$04,$20,$3B,$54,$6C,$83
.byte $98,$AD,$C0,$D2,$E3,$F3,$02,$10,$1E,$2A,$36,$42,$4C,$56,$60,$69
.byte $71,$79,$81,$88,$8F,$95,$9B,$A1,$A6,$AB,$B0,$B4,$B9,$BD,$C0,$C4
.byte $C7,$CB,$CE,$D0,$D3,$D6,$D8,$DA,$DC,$DE,$E0,$E2,$E4

tempo   .byte $05,$05

inststr .byte $00,$02,$09,$10,$17,$1e,$25,$28,$2f,$36,$3b,$44,$49,$4e

insttab .byte $00,$f0
        .byte $00,$00,$e3,$e3,$e7,$e7,$f5
        .byte $00,$00,$e4,$e4,$e7,$e7,$f5
	.byte $00,$00,$e2,$e2,$e7,$e7,$f5
	.byte $00,$00,$e5,$e5,$e7,$e7,$f5
	.byte $00,$00,$e5,$e5,$e9,$e9,$f5
	.byte $ec,$00,$f0	
	.byte $0c,$00,$00,$3c,$00,$00,$f1
	.byte $00,$ef,$ec,$00,$00,$00,$f1
	.byte $d4,$00,$00,$d4,$f3
	.byte $00,$ec,$e3,$00,$e7,$00,$00,$00,$f6
	.byte $ec,$ec,$00,$00,$f3 
	.byte $ec,$ec,$00,$00,$f3 
	.byte $e7,$00,$f0

volstrt .byte $00,$4a,$4a,$4a,$4a,$4a,$4a,$4e,$4e,$4e,$4a,$4e,$4e,$4a
voldec  .byte $00,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04
volpri  .byte $00,$00,$00,$00,$00,$00,$80,$03,$03,$03,$03,$83,$00,$00 
notelen .byte $00,$0a,$0a,$0a,$0a,$0a,$03,$8c,$87,$84,$84,$1f,$04,$03 

songstart  
         .byte  $00,$48 

songtab  

	.byte $01,$02,$04,$05,$01,$03,$04,$05,$71,$72,$74,$76,$71,$73,$74,$76
	.byte $01,$02,$04,$05,$01,$03,$04,$05,$71,$72,$74,$76,$71,$73,$74,$76
        .byte $09,$09
	.byte $01,$02,$04,$05,$01,$03,$04,$05,$71,$72,$74,$76,$71,$73,$74,$76
	.byte $01,$02,$04,$05,$01,$03,$04,$05,$71,$72,$74,$76,$71,$73,$74,$76
	.byte $0a,$0a,$7a,$7a,$e4
        .byte $ff 
             
        .byte $57,$57,$07,$08
        .byte $ff
    
pattstart  .byte $00,$05,$14,$18,$1c,$26,$2a,$2e,$4c,$6c,$a8

patttab .byte $f0,$8f,$00,$00,$7f 

        .byte $f2,$81,$1c,$f1,$1e,$80,$f6,$12,$81,$f1,$1e,$80,$f6,$1e,$7f
        
        .byte $81,$f4,$1e,$7f
        
	.byte $81,$f3,$1e,$7f
	
        .byte $80,$f6,$12,$81,$f1,$1e,$80,$f6,$1e,$7f
        
        .byte $81,$f5,$1e,$7f
        
        .byte $81,$f3,$1e,$7f
        
        .byte $f7,$81,$01,$fa,$80,$19,$19,$f9,$44,$f8,$81,$0d,$f7,$80,$08
        .byte $fa,$19,$f8,$0b,$81,$06,$80,$f9,$44,$f8,$08,$f7,$81,$04,$7f
        
        .byte $f7,$81,$01,$fa,$80,$19,$f8,$0d,$f9,$44,$f8,$81,$03,$80,$0f
        .byte $f7,$04,$f8,$81,$10,$80,$f8,$04,$f9,$44,$f8,$81,$05,$80,$f7,$11,$7f 
        
        .byte $fb,$81,$21,$20,$1e,$80,$fc,$20,$fb,$83,$21,$fc,$80,$19,$1c,$1e,$20,$1e
  	.byte $fb,$83,$23,$81,$21,$83,$20,$21,$fc,$81,$23,$20,$1c,$19,$80,$17,$fb,$84,$19,$87,$00
  	.byte $f1,$81,$25,$f6,$80,$19,$19,$f2,$23,$f1,$25,$00,$81,$25,$f6,$80,$19,$f1,$25,$25,$7f  
  	
  	.byte $fd,$80,$1c,$10,$1e,$12,$1e,$12,$19,$0d,$1c,$1e,$12,$1e,$12,$19,$1c,$19,$7f

repeaty   .byte $00,$00 
songpos   .byte $00,$00
notewait  .byte $00,$00
pattpos   .byte $00,$00
prevnote  .byte $00,$00
note      .byte $00,$00
transpose .byte $00,$00
transtemp .byte $00,$00
delay     .byte $00,$00
delayval  .byte $00,$00
instpos   .byte $00,$00
currinst  .byte $00,$00
patwait   .byte $00,$00
insvibc   .byte $00
volmast   .byte $00
volnum    .byte $00
priority  .byte $00 
thevol    .byte $00
tempocnt  .byte $01
ticks     .byte $00
temp .byte $00 
temp2 .byte $00
temp3 .byte $00

;; End of Music Driver Code
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
     