// SendFxDelay.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "SendFxDelay.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "isDelay.h"

/////////////////////////////////////////////////////////////////////////////
// CSendFxDelay dialog


CSendFxDelay::CSendFxDelay(CWnd* pParent /*=NULL*/)
	: CDialog(CSendFxDelay::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSendFxDelay)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_delay = 0;
}


void CSendFxDelay::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSendFxDelay)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSendFxDelay, CDialog)
	//{{AFX_MSG_MAP(CSendFxDelay)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSendFxDelay message handlers

void CSendFxDelay::setDelay(isDelay *delay)
{
	m_delay = delay;


}

static void WINAPI s_EFFECTSLIDER_CALLBACK(LPVOID passed, float newval)
{
	CSendFxDelay *p = (CSendFxDelay *) passed;
	p->update();
}

void CSendFxDelay::update(void)
{
	if (m_delay)
		m_delay->Update();
}


BOOL CSendFxDelay::OnInitDialog() 
{
	CDialog::OnInitDialog();

	if (!m_delay)
		return FALSE;
	
	// TODO: Add extra initialization here
	// Position?
	POINT p;
	p.x = 10;	
	int spacing = -1;
	// TODO: Add your control notification handler code here
	for (int i=0;i<8;i++) {
		
		if (i==0 || i == 4)
			p.y = 30;

		if (i < 4) 
			p.x = 10;
		else
			p.x = 350;

		m_sliders[i].Create( IDD_EFFECTSLIDER, this );	
		m_sliders[i].setRange( 0, 1 );
		WINDOWPLACEMENT pm;
		m_sliders[i].SetWindowPos( 0, p.x, p.y, 0, 0, SWP_NOSIZE | SWP_SHOWWINDOW );
		m_sliders[i].GetWindowPlacement( &pm );		
		p.y += pm.rcNormalPosition.bottom - pm.rcNormalPosition.top + spacing;

		isDelay::DELAYTAP *tap;
		if (i>3)
			tap = &m_delay->right;
		else
			tap = &m_delay->left;

		switch (i%4) {
			case 0:
				m_sliders[i].setTitle( _T("Delay") );
				m_sliders[i].setRange(0,128);
				m_sliders[i].setInt( (int*)&tap->delay );				
				break;
			case 1:
				m_sliders[i].setTitle( _T("EchoLength") );
				m_sliders[i].setRange(0,128);
				m_sliders[i].setInt( (int*)&tap->echoLength );				
				break;
			case 2:
				m_sliders[i].setTitle( _T("Volume") );
				m_sliders[i].setRange(-1,1);
				m_sliders[i].setFloat( &tap->volume );
				break;
			case 3:
				m_sliders[i].setRange(-1,1);
				m_sliders[i].setTitle( _T("FeedBack") );
				m_sliders[i].setFloat( &tap->feedback );
				break;
		}
		m_sliders[i].setChangeCallback( s_EFFECTSLIDER_CALLBACK, this );
	}

	
	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
