#ifndef __ISPLAYER_H__
#define __ISPLAYER_H__

// Kommentera definen ifall trackern skall kompileras.
// #define PLAYER_MINI_EDITION

#include <dsound.h>
#include "isSynth.h"
#include "gtkformat.h"

#define GTK_MAX_CHANNELS			0x100
#define PLAYER_EFFECTBIAS_CHANGED	0x1000

//////////////////////////////////////////////////////////////////////
//																	//
//	r PLAYER_MINI_EDITION definerad kommer playern att sakna		//
//	en massa tjafs. Det som kommer att finnas "kvar" r snt man	//
//	behver nr man bara r intresserad av att spela upp en lt		//
//																	//
//////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////
//	Prekalkningen:													  //
//		Allokerer en massa minne som inte kan avallokeras speciellt   //
//		ltt. Men det bryr man ju sig inte om s lnge man inte skall //
//		spela en himla massa ltar och prekalka om mellan ltarna     //
////////////////////////////////////////////////////////////////////////


// Update-Callback
typedef void (WINAPI *POSITIONUPDATECALLBACK)(LPVOID passed);
typedef void (WINAPI *PRECALCPROGRESS)(LPVOID passed, float progress);

struct InterpolatedEffect;
struct PlayInfo;

// Struktor fr att ta hand om snapshots.. innehller "aktuella" positioner fr
// alla patterns och sdant.
struct PlayerStateSnapshot {	
	DWORD time;	 // Tid fr aktivering
	int currentpos[ GTK_DEFAULT_PATCHANNELS ];	// State
	GTK_PATTERN *playpattern[ GTK_MAX_CHANNELS ];
	int sequencerpos;	
};

// Varje frame r en BPM stor
struct PrecalcFrame {
	short *pf_samples;
};

class isPlayer {
	public:
		// Konstruktor / Destruktor
		isPlayer( HWND hwnd, isSynth *synth );
		~isPlayer();
	
		
#ifndef PLAYER_MINI_EDITION

		// Saker som bara skall tas med i "stora" versionen av playern		
		void SetUpdateCallback( POSITIONUPDATECALLBACK puc, LPVOID paramtopass ); 

		float *GetLeftPlayingBuffer (DWORD *l);
		float *GetRightPlayingBuffer (DWORD *l);

		void Pause(void);
		void Resume(void);

        // only in "big" version
        int GetLatency (void);  // Gets the latency from the player, need for editor
        

#else

		// Saker som bara skall finnas med i "lilla" versionen av playern
		void PrecalcSong(GTK *playmodule, DWORD startseqpos, DWORD stopseqpos, BOOL showdialog = TRUE, int maxframes=4096, PRECALCPROGRESS callback=0, void *callback_ptr=0); // Prekalkar frn och med startseqpos t.om. stopseqpos
		void GetSyncData( int *tickcount, int *seqpos );
		
#endif

		float GetCPUUsage(void); // Tar reda p hur stor cpu usage

		void SetLatency( int latency ); // Stter latencyn fr spelaren. Hg latency = stabil playback
		void Start(GTK *playmodule, DWORD startseqpos = 0); // Har man precalcat spelar det ingen roll vad man skickar hr
		void Stop(void); // Stannar uppspelningen




		void process(void);
		
		// Hmtar aktuell position
		void GetCurrentPosition( int activechannel, int &sequencerrow, int &pattern, int &patternrow );
		DWORD GetCurrentTick( void );

		HANDLE GetThreadHandle(void) {
			return m_threadhandle;
		}

		   
	private:
		
		// Interna funktioner som anvnds av spelaren sjlv.
		void DoTick( void ); // Genomfr ett tick och stegar fram det som behvs samt matar patterns.
		void SetBPM( int bpm ); // ndrar bpm. Stter ocks bufferstorlekar och sdant

		void update( DWORD timedelta_ms ); // Uppdaterar spelningsbuffrar och sdant. Anropas av trden som skter uppspelning

		// Variabler fr fnster och directsoundobjekt. Ndvndiga i alla fall.
		HWND m_hwnd;
		IDirectSound8 *m_ds8;
		IDirectSoundBuffer8 *m_sec8;				
		BOOL m_firsttime; // Flagga ndvndig fr uppspelningen. Resettar uppspelning och s.
		BOOL m_isplaying; 

		// Variabler som hller koll p diverse saker i uppspelning
		DWORD m_lastownwritepos, m_lastwritecursorpos;		
		DWORD m_buffersize, m_bytesbehind; // Buffersize r DSOUND-bufferns storlek
		DWORD m_latencyms;
		DWORD m_latencybytes;

		// Uppdateringstrden = Trden som spelar upp i DSOUND
		DWORD m_threadid;
		HANDLE m_threadhandle, m_processevent;
		BOOL m_stopthread;
		// Vn-funktion till klassen (trdfunktionen)
		friend DWORD WINAPI AutoUpdateThread( LPVOID passed );

#ifndef PLAYER_MINI_EDITION

		// Callback fr position update. Skall bara finnas med i "stora varianten" av playern.
		POSITIONUPDATECALLBACK m_puc;
		LPVOID m_pucparam;

#else

		// Ifall allting r precalcat. Bara intressant i lilla versionen.
		BOOL m_isprecalced;
		DWORD m_precalcstarttime;
		DWORD m_hearingtick;
		PrecalcFrame *m_precalcframe;
		int m_precalcframes;
		int m_currentframe;

#endif
		int m_pause_reference;

		CRITICAL_SECTION m_playerlock;
		
		PlayInfo *m_playinfo; // Hller koll p vilken lt som spelas etc.
		isSynth *m_synth; 
		
		DWORD m_synthbufsize;
		float *m_tempbuf_l, *m_tempbuf_r; // Fr att skyffla data


		// CPUtidsmtning
		float m_lastcpumeasure;

		// AntiLatencyList
		PlayerStateSnapshot *m_allist;
		PlayerStateSnapshot m_last_backsnap;
		int m_allistlen;
};

#endif
