/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isEnvelope_h
#define __isEnvelope_h

#include "isModulator.h"

class isEnvelope : public isModulator
{
public:
	isEnvelope();
	virtual ~isEnvelope();

	void Load(isFile *f);
	void Save(isFile *f);
		
	void Render(int polyNr);
	void Event(isEVENT event,int polyNr);
	
	// "attack decay release sustain"
	// it's all tick based now, and therefor tempo based
	unsigned char a,d,r;
	float s;		// but the sustain is still a float 0..1
	
	// "Velocity Sensitivity" 
	// how much shall the velocity alter the amplitude of the envelope?
	// -1.0..1.0 
	float veloSens;
	
	// "Use Sustain"
	bool useSustain;

private:
	float velo[MAXPOLY];
	int tickCounter[MAXPOLY], offTick[MAXPOLY];
	bool noteOn[MAXPOLY];
	float offVal[MAXPOLY],val[MAXPOLY];
	float q1[MAXPOLY],q2[MAXPOLY];		// to do a nice fadein when note is cut by another note. the attack WON'T go from 0, but I do not care.

};

#endif
