/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

//#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include "isOscillator.h"

float *isOscillator::syncBuffer=NULL;
float *isOscillator::buffer=NULL;

isOscillator::isOscillator(isSamplePool &samplePool, isModulator **modList, isOscillator *mod/* =NULL */) : samplePool(samplePool)
{
	OutputDebugString("isOscillator\n");

	modulatorList=modList;

	params.sFM=params.eFM=0.0f;
	params.modulator=mod;
	for(int polyNr=0;polyNr<MAXPOLY;polyNr++)
	{
		params.cnt[polyNr]=params.lcnt[polyNr]=0.0f;
		baseFreq[polyNr]=newFreq[polyNr]=0.0f;
		jng_seed[polyNr]=1;
		params.cnt[polyNr]=0.0f;
		pong[polyNr]=1.0f;
	}
	detune=0.0f;
	dc=0.5f;
	multiplier=2;
	transpose=0;
	portamento=0.0f;
	mix=1.0f;
	fm=0.0f;
	wave=TRI1;
	sync=false;
	mode=ADD;
	
	// set modulator stuff
	modNr[0]=0;
	modNr[1]=0;
	modNr[2]=0;
	modNr[3]=0;
	modNr[4]=0;
	modNr[5]=0;
	modAmount[0]=0.0f;
	modAmount[1]=0.0f;
	modAmount[2]=0.0f;
	modAmount[3]=0.0f;
	modAmount[4]=0.0f;
	modAmount[5]=0.0f;	
}


isOscillator::~isOscillator()
{

}

void isOscillator::Load(isFile *f) 
{
	detune=f->ReadFloat();
	dc=f->ReadFloat();
	multiplier=f->ReadInt(1);
	transpose=f->ReadInt(1);
	portamento=f->ReadFloat();
	wave=(isWaveForm)f->ReadInt(1);
	sync=f->ReadInt(1)==0?false:true;
	mode=(isMixMode)f->ReadInt(1);
	mix=f->ReadFloat();
	fm=f->ReadFloat();
	
	for(int i=0;i<6;i++)
	{
		modNr[i]=f->ReadInt(1);
		modAmount[i]=f->ReadFloat();
	}
}
	
void isOscillator::Save(isFile *f) 
{
	f->WriteFloat(detune);
	f->WriteFloat(dc);
	f->WriteInt(multiplier,1);
	f->WriteInt(transpose,1);
	f->WriteFloat(portamento);	
	f->WriteInt((unsigned char)wave,1);
	f->WriteInt(sync?1:0,1);
	f->WriteInt((unsigned char)mode,1);
	f->WriteFloat(mix);
	f->WriteFloat(fm);
	
	for(int i=0;i<6;i++)
	{
		f->WriteInt(modNr[i],1);
		f->WriteFloat(modAmount[i]);
	}
}
void isOscillator::SetBufferSize(int length)
{
	if(syncBuffer!=NULL) 
	{
		delete []syncBuffer;
		delete []buffer;
	}
	syncBuffer=new float[length];
	buffer=new float[length];
}

void isOscillator::Play(int length, float *buff, int polyNr)
{
	// first the "offsets"
	params.sDC=dc;
	params.eDC=dc;
	params.sFM=fm;
	params.eFM=fm;

	baseFreq[polyNr]=baseFreq[polyNr]*(portamento)+newFreq[polyNr]*(1.0f-portamento);
	params.sFreq=(baseFreq[polyNr]+baseFreq[polyNr]*detune)*multiplier;

	baseFreq[polyNr]=baseFreq[polyNr]*(portamento)+newFreq[polyNr]*(1.0f-portamento);
	params.eFreq=(baseFreq[polyNr]+baseFreq[polyNr]*detune)*multiplier;

	params.sync=sync;

	// add modulatotion
	// these are for storage :)
	float start[6],end[6]; 
	for(int i=0;i<6;i++)
	{
		if (modulatorList[modNr[i]]!=NULL && modAmount[i]!=0.0f) 
		{
			start[i]=modulatorList[modNr[i]]->StartValue(polyNr)*modAmount[i];
			end[i]=modulatorList[modNr[i]]->EndValue(polyNr)*modAmount[i];
		}
		else
		{
			start[i]=end[i]=0.0f;
		}
	}
	params.sDC+=start[0]+start[1];
	params.eDC+=end[0]+end[1];
	params.sFreq+=params.sFreq*(start[2]+start[3]);
	params.eFreq+=params.eFreq*(end[2]+end[3]);
	params.sFM+=start[4]+start[5];
	params.eFM+=end[4]+end[5];
	
	if(params.sFreq>=0.49f) params.sFreq=0.49f;
	if(params.eFreq>=0.49f) params.eFreq=0.49f;
	
	if(params.sDC>1.0f) params.sDC=1.0f;
	if(params.eDC>1.0f) params.eDC=1.0f;
	
	// done, now generate the wave :)
/*	if(wave!=SAMPLE)
	{
		if(params.cnt[polyNr]>1.0f) params.cnt[polyNr]=1.0f;
		if(params.cnt[polyNr]<0.0f) params.cnt[polyNr]=0.0f;
	}*/
	switch(wave)
	{
	case SINE1:
		Sine1(length,params, polyNr);
		break;
	case PULSE1:
		Pulse1(length,params, polyNr);
		break;
	case PULSE2:
		Pulse2(length,params, polyNr);
		break;
	case TRI1:
		Tri1(length,params, polyNr);
		break;
	case NOISE1:
		Noise1(length,params, polyNr);
		break;
	case NOISE2:
		Noise2(length,params, polyNr);
		break;
	case SAMPLE:
		Sample(length,params,polyNr);
		break;
	}
	
	
	for(int b=0;b<length;b++)
	{
		buff[b]=buffer[b];
	}
}

void isOscillator::Event(isEVENT event, int polyNr)
{
	switch(event.type) 
	{
	case NOTE_ON:
		event.param1+=2;
		newFreq[polyNr]=27.5f*powf(2.0f,(transpose+event.param1)/12.0f)/44100.0f;
		if(wave==SAMPLE)
		{
			params.cnt[polyNr]=0.0f;
			//event.param1-=14;
			newFreq[polyNr]=powf(2.0f,(transpose+event.param1)/12.0f)/44100.0f;
			pong[polyNr]=1.0f;
		}
		sineX[polyNr]=0.0f;
		pulseX[polyNr]=0.0f;
		break;
	}
}

void isOscillator::Sine1(int length, Params &p, int polyNr)
{
	// use the triangle waveform to get DC and FM and sync and such
	Tri1(length,p,polyNr);
	float *buff=buffer;
	float pi=3.1415926535897932384626433832795f;
	for(int b=0;b<length;b++)
	{
		//sineX[polyNr]+=*buff*0.02;
		//*buff=sineX[polyNr];
		*buff=sinf(*buff*pi*0.5f);
		buff++;
	}

}

void isOscillator::Sample(int length, Params &p, int polyNr)
{
	int sampleNr=(int)(p.sDC*32.0f);
	assert(sampleNr>=0 && sampleNr<32);
	if(!samplePool.used[sampleNr])
	{
		for(int register i=0;i<length;i++,buffer++)
			*buffer=0.0f;
		return;
	}

	static unsigned char s;
	static float last;
	float fd,dcd; // delta values for interpolation
	float freq;

	dcd = 0.f;
	p.sFreq*=88200.0f/27.5f;
	p.eFreq*=88200.0f/27.5f;
	
	fd=(p.eFreq-p.sFreq)/length;
	
	float *syncBuffer = isOscillator::syncBuffer;
	float *buffer = isOscillator::buffer;

	if((p.modulator==NULL || (p.sFM==0.0f && p.eFM==0.0f) ))
	{
		for(int register i=0;i<length;i++,buffer++)
		{
			*syncBuffer = -1;
			
			if(p.cnt[polyNr]>samplePool.sample[sampleNr].loopEnd && samplePool.sample[sampleNr].loop && !samplePool.sample[sampleNr].pingpong)
			{
				p.cnt[polyNr]=samplePool.sample[sampleNr].loopStart;
			}
			else if(p.cnt[polyNr]>samplePool.sample[sampleNr].loopEnd && samplePool.sample[sampleNr].loop && samplePool.sample[sampleNr].pingpong)
			{
				p.cnt[polyNr]=samplePool.sample[sampleNr].loopEnd-p.sFreq*2;
				pong[polyNr]=-1.0f;
			}
			else if(p.cnt[polyNr]<samplePool.sample[sampleNr].loopStart && pong[polyNr]<0.0f)
			{
				pong[polyNr]=+1.0f;
				p.cnt[polyNr]+=p.sFreq*2;
			}
			
			if(p.cnt[polyNr]>samplePool.sample[sampleNr].sampleLength && !samplePool.sample[sampleNr].loop)
			{
				*buffer=0.0f;
			}
			else
				*buffer = samplePool.sample[sampleNr].buffer[(int)p.cnt[polyNr]];
	
			
			syncBuffer++;
			p.lcnt[polyNr]=p.cnt[polyNr];
			p.cnt[polyNr] += p.sFreq*pong[polyNr];
			p.sFreq += fd;
		}
	}
	else
	{
		float dFM=(p.eFM-p.sFM)/length;
		float sFM=p.sFM;
		for(int i=0;i<length;i++)
		{
			lc[polyNr]=c[polyNr];
			c[polyNr]=*buffer*sFM*0.5f;
			freq=p.sFreq;
			p.cnt[polyNr]+=freq;

			p.cnt[polyNr]+=c[polyNr];
			

			buffer[i]=jng_rand(polyNr)*2.0f;
			
			p.cnt[polyNr]+=freq;
			
			if(p.cnt[polyNr]>1.0f)
			{
				p.cnt[polyNr]-=1.0f;
				syncBuffer[i]=p.cnt[polyNr];
				jng_seed[polyNr]=(unsigned long)(p.sDC*0x7ffffff);
			}
			else if(syncBuffer[i]>=0.0f)
			{
				p.cnt[polyNr]=syncBuffer[i];
				jng_seed[polyNr]=(unsigned long)(p.sDC*0x7ffffff);
			}
			else
				syncBuffer[i]=-1.0f;
			
			// interpolate
			p.sDC+=dcd;
			p.sFreq+=fd;
			sFM+=dFM;

			p.cnt[polyNr]-=c[polyNr];

		}
	}
}

void isOscillator::Pulse2(int length, Params &p, int polyNr)
{
	// use the triangle waveform to get DC and FM and sync and such
	Pulse1(length,p,polyNr);
	float *buff=buffer;
	float pi=3.1415926535897932384626433832795f;
	static float out=0;
	for(int b=0;b<length;b++)
	{
		out=pulseX[polyNr]*0.99f+buff[b]*0.01f;
		buff[b]=SoftClipping(out*60);
		pulseX[polyNr]=out;
	}
}

void isOscillator::Pulse1(int length, Params &p, int polyNr)
{
	float fd,dcd; // delta values for interpolation
	float freq;
	
	fd=(p.eFreq-p.sFreq)/length;
	dcd=(p.eDC-p.sDC)/length;
	
	float *buff = buffer;
	float *syncBuff=syncBuffer;

	if((p.modulator==NULL || (p.sFM==0.0f && p.eFM==0.0f && !p.sync) ))
	{
		for(int register i=0;i<length;i++,buff++)
		{
			*syncBuff = -1;
			
/*			if (p.cnt[polyNr]>1.0f)
			{
				p.cnt[polyNr]-=1.0f;
				*syncBuff = p.cnt[polyNr];
			}*/
			ModCounter(p.cnt[polyNr],*syncBuff,p.sync);

			
			syncBuff++;
			
			if ( (p.lcnt[polyNr] >= p.sDC && p.lcnt[polyNr] <= p.cnt[polyNr]) || (p.cnt[polyNr] <= p.sDC && p.lcnt[polyNr] <=p.sDC)) {
				if (p.cnt[polyNr] <= p.sDC)
					*buff = -1.0f;
				else
					*buff = 1.0f;
				*buff-=1-2*p.sDC;
				p.lcnt[polyNr] = p.cnt[polyNr];
				p.cnt[polyNr] += p.sFreq;
				p.sFreq += fd;
				p.sDC += dcd;
				continue;
			}
			
			if (p.cnt[polyNr] > p.sDC) {
				if(p.lcnt[polyNr] > p.sDC && p.lcnt[polyNr] > p.cnt[polyNr]) // special case. like from 0.9->0.6 with dc=0.5
					//*buff=1.0f-(p.sDC)/(1.0f-p.lcnt[polyNr]+p.cnt[polyNr]);
					*buff=(-p.sDC+(p.cnt[polyNr]-p.sDC)+(1-p.lcnt[polyNr]));///(1.0f-p.lcnt[polyNr]+p.cnt[polyNr]);
				else
					*buff=(p.cnt[polyNr]-p.sDC*2.0f+p.lcnt[polyNr])/(p.cnt[polyNr]-p.lcnt[polyNr]);

			} else
				*buff=(-p.cnt[polyNr]+1.0f-p.lcnt[polyNr])/(p.cnt[polyNr]+1.0f-p.lcnt[polyNr]);
			
			*buff-=1-2*p.sDC;
			
			p.lcnt[polyNr] = p.cnt[polyNr];
			p.cnt[polyNr] += p.sFreq;
			p.sFreq += fd;
			p.sDC += dcd;
		}
	}
	else
	{
		float dFM=(p.eFM-p.sFM)/length;
		float sFM=p.sFM;
		float a,b;
		for(int i=0;i<length;i++)
		{
			lc[polyNr]=c[polyNr];
			c[polyNr]=*buff*sFM*0.5f;
			freq=p.sFreq;
			p.cnt[polyNr]+=freq;

			p.cnt[polyNr]+=c[polyNr];
			ModCounter(p.cnt[polyNr],*syncBuff,p.sync);
//			if((freq<0.0f && (c-lc)>freq) || ((c-lc)<0.0f && (lc-c)>freq))

			if((freq)<0.0f || (lc[polyNr]-c[polyNr])>freq)
			{
				a=p.cnt[polyNr];
				b=p.lcnt[polyNr];
			}
			else
			{
				a=p.lcnt[polyNr];
				b=p.cnt[polyNr];
			}		
			// antialiasing
			if(b>p.sDC && a>p.sDC && a>b) // special case. like from 0.9->0.6 with dc=0.5
			{
				*buff=1.0f-(p.sDC)/(1.0f-a+b);
			}
			else if(b>p.sDC && a<=p.sDC)
			{
				*buff=(b-p.sDC*2.0f+a)/(b-a);
			}
			else if(b<=p.sDC && a>p.sDC)
			{
				*buff=(-b+1.0f-a)/(b+1.0f-a);
			}
			// no antialasing
			else
			{
				*buff=(p.cnt[polyNr]>p.sDC)?1.0f:-1.0f;
			}
			
			// interpolate
			p.sDC+=dcd;
			p.sFreq+=fd;
			sFM+=dFM;
			buff++;
			p.lcnt[polyNr]=p.cnt[polyNr];
			p.cnt[polyNr]-=c[polyNr];

		}
	}
}


#define VAL(x) ((x<p.sDC)?(x/p.sDC*2.0f-1.0f):((1.0f-x)/(1.0f-p.sDC)*2.0f-1.0f))

void isOscillator::Noise1(int length, Params &p, int polyNr)
{
	static unsigned char s;
	static float last;
	float *buff=buffer;
	unsigned char tjoff=(unsigned char)(p.sDC*255);
	for(int b=0;b<length;b++)
	{	
		if((s&tjoff)==0)
		{
			last=jng_rand(polyNr);
		}
		
		*buff=last;
		buff++;
		s++;
	}}

void isOscillator::Noise2(int length, Params &p, int polyNr)
{
	static unsigned char s;
	static float last;
	float fd,dcd; // delta values for interpolation
	float freq;
	
	fd=(p.eFreq-p.sFreq)/length;
	dcd=(p.eDC-p.sDC)/length;
	
	if((p.modulator==NULL || (p.sFM==0.0f && p.eFM==0.0f && !p.sync) ))
	{
		for(int register i=0;i<length;i++)
		{
			syncBuffer[i] = -1;
			
			if (p.cnt[polyNr]>1.0f)
			{
				p.cnt[polyNr]-=1.0f;
				syncBuffer[i] = p.cnt[polyNr];
				jng_seed[polyNr]=(unsigned long)(p.sDC*0x7ffffff);
			}
			
			
			buffer[i] = jng_rand(polyNr);
			p.lcnt[polyNr] = p.cnt[polyNr];
			p.cnt[polyNr] += p.sFreq;
			p.sFreq += fd;
			p.sDC += dcd;
		}
	}
	else
	{
		float dFM=(p.eFM-p.sFM)/length;
		float sFM=p.sFM;
		for(int i=0;i<length;i++)
		{
			lc[polyNr]=c[polyNr];
			c[polyNr]=buffer[i]*sFM*0.5f;
			freq=p.sFreq;
			p.cnt[polyNr]+=freq;

			p.cnt[polyNr]+=c[polyNr];
			

			buffer[i]=jng_rand(polyNr)*2.0f;
			
			p.cnt[polyNr]+=freq;
			
			if(p.cnt[polyNr]>1.0f)
			{
				p.cnt[polyNr]-=1.0f;
				syncBuffer[i]=p.cnt[polyNr];
				jng_seed[polyNr]=(unsigned long)(p.sDC*0x7ffffff);
			}
			else if(syncBuffer[i]>=0.0f)
			{
				p.cnt[polyNr]=syncBuffer[i];
				jng_seed[polyNr]=(unsigned long)(p.sDC*0x7ffffff);
			}
			else
				syncBuffer[i]=-1.0f;
			
			// interpolate
			p.sDC+=dcd;
			p.sFreq+=fd;
			sFM+=dFM;

			p.lcnt[polyNr]=p.cnt[polyNr];
			p.cnt[polyNr]-=c[polyNr];

		}
	}
}

float inline isOscillator::jng_rand(int polyNr)
{	
	//jng_seed = 16807*(jng_seed % 127773) - (jng_seed/127773)*2836;
	int register jng_mod = jng_seed[polyNr] % 127773;
	int register jng_div = jng_seed[polyNr] / 127773;
	jng_div *= 2836;
	jng_mod *= 16807;
	jng_div += jng_mod;
	if (jng_div < 0)
		jng_seed[polyNr] = jng_div + 0x7fffffff;
	else
		jng_seed[polyNr] = jng_div;
	return jng_seed[polyNr]*(1.0f/(64.0f*256.0f*256.0f*256.0f))-1.0f;
}

void isOscillator::Tri1(int length, Params &p, int polyNr)
{
	float fd,dcd;	// delta values for interpolation
	float freq;
	float a,b;

	fd=(p.eFreq-p.sFreq)/length;
	dcd=(p.eDC-p.sDC)/length;
	
	float *buff=buffer;
	float *syncBuff=syncBuffer;
	if(p.modulator==NULL || (p.sFM==0.0f && p.eFM==0.0f && !p.sync))
	{
		for(int i=0;i<length;i++)
		{
/*			if(p.cnt[polyNr]>1.0f) 
			{
				p.cnt[polyNr]-=1.0f;
				*syncBuff=p.cnt[polyNr];
			}
			else
				*syncBuff=-1.0f;*/
			ModCounter(p.cnt[polyNr],*syncBuff,p.sync);

			if (p.lcnt[polyNr] > p.cnt[polyNr]) {
				if (p.cnt[polyNr] > p.sDC && p.lcnt[polyNr] <= p.sDC)
					goto no_antialias;

			} else {
				if (p.lcnt[polyNr] <= p.cnt[polyNr]) {
					if (p.lcnt[polyNr] > p.sDC && p.cnt[polyNr] <= p.sDC)
						goto no_antialias;
					if (p.lcnt[polyNr] <= p.sDC && p.cnt[polyNr] >= p.sDC)
						goto no_antialias;
				}
			}
			
			if (p.lcnt[polyNr] > p.cnt[polyNr]) {
				// antialiasing
				if( p.cnt[polyNr] > p.sDC && p.lcnt[polyNr] > p.sDC )
				{
					// now optimized...
					*buff=( (p.lcnt[polyNr]-1.0f)+p.sDC+(VAL(p.cnt[polyNr]))*(p.cnt[polyNr]-p.sDC) )/(p.cnt[polyNr]+1.0f-p.lcnt[polyNr]);				
					goto tri1_done;
				} 
				if( p.lcnt[polyNr] < p.sDC )
				{
					*buff=( (p.sDC-p.lcnt[polyNr])+(p.sDC-1.0f)+VAL(p.cnt[polyNr])*p.cnt[polyNr] )/(1-p.lcnt[polyNr]+p.cnt[polyNr]);				
					goto tri1_done;
				}
			}			

			if( p.lcnt[polyNr] < p.sDC && p.cnt[polyNr] > p.sDC )
			{
				*buff=( (p.sDC-p.lcnt[polyNr])+VAL(p.cnt[polyNr])*(p.cnt[polyNr]-p.sDC) )/(p.cnt[polyNr]-p.lcnt[polyNr]);			
				goto tri1_done;
			}

			if( p.lcnt[polyNr] > p.sDC && p.cnt[polyNr] < p.sDC)
			{
				*buff=( (p.lcnt[polyNr]-1.0f)+VAL(p.cnt[polyNr])*p.cnt[polyNr] )/(p.cnt[polyNr]+1.0f-p.lcnt[polyNr]);				
				goto tri1_done;
			}
			//__asm int 3

			no_antialias:

			//*buff=(p.cnt[polyNr]<p.sDC)?(p.cnt[polyNr]/p.sDC*2.0f-1.0f):((1.0f-p.cnt[polyNr])/(1.0f-p.sDC)*2.0f-1.0f);
			if (p.cnt[polyNr] < p.sDC) {
				*buff = p.cnt[polyNr] / p.sDC * 2.0f - 1.0f;
			} else {
				*buff = ( 1.0f - p.cnt[polyNr] ) / ( 1.0f - p.sDC ) * 2.0f - 1.0f;
			}

			tri1_done:
			
			// interpolate
			p.lcnt[polyNr]=p.cnt[polyNr];
			p.cnt[polyNr]+=p.sFreq+=fd;
			p.sDC+=dcd;
			buff++;
			syncBuff++;
		}
	}
	else 
	{
		float dFM=(p.eFM-p.sFM)/length;
		float sFM=p.sFM;
		bool didSync;
		for(int i=0;i<length;i++)
		{
			didSync=false;
			//freq+=*buff*sFM*freq;
			lc[polyNr]=c[polyNr];
			c[polyNr]=-*buff*sFM*0.5f;
			freq=p.sFreq;
			p.cnt[polyNr]+=freq+c[polyNr];


/*			if(p.cnt[polyNr]>=1.0f)
			{
				do
				{
					p.cnt[polyNr]-=1.0f;
				} while(p.cnt[polyNr]>=1.0f);
				*syncBuff=p.cnt[polyNr];
			}
			else if(p.cnt[polyNr]<0.0f)
			{
				do
				{
					p.cnt[polyNr]+=1.0f;
				} while(p.cnt[polyNr]<0.0f);
				*syncBuff=p.cnt[polyNr];
			}
			else if(*syncBuff>=0.0f && p.sync) 
			{
				p.cnt[polyNr]=*syncBuff;
				didSync=true;
			}
			else
				*syncBuff=-1.0f;*/
			ModCounter(p.cnt[polyNr],*syncBuff,p.sync);


			if((freq)<0.0f || (lc[polyNr]-c[polyNr])>freq || (didSync && (p.lcnt[polyNr]-p.cnt[polyNr])<0.5f))
			{
				a=p.cnt[polyNr];
				b=p.lcnt[polyNr];
			}
			else
			{
				a=p.lcnt[polyNr];
				b=p.cnt[polyNr];
			}
			// antialiasing
			if(b>p.sDC && a>p.sDC && a>b)
			{
				// now optimized...
				*buff=( (a-1.0f)+p.sDC+(VAL(b))*(b-p.sDC) )/(b+1.0f-a);
			}
			else if(a>b && a<p.sDC)
			{
				*buff=( (p.sDC-a)+(p.sDC-1.0f)+VAL(b)*b )/(1-a+b);
			}
			else if(b>p.sDC && a<p.sDC)
			{
				*buff=( (p.sDC-a)+VAL(b)*(b-p.sDC) )/(b-a);
			}
			else if(a>p.sDC && b<p.sDC)
			{
				*buff=( (a-1.0f)+VAL(b)*b )/(b+1.0f-a);
			}
			// no antialasing
			else
			{
				*buff=(p.cnt[polyNr]<p.sDC)?(p.cnt[polyNr]/p.sDC*2.0f-1.0f):((1.0f-p.cnt[polyNr])/(1.0f-p.sDC)*2.0f-1.0f);
			}

			if(didSync) *buff=(*buff+lastOut[polyNr])*0.5f;
			lastOut[polyNr]=*buff;

			// interpolate
			p.sDC+=dcd;
			p.sFreq+=fd;
			sFM+=dFM;
			buff++;
			syncBuff++;

			p.lcnt[polyNr]=p.cnt[polyNr];
			p.cnt[polyNr]-=c[polyNr];
		}
	}
}
