/*
   Reverie
   delaycube.h
   Copyright (C)2003 Dan Potter
*/

#ifndef __DELAYCUBE_H
#define __DELAYCUBE_H

class DelayCube : public Drawable {
public:
	DelayCube();
	virtual ~DelayCube();

	virtual void draw(int list);
	virtual void nextFrame();

	void	switchToBox();
	void	switchToPyramid();
	void	switchToCube();
	void	switchToSphere();

	class SwitchObject : public Animation {
	public:
		SwitchObject(int w) { m_w = w; }
		virtual ~SwitchObject() { }

		virtual void nextFrame(Drawable * t) {
			DelayCube * dc = (DelayCube *)t;
			switch (m_w) {
			case 0:
				dc->switchToCube();
				break;
			case 1:
				dc->switchToPyramid();
				break;
			case 2:
				dc->switchToBox();
				break;
			case 3:
				dc->switchToSphere();
				break;
			default:
				assert( false );
			}
			complete(t);
		}
	private:
		int m_w;
	};

	float		m_theta;
private:
	// Vector object stuff
	void	makeCube(Vector * target);
	
	void	drawCube(float b);

	void	transFrame();
	void	makeBox();
	void	makePyramid();
	void	makeSphere();

	Vector		m_points[6*6*6];
	Vector		m_pointsTo[6*6*6];
	matrix_t	m_oldmats[8];

	float		m_hsv;
	bool		m_needTrans;
};

#endif	// __DELAYCUBE_H

