/*
   Reverie
   melter.cpp
   Copyright (C)2003 Dan Potter
*/

#include "global.h"
#include "melter.h"

/*

The PVR is not only good at 3D, it makes an excellent blitter and sprite
layering engine.

This simple Parallax example demonstrates a very old school demo effect --
the raster melt. The idea is to slowly draw a bitmap onto the screen one
scanline at a time, stretching out that one scanline to the bottom half of
the screen which hasn't been filled yet.

NOTE: This is modified from the Parallax example in that it contrains the
effect to a single polygon and not the whole screen. It also is capable of
fading in and out with the melt.

*/

Melter::Melter(Texture * t) {
	m_txr = t;
	m_pos = 0;
	m_meltOff = false;
}

Melter::~Melter() {
}

void Melter::meltOut() {
	m_meltOff = true;
	m_pos = 0;
}

void Melter::draw(int list) {
	if (list != PLX_LIST_TR_POLY)
		return;

	plx_cxt_texture(*m_txr);
	plx_cxt_culling(PLX_CULL_NONE);
	plx_cxt_send(list);

	// Get our position
	Vector p = getPosition();
	float xl = p.x - m_txr->getW()/2, xr = p.x + m_txr->getW()/2;
	float yt = p.y - m_txr->getH()/2, yb = p.y + m_txr->getH()/2;

	float v = 1.0f*m_pos/m_txr->getH();
	if (!m_meltOff) {
		Color pc(v, 1, 1, 1);
		uint32 pi = pc;

		// Two polys -- one normal up to the scan point, and one
		// stretched to the bottom.
		plx_vert_ifp(PLX_VERT, xl, yt+m_pos, p.z, pi, 0.0f, v);
		plx_vert_ifp(PLX_VERT, xl, yt, p.z, pi, 0.0f, 0.0f);
		plx_vert_ifp(PLX_VERT, xr, yt+m_pos, p.z, pi, 1.0f, v);
		plx_vert_ifp(PLX_VERT_EOS, xr, yt, p.z, pi, 1.0f, 0.0f);

		if (m_pos < m_txr->getH()) {
			plx_vert_ifp(PLX_VERT, xl, 480.0f, p.z, pi, 0.0f, v);
			plx_vert_ifp(PLX_VERT, xl, yt+m_pos, p.z, pi, 0.0f, v);
			plx_vert_ifp(PLX_VERT, xr, 480.0f, p.z, pi, 1.0f, v);
			plx_vert_ifp(PLX_VERT_EOS, xr, yt+m_pos, p.z, pi, 1.0f, v);
		}
	} else {
		// Two polys -- one stretched from the top to the scan point, and one
		// normal down to the bottom.
		if (m_pos < m_txr->getH()) {
			Color pc(1.0f - v, 1, 1, 1);
			uint32 pi = pc;
			plx_vert_ifp(PLX_VERT, xl, yt+m_pos, p.z, pi, 0.0f, v);
			plx_vert_ifp(PLX_VERT, xl, 0.0f, p.z, pi, 0.0f, v);
			plx_vert_ifp(PLX_VERT, xr, yt+m_pos, p.z, pi, 1.0f, v);
			plx_vert_ifp(PLX_VERT_EOS, xr, 0.0f, p.z, pi, 1.0f, v);

			plx_vert_ifp(PLX_VERT, xl, yb, p.z, pi, 0.0f, 1.0f);
			plx_vert_ifp(PLX_VERT, xl, yt+m_pos, p.z, pi, 0.0f, v);
			plx_vert_ifp(PLX_VERT, xr, yb, p.z, pi, 1.0f, 1.0f);
			plx_vert_ifp(PLX_VERT_EOS, xr, yt+m_pos, p.z, pi, 1.0f, v);
		}
	}
}

void Melter::nextFrame() {
	m_pos += 2;
	if (m_pos >= m_txr->getH())
		m_pos = m_txr->getH();

	Drawable::nextFrame();
}
