;////////////////////////////////////////////////////////////////////////////;
;/ Image test             							 	   (C) BlackThunder /;
;////////////////////////////////////////////////////////////////////////////;
	include	"ngpc.inc"

;////////////////////////////////////////////////////////////////////////////;
;/ Macro's      															/;
;////////////////////////////////////////////////////////////////////////////;
CopyMem:	macro from, to, bytes
	ld		xhl, from
	ld		xde, to
	ld		xbc, (bytes)/2
	ldirw
	endm

CopyMemB:	macro from, to, bytes
	ld		xhl, from
	ld		xde, to
	ld		xbc, bytes
	ldir
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ variables                                                                /;
;////////////////////////////////////////////////////////////////////////////;
	area	"RAM"
myvar	db	?
	area	"ROM"

;////////////////////////////////////////////////////////////////////////////;
;/ Memory clear                                                             /;
;////////////////////////////////////////////////////////////////////////////;
ClearMemory:

;Clear Sprite Attribute	Memory
	ld		wa,	0
	ld		b, 64
	ld		xix, _SPRRAM
SAMloop:
	ld		(xix+),	wa
	ld		(xix+),	wa
	djnz	b, SAMloop

;Clear Scroll 1	& 2	VRAM with 20h,00h,20h,00h,...
	ld		xhl, _SCR1RAM
	ldw		(xhl), 0020h
	ld		xde, xhl
	inc		xde
	inc		xde
	ld		bc,	800h-1
	ldirw

;Clear Main	RAM
	ld		xhl, _MAINRAM
	ldb		(xhl), 00h
	ld		xde, xhl
	inc		xde
	ld		bc,	2000h-1
	ldir

	ret

;////////////////////////////////////////////////////////////////////////////;
;/ Zoom the window                                                          /;
;////////////////////////////////////////////////////////////////////////////;
ZoomWindow:
	ld		a, 80	;x	80->0
	ld		b, 76	;y	76->0
	ld		c, 0	;w	0->160
	ld		d, 0	;h	0->152

	ld		e, 77
zw_loop:
	ld		(rWBAH), a
	ld		(rWBAV), b
	ld		(rWSIH), c
	ld		(rWSIV), d
	dec		a
	dec		b
	add		c, 2
	add		d, 2

	calr	ZoomDelay

	djnz	e, zw_loop

	ret


ZoomWindowOut:
	ld		a, 0
	ld		b, 0
	ld		c, 76*2
	ld		d, 76*2

	ld		e, 77
zwo_loop:
	ld		(rWBAH), a
	ld		(rWBAV), b
	ld		(rWSIH), c
	ld		(rWSIV), d
	inc		a
	inc		b
	sub		c, 2
	sub		d, 2

	calr	ZoomDelay

	djnz	e, zwo_loop

	ret


ZoomDelay:
	ld		iz, 5000
delay_loop:
	djnz	iz, delay_loop
	ret

;////////////////////////////////////////////////////////////////////////////;
;/ Load graphics                                                            /;
;////////////////////////////////////////////////////////////////////////////;
InitVideo:

;load system font tileset
	;SysFontSet 1,0

;load image...
	CopyMem Squall_0, _TILERAM, 512*8*2
	CopyMem Squall_1, _SCR1RAM, 32*32*2
	CopyMem Squall_2, _SCR2RAM, 32*32*2
	CopyMem Palettes1, _SCR1PAL, 16*4*2
	CopyMem Palettes2, _SCR2PAL, 16*4*2

;set Window	X &	Y Size
	;ldb		(rWSIH), SCRN_X
	;ldb		(rWSIV), SCRN_Y

	ret

;////////////////////////////////////////////////////////////////////////////;
;/ Main                                                                     /;
;////////////////////////////////////////////////////////////////////////////;
Main:
	calr	OS_VERSION		;Initialize NGP or NGPC mode
	set		6, (rUSERA)		;User Answer

	;calr	ClearMemory		;ah.. don't need it


	;set vblank int
	ld		xwa, VBlankInt
	ld		(rVBI), xwa

	calr	InitVideo

	ei

MainLoop:
	calr	ZoomWindow
	calr	ZoomWindowOut

	;User shutdown?
	cp		(rUSERS), 0
	jr		z, MainLoop
	Shutdown
	di
	halt


;////////////////////////////////////////////////////////////////////////////;
;/ Vertical Blank Interrupt                                                 /;
;////////////////////////////////////////////////////////////////////////////;
VBlankInt:
	WatchDogUpdate
	reti		;!!!!!!!!!!!! ;-)
	irp		r, xix, xiy, xiz, xwa, xbc, xde, xhl	;+sr?
		push	r
	endm


	bit		CONT_A, (rSL)
	jr		z, S2



S1:

	ld		a,(rS1SOH)
	bit		CONT_LEFT, (rSL)
	jr		z, .nLeft1
	inc		a
.nLeft1:
	bit		CONT_RIGHT, (rSL)
	jr		z, .nRight1
	dec		a
.nRight1:
	ld		(rS1SOH),a


	ld		a,(rS1SOV)
	bit		CONT_UP, (rSL)
	jr		z, .nUp1
	inc		a
.nUp1:
	bit		CONT_DOWN, (rSL)
	jr		z, .nDown1
	dec		a
.nDown1:
	ld		(rS1SOV),a

	jr		S0

S2:

	ld		a,(rS2SOH)
	bit		CONT_LEFT, (rSL)
	jr		z, .nLeft2
	inc		a
.nLeft2:
	bit		CONT_RIGHT, (rSL)
	jr		z, .nRight2
	dec		a
.nRight2:
	ld		(rS2SOH),a


	ld		a,(rS2SOV)
	bit		CONT_UP, (rSL)
	jr		z, .nUp2
	inc		a
.nUp2:
	bit		CONT_DOWN, (rSL)
	jr		z, .nDown2
	dec		a
.nDown2:
	ld		(rS2SOV),a


S0:

	irp		r, xhl, xde, xbc, xwa, xiz, xiy, xix
		pop	r
	endm
	reti


;////////////////////////////////////////////////////////////////////////////;
;/ Palette macros                                                           /;
;////////////////////////////////////////////////////////////////////////////;
GBC2NGPC:	macro n			;convert GBC colors to NGPC colors
	dw	(((n>>1)&15)<<0) + (((n>>6)&15)<<4) + (((n>>11)&15)<<8)
	endm

dw1:	macro c0,c1,c2,c3	;scroll plane 1 palettes (GBC format, 3 colors)
	GBC2NGPC	c0
	GBC2NGPC	c1
	GBC2NGPC	c2
	GBC2NGPC	c3
	endm

dw2:	macro c0,c1,c2,c3	;scroll plane 2 palettes (GBC format, first color)
	GBC2NGPC	c0
	GBC2NGPC	c0
	GBC2NGPC	c0
	GBC2NGPC	c0
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ Image data                                                               /;
;////////////////////////////////////////////////////////////////////////////;
Palettes1:
	dw1 25534,17051,33,5322
	dw1 20975,14731,7472,25236
	dw1 25236,15855,26359,29564
	dw1 8493,11666,4196,20984
	dw1 21243,14872,9583,4227
	dw1 25501,8431,12757,6380
	dw1 20251,8390,24510,15887
	dw1 17903,25368,29598,8456
	dw1 0,0,0,0
	dw1 0,0,0,0
	dw1 0,0,0,0
	dw1 0,0,0,0
	dw1 0,0,0,0
	dw1 0,0,0,0
	dw1 0,0,0,0
	dw1 0,0,0,0

Palettes2:
	dw2 25534,17051,33,5322
	dw2 20975,14731,7472,25236
	dw2 25236,15855,26359,29564
	dw2 8493,11666,4196,20984
	dw2 21243,14872,9583,4227
	dw2 25501,8431,12757,6380
	dw2 20251,8390,24510,15887
	dw2 17903,25368,29598,8456
	dw2 0,0,0,0
	dw2 0,0,0,0
	dw2 0,0,0,0
	dw2 0,0,0,0
	dw2 0,0,0,0
	dw2 0,0,0,0
	dw2 0,0,0,0
	dw2 0,0,0,0

Squall_0:
	binclude	"squall_0.bin"
Squall_1:
	binclude	"squall_1.bin"
Squall_2:
	binclude	"squall_2.bin"




;////////////////////////////////////////////////////////////////////////////;
	end
