'$DYNAMIC
'$INCLUDE: 'BWSB\INCLUDE\BWSB.BI'
'$INCLUDE: 'BWSB\INCLUDE\GDMTYPE.BI'
DEFINT A-Z
TYPE OvrLoad
  FileName      AS STRING * 12
  Location      AS LONG
  Length        AS LONG
END TYPE
TYPE OvrEnd
  ID            AS STRING * 10
  Entries       AS STRING * 1
  Location      AS LONG
END TYPE

DECLARE SUB BigPrint (S$, BYVAL Column, BYVAL row, BYVAL Size, BYVAL Colr, BYVAL Style)
DECLARE SUB BigPrint2 (S$, BYVAL Column%, BYVAL row%, BYVAL Size%, BYVAL Colr%, BYVAL Style%)
DECLARE FUNCTION RandUL$ (S$)
DECLARE SUB QTInit ()
DECLARE SUB QTSetTimer (BYVAL Channel, BYVAL Time)
DECLARE FUNCTION QTGetTimer (BYVAL Channel)
DECLARE SUB QTDelay (BYVAL Time)
DECLARE SUB QTDone ()
DECLARE SUB GetSoundCardInfo ()
DECLARE SUB NewPal ()
DECLARE FUNCTION OverSeek& (FileNumber, FileName$)

DIM ShakeDir(0 TO 7)
ShakeDir(0) = -321: ShakeDir(1) = -320: ShakeDir(2) = -319
ShakeDir(3) = -1: ShakeDir(4) = 1
ShakeDir(5) = 319: ShakeDir(6) = 320: ShakeDir(7) = 321
FOR L = 0 TO 7: ShakeDir(L) = ShakeDir(L) * 7: NEXT

DIM X(4), Y(4), Colr(4), Dir(4), OldDir(4), C$(4), Size(2)

DIM D$(0 TO 3, 0 TO 3)
D$(0, 0) = "": D$(0, 1) = "": D$(0, 3) = ""
D$(1, 0) = "": D$(1, 1) = "": D$(1, 2) = ""
D$(2, 1) = "": D$(2, 2) = "": D$(2, 3) = ""
D$(3, 0) = "": D$(3, 2) = "": D$(3, 3) = ""

RANDOMIZE TIMER

' *** SOUND INIT ***
DIM ModHeader AS GDMHeader
DIM Flags AS INTEGER, MusChans AS INTEGER
DIM Device(6) AS LONG: Device(1) = 0: Device(2) = 12278: Device(3) = 22708: Device(4) = 33155: Device(5) = 44722: Device(6) = 56138
A& = SETMEM(-150000)  ' mem to free for BWSB - adjust as needed
PRINT A&; "k base RAM free"
GetSoundCardInfo        ' gets Dev, Port, IRQ, & DMA
OPEN "ILLEGAL.EXE" FOR BINARY AS 1
ErrorFlag = LoadMSE("ILLEGAL.EXE", Device(Dev) + OverSeek(1, "SOUND.DAT"), 45, 4096, Port, IRQ, DMA)
'ErrorFlag = LoadMSE("SOUND.DAT", Device(Dev), 45, 4096, Port, IRQ, DMA)
ERASE Device
Flags = EmsExist AND 1
IF Dev > 1 AND Flags = 0 THEN
	PRINT "EMS is required for a non-GUS soundcard.": END
END IF

' ** MUSIC LOAD **
PRINT "Loading music"
LoadGDM FILEATTR(1, 2), OverSeek(1, "ILLEGAL.GDM"), Flags, VARSEG(ModHeader), VARPTR(ModHeader)
'LoadGDM FILEATTR(1, 2), 0, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
CLOSE 1
MusChans = 0
FOR J = 1 TO 32                  'Scan for used music channels
	IF ASC(MID$(ModHeader.PanMap, J, 1)) <> &HFF THEN
		MusChans = MusChans + 1
	END IF
NEXT

' VGA mode
SCREEN 13

OverRate& = StartOutput(MusChans, 0)

DIM I$(7), MR(7), ITX(7), ITY(7)
FOR L = 1 TO 7: READ I$(L): NEXT
FOR L = 1 TO 7: READ MR(L): NEXT
FOR L = 1 TO 7: READ ITX(L): NEXT
FOR L = 1 TO 7: READ ITY(L): NEXT
OPEN "illegal.txt" FOR INPUT AS 2: L = 0
DO UNTIL EOF(2)
	L = L + 1
	REDIM PRESERVE Lines$(L)
	LINE INPUT #2, Lines$(L)
LOOP
CLOSE 2

QTInit

NewMode:
IF modecount MOD 8 = 0 THEN
	mode = 0: StartMusic: L = MusicOrder(0): L = MusicVolume(20)
ELSEIF modecount = 25 AND UCASE$(COMMAND$) <> "TELEPATHY" THEN
	mode = 0: StartMusic: L = MusicOrder(1): L = MusicVolume(20)
ELSE
	DO: mode = INT(RND * 7) + 1: LOOP UNTIL mode <> oldmode
END IF


Sample = 10
Rate& = 12000
Duration = 5000
IF mode = 0 THEN
	Duration = 3000
ELSEIF mode = 2 THEN
	Delay = 40: DMin = 40: DMax = 40
ELSEIF mode = 4 THEN
	FOR L = 1 TO 2: X(L) = 90 + L * 40: Y(L) = 90: NEXT
	Delay = 55
	DMin = 35: DMax = 70
ELSEIF mode = 5 THEN
	Delay = 170: DMin = 150: DMax = 200
	X = 0: Y = 0
ELSEIF mode = 6 THEN
	Delay = 25: DMin = 25: DMax = 25
	DEF SEG = &HA000
	'FOR Y = 0 TO 199: FOR X = 0 TO 319: POKE X + Y * 320, INT(RND * 16) + 16: NEXT
	'CALL BlockMove(INT(RND * 10000), 0, &HA000, 0, 64000, 0)
	Noise = INT(RND * 20000)
	NoiseSamp = INT(RND * 19) + 1
	Duration = 800
ELSEIF mode = 7 THEN
	FOR L = 1 TO 4: X(L) = 150: Y(L) = 90: NEXT
	Delay = 60
	DMin = 40: DMax = 80
	FOR L = 1 TO 4: Colr(L) = INT(RND * 254) + 1: NEXT L
	BigFont = 3
	BigPrint CHR$(INT(RND * 2) + 1), 135, 90, 6, 31, 0
	L = INT(RND * UBOUND(Lines$)) + 1
	BigFont = 4
	BigPrint Lines$(L), 1, 182, 1, 31, 0
ELSE
	X = 1: Y = 1
	Delay = 100
	DMin = 50: DMax = 150
END IF
IF mode = 3 THEN
	X = 70: OldY = 100
	BigFont = 3
	BigPrint CHR$(1), 20 + INT(RND * 5) - 3, 70 + INT(RND * 5) - 3, 5, INT(RND * 254) + 1, 0
	BigPrint CHR$(2), 260 + INT(RND * 5) - 3, 70 + INT(RND * 5) - 3, 5, INT(RND * 254) + 1, 0
	BigPrint CHR$(1), 20 + INT(RND * 5) - 3, 70 + INT(RND * 5) - 3, 5, INT(RND * 254) + 1, 0
	BigPrint CHR$(2), 260 + INT(RND * 5) - 3, 70 + INT(RND * 5) - 3, 5, INT(RND * 254) + 1, 0
	BigPrint CHR$(1), 20, 70, 5, 31, 0
	BigPrint CHR$(2), 260, 70, 5, 31, 0
END IF
IF mode = 1 THEN Size = INT(RND * 7) + 2

I = 1
NewPal
QTSetTimer 3, Duration

DO
	IF mode <> 0 THEN
		'QTDelay Delay
		T = QTGetTimer(1)
		NewTimer = 0
		IF T = 0 THEN
			Delay = Delay + (INT(RND * 3) - 1) * 30
			IF Delay < DMin THEN Delay = DMin
			IF Delay > DMax THEN Delay = DMax

			'Sample = RND * 20 + 1
			'Rate& = RND * 10000 + 10000
			IF mode <> 6 THEN
				Sample = Sample + INT(RND * 3) - 1
				IF Sample < 1 THEN Sample = 1
				IF Sample > 20 THEN Sample = 20
				Rate& = Rate& + (INT(RND * 3) - 1) * 1000
				IF Rate& < 8000 THEN Rate& = 8000
				IF Rate& > 18000 THEN Rate& = 18000
			ELSE
				R = R XOR 1
				Sample = NoiseSamp + R
				Rate& = 20000
			END IF

			PlaySample 1, Sample, Rate&, 24, &HFF

			QTSetTimer 1, Delay: NewTimer = 1
		END IF
	END IF
		  
	IF mode = 0 THEN
		MR = MusicRow
		Size = 3: Colr = 15: Style = 0
		IF MR <> OldMR THEN
			IF MR = MR(I) THEN
				BigFont = INT(RND * 3) + 2
				C$ = RandUL$(I$(I))
				X = ITX(I): Y = ITY(I)
				BigPrint C$, X + INT(RND * 7) - 3, Y + INT(RND * 7) - 3, Size, INT(RND * 255), Style
				BigPrint C$, X + INT(RND * 7) - 3, Y + INT(RND * 7) - 3, Size, INT(RND * 255), Style
				BigPrint C$, X, Y, Size, Colr, Style
				I = I + 1
			END IF
		END IF
		IF modecount = 25 AND MR >= 30 THEN
			BigPrint RandUL$(I$(INT(RND * 7) + 1)), INT(RND * 320), INT(RND * 200), Size, Colr, 1
		ELSEIF MR = 27 THEN
			CALL BlockMove(&HA000, 0, &HB000, 0, 64000, 0)
		ELSEIF MR > 27 AND MR < 35 THEN
			A = INT(ShakeDir(RND * 8))
			CALL BlockMove(&HB000, 0, &HA000, A, 64000, 0)
		END IF
		IF I = 8 THEN I = 1
		OldMR = MR

	ELSEIF mode = 1 AND NewTimer = 1 THEN
		BigFont = INT(RND * 3) + 2
		C$ = CHR$(INT(RND * 255) + 1)
		'C$ = CHR$(INT(RND * 80) + 48)
		IF X > 310 THEN X = 1: Y = Y + Size * 15
		IF Y > 175 THEN
			CLS : NewPal
			Y = 1
			Size = INT(RND * 7) + 2
			DMin = Size * 20: DMax = Size * 40
		END IF
		Style = INT(RND * 2)
		Colr = INT(RND * 12) + 20
		BigPrint C$, X, Y, Size, Colr, Style
		X = X + Size * 10
		A& = &HA000 + INT(RND * 3900): B& = &HA000 + INT(RND * 3900)
		IF A& = B& THEN A& = A& + 1
		FOR L = 0 TO 7
			CALL BlockMove(A&, L * 320, B&, L * 320, 8, 0)
		NEXT

	ELSEIF mode = 2 AND NewTimer = 1 THEN
		BigFont = INT(RND * 3) + 2
		C$ = CHR$(INT(RND * 255) + 1)
		X = INT(RND * 300): Y = INT(RND * 180)
		Size = 3
		Colr = INT(RND * 16) + 16
		'Colr = 32 - (SQR((ABS(X - 150)) ^ 2 + (ABS(Y - 90)) ^ 2) \ 10)
		Style = INT(RND * 2)
		BigPrint2 C$, X, Y, Size, Colr, Style
		'A& = &HA000 + INT(RND * 190) * 20
		'B& = &HA000 + INT(RND * 190) * 20
		'IF A& = B& THEN A& = A& + 20
		CALL BlockMove(&HA000, 0, &HB000, 0, 64000, 0)
		CALL BlockMove(&HB000, 1, &HA000, 0, 63999, 0)

	ELSEIF mode = 3 THEN
		R = R XOR 1
		X = X + R
		GetMainScope LScope&, RScope&
		IF R = 1 THEN
			IF X >= 250 THEN X = 70: LINE (69, 10)-(69, 190), 0  ': CLS
			Y = (LScope& \ 33) - 900
			IF Y < 10 THEN Y = 10
			IF Y > 190 THEN Y = 190
			'PSET (X, Y), 15
			LINE (X, 10)-(X, 190), 0
			LINE (X - 1, OldY)-(X, Y), 28
			OldY = Y
		END IF

	ELSEIF mode = 4 AND NewTimer = 1 THEN
		BigFont = INT(RND * 3) + 2
		Colr = 20

		FOR L = 1 TO 2
			'C$ = CHR$(INT(RND * 32) + 179)
			C$(L) = CHR$(INT(RND * 255) + 1)
			'C$ = CHR$(INT(RND * 80) + 48)
			X(L) = X(L) + INT(RND * 3) * 10 - 10: Y(L) = Y(L) + INT(RND * 3) * 8 - 8
			IF X(L) < 0 THEN X(L) = 0
			IF X(L) > 309 THEN X(L) = 309
			IF Y(L) < 0 THEN Y(L) = 0
			IF Y(L) > 179 THEN Y(L) = 179
			'Size = 2
			Size(L) = Size(L) + INT(RND * 3) - 1
			IF Size(L) < 1 THEN Size(L) = 1
			IF Size(L) > 3 THEN Size(L) = 3
			BigPrint2 C$(L), X(L), Y(L), Size(L), Colr, Style
		NEXT L

	ELSEIF mode = 5 AND NewTimer = 1 THEN
		L = INT(RND * UBOUND(Lines$)) + 1
		X = 0: Size = INT(RND * 3) + 1: Colr = 20: Style = INT(RND * 2)
		BigFont = INT(RND * 3) + 2
		BigPrint2 Lines$(L), X, Y, Size, Colr, Style
		Y = Y + 10
		IF Y > 179 THEN CLS : NewPal: Y = 0

	ELSEIF mode = 6 AND NewTimer = 1 THEN
		'CALL BlockMove(INT(RND * 10000), 0, &HA000, 0, 64000, 0)
		A = INT(ShakeDir(RND * 8))
		CALL BlockMove(Noise, 0, &HA000, A, 64000, 0)

	ELSEIF mode = 7 AND NewTimer = 1 THEN
		BigFont = 2: Size = 1
		
		FOR L = 1 TO 4
			Dir = INT(RND * 3) + 1
			SELECT CASE (OldDir(L))
			CASE 0
				SELECT CASE Dir
					CASE 1: X = 0: Y = -1: Dir(L) = 0
					CASE 2: X = 1: Y = 0: Dir(L) = 1
					CASE 3: X = -1: Y = 0: Dir(L) = 3
				END SELECT
			CASE 1
				SELECT CASE Dir
					CASE 1: X = 0: Y = -1: Dir(L) = 0
					CASE 2: X = 1: Y = 0: Dir(L) = 1
					CASE 3: X = 0: Y = 1: Dir(L) = 2
				END SELECT
			CASE 2
				SELECT CASE Dir
					CASE 1: X = 1: Y = 0: Dir(L) = 1
					CASE 2: X = 0: Y = 1: Dir(L) = 2
					CASE 3: X = -1: Y = 0: Dir(L) = 3
				END SELECT
			CASE 3
				SELECT CASE Dir
					CASE 1: X = 0: Y = -1: Dir(L) = 0
					CASE 2: X = 0: Y = 1: Dir(L) = 2
					CASE 3: X = -1: Y = 0: Dir(L) = 3
				END SELECT
			END SELECT
			
			C$(L) = D$(OldDir(L), Dir(L))
			BigPrint C$(L), X(L), Y(L), Size, Colr(L), Style

			X(L) = X(L) + X * 8: Y(L) = Y(L) + Y * 8
			IF X(L) < 0 THEN X(L) = 0: OldDir(L) = 1
			IF X(L) > 309 THEN X(L) = 309: OldDir(L) = 3
			IF Y(L) < 0 THEN Y(L) = 0: OldDir(L) = 2
			IF Y(L) > 179 THEN Y(L) = 179: OldDir(L) = 0

			OldDir(L) = Dir(L)
		NEXT L

	END IF
LOOP UNTIL INKEY$ = CHR$(27) OR QTGetTimer(3) = 0
IF mode = 0 THEN StopMusic
IF QTGetTimer(3) = 0 THEN
	oldmode = mode
	modecount = modecount + 1
	IF modecount MOD 8 <> 0 THEN CLS
	IF modecount < 26 OR UCASE$(COMMAND$) = "TELEPATHY" THEN GOTO NewMode
END IF

' ** shut down **
TheEnd:
QTDone

'StopMusic                               'Disable music processing
StopOutput                              'Stop all sound output
UnloadModule                            'Free module memory
FreeMSE                                 'Remove MSE from memory

SCREEN 0: CLS

END

' I$
DATA "IL", "LE", "GAL", "TE", "LE", "PA", "THY"
' IT music row
DATA 1, 4, 8, 16, 20, 24, 27
' IT X
DATA 70, 125, 180, 40, 95, 150, 205
' IT Y
DATA 40, 40, 40, 110, 110, 110, 110

REM $STATIC
SUB BigPrint (S$, BYVAL Column, BYVAL row, BYVAL Size, BYVAL Colr, BYVAL Style)
SHARED BigFont
SELECT CASE BigFont
	CASE 1: DEF SEG = &HF000: Offs = &HFA6E: Rows = 8  ' ROM BIOS
	CASE 2: DEF SEG = &HC000: Offs = &H100: Rows = 8   ' VGA BIOS
	CASE 3: DEF SEG = &HC000: Offs = &H900: Rows = 14
	CASE 4: DEF SEG = &HC000: Offs = &H1700: Rows = 16
END SELECT
S1 = Size - 1
IF Style = 1 THEN ItalOff = Rows ELSE ItalOff = 0
FOR L = 1 TO LEN(S$)
	Char = ASC(MID$(S$, L, 1))
	FOR Y = 0 TO Rows - 1
		PY = row + Y * Size: PY2 = PY + S1
		PX = Column + ItalOff + (L - 1) * 8 * Size
		A = PEEK(Offs + Char * Rows + Y)
		IF Style = 1 THEN ItalOff = ItalOff - 1
		FOR X = 7 TO 0 STEP -1
			IF A AND (2 ^ X) THEN LINE (PX, PY)-(PX + S1, PY2), Colr, BF
			PX = PX + Size
NEXT X, Y, L
END SUB

SUB BigPrint2 (S$, BYVAL Column, BYVAL row, BYVAL Size, BYVAL Colr, BYVAL Style)
SHARED BigFont
SELECT CASE BigFont
	CASE 1: DEF SEG = &HF000: Offs = &HFA6E: Rows = 8  ' ROM BIOS
	CASE 2: DEF SEG = &HC000: Offs = &H100: Rows = 8   ' VGA BIOS
	CASE 3: DEF SEG = &HC000: Offs = &H900: Rows = 14
	CASE 4: DEF SEG = &HC000: Offs = &H1700: Rows = 16
END SELECT
S1 = Size - 1
IF Style = 1 THEN ItalOff = Rows ELSE ItalOff = 0
FOR L = 1 TO LEN(S$)
	Char = ASC(MID$(S$, L, 1))
	FOR Y = 0 TO Rows - 1
		PY = row + Y * Size: PY2 = PY + S1
		PX = Column + ItalOff + (L - 1) * 8 * Size
		DEF SEG = &HC000
		A = PEEK(Offs + Char * Rows + Y)
		IF Style = 1 THEN ItalOff = ItalOff - 1
		DEF SEG = &HA000
		FOR X = 7 TO 0 STEP -1
			IF A AND (2 ^ X) THEN
				FOR LY = PY TO PY2
					FOR LX = PX TO PX + S1
						B = PEEK(LX + LY * 320)
						IF B = 0 THEN
							POKE LX + LY * 320, Colr
						ELSEIF B < 30 THEN
							POKE LX + LY * 320, B + 2
						ELSE
						END IF
				NEXT LX, LY
			END IF
			PX = PX + Size
NEXT X, Y, L

END SUB

REM $DYNAMIC
SUB GetSoundCardInfo
SHARED Dev, Port, IRQ, DMA
		  IF INSTR(COMMAND$, "SETUP") THEN Setup = 1
		  IF LEN(ENVIRON$("ULTRASND")) AND Setup = 0 THEN
					 PRINT "Gravis Ultrasound detected."
					 Dev = 1: Port = &HFFFF: IRQ = &HFF: DMA = &HFF
		  ELSEIF LEN(ENVIRON$("BLASTER")) AND Setup = 0 THEN
					 T$ = MID$(ENVIRON$("BLASTER"), INSTR(ENVIRON$("BLASTER"), "T") + 1, 1)
					 SELECT CASE T$
					 CASE "1"
								PRINT "Sound Blaster 1.x detected."
								Dev = 2
					 CASE "2"
								PRINT "Sound Blaster 2.x detected."
								Dev = 3
					 CASE "4"
								PRINT "Sound Blaster Pro detected."
								Dev = 4
					 CASE "6"
								PRINT "Sound Blaster 16 detected."
								Dev = 5
					 END SELECT
					 Port = &HFFFF: IRQ = &HFF: DMA = &HFF
		  ELSE
					 PRINT "Select soundcard:"
					 PRINT "1) Gravis Ultrasound"
					 PRINT "2) Sound Blaster 1.x"
					 PRINT "3) Sound Blaster 2.x"
					 PRINT "4) Sound Blaster Pro"
					 PRINT "5) Sound Blaster 16"
					 PRINT "6) Pro Audio Spectrum"
					 PRINT "0) Abort"
					 DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "6"
					 IF In$ = "0" THEN END ELSE Dev = ASC(In$) - 48
					 PRINT "Port address (2x0h, 0 to autodetect):"
					 DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "9"
					 IF In$ = "0" THEN Port = &HFFFF ELSE Port = (16 * (ASC(In$) - 48)) + 512
					 PRINT "IRQ (in hex, 0 to autodetect):"
					 DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9") OR (In$ >= "a" AND In$ <= "f")
					 IF In$ = "0" THEN
								IRQ = &HFF
					 ELSEIF In$ <= "9" THEN IRQ = ASC(In$) - 48
					 ELSE IRQ = ASC(In$) - 87
					 END IF
					 PRINT "DMA (0 to autodetect):"
					 DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9")
					 IF In$ = "0" THEN DMA = &HFF ELSE DMA = ASC(In$) - 48
		  END IF
END SUB

REM $STATIC
SUB NewPal
OUT &H3C8, 16
R = INT(RND * 32) + 32: G = INT(RND * 32) + 32: B = INT(RND * 32) + 32
FOR L = 1 TO 16
	OUT &H3C9, R * (L / 16): OUT &H3C9, G * (L / 16): OUT &H3C9, B * (L / 16)
NEXT
END SUB

FUNCTION OverSeek& (FileNumber, File$)
DIM OverEnd AS OvrEnd
DIM OverLoad AS OvrLoad
	GET FileNumber, LOF(FileNumber) - 14, OverEnd
	SEEK FileNumber, OverEnd.Location
	FOR L = 1 TO ASC(OverEnd.Entries)
		GET 1, , OverLoad
		IF OverLoad.FileName = LEFT$(File$ + STRING$(12, 0), 12) THEN
			OverSeek& = OverLoad.Location - 1
			EXIT FUNCTION
		END IF
	NEXT
	OverSeek& = -1
END FUNCTION

FUNCTION RandUL$ (S$)
	R$ = ""
	FOR L = 1 TO LEN(S$)
		R$ = R$ + CHR$(ASC(MID$(S$, L, 1)) + INT(RND * 2) * 32)
	NEXT
	RandUL$ = R$
END FUNCTION

