'$DYNAMIC
'$INCLUDE: 'BWSB\INCLUDE\BWSB.BI'
'$INCLUDE: 'BWSB\INCLUDE\GDMTYPE.BI'
DEFINT A-Z
DEFSNG J
OPTION BASE 1
TYPE ImageType
   ImageName AS STRING * 8
   Title AS STRING * 20
   Width AS LONG
   Height AS LONG
   Size AS LONG
   Colors AS INTEGER
   Segment AS INTEGER
   Offset AS INTEGER
   XMSOffset AS LONG
   X AS INTEGER
   Y AS INTEGER
   Palett(0 TO 255, 1 TO 3) AS INTEGER
   Points AS INTEGER
END TYPE
TYPE PointData
   X AS SINGLE
   Y AS SINGLE
   xspeed AS SINGLE
   yspeed AS SINGLE
   color AS INTEGER
   onscreen AS INTEGER
END TYPE

DECLARE SUB QTInit ()
DECLARE SUB QTSetTimer (BYVAL Channel, BYVAL Time)
DECLARE FUNCTION QTGetTimer (BYVAL Channel)
DECLARE SUB QTDelay (BYVAL Time)
DECLARE SUB QTDone ()

DECLARE SUB TriFill (BYVAL X1, BYVAL y1, BYVAL X2, BYVAL y2, BYVAL x3, BYVAL y3, Col, BYVAL Style)
DECLARE SUB AALine (BYVAL X1, BYVAL y1, BYVAL X2, BYVAL y2, BYVAL Style)
DECLARE SUB Shellsort (Array(), BYVAL ubnd)
DECLARE SUB FontPrintCenter (BYVAL X%, BYVAL Y%, Text$)
DECLARE SUB LoadBMP (BMPFile$, Array() AS STRING * 1, PData AS ImageType)
DECLARE SUB ShowBMP (BMPFile$, PData AS ImageType, BYVAL X0, BYVAL Y0)
DECLARE SUB PreLoad ()
DECLARE SUB GetSoundCardInfo ()
DECLARE FUNCTION GetLibOffset& (File$)

DECLARE FUNCTION IsXMSInstalled ()
DECLARE FUNCTION AllocateXMS (BYVAL Bytes&)
DECLARE SUB DeallocateXMS (BYVAL Handle)
DECLARE FUNCTION FreeXMSmemory& ()
DECLARE SUB MoveXMS (BYVAL SourceHandle, BYVAL SourceOffset&, BYVAL DestHandle, BYVAL DestOffset&, BYVAL Bytes&)
DECLARE SUB MoveToXMS (BYVAL Handle, BYVAL Segment, BYVAL Offset, BYVAL Bytes&, BYVAL XMSOffset&)
DECLARE SUB MoveFromXMS (BYVAL Handle, BYVAL Segment, BYVAL Offset, BYVAL Bytes&, BYVAL XMSOffset&)
TYPE XMSItemType
   Width AS INTEGER
   Height AS INTEGER
   Size AS LONG
   Handle AS INTEGER
   Segment AS INTEGER
   Offset AS INTEGER
END TYPE
TYPE LibHeaderType
   FileName AS STRING * 12
   Offset AS LONG
   Size AS LONG
END TYPE

'RANDOMIZE TIMER
CONST Lib$ = "PD.DAT"
CONST pi = 3.14159
CONST Points = 272, lines = 816, faces = 544
CONST effects = 8, flashes = 4
CONST scriptcount = 106
CONST effectcount = 27
DIM X(effects, Points) AS SINGLE, Y(effects, Points) AS SINGLE, Z(effects, Points) AS SINGLE
DIM L1(effects, lines), L2(effects, lines)
DIM F1(effects, faces), F2(effects, faces), F3(effects, faces)
DIM faceon(2, faces), fontime(faces)
DIM lineon(2, lines), lontime(lines)
DIM zavg(faces)
DIM fcolor(effects, faces)
DIM SHARED fsort(faces)
DIM dx(Points), dy(Points), Jz(Points) AS SINGLE
DIM flash(flashes), fpal(flashes, 3)
DIM currenteffect(2)
DIM Points(effects), faces(effects), lines(effects)
DIM xoffset(effects), yoffset(effects), rad(effects), moveback(effects)
DIM fx(2, effectcount), fxduration(2, effectcount), fxnum(2), direction(2, effectcount)
DIM xrot(2, effectcount) AS SINGLE, yrot(2, effectcount) AS SINGLE, zrot(2, effectcount) AS SINGLE
DIM camdist(2, effectcount) AS SINGLE, glitch(2, effectcount)
DIM xoff AS SINGLE, yoff AS SINGLE

DIM xrot AS SINGLE, yrot AS SINGLE, zrot AS SINGLE
DIM cosx AS SINGLE, sinx AS SINGLE
DIM cosy AS SINGLE, siny AS SINGLE
DIM cosz AS SINGLE, sinz AS SINGLE

DIM ScriptText$(scriptcount), ScriptTime(scriptcount)
DIM SHARED XMSItem(15) AS XMSItemType
DIM SHARED Image(7) AS ImageType

IF COMMAND$ = "D" THEN Debug = 1 ELSE Debug = 0

' *** SOUND INIT ***
DIM ModHeader AS GDMHeader
DIM Flags AS INTEGER, MusChans AS INTEGER
DIM Device(6) AS LONG: Device(1) = 0: Device(2) = 12278: Device(3) = 22708: Device(4) = 33155: Device(5) = 44722: Device(6) = 56138
'DIM Device(6) AS LONG: Device(1) = 0: Device(2) = 12126: Device(3) = 22552: Device(4) = 32999: Device(5) = 44566: Device(6) = 55982
A& = SETMEM(-150000)  ' mem to free for BWSB - adjust as needed
'PRINT A&; "k base RAM free"
GetSoundCardInfo        ' gets Dev, Port, IRQ, & DMA
'ErrorFlag = LoadMSE("SOUND.DAT", Device(Dev), 45, 4096, Port, IRQ, DMA)
ErrorFlag = LoadMSE(Lib$, GetLibOffset("SOUND.DAT") - 1 + Device(Dev), 45, 4096, Port, IRQ, DMA)
ERASE Device
Flags = EmsExist AND 1
IF Dev > 1 AND Flags = 0 THEN
   PRINT "EMS is required for a non-GUS soundcard.": END
END IF

' *** XMS INIT, LOAD ***
IF IsXMSInstalled = -1 THEN
   PRINT FreeXMSmemory& \ 1024; "k extended memory detected."
ELSE
   PRINT "Extended memory (XMS) required.": END
END IF
' ** LOAD INTO XMS **
SCREEN 13
PreLoad
'PRINT FreeXMSmemory& \ 1024; "k extended memory free."

' ** MUSIC LOAD **
'PRINT "Loading music"
'OPEN "pd.gdm" FOR BINARY AS 1
OPEN Lib$ FOR BINARY AS 1
'LoadGDM FILEATTR(1, 2), 0, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
LoadGDM FILEATTR(1, 2), GetLibOffset("PD.GDM") - 1, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
CLOSE 1
MusChans = 0
FOR L = 1 TO 32                  'Scan for used music channels
   IF ASC(MID$(ModHeader.PanMap, L, 1)) <> &HFF THEN
      MusChans = MusChans + 1
   END IF
NEXT
LINE (0, 85)-(300, 114), 4, BF
DIM VirtScr(0 TO 319, 0 TO 199) AS STRING * 1
DIM BlankScr(0 TO 319, 0 TO 84) AS STRING * 1
VS = VARSEG(VirtScr(0, 0)): VO = VARPTR(VirtScr(0, 0))
BS = VARSEG(BlankScr(0, 0)): BO = VARPTR(BlankScr(0, 0))
'BS = &HB000: BO = 0
'FOR L = 0 TO 319: FOR M = 0 TO 84: BlankScr(L, M) = CHR$(0): NEXT M, L
DEF SEG = BS
FOR L = 0 TO 319: FOR M = 0 TO 84: POKE L + M * 320, 0: NEXT M, L

' load font
DIM Font(0 TO 0, 0 TO 0) AS STRING * 1
DIM FontData AS ImageType
DIM CharWidth(32 TO 90), CharOffs(32 TO 90)
LoadBMP "pdfont.bmp", Font(), FontData
RESTORE FontData
CharOff = 0
FOR L = 32 TO 90
   READ CharWidth(L)
   CharOffs(L) = CharOff
   CharOff = CharOff + CharWidth(L)
NEXT
FontData.Segment = VARSEG(Font(0, 0)): FontData.Offset = VARPTR(Font(0, 0))
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS
LINE (0, 85)-(319, 114), 4, BF
FOR Y = 0 TO FontData.Height - 1
   FOR X = 0 TO FontData.Width - 1
      IF ASC(Font(X, Y)) < 16 THEN Font(X, Y) = CHR$(ASC(Font(X, Y)) + 240)
NEXT X, Y

' brighten up darker colors
DIM Cols(3)
FOR L = 128 TO 200
   OUT &H3C7, L
   FOR M = 1 TO 3: Cols(M) = INP(&H3C9): NEXT M
   OUT &H3C8, L
   FOR M = 1 TO 3
      C = Cols(M) * 1.5
      IF C > 63 THEN C = 63
      OUT &H3C9, C
   NEXT M
NEXT L

' effect #1: tunnel filled
Points(1) = 272: faces(1) = 544
xoffset(1) = 160: yoffset(1) = 100
rad(1) = 120: moveback(1) = (rad(1) \ 2) * 16

' effect #2: tunnel wireframe
Points(2) = 272: lines(2) = 816
xoffset(2) = 160: yoffset(2) = 100
rad(2) = 120: moveback(2) = (rad(2) \ 2) * 16

' effect #3: landscape filled
Points(3) = 272: faces(3) = 544
xoffset(3) = 160: yoffset(3) = 100
rad(3) = 30: moveback(3) = rad(3) * 16 * 1.5

' effect #4: landscape wireframe
Points(4) = 272: lines(4) = 816
xoffset(4) = 160: yoffset(4) = 100
rad(4) = 30: moveback(4) = rad(4) * 16 * 1.5

' effect #5: globe inside
Points(5) = 130: faces(5) = 288
xoffset(5) = 160: yoffset(5) = 100
rad(5) = 120

' effect #6: spike ball
Points(6) = 130: faces(6) = 288
xoffset(6) = 160: yoffset(6) = 100

' effect #7: wire cube
Points(7) = 24: lines(7) = 36
xoffset(7) = 160: yoffset(7) = 100

' effect #8: fill cube
Points(8) = 24: faces(8) = 44
xoffset(8) = 160: yoffset(8) = 100


E = 1 ' tf
FOR p = 1 TO Points(E)
   Z(E, p) = ((p - 1) \ 16) * (rad(E) \ 2)
   ang! = ((p - 1) MOD 16) / (16 / (pi * 2))
   IF ((p - 1) \ 16) MOD 2 = 0 THEN
      ang! = ang! + .19
   END IF
   
   X(E, p) = COS(ang!) * rad(E): Y(E, p) = SIN(ang!) * rad(E)
   'z(p) = COS(zang!) * y(p): y(p) = SIN(zang!) * y(p)

    IF p < Points(E) - 15 THEN
      F1(E, p * 2) = p
      IF ((p - 1) \ 16) MOD 2 = 0 THEN
         F2(E, p * 2) = p + 16
         IF p MOD 16 = 0 THEN
            F3(E, p * 2) = p + 1
         ELSE
            F3(E, p * 2) = p + 17
         END IF
      ELSE
         IF p MOD 16 = 1 THEN
            F2(E, p * 2) = p + 31
         ELSE
            F2(E, p * 2) = p + 15
         END IF
         F3(E, p * 2) = p + 16
      END IF

      F1(E, p * 2 - 1) = p
      IF p MOD 16 = 0 THEN
         F2(E, p * 2 - 1) = p - 15
      ELSE
         F2(E, p * 2 - 1) = p + 1
      END IF
      IF ((p - 1) \ 16) MOD 2 = 0 THEN
         IF p MOD 16 = 0 THEN
            F3(E, p * 2 - 1) = p + 1
         ELSE
            F3(E, p * 2 - 1) = p + 17
         END IF
      ELSE
         F3(E, p * 2 - 1) = p + 16
      END IF
      X = p MOD 32
      Y = p \ 16
      C = 128 + SIN(X) * 2 + SIN(Y) * 2 + (X + Y)
      'C = 5 + 128 + SIN(X) * 1 + SIN(Y) * 1 + (X + Y) / 6
      fcolor(E, p * 2) = C
      fcolor(E, p * 2 - 1) = C + 48
      'fcolor(E, p * 2) = (p \ 4) + 50
      'fcolor(E, p * 2 - 1) = (p \ 4) + 100
    END IF
NEXT p

E = 2 ' tw
FOR p = 1 TO Points(E)
   Z(E, p) = ((p - 1) \ 16) * (rad(E) \ 2)
   ang! = ((p - 1) MOD 16) / (16 / (pi * 2))
   IF ((p - 1) \ 16) MOD 2 = 0 THEN
      ang! = ang! + .19
   END IF

   X(E, p) = COS(ang!) * rad(E): Y(E, p) = SIN(ang!) * rad(E)

    IF p < Points(E) - 15 THEN
      L1(E, p * 3) = p
      IF p MOD 16 = 0 THEN
         L2(E, p * 3) = p - 15
      ELSE
         L2(E, p * 3) = p + 1
      END IF

      L1(E, p * 3 - 1) = p
      L1(E, p * 3 - 2) = p
      IF ((p - 1) \ 16) MOD 2 = 0 THEN
         L2(E, p * 3 - 1) = p + 16
         IF p MOD 16 = 0 THEN
            L2(E, p * 3 - 2) = p + 1
         ELSE
            L2(E, p * 3 - 2) = p + 17
         END IF
      ELSE
         IF p MOD 16 = 1 THEN
            L2(E, p * 3 - 1) = p + 31
         ELSE
            L2(E, p * 3 - 1) = p + 15
         END IF
         L2(E, p * 3 - 2) = p + 16
      END IF
    END IF
NEXT p

E = 3 ' lf
FOR p = 1 TO Points(E)
   Z(E, p) = ((p - 1) \ 16) * rad(E) * 1.5
   X(E, p) = (((p - 1) MOD 16) - 7.5) * rad(E) * 1.5
   Y(E, p) = -100 + SIN((p - 1) \ 16) * 30 + SIN((p - 1) MOD 16) * 30
   IF ((p - 1) \ 16) MOD 2 = 0 THEN
      X(E, p) = X(E, p) + rad * .75
   END IF
   IF p < Points(E) - 15 THEN
      F1(E, p * 2) = p
      IF ((p - 1) \ 16) MOD 2 = 0 THEN
         F2(E, p * 2) = p + 16
         IF p MOD 16 = 0 THEN
            F3(E, p * 2) = p
         ELSE
            F3(E, p * 2) = p + 17
         END IF
      ELSE
         IF p MOD 16 = 1 THEN
            F2(E, p * 2) = p
         ELSE
            F2(E, p * 2) = p + 15
         END IF
         F3(E, p * 2) = p + 16
      END IF

      F1(E, p * 2 - 1) = p
      IF p MOD 16 = 0 THEN
         F2(E, p * 2 - 1) = p
      ELSE
         F2(E, p * 2 - 1) = p + 1
      END IF
      IF ((p - 1) \ 16) MOD 2 = 0 THEN
         IF p MOD 16 = 0 THEN
            F3(E, p * 2 - 1) = p
         ELSE
            F3(E, p * 2 - 1) = p + 17
         END IF
      ELSE
         F3(E, p * 2 - 1) = p + 16
      END IF

      X = p MOD 16
      Y = p \ 16
      C = 3 + 128 + SIN(X) * 2 + SIN(Y) * 2 + (X + Y) * 1.2
      fcolor(E, p * 2) = C
      fcolor(E, p * 2 - 1) = C + 48

      'fcolor(E, p * 2) = p \ 5 + 50
      'fcolor(E, p * 2 - 1) = p \ 5 + 100
    END IF
NEXT p

E = 4 ' lw
FOR p = 1 TO Points(E)
   Z(E, p) = ((p - 1) \ 16) * rad(E) * 1.5

   X(E, p) = (((p - 1) MOD 16) - 7.5) * rad(E) * 1.5
   Y(E, p) = -100 + SIN((p - 1) \ 16) * 30 + SIN((p - 1) MOD 16) * 30
   IF ((p - 1) \ 16) MOD 2 = 0 THEN
      X(E, p) = X(E, p) + rad(E) * .75
   END IF

    IF p < Points(E) - 15 THEN
      L1(E, p * 3) = p
      IF p MOD 16 = 0 THEN
         L2(E, p * 3) = p
      ELSE
         L2(E, p * 3) = p + 1
      END IF

      L1(E, p * 3 - 1) = p
      L1(E, p * 3 - 2) = p
      IF ((p - 1) \ 16) MOD 2 = 0 THEN
         L2(E, p * 3 - 1) = p + 16
         IF p MOD 16 = 0 THEN
            L2(E, p * 3 - 2) = p
         ELSE
            L2(E, p * 3 - 2) = p + 17
         END IF
      ELSE
         IF p MOD 16 = 1 THEN
            L2(E, p * 3 - 1) = p
         ELSE
            L2(E, p * 3 - 1) = p + 15
         END IF
         L2(E, p * 3 - 2) = p + 16
      END IF
    END IF
NEXT p

E = 5 ' globe8
Pts = Points(E)
FOR p = 1 TO Pts - 2
   ang! = ((p - 1) MOD 8) / 2.7 + .27
   X(E, p) = COS(ang!) * rad(E): Y(E, p) = SIN(ang!) * rad(E)
   zang! = ((p - 1) \ 8) / (1.273 * 2) + (((p - 1) MOD 8) * .19)
   Z(E, p) = COS(zang!) * Y(E, p): Y(E, p) = SIN(zang!) * Y(E, p)
   IF p MOD 8 <> 0 AND p < Pts - 9 THEN
      F1(E, p * 2) = p
      F2(E, p * 2) = p + 1
      F3(E, p * 2) = p + 8
      'fcolor(E, p * 2) = p + 40
      F1(E, p * 2 - 1) = p + 1
      F2(E, p * 2 - 1) = p + 8
      F3(E, p * 2 - 1) = p + 9
      'fcolor(E, p * 2 - 1) = p + 80
      X = p MOD 8
      Y = p \ 8
      C = 3 + 128 + SIN(X) * 2 + SIN(Y) * 2 + (X + Y) * 1.2
      'C = 5 + 128 + SIN(X) * 1 + SIN(Y) * 1 + (X + Y) / 6
      fcolor(E, p * 2) = C
      fcolor(E, p * 2 - 1) = C + 48
   END IF
NEXT p
FOR p = Pts - 9 TO Pts - 3
   F1(E, p * 2) = p
   F2(E, p * 2) = p + 1
   F3(E, p * 2) = ((p - 1) MOD 8) + 1
   'fcolor(E, p * 2) = p + 40
   F1(E, p * 2 - 1) = p + 1
   F2(E, p * 2 - 1) = ((p - 1) MOD 8) + 1
   F3(E, p * 2 - 1) = ((p - 1) MOD 8) + 2
   'fcolor(E, p * 2 - 1) = p + 40
      X = p MOD 8
      Y = p \ 8
      C = 3 + 128 + SIN(X) * 2 + SIN(Y) * 2 + (X + Y) * 1.2
      'C = 5 + 128 + SIN(X) * 1 + SIN(Y) * 1 + (X + Y) / 6
      fcolor(E, p * 2) = C
      fcolor(E, p * 2 - 1) = C + 48
NEXT p
'end caps
X(E, Pts - 1) = rad(E): Y(E, Pts - 1) = 0: Z(E, Pts - 1) = 0
X(E, Pts) = -rad(E): Y(E, Pts) = 0: Z(E, Pts) = 0
FOR p = 1 TO 16
   F1(E, (faces(E) - 32) + p) = p * 8 - 7
   F2(E, (faces(E) - 32) + p) = ((p MOD 16) + 1) * 8 - 7
   F3(E, (faces(E) - 32) + p) = Pts - 1
   fcolor(E, (faces(E) - 32) + p) = p + 133
NEXT
FOR p = 1 TO 16
   F1(E, (faces(E) - 16) + p) = p * 8
   F2(E, (faces(E) - 16) + p) = ((p MOD 16) + 1) * 8
   F3(E, (faces(E) - 16) + p) = Pts
   fcolor(E, (faces(E) - 16) + p) = p + 141
NEXT

E = 6 ' globe6b
Pts = Points(E)
FOR p = 1 TO Pts - 2
   IF ((p - 1) \ 8) MOD 2 = 0 AND (p MOD 2 = 1) AND ((p - 1) MOD 8) <> 0 THEN
      rad = 140
   ELSE rad = 80
   END IF
   ang! = ((p - 1) MOD 8) / 2.7 + .27
   X(E, p) = COS(ang!) * rad: Y(E, p) = SIN(ang!) * rad
   zang! = ((p - 1) \ 8) / (1.273 * 2) + (((p - 1) MOD 8) * .19)
   Z(E, p) = COS(zang!) * Y(E, p): Y(E, p) = SIN(zang!) * Y(E, p)

   IF p MOD 8 <> 0 AND p < Pts - 9 THEN
      F1(E, p * 2) = p
      F2(E, p * 2) = p + 1
      F3(E, p * 2) = p + 8
      'fcolor(E, p * 2) = p + 40
      F1(E, p * 2 - 1) = p + 1
      F2(E, p * 2 - 1) = p + 8
      F3(E, p * 2 - 1) = p + 9
      'fcolor(E, p * 2 - 1) = p + 80
      X = p MOD 8
      Y = p \ 8
      C = 3 + 128 + SIN(X) * 2 + SIN(Y) * 2 + (X OR Y) * 1.2
      fcolor(E, p * 2) = C
      fcolor(E, p * 2 - 1) = C + 48
   END IF
NEXT p

FOR p = Pts - 9 TO Pts - 3
   F1(E, p * 2) = p
   F2(E, p * 2) = p + 1
   F3(E, p * 2) = ((p - 1) MOD 8) + 1
   'fcolor(E, p * 2) = p + 40
   F1(E, p * 2 - 1) = p + 1
   F2(E, p * 2 - 1) = ((p - 1) MOD 8) + 1
   F3(E, p * 2 - 1) = ((p - 1) MOD 8) + 2
   'fcolor(E, p * 2 - 1) = p + 40
      X = p MOD 8
      Y = p \ 8
      C = 3 + 128 + SIN(X) * 2 + SIN(Y) * 2 + (X OR Y) * 1.2
      fcolor(E, p * 2) = C
      fcolor(E, p * 2 - 1) = C + 48
NEXT p

'end caps
X(E, Pts - 1) = 140: Y(E, Pts - 1) = 0: Z(E, Pts - 1) = 0
X(E, Pts) = -140: Y(E, Pts) = 0: Z(E, Pts) = 0
FOR p = 1 TO 16
   F1(E, (faces(E) - 32) + p) = p * 8 - 7
   F2(E, (faces(E) - 32) + p) = ((p MOD 16) + 1) * 8 - 7
   F3(E, (faces(E) - 32) + p) = Pts - 1
   fcolor(E, (faces(E) - 32) + p) = p + 133
NEXT
FOR p = 1 TO 16
   F1(E, (faces(E) - 16) + p) = p * 8
   F2(E, (faces(E) - 16) + p) = ((p MOD 16) + 1) * 8
   F3(E, (faces(E) - 16) + p) = Pts
   fcolor(E, (faces(E) - 16) + p) = p + 141
NEXT

E = 7 'cube8
Size = 80: chunk = 40
p = 1
FOR Z = -1 TO 1 STEP 2
   FOR Y = -1 TO 1 STEP 2
      FOR X = -1 TO 1 STEP 2
         FOR I = 1 TO 3
            X(E, p) = Size * X
            Y(E, p) = Size * Y
            Z(E, p) = Size * Z
            SELECT CASE I
               CASE 1: X(E, p) = (Size - chunk) * X
               CASE 2: Y(E, p) = (Size - chunk) * Y
               CASE 3: Z(E, p) = (Size - chunk) * Z
            END SELECT
            p = p + 1
NEXT I, X, Y, Z
FOR I = 1 TO 8
   L1(E, I * 3 - 2) = I * 3 - 2: L2(E, I * 3 - 2) = I * 3 - 1
   L1(E, I * 3 - 1) = I * 3 - 1: L2(E, I * 3 - 1) = I * 3
   L1(E, I * 3) = I * 3: L2(E, I * 3) = I * 3 - 2
NEXT I
L1(E, 25) = 1: L2(E, 25) = 4
L1(E, 26) = 2: L2(E, 26) = 8
L1(E, 27) = 5: L2(E, 27) = 11
L1(E, 28) = 7: L2(E, 28) = 10
L1(E, 29) = 3: L2(E, 29) = 15
L1(E, 30) = 6: L2(E, 30) = 18
L1(E, 31) = 9: L2(E, 31) = 21
L1(E, 32) = 12: L2(E, 32) = 24
L1(E, 33) = 13: L2(E, 33) = 16
L1(E, 34) = 14: L2(E, 34) = 20
L1(E, 35) = 17: L2(E, 35) = 23
L1(E, 36) = 19: L2(E, 36) = 22

E = 8 'cube8a
Size = 80: chunk = 40
p = 1
FOR Z = -1 TO 1 STEP 2
   FOR Y = -1 TO 1 STEP 2
      FOR X = -1 TO 1 STEP 2
         FOR I = 1 TO 3
            X(E, p) = Size * X
            Y(E, p) = Size * Y
            Z(E, p) = Size * Z
            SELECT CASE I
               CASE 1: X(E, p) = (Size - chunk) * X
               CASE 2: Y(E, p) = (Size - chunk) * Y
               CASE 3: Z(E, p) = (Size - chunk) * Z
            END SELECT
            p = p + 1
NEXT I, X, Y, Z

F1(E, 1) = 1: F2(E, 1) = 2: F3(E, 1) = 4
F1(E, 2) = 2: F2(E, 2) = 4: F3(E, 2) = 5
F1(E, 3) = 2: F2(E, 3) = 5: F3(E, 3) = 8
F1(E, 4) = 5: F2(E, 4) = 8: F3(E, 4) = 11
F1(E, 5) = 8: F2(E, 5) = 11: F3(E, 5) = 7
F1(E, 6) = 7: F2(E, 6) = 11: F3(E, 6) = 10
FOR L = 7 TO 12
   F1(E, L) = F1(E, L - 6) + 12: F2(E, L) = F2(E, L - 6) + 12: F3(E, L) = F3(E, L - 6) + 12
NEXT L

F1(E, 13) = 1: F2(E, 13) = 3: F3(E, 13) = 4
F1(E, 14) = 3: F2(E, 14) = 4: F3(E, 14) = 6
F1(E, 15) = 3: F2(E, 15) = 6: F3(E, 15) = 15
F1(E, 16) = 6: F2(E, 16) = 15: F3(E, 16) = 18
F1(E, 17) = 15: F2(E, 17) = 18: F3(E, 17) = 13
F1(E, 18) = 13: F2(E, 18) = 18: F3(E, 18) = 16
FOR L = 19 TO 24
   F1(E, L) = F1(E, L - 6) + 6: F2(E, L) = F2(E, L - 6) + 6: F3(E, L) = F3(E, L - 6) + 6
NEXT L

F1(E, 25) = 2: F2(E, 25) = 3: F3(E, 25) = 15
F1(E, 26) = 2: F2(E, 26) = 15: F3(E, 26) = 14
F1(E, 27) = 2: F2(E, 27) = 14: F3(E, 27) = 20
F1(E, 28) = 2: F2(E, 28) = 8: F3(E, 28) = 20
F1(E, 29) = 8: F2(E, 29) = 20: F3(E, 29) = 21
F1(E, 30) = 8: F2(E, 30) = 9: F3(E, 30) = 21
FOR L = 31 TO 36
   F1(E, L) = F1(E, L - 6) + 3: F2(E, L) = F2(E, L - 6) + 3: F3(E, L) = F3(E, L - 6) + 3
NEXT L

FOR L = 1 TO 8
   F1(E, L + 36) = L * 3 - 2
   F2(E, L + 36) = L * 3 - 1
   F3(E, L + 36) = L * 3
NEXT L

'C = INT(RND * 16)
FOR L = 0 TO 5
   FOR M = 1 TO 6
      fcolor(E, L * 6 + M) = L + 57 '+ C
NEXT M, L
FOR L = faces(E) - 7 TO faces(E)
   fcolor(E, L) = (L + 7 - faces(E)) + 57 + 48 '+ C '((L + 7 - faces) \ 4) * 48 + ((L + 7 - faces) MOD 4) + 128 + 24 + C
NEXT L

FOR L = 0 TO 15
   OUT &H3C8, L + 240
   OUT &H3C9, FontData.Palett(L, 1)
   OUT &H3C9, FontData.Palett(L, 2)
   OUT &H3C9, FontData.Palett(L, 3)
NEXT L

RESTORE ImageScript
FOR L = 1 TO scriptcount
   READ ScriptText$(L), ScriptTime(L)
NEXT L
RESTORE EffectsTop
FOR L = 1 TO effectcount
   READ fx(1, L), fxduration(1, L), direction(1, L), xrot(1, L), yrot(1, L), zrot(1, L), camdist(1, L), glitch(1, L)
NEXT L
RESTORE EffectsBottom
FOR L = 1 TO effectcount
   READ fx(2, L), fxduration(2, L), direction(2, L), xrot(2, L), yrot(2, L), zrot(2, L), camdist(2, L), glitch(2, L)
NEXT L

OverRate& = StartOutput(MusChans, 0)
StartMusic
L = MusicVolume(40)

QTInit
' *** INTRO PART ***
   X = 50: Y = 1: R = 0
   Delay = 100
   DMin = 50: DMax = 150
   OldY = 100: Col = 1
   DIM YColL(36), YDirL(36)
   DIM YColR(36), YDirR(36)
   OldT = 30000
QTSetTimer 1, 30000
'GOTO Splode
DO
      t = QTGetTimer(1)
      IF t = 0 THEN QTSetTimer 1, 30000
      R = R XOR 1
      IF t > 29000 THEN
         t2! = 1 - ((30000 - t) / 1000)
         OUT &H3C8, 0
         FOR M = 1 TO 3: OUT &H3C9, 63 * t2!: NEXT M
      END IF
      IF OldT - t > 0 THEN
         X = X + (OldT - t) * 6
         Col = Col + (OldT - t)
         GetMainScope LScope&, RScope&
         IF X >= 265 THEN X = 50: Col = 1
         Y = 80 - (ABS(LScope& - 32767) \ 30)
         IF Y < 10 THEN Y = 10
         IF Y > 80 THEN Y = 80
         IF YColL(Col) > Y THEN YDirL(Col) = -1
         IF YColL(Col) < Y THEN YDirL(Col) = 1
         LINE (X - 2, YColL(Col) - 2)-STEP(4, 4), 0, BF
         LINE (X - 2, Y)-STEP(4, 0), 15
         LINE (X - 1, Y + YDirL(Col))-STEP(2, 0), 15
         PSET (X, Y + YDirL(Col) * 2), 15
         YColL(Col) = Y
         Y = 120 + (ABS(RScope& - 32767) \ 30)
         IF Y < 120 THEN Y = 120
         IF Y > 190 THEN Y = 190
         IF YColR(Col) > Y THEN YDirR(Col) = 1
         IF YColR(Col) < Y THEN YDirR(Col) = -1
         LINE (X - 2, YColR(Col) - 2)-STEP(4, 4), 0, BF
         LINE (X - 2, Y)-STEP(4, 0), 15
         LINE (X - 1, Y + YDirR(Col))-STEP(2, 0), 15
         PSET (X, Y + YDirR(Col) * 2), 15
         YColR(Col) = Y
      END IF
      OldT = t
      IF INKEY$ = CHR$(27) THEN GOTO TheEnd
LOOP UNTIL MusicOrder(&HFF) = 2
ERASE YColL, YColR, YDirL, YDirR
'GOTO Middle

' *** MAIN PART ***
currentscript = 0
fxnum(1) = 0: fxnum(2) = 0
FOR L = 1 TO faces(E): faceon(1, L) = 0: faceon(2, L) = 0: fontime(L) = INT(RND * 1500): NEXT L
QTSetTimer 1, 32000
QTSetTimer 2, 0
QTSetTimer 3, 0
QTSetTimer 0, 0
told = 32000
tflash = 32000
gint = 200: gon = -1: gstart = 32767

Main:
LINE (0, 85)-(319, 114), 240, BF
DO
'CALL BlockMove(BS, BO, VS, VO, 64000, 0)
'DO: LOOP UNTIL LEN(INKEY$)
'GOTO TheEnd
CALL BlockMove(BS, BO, VS, VO, 27200, 0)
CALL BlockMove(BS, BO, VS, VO + 36800, 27200, 0)

t = QTGetTimer(1)
t1 = QTGetTimer(2)
t2 = QTGetTimer(3)
t3 = QTGetTimer(0)
IF Debug = 1 THEN
LOCATE 1, 1: PRINT t1; currenteffect(1);
LOCATE 16, 1: PRINT t2; currenteffect(2);
LOCATE 14, 1: PRINT t3; currentscript; MusicOrder(&HFF);
END IF
IF t = 0 THEN QTSetTimer 1, 32000: t = 32000: told = t: tflash = t ' only lasts 32.7 seconds :/
IF t1 = 0 THEN
      IF (glitch(1, fxnum(1)) AND 4) > 0 THEN
      FOR L = 1 TO flashes
         OUT &H3C8, fcolor(currenteffect(1), flash(L))
         FOR M = 1 TO 3: OUT &H3C9, fpal(L, M): NEXT M
      NEXT L
      tflash = 32000
      END IF
      fxnum(1) = fxnum(1) + 1
      IF fxnum(1) > effectcount THEN EXIT DO
      currenteffect(1) = fx(1, fxnum(1))
      E = currenteffect(1)
      IF E = 3 OR E = 4 THEN yoffset(E) = 0
      IF fxnum(1) < 5 THEN
         FOR L = 1 TO faces(currenteffect(1)): faceon(1, L) = 0: fontime(L) = INT(RND * 1500): NEXT L
         FOR L = 1 TO lines(currenteffect(1)): lineon(1, L) = 0: lontime(L) = INT(RND * 1500): NEXT L
      ELSEIF (glitch(1, fxnum(1)) AND 8) > 0 THEN
         FOR L = 1 TO faces(currenteffect(1)): faceon(1, L) = INT(RND * 2) + 1: NEXT L
         FOR L = 1 TO lines(currenteffect(1)): lineon(1, L) = INT(RND * 2) + 1: NEXT L
      ELSE  'IF fxnum(1) = 5 THEN
         FOR L = 1 TO faces: faceon(1, L) = 2: NEXT L
         FOR L = 1 TO lines: lineon(1, L) = 2: NEXT L
      END IF
      QTSetTimer 2, fxduration(1, fxnum(1))
ELSEIF t2 = 0 THEN
      IF (glitch(2, fxnum(2)) AND 4) > 0 THEN
      FOR L = 1 TO flashes
         OUT &H3C8, fcolor(currenteffect(2), flash(L))
         FOR M = 1 TO 3: OUT &H3C9, fpal(L, M): NEXT M
      NEXT L
      tflash = 32000
      END IF
      fxnum(2) = fxnum(2) + 1
      IF fxnum(2) > effectcount THEN EXIT DO
      currenteffect(2) = fx(2, fxnum(2))
      E = currenteffect(2)
      IF E = 3 OR E = 4 THEN yoffset(E) = 100
      IF (glitch(2, fxnum(2)) AND 8) > 0 THEN
         FOR L = 1 TO faces(currenteffect(2)): faceon(2, L) = INT(RND * 2) + 1: NEXT L
         FOR L = 1 TO lines(currenteffect(2)): lineon(2, L) = INT(RND * 2) + 1: NEXT L
      ELSEIF fxnum(2) >= 5 THEN
         FOR L = 1 TO faces: faceon(2, L) = 2: NEXT L
         FOR L = 1 TO lines: lineon(2, L) = 2: NEXT L
      END IF
      QTSetTimer 3, fxduration(2, fxnum(2))
END IF
IF t3 = 0 THEN
   IF MusicOrder(&HFF) = 16 THEN GOTO Middle
   'IF (currentscript = 50 AND t < 31000) OR MusicOrder(&HFF) = 16 THEN GOTO Middle
   currentscript = currentscript + 1
   't3 = t
   LINE (0, 85)-(319, 114), 240, BF
   IF currentscript < 102 THEN
      FontPrintCenter 160, 85, ScriptText$(currentscript)
      QTSetTimer 0, ScriptTime(currentscript)
   ELSEIF currentscript < 150 THEN
      FontPrintCenter 160, 85, ScriptText$(INT(RND * scriptcount) + 1)
      QTSetTimer 0, (150 - currentscript) * 4
   ELSE
      S$ = ""
      FOR L = 1 TO 8 + INT(RND * 12)
         S$ = S$ + CHR$(INT(RND * 57) + 33)
         FontPrintCenter 160, 85, S$
      NEXT L
      QTSetTimer 0, 10
   END IF
END IF

FOR fx = 1 TO 2
   E = currenteffect(fx)
   direction = direction(fx, fxnum(fx))
   glitch = glitch(fx, fxnum(fx))
   camdist = camdist(fx, fxnum(fx))
   duration = fxduration(fx, fxnum(fx))
   SELECT CASE fx
      CASE 1: Top = 0: Bottom = 84
      CASE 2: Top = 115: Bottom = 199
   END SELECT
   
   xrot = (t / 10000!) * xrot(fx, fxnum(fx))
   yrot = (t / 10000!) * yrot(fx, fxnum(fx))
   zrot = (t / 10000!) * zrot(fx, fxnum(fx))

   IF fxnum(1) = 3 THEN xrot = -1: yrot = .2: zrot = zrot - 2.3

   IF currentscript < 3 AND E = 6 THEN
      xoff = -30: yoff = 10   ': camdist = 180
   ELSEIF currentscript < 5 AND E = 2 THEN
      IF camdist = 150 THEN
         front = -200: frontclip = -140
      ELSE front = -560: frontclip = -70
      END IF
      xoff = COS(t / 2000) * 40: yoff = SIN(t / 1500) * 20
   ELSEIF currentscript < 7 AND E = 3 THEN
      xoff = -90: yoff = -20
   'ELSEIF currentscript < 9 and E = 5 THEN
   ELSEIF E = 1 OR E = 2 THEN
      IF camdist = 150 THEN
         front = -200: frontclip = -140
      ELSE front = -560: frontclip = -70
      END IF
      xoff = COS(t / 500) * 20: yoff = SIN(t / 800) * 30
   ELSE
      xoff = 0: yoff = 0
   END IF
   IF fxnum(2) = 5 THEN
      IF t1 > 8600 THEN
         xoffset(E) = 160 + (8600 - t1) \ 5
      ELSEIF t2 > 0 AND t2 < 8000 AND NOT (fx = 1 AND t2 < 2400) THEN
         xoffset(E) = 160 + SIN((8000 - t2) / 500) * (SIN((8000 - t2) / 3000) * 80) * (fx * 2 - 3)
         yoffset(E) = 100 + SIN((8000 - t2) / 5000) * 50 * (fx * 2 - 3)
         camdist = 250 + SIN((8000 - t2) / 5000) * 80 '* (fx * 2 - 3)
      ELSE
         xoffset(E) = 160: yoffset(E) = 100: camdist = camdist(fx, fxnum(fx))
      END IF
   ELSEIF fxnum(2) = 6 THEN
      ' reset stuff
      xoffset(8) = 160: yoffset(8) = 100
      xoffset(5) = 160: yoffset(5) = 100
   END IF

   IF (glitch AND 4) > 0 AND faces(E) > 0 THEN
   IF tflash - t > 600 THEN
      FOR L = 1 TO flashes
         flash(L) = INT(RND * (faces(E))) + 1
         OUT &H3C7, fcolor(E, flash(L))
         FOR M = 1 TO 3: fpal(L, M) = INP(&H3C9): NEXT M
      NEXT L
      tflash = t
   END IF
   flashamt! = (600 - (tflash - t)) / 600
   LOCATE 14, 15
   IF flash(1) > 0 THEN
      FOR L = 1 TO flashes
         IF fcolor(E, flash(L)) > 32 THEN
            OUT &H3C8, fcolor(E, flash(L))
            FOR M = 1 TO 3
               OUT &H3C9, fpal(L, M) + INT((64 - fpal(L, M)) * flashamt!)
            NEXT M
         END IF
      NEXT L
   END IF
   END IF

   IF MusicOrder(&HFF) = 28 THEN
      Fin! = MusicRow / 64!
      FOR L = 0 TO 230
         OUT &H3C8, L
         FOR M = 1 TO 3
            OUT &H3C9, FontData.Palett(L + 16, M) + ((63 - FontData.Palett(L + 16, M)) * Fin!)
         NEXT M
      NEXT L
   ELSEIF MusicOrder(&HFF) = 19 AND MusicRow <= 16 THEN
      Fin! = 1 - (MusicRow / 16!)
      FOR L = 0 TO 230
         OUT &H3C8, L
         FOR M = 1 TO 3
            OUT &H3C9, FontData.Palett(L + 16, M) + ((63 - FontData.Palett(L + 16, M)) * Fin!)
         NEXT M
      NEXT L
   END IF

   cosx = COS(xrot): sinx = SIN(xrot)
   cosy = COS(yrot): siny = SIN(yrot)
   cosz = COS(zrot): sinz = SIN(zrot)
   tdiff = told - t
   
   FOR p = 1 TO Points(E)
      X2 = X(E, p) + xoff: y2 = Y(E, p) + yoff
       
      IF NOT (fx = 2 AND currenteffect(1) = currenteffect(2)) THEN
         SELECT CASE E
         CASE 1, 2
         
            IF currentscript < 5 THEN
               Z(E, p) = Z(E, p) - tdiff / 25
            ELSE
               Z(E, p) = Z(E, p) - (tdiff / 5) * direction
            END IF
            IF direction = 1 THEN
               IF Z(E, p) < front THEN Z(E, p) = Z(E, p) + moveback(E)
            ELSE
               IF Z(E, p) > front + moveback(E) THEN Z(E, p) = Z(E, p) - moveback(E)
            END IF
         CASE 3, 4
            IF currentscript < 7 THEN
               Z(E, p) = Z(E, p) - tdiff / 12
            ELSE
               Z(E, p) = Z(E, p) - (tdiff / 5) * direction
            END IF
            IF direction = 1 THEN
               IF Z(E, p) < -380 THEN Z(E, p) = Z(E, p) + moveback(E)
            ELSE
               IF Z(E, p) > -380 + moveback(E) THEN Z(E, p) = Z(E, p) - moveback(E)
            END IF
         END SELECT
      END IF

      ' x-axis rotate
      JY1 = cosx * y2 - sinx * Z(E, p)
      JZ1 = sinx * y2 + cosx * Z(E, p)
      ' y-axis rotate
      JX1 = siny * JZ1 + cosy * X2
      Jz(p) = cosy * JZ1 - siny * X2
      ' z-axis rotate
      JX = cosz * JX1 - sinz * JY1
      JY = sinz * JX1 + cosz * JY1
      ' map 3d to 2d
      dx(p) = (-JX * 150) / (Jz(p) + camdist) + xoffset(E)
      dy(p) = (-JY * 125) / (Jz(p) + camdist) + yoffset(E)
   NEXT p

   IF fxnum(1) <= 4 THEN
   'IF fx = 1 AND fxnum(1) <= 4 THEN
   FOR L = 1 TO faces(E)
      IF faceon(fx, L) = 0 THEN
         IF t1 < duration - fontime(L) AND t1 > 2800 THEN faceon(fx, L) = 1
      ELSEIF faceon(fx, L) = 1 THEN
         IF t1 < (duration - 500) - fontime(L) AND t1 > 2800 THEN faceon(fx, L) = 2
         IF t1 < 1600 - fontime(L) THEN faceon(fx, L) = 0
      ELSEIF faceon(fx, L) = 2 THEN
         IF t1 < 2100 - fontime(L) THEN faceon(fx, L) = 1
      END IF
   NEXT
   FOR L = 1 TO lines(E)
      IF lineon(fx, L) = 0 THEN
         IF t1 < duration - lontime(L) AND t1 > 2800 THEN lineon(fx, L) = 1
      ELSEIF lineon(fx, L) = 1 THEN
         IF t1 < (duration - 500) - lontime(L) AND t1 > 2800 THEN lineon(fx, L) = 2
         IF t1 < 1800 - lontime(L) THEN lineon(fx, L) = 0
      ELSEIF lineon(fx, L) = 2 THEN
         IF t1 < 2300 - lontime(L) THEN lineon(fx, L) = 1
      END IF
   NEXT
   END IF

   IF E = 3 OR E = 6 THEN
      FOR L = 1 TO faces(E)
         fsort(L) = L
         zavg(L) = (Jz(F1(E, L)) + Jz(F2(E, L)) + Jz(F3(E, L))) \ 3
      NEXT
      Shellsort zavg(), faces(E)
   ELSEIF E = 8 THEN
      FOR L = 1 TO faces(E) - 8 STEP 6
         zavg1! = 0
         FOR M = L TO L + 5
            zavg1! = zavg1! + (Jz(F1(E, M)) + Jz(F2(E, M)) + Jz(F3(E, M))) / 3
         NEXT M
         FOR M = L TO L + 5
            fsort(M) = M
            zavg(M) = zavg1! / 6
         NEXT M
      NEXT L
      FOR L = faces(E) - 7 TO faces(E)
         fsort(L) = L
         zavg(L) = (Jz(F1(E, L)) + Jz(F2(E, L)) + Jz(F3(E, L))) \ 3
      NEXT
      Shellsort zavg(), faces(E)
   END IF

   SELECT CASE E
   CASE 1   'tf
      FOR M = faces(E) TO 1 STEP -1
         'm = fsort(l)
         IF Jz(F1(E, M)) > frontclip AND Jz(F2(E, M)) > frontclip AND Jz(F3(E, M)) > frontclip THEN
            IF Z(E, F1(E, M)) > -440 AND Z(E, F2(E, M)) > -440 AND Z(E, F3(E, M)) > -440 THEN
               Style = faceon(fx, M)
               IF Style >= 1 THEN
                  TriFill dx(F1(E, M)), dy(F1(E, M)), dx(F2(E, M)), dy(F2(E, M)), dx(F3(E, M)), dy(F3(E, M)), fcolor(E, M), Style
               END IF
            END IF
         END IF
      NEXT M

   CASE 2   'tw
      FOR M = 1 TO lines(E)
         IF lineon(fx, M) >= 1 THEN
            IF Jz(L1(E, M)) > frontclip AND Jz(L2(E, M)) > frontclip THEN
               IF Z(E, L1(E, M)) > -440 AND Z(E, L2(E, M)) > -440 THEN 'AND z(E, L1(E, M)) < 500 AND z(E, L2(E, M)) < 500 THEN
                  AALine dx(L1(E, M)), dy(L1(E, M)), dx(L2(E, M)), dy(L2(E, M)), lineon(fx, M)
               END IF
            END IF
         END IF
      NEXT M

   CASE 3   ' lf
      FOR L = faces TO 1 STEP -1
         'M = L
         M = fsort(L)
         IF Jz(F1(E, M)) > -200 AND Jz(F2(E, M)) > -200 AND Jz(F3(E, M)) > -200 THEN
            IF Z(E, F1(E, M)) > -300 AND Z(E, F2(E, M)) > -300 AND Z(E, F3(E, M)) > -300 THEN
               Style = faceon(fx, M)
               IF Style >= 1 THEN
                  TriFill dx(F1(E, M)), dy(F1(E, M)), dx(F2(E, M)), dy(F2(E, M)), dx(F3(E, M)), dy(F3(E, M)), fcolor(E, M), Style
               END IF
            END IF
         END IF
      NEXT L

   CASE 4   ' lw
      FOR L = 1 TO lines(E)
         IF lineon(fx, L) >= 1 THEN
            IF Jz(L1(E, L)) > -200 AND Jz(L2(E, L)) > -200 THEN
               IF Z(E, L1(E, L)) > -300 AND Z(E, L2(E, L)) > -300 THEN
                  AALine dx(L1(E, L)), dy(L1(E, L)), dx(L2(E, L)), dy(L2(E, L)), lineon(fx, L)
               END IF
            END IF
         END IF
      NEXT L

   CASE 5   ' globe8
      FOR M = faces TO 1 STEP -1
         IF Jz(F1(E, M)) > 0 AND Jz(F2(E, M)) > 0 AND Jz(F3(E, M)) > 0 THEN
            Style = faceon(fx, M)
            IF Style >= 1 THEN
               TriFill dx(F1(E, M)), dy(F1(E, M)), dx(F2(E, M)), dy(F2(E, M)), dx(F3(E, M)), dy(F3(E, M)), fcolor(E, M), Style
            END IF
         END IF
      NEXT M

   CASE 6   ' globe6b
      FOR L = faces TO 1 STEP -1
         'M = L
         M = fsort(L)
         'IF z(E, F1(E, M)) > -150 AND z(E, F2(E, M)) > -150 AND z(E, F3(E, M)) > -150 THEN
         Style = faceon(fx, M)
         IF Style >= 1 THEN
            TriFill dx(F1(E, M)), dy(F1(E, M)), dx(F2(E, M)), dy(F2(E, M)), dx(F3(E, M)), dy(F3(E, M)), fcolor(E, M), Style
         END IF
      NEXT L

   CASE 7   ' cube8
      FOR L = 1 TO lines(E)
         IF lineon(fx, L) >= 1 THEN
            AALine dx(L1(E, L)), dy(L1(E, L)), dx(L2(E, L)), dy(L2(E, L)), lineon(fx, L)
         END IF
      NEXT L

   CASE 8   ' cube8a
      FOR L = faces \ 2 TO 1 STEP -1
         M = fsort(L)
         Style = faceon(fx, M)
         IF Style >= 1 THEN
            TriFill dx(F1(E, M)), dy(F1(E, M)), dx(F2(E, M)), dy(F2(E, M)), dx(F3(E, M)), dy(F3(E, M)), fcolor(E, M), Style
         END IF
      NEXT L

   END SELECT
NEXT fx
'CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)

IF (glitch AND 2) > 0 THEN
   IF gstart - t > gint THEN
      gint = 300 'INT(RND * 200) + 100
      gstart = t
      gon = NOT gon
      IF NOT gon THEN gint = gint * 2
   END IF
   IF gstart < gint THEN gstart = 32000
END IF
IF (glitch AND 1) > 0 THEN
   FOR L = 0 TO 199
      N = SIN((L / 10) + (t / 200)) + SIN((L / 4) + (t / 300))
      IF L < 85 OR L > 114 THEN
         IF N > 0 THEN
            CALL BlockMove(VS, VO + L * 320, &HA000, 20 + (L * 320), 320, 0)
         ELSE
            CALL BlockMove(VS, VO + L * 320, &HA000, L * 320, 320, 0)
         END IF
      END IF
   NEXT L
ELSEIF (glitch AND 2) > 0 AND gon THEN
   FOR L = 0 TO 9
      IF L < 4 OR L > 5 THEN
         M = INT(RND * 10)
         CALL BlockMove(VS, VO + M * 320 * 20, &HA000, L * 320 * 20, 320 * 20, 0)
      END IF
   NEXT L
ELSE
   CALL BlockMove(VS, VO, &HA000, 0, 27200, 0)
   CALL BlockMove(VS, VO + 36800, &HA000, 36800, 27200, 0)
END IF
told = t
IF INKEY$ = CHR$(27) THEN GOTO TheEnd
LOOP UNTIL MusicOrder(&HFF) = 29
GOTO Splode

Middle:
'A = MusicOrder(16)
DIM pang(120) AS SINGLE, pzang(120) AS SINGLE
DIM dist(120), dir(120), dy2(120) AS SINGLE
DIM xrot2 AS SINGLE, yrot2 AS SINGLE, zrot2 AS SINGLE
DIM cosx2 AS SINGLE, sinx2 AS SINGLE
DIM cosy2 AS SINGLE, siny2 AS SINGLE
DIM cosz2 AS SINGLE, sinz2 AS SINGLE

' reuse font palette for fadein
FOR L = 1 TO 230
   OUT &H3C7, L
   FOR M = 1 TO 3: FontData.Palett(L + 16, M) = INP(&H3C9): NEXT M
   OUT &H3C8, L
   FOR M = 1 TO 3: OUT &H3C9, 0: NEXT M
NEXT L

E = 8: xoff = 0: yoff = 0: X1 = 1
Top = 0: Bottom = 199
camdist = 280
FOR L = 1 TO UBOUND(pang)
   pang(L) = RND * 6.28
   pzang(L) = RND * 6.28
   dist(L) = Size * 3 + INT(RND * 200)
NEXT

QTSetTimer 1, 30000
DO
   'CALL BlockMove(BS, BO, VS, VO, 64000, 0)
   CALL BlockMove(BS, BO, VS, VO, 20000, 0)
   CALL BlockMove(BS, BO, VS, VO + 20000, 20000, 0)
   CALL BlockMove(BS, BO, VS, VO + 40000, 24000, 0)
   t = QTGetTimer(1)
   
   IF t > 28000 AND OldT <> t THEN
      Fin! = 1 - ((t - 28000) / 2000)
      FOR L = 1 TO 230
         OUT &H3C8, L
         OUT &H3C9, FontData.Palett(L + 16, 1) * Fin!
         OUT &H3C9, FontData.Palett(L + 16, 2) * Fin!
         OUT &H3C9, FontData.Palett(L + 16, 3) * Fin!
      NEXT L
   END IF

      IF MusicOrder(&HFF) >= 17 AND OldT <> t THEN
         X1 = X1 + 1
         GetMainScope LScope&, RScope&
         IF X1 >= 120 THEN
            X1 = 1
         END IF
         Y = (ABS(LScope& - 32767) \ 30)
         IF Y < 0 THEN Y = 0
         IF Y > 50 THEN Y = 50
         dist(X1) = Size * 1.8 + Y
         'LOCATE 1, 1: PRINT Y;
      END IF

   xoffset(E) = 160 + SIN(t / 1000) * ((30000 - t) / 1000)
   
   xrot = t / 1500
   yrot = t / 1500
   zrot = t / 1500
   xrot2 = t / 1800
   yrot2 = t / 2300
   zrot2 = 0
   cosx = COS(xrot): sinx = SIN(xrot)
   cosy = COS(yrot): siny = SIN(yrot)
   cosz = COS(zrot): sinz = SIN(zrot)
   cosx2 = COS(xrot2): sinx2 = SIN(xrot2)
   cosy2 = COS(yrot2): siny2 = SIN(yrot2)
   cosz2 = COS(zrot2): sinz2 = SIN(zrot2)
   FOR p = 1 TO Points(E)
      X2 = X(E, p): y2 = Y(E, p)
      ' x-axis rotate
      JY1 = cosx * y2 - sinx * Z(E, p)
      JZ1 = sinx * y2 + cosx * Z(E, p)
      ' y-axis rotate
      JX1 = siny * JZ1 + cosy * X2
      Jz(p) = cosy * JZ1 - siny * X2
      ' z-axis rotate
      JX = cosz * JX1 - sinz * JY1
      JY = sinz * JX1 + cosz * JY1
      ' map 3d to 2d
      dx(p) = (-JX * 150) / (Jz(p) + camdist) + xoffset(E)
      dy(p) = (-JY * 125) / (Jz(p) + camdist) + yoffset(E)
   NEXT p
   IF t > 20000 THEN
      mode = 1
   ELSEIF MusicOrder(&HFF) >= 17 THEN mode = 3
   ELSE mode = 2
   END IF
   dist = Size * 1.9
   FOR p = 1 TO UBOUND(pang)
      p2 = p + 120
      IF mode = 1 THEN
         dist = dist(p) - ((30000 - t) / 20)
         IF dist < Size * 1.9 THEN dist = Size * 1.9
      ELSEIF mode = 3 THEN dist = dist(p)
      END IF
      X(E, p2) = COS(pang(p)) * dist: Y(E, p2) = SIN(pang(p)) * dist
      Z(E, p2) = COS(pzang(p)) * Y(E, p2): Y(E, p2) = SIN(pzang(p)) * Y(E, p2)
      ' x-axis rotate
      JY1 = cosx2 * Y(E, p2) - sinx2 * Z(E, p2)
      JZ1 = sinx2 * Y(E, p2) + cosx2 * Z(E, p2)
      ' y-axis rotate
      JX1 = siny2 * JZ1 + cosy2 * X(E, p2)
      Jz(p2) = cosy2 * JZ1 - siny2 * X(E, p2)
      ' z-axis rotate
      JX = cosz2 * JX1 - sinz2 * JY1
      JY = sinz2 * JX1 + cosz2 * JY1
      ' map 3d to 2d
      dx(p2) = (-JX * 150) / (Jz(p2) + camdist) + xoffset(E)
      dy(p2) = (-JY * 125) / (Jz(p2) + camdist) + yoffset(E)
   NEXT p
      FOR L = 1 TO faces(E) - 8 STEP 6
         zavg1! = 0
         FOR M = L TO L + 5
            zavg1! = zavg1! + (Jz(F1(E, M)) + Jz(F2(E, M)) + Jz(F3(E, M))) / 3
         NEXT M
         FOR M = L TO L + 5
            fsort(M) = M
            zavg(M) = zavg1! / 6
         NEXT M
      NEXT L
      FOR L = faces(E) - 7 TO faces(E)
         fsort(L) = L
         zavg(L) = (Jz(F1(E, L)) + Jz(F2(E, L)) + Jz(F3(E, L))) \ 3
      NEXT
      Shellsort zavg(), faces(E)
   FOR p = 1 TO UBOUND(pang)
      p2 = p + 120
      IF Jz(p2) > 0 AND (dy(p2) >= 2 AND dy(p2) < 198) THEN
         Col = 25 - Jz(p2) / 12
         IF Col > 31 THEN Col = 31
         IF Col < 16 THEN Col = 16
         FOR X = dx(p2) - 2 TO dx(p2) + 2
            POKE X + dy(p2) * 320, Col
         NEXT X
         IF dy2(p) < dy(p2) THEN
            dir(p) = 1
         ELSEIF dy2(p) > dy(p2) THEN
            dir(p) = -1
         END IF
         FOR X = dx(p2) - 1 TO dx(p2) + 1
            POKE X + (dy(p2) + dir(p)) * 320, Col
         NEXT X
         POKE dx(p2) + (dy(p2) + dir(p) * 2) * 320, Col
         dy2(p) = dy(p2)
      END IF
   NEXT p
      FOR L = faces \ 2 TO 1 STEP -1
         M = fsort(L)
         TriFill dx(F1(E, M)), dy(F1(E, M)), dx(F2(E, M)), dy(F2(E, M)), dx(F3(E, M)), dy(F3(E, M)), fcolor(E, M), Style
      NEXT L
   FOR p = 1 TO UBOUND(pang)
      p2 = p + 120
      IF Jz(p2) < 0 AND (dy(p2) >= 2 AND dy(p2) < 198) AND (dx(p2) >= 2 AND dx(p2) < 318) THEN
         Col = 25 - Jz(p2) / 12
         IF Col > 31 THEN Col = 31
         IF Col < 16 THEN Col = 16
         FOR X = dx(p2) - 2 TO dx(p2) + 2
            POKE X + dy(p2) * 320, Col
         NEXT X
         IF dy2(p) < dy(p2) THEN
            dir(p) = 1
         ELSEIF dy2(p) > dy(p2) THEN
            dir(p) = -1
         END IF
         FOR X = dx(p2) - 1 TO dx(p2) + 1
            POKE X + (dy(p2) + dir(p)) * 320, Col
         NEXT X
         POKE dx(p2) + (dy(p2) + dir(p) * 2) * 320, Col
         dy2(p) = dy(p2)
      END IF
   NEXT p
   OldT = t
   IF MusicOrder(&HFF) = 18 THEN
      FOR L = 0 TO 9
         IF MusicRow < 10 THEN
            IF L > 1 AND L < 8 THEN
               M = INT(RND * 3) - 1 + L
            ELSE M = L
            END IF
         ELSE M = INT(RND * 10)
         END IF
         CALL BlockMove(VS, VO + M * 320 * 20, &HA000, L * 320 * 20, 320 * 20, 0)
      NEXT L
   ELSE
      CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
   END IF
   IF INKEY$ = CHR$(27) THEN GOTO TheEnd
LOOP UNTIL MusicOrder(&HFF) = 19

camdist = 250: xoffset(E) = 160
ERASE dist, dir, pang, pzang, dy2
'currentscript = currentscript + 1
'QTSetTimer 0, ScriptTime(currentscript)
QTSetTimer 1, 0
QTSetTimer 2, 0
QTSetTimer 3, 0
GOTO Main

Splode:
CLS
ERASE X, Y, Z, L1, L2, F1, F2, F3, faceon, lineon, fontime, lontime
ERASE zavg, fsort, fcolor, dx, dy, Jz
DIM PicD AS ImageType
'GOTO Here2
FOR PicLoop = 1 TO 7
PicD = Image(PicLoop)
REDIM Pic(0 TO PicD.Width - 1, 0 TO PicD.Height - 1) AS STRING * 1
MoveFromXMS XMSItem(PicLoop).Handle, VARSEG(Pic(0, 0)), VARPTR(Pic(0, 0)), PicD.Size, PicD.XMSOffset
REDIM pt(PicD.Points) AS PointData
OUT &H3C8, 0
FOR M = 1 TO 3: OUT &H3C9, 0: NEXT M
OUT &H3C8, 1
FOR L = 1 TO PicD.Colors - 1
   FOR M = 1 TO 3: OUT &H3C9, PicD.Palett(L, M): NEXT M
NEXT L

Pts = 0
speed = 10
FOR Y = 0 TO PicD.Height - 1
   FOR X = 0 TO PicD.Width - 1
      IF Pic(X, Y) <> CHR$(0) THEN
          Pts = Pts + 1
          pt(Pts).X = X
          pt(Pts).Y = Y
          pt(Pts).xspeed = (RND * 2 - 1) * (speed / 100)
          pt(Pts).yspeed = (RND * 2 - 1) * (speed / 100)
          pt(Pts).color = ASC(Pic(X, Y))
          pt(Pts).onscreen = 1
   END IF
NEXT X, Y

FOR p = 1 TO PicD.Points
   PSET (INT(pt(p).X), INT(pt(p).Y)), pt(p).color
NEXT p
LINE (0, 85)-(319, 114), 240, BF
FontPrintCenter 160, 85, RTRIM$(PicD.Title)
QTDelay 2000

QTSetTimer 1, 32767
T0 = 32767
DO
   'CALL BlockMove(BS, BO, VS, VO, 64000, 0)
   CALL BlockMove(BS, BO, VS, VO, 20000, 0)
   CALL BlockMove(BS, BO, VS, VO + 20000, 20000, 0)
   CALL BlockMove(BS, BO, VS, VO + 40000, 24000, 0)
   t = QTGetTimer(1)
   IF t < 30000 THEN EXIT DO
   IF t > 32267 THEN
      t2! = 1 - ((32767 - t) / 500)
      OUT &H3C8, 0
      FOR M = 1 TO 3: OUT &H3C9, 31 * t2!: NEXT M
      OUT &H3C8, 1
      FOR L = 1 TO PicD.Colors - 1
         FOR M = 1 TO 3
            OUT &H3C9, PicD.Palett(L, M) + ((63 - PicD.Palett(L, M)) * t2!)
         NEXT M
      NEXT L
   END IF
   td = T0 - t
   ts! = 1.8 - (((t - 30000) / 1100!) ^ 1.4)
   FOR p = 1 TO PicD.Points
      IF pt(p).onscreen = 1 THEN
         pt(p).X = pt(p).X + td * pt(p).xspeed
         pt(p).Y = pt(p).Y + td * pt(p).yspeed + ts!
         IF pt(p).X >= 0 AND pt(p).X < 320 AND pt(p).Y < 199 THEN
            IF pt(p).Y >= 0 THEN
               POKE INT(pt(p).X) + INT(pt(p).Y) * 320, pt(p).color
            END IF
         ELSE pt(p).onscreen = 0
         END IF
      END IF
   NEXT p
   CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
   'Frames = Frames + 1
   T0 = t
   IF INKEY$ = CHR$(27) THEN GOTO TheEnd
LOOP UNTIL MusicRow = 63
CLS
NEXT PicLoop

here:
'CALL BlockMove(BS, BO, VS, VO, 64000, 0)
CALL BlockMove(BS, BO, VS, VO, 20000, 0)
CALL BlockMove(BS, BO, VS, VO + 20000, 20000, 0)
CALL BlockMove(BS, BO, VS, VO + 40000, 24000, 0)
LINE (0, 85)-(319, 114), 240, BF
FontPrintCenter 160, 85, "PERMANENT"

CALL BlockMove(&HA000, 85 * 320, BS, BO, 30 * 320, 0)
QTSetTimer 1, 2400
DIM C(0 TO 319)
DO
   t = QTGetTimer(1)
   IF t = 0 THEN EXIT DO
   H = 30 + ((2400 - t) \ 110)
   W = 200 + ((2400 - t) \ 22)
   Y = 100 - H \ 2
   X = 160 - W \ 2
   FOR M = 1 TO W
      C(X) = M * (200 / W) + 60
      X = X + 1
   NEXT M
   FOR L = 1 TO H
      FOR M = 0 TO 319: POKE M + Y * 320, 240: NEXT M
      R = L * (30 / H)
      IF R < 1 THEN R = 1
      X = 160 - W \ 2
      FOR M = 1 TO W
         CALL BlockMove(BS, BO + C(X) + (R - 1) * 320, VS, VO + X + Y * 320, 1, 0)
         X = X + 1
      NEXT M
      Y = Y + 1
   NEXT L
   IF INKEY$ = CHR$(27) THEN GOTO TheEnd
   CALL BlockMove(VS, VO, &HA000, 0, 64000, 1)
LOOP UNTIL MusicRow = 32

LINE (0, 85)-(319, 114), 240, BF
FontPrintCenter 160, 85, "DAMAGE"
CALL BlockMove(&HA000, 85 * 320, BS, BO, 30 * 320, 0)
QTSetTimer 1, 2400
DO
   t = QTGetTimer(1)
   IF t = 0 THEN EXIT DO
   H = 50 + ((2400 - t) \ 110)
   W = 200 + ((2400 - t) \ 22)
   Y = 100 - H \ 2
   X = 160 - W \ 2
   FOR M = 1 TO W
      C(X) = M * (100 / W) + 110
      X = X + 1
   NEXT M
   FOR L = 1 TO H
      FOR M = 0 TO 319: POKE M + Y * 320, 240: NEXT M
      R = L * (30 / H)
      IF R < 1 THEN R = 1
      X = 160 - W \ 2
      FOR M = 1 TO W
         CALL BlockMove(BS, BO + C(X) + (R - 1) * 320, VS, VO + X + Y * 320, 1, 0)
         X = X + 1
      NEXT M
      Y = Y + 1
   NEXT L
   IF INKEY$ = CHR$(27) THEN GOTO TheEnd
   CALL BlockMove(VS, VO, &HA000, 0, 64000, 1)
LOOP UNTIL MusicRow = 0

Pts = 70 * 320 \ 16
REDIM pt(Pts) AS PointData
speed = 6
Pts = 0
FOR Y = 0 TO 199 STEP 4
   FOR X = 0 TO 319 STEP 4
      IF PEEK(X + Y * 320) <> 0 THEN
          Pts = Pts + 1
          pt(Pts).X = X
          pt(Pts).Y = Y
          pt(Pts).xspeed = (RND * 2 - 1) * (speed / 100)
          pt(Pts).yspeed = (RND * 2 - 1) * (speed / 100)
          pt(Pts).color = PEEK(X + Y * 320)
          pt(Pts).onscreen = 1
   END IF
NEXT X, Y
DEF SEG = BS
'FOR L = 0 TO 319: FOR M = 0 TO 199: BlankScr(L, M) = CHR$(0): NEXT M, L
FOR L = 0 TO 319: FOR M = 0 TO 84: POKE L + M * 320, 0: NEXT M, L
DEF SEG = VS
QTSetTimer 1, 32767
T0 = 32767
DO
   'CALL BlockMove(BS, BO, VS, VO, 64000, 0)
   CALL BlockMove(BS, BO, VS, VO, 20000, 0)
   CALL BlockMove(BS, BO, VS, VO + 20000, 20000, 0)
   CALL BlockMove(BS, BO, VS, VO + 40000, 24000, 0)
   t = QTGetTimer(1)
   IF t < 30000 THEN EXIT DO
   IF t > 32267 THEN
      t2! = 1 - ((32767 - t) / 500)
      OUT &H3C8, 0
      FOR M = 1 TO 3: OUT &H3C9, 63 * t2!: NEXT M
      OUT &H3C8, 240
      FOR L = 0 TO 15
         FOR M = 1 TO 3
            OUT &H3C9, FontData.Palett(L, M) + ((63 - FontData.Palett(L, M)) * t2!)
         NEXT M
      NEXT L
   END IF
   td = T0 - t
   ts! = 1 - (((t - 30000) / 2000!))
   FOR p = 1 TO Pts
      IF pt(p).onscreen = 1 THEN
         pt(p).X = pt(p).X + td * pt(p).xspeed
         pt(p).Y = pt(p).Y + td * pt(p).yspeed + ts!
         IF pt(p).X >= 0 AND pt(p).X < 320 AND pt(p).Y < 199 THEN
            IF pt(p).Y >= 0 THEN
               POKE INT(pt(p).X) + INT(pt(p).Y) * 320, pt(p).color
            END IF
         ELSE pt(p).onscreen = 0
         END IF
      END IF
   NEXT p
   CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
   'Frames = Frames + 1
   T0 = t
LOOP UNTIL LEN(INKEY$)
CLS

Here2:
ERASE pt, VirtScr', BlankScr

SCREEN 12: CLS
OUT &H3C8, 1
FOR L = 1 TO 15
   OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
NEXT
ShowBMP "dc5l.bmp", Image(1), 0, 100
PicD = Image(1)
QTSetTimer 1, 2000
DO
   WAIT &H3DA, 8: WAIT &H3DA, 8, 8
   t = QTGetTimer(1)
   Fin! = 1 - (t / 2000)
   FOR L = 1 TO 15
      OUT &H3C8, L
      OUT &H3C9, PicD.Palett(L, 1) * Fin!
      OUT &H3C9, PicD.Palett(L, 2) * Fin!
      OUT &H3C9, PicD.Palett(L, 3) * Fin!
   NEXT L
LOOP UNTIL t = 0
QTDelay 3000
QTSetTimer 1, 2000
DO
   WAIT &H3DA, 8: WAIT &H3DA, 8, 8
   t = QTGetTimer(1)
   Fin! = (t / 2000)
   FOR L = 1 TO 15
      OUT &H3C8, L
      OUT &H3C9, PicD.Palett(L, 1) * Fin!
      OUT &H3C9, PicD.Palett(L, 2) * Fin!
      OUT &H3C9, PicD.Palett(L, 3) * Fin!
   NEXT L
LOOP UNTIL t = 0

TheEnd:
QTDone
StopMusic                               'Disable music processing
StopOutput                              'Stop all sound output
UnloadModule                            'Free module memory
FreeMSE                                 'Remove MSE from memory

SCREEN 0: WIDTH 80
LOCATE 12, 1: COLOR 15, 4: PRINT SPACE$(35); "DC5  MMXIX"; SPACE$(35); : LOCATE 1, 1

FOR Slot = 1 TO UBOUND(XMSItem)
   IF XMSItem(Slot).Handle > 0 THEN DeallocateXMS XMSItem(Slot).Handle
NEXT

END

FontData:
DATA 9,8,12,13,14,23,19,6,9,9,11,16,7,10,6,9,13,12,14,13,14,13,13,13,14,14,7,6,14,14,13,12,23,15,15,15,17,13,13,17,16,6,13,15,13,21,16,16,16,16,16,14,15,15,15,23,15,15,13

ImageScript:
DATA PRIDE, 2400
DATA GREED, 2400
DATA LUST, 2400
DATA ENVY, 2400
DATA GLUTTONY, 2400
DATA WRATH, 2400
DATA SLOTH, 2400
DATA "D C 5", 4800

DATA "", 4000
DATA HOLY CRAP! TWO CUBES!, 5600

DATA LANDSLIDE, 1200
DATA WILDFIRE, 1200
DATA TSUNAMI, 1200
DATA AVALANCHE, 1200
DATA HURRICANE, 1200
DATA TORNADO, 1200
DATA VOLCANIC ERUPTION, 1200
DATA EARTHQUAKE, 1200

DATA IPA, 1200
DATA PILSNER, 1200
DATA STOUT, 1200
DATA PALE ALE, 1200
DATA HEFEWEIZEN, 1200
DATA PORTER, 1200
DATA AMBER ALE, 1200
DATA DOUBLE BOCK, 1200

DATA NARCISSISM, 1200
DATA SCHIZOPHRENIA, 1200
DATA INSANITY, 1200
DATA DEPRESSION, 1200
DATA PARANOIA, 1200
DATA ANXIETY, 1200
DATA PSYCHOSIS, 1200
DATA NEUROTICISM, 1200

DATA MORPHINE, 1200
DATA CODEINE, 1200
DATA PERCOCET, 1200
DATA VICODIN, 1200
DATA OXYCONTIN, 1200
DATA FENTANYL, 1200
DATA HEROIN, 1200
DATA METHADONE, 1200

DATA "NAGASAKI: 1945", 1200
DATA "KYSHTYM: 1957", 1200
DATA "LUCENS: 1969", 1200
DATA "FLIXBOROUGH: 1974", 1200
DATA "THREE MILE ISLAND: 1979", 1200
DATA "BHOPAL: 1984", 1200
DATA "CHERNOBYL: 1986", 1200
DATA "FUKUSHIMA: 2011", 1200

DATA ALPHA DESIGN, 600
DATA ATE BIT, 600
DATA B-STATE, 600
DATA BAWLZ, 600
DATA BYTERAPERS, 600
DATA CATALYST, 600
DATA CMUCC, 600
DATA CRONIES, 600
DATA CRTC, 600
DATA DESIRE, 600
DATA DISASTER AREA, 600
DATA FULCRUM, 600
DATA HORNET, 600
DATA INCLINE, 600
DATA INVERSE PHASE, 600
DATA JUMALAUTA, 600
DATA LIMP NINJA, 600
DATA LOGICOMA, 600
DATA OPTIMUS, 600
DATA PLANET EARTH, 600
DATA PVM, 600
DATA SATORI, 600
DATA SENSENSTAHL, 600
DATA SURICRASIA ONLINE, 600
DATA TPOLM, 600
DATA TRAKTOR, 600
DATA TROPE, 600
DATA UMLAUT DESIGN, 600
DATA UNCHAINED, 600
DATA VAAHTERA, 600
DATA VRTX, 600
DATA XYLEM, 600

DATA MARIJUANA, 1200
DATA COCAINE, 1200
DATA CRYSTAL METH, 1200
DATA ECSTASY, 1200
DATA CRACK, 1200
DATA BATH SALTS, 1200
DATA KETAMINE, 1200
DATA LSD, 1200

'DATA PISTOL, 1200
'DATA GRENADE, 1200
'DATA LANDMINE, 1200
'DATA RIFLE, 1200
'DATA MISSILE, 1200
'DATA MACHINE GUN, 1200
'DATA ROCKET LAUNCHER, 1200
'DATA NUCLEAR BOMB, 1200

DATA TUBERCULOSIS, 1200
DATA RABIES, 1200
DATA ANTHRAX, 1200
DATA SMALLPOX, 1200
DATA BIRD FLU H5N1, 1200
DATA AIDS, 1200
DATA EBOLA, 1200
DATA BUBONIC PLAGUE, 1200

DATA FEAR, 1200
DATA UNCERTAINTY, 1200
DATA DOUBT, 1200
DATA DISTRACTION, 1200
DATA CONTROL, 1200
DATA MANIPULATION, 1200
DATA PERSECUTION, 1200
DATA DESTRUCTION, 1200

EffectsTop:
' effect #, duration, direction, xrotmult, yrotmult, zrotmult, camdist, glitch
' glitch = 1: horizontal offset waves
'          2: vertical shake (can't be done with 1)
'          4: strobing faces (fill only)
'          8: some broken lines/fill
DATA 6, 4800, 1, .7, .8, .6, 170, 0
DATA 2, 4800, 1, 0, 0, 1, 150, 0
DATA 3, 4800, 1, 1, 1, 1, 170, 0
DATA 5, 7200, 1, .7, .8, .9, 30, 0
DATA 8, 9600, 1, 5, 5, 5, 250, 4
DATA 1, 4800, 1, 0, 3, 0, 100, 0
DATA 2, 4800, 1, 0, -3, 0, 100, 0
DATA 3, 4800, 1, 0, 4, 0, 220, 4
DATA 4, 4800, -1, 0, 0, 0, 220, 0
DATA 5, 4800, 1, 5, 5, 5, 30, 4
DATA 6, 4800, 1, -15, 5, 5, 250, 0
DATA 7, 4800, 1, 5, 5, 5, 250, 0
DATA 4, 4800, 1, 0, 0, 0, 220, 0
DATA 1, 4800, 1, 0, 0, 4, 150, 0
DATA 2, 4800, 1, 0, 4, 0, 100, 0
DATA 3, 4800, 1, 0, 0, 0, 220, 0
DATA 4, 4800, 1, 0, 3, 0, 220, 9
DATA 5, 4800, 1, 2, 12, 5, 30, 0
DATA 6, 4800, 1, 8, 8, 5, 220, 4
DATA 7, 4800, 1, 18, 10, 5, 220, 9
DATA 1, 4800, 1, 0, 3, 0, 100, 9
DATA 4, 4800, 1, 4, 0, 4, 220, 1
DATA 6, 4800, 1, 5, 12, -8, 220, 8
DATA 3, 4800, 1, 0, 0, 0, 220, 10
DATA 1, 4800, 1, 0, 0, 0, 150, 9
DATA 8, 2400, 1, 10, 20, -4, 220, 0
DATA 5, 2400, 1, 6, 20, 10, 30, 0

EffectsBottom:
' effect #, duration, direction, xrotmult, yrotmult, zrotmult, camdist, glitch (flash = 3)
DATA 6, 4800, 1, .7, .8, .6, 170, 0
DATA 2, 4800, 1, 0, 0, 1, 150, 0
DATA 3, 4800, 1, 1, 1, 1, 170, 0
DATA 5, 7200, 1, .7, .8, .9, 30, 0
DATA 8, 12000, 1, 5, 5, 5, 250, 4
DATA 1, 4800, 1, 0, 3, 0, 100, 4
DATA 2, 4800, 1, 0, -3, 0, 100, 0
DATA 6, 4800, 1, 5, 5, 5, 220, 0
DATA 5, 4800, 1, 5, 5, 5, 30, 4
DATA 4, 4800, 1, 0, -4, 0, 220, 0
DATA 3, 4800, 1, 0, 0, 0, 220, 0
DATA 8, 4800, 1, 5, 5, 5, 250, 0
DATA 1, 4800, 1, 0, 0, 4, 150, 0
DATA 2, 4800, 1, 0, -4, 0, 100, 0
DATA 7, 4800, 1, 5, 5, 5, 250, 0
DATA 6, 4800, 1, 5, -7, 10, 220, 4
DATA 5, 4800, 1, 5, 5, 5, 30, 1
DATA 4, 2400, 1, 0, -6, 0, 220, 8
DATA 3, 4800, -1, 4, 0, 0, 220, 8
DATA 2, 4800, -1, 0, 0, 0, 150, 8
DATA 1, 4800, 1, 0, 0, -5, 150, 12
DATA 8, 4800, 1, 8, 2, -8, 220, 9
DATA 7, 4800, 1, 5, 5, 12, 220, 9
DATA 6, 4800, 1, 15, 15, 5, 220, 10
DATA 5, 4800, 1, 5, 5, 5, 30, 10
DATA 4, 2400, 1, 0, 0, 0, 220, 0
DATA 1, 2400, 1, 0, 0, 0, 150, 0

ImageList:
DATA pd1,BARR
DATA pd2,KAVANAUGH
DATA pd3,HANNITY
DATA pd4,MCCONNELL
DATA pd5,SANDERS
DATA pd6,BANNON
DATA pd7,TRUMP

REM $STATIC
DEFINT J
SUB AALine (BYVAL X1, BYVAL y1, BYVAL X2, BYVAL y2, BYVAL Style)
   SHARED Top, Bottom

   IF (X1 < 0 AND X2 < 0) OR (X1 > 319 AND X2 > 319) THEN EXIT SUB
   IF (y1 < Top AND y2 < Top) OR (y1 > Bottom AND y2 > Bottom) THEN EXIT SUB

   steep = (ABS(y2 - y1) > ABS(X2 - X1))
   IF steep THEN SWAP X1, y1: SWAP X2, y2
   IF X1 > X2 THEN SWAP X1, X2: SWAP y1, y2
   gradient! = (y2 - y1) / (X2 - X1)
   Y! = y1
   Z = 0
IF steep THEN
   IF X2 >= Bottom THEN X2 = Bottom
   FOR X = X1 TO X2
      IF X >= Top THEN
         Y = INT(Y!): fy! = Y! - Y
         IF Y >= 0 AND Y < 319 THEN
            pixel = Y + X * 320: A = (1 - fy!) * 15: d = PEEK(pixel)
            IF d = 0 THEN
               IF Style <> 1 OR (Z AND 4) = 0 THEN
                  POKE pixel, 16 + A
               END IF
            ELSE
               d = d + A
               IF d > 31 THEN d = 31
               IF Style = 1 AND (Z AND 4) = 0 THEN d = 0
               POKE pixel, d
            END IF
            pixel = pixel + 1: A = 15 - A: d = PEEK(pixel)
            IF d = 0 THEN
               IF Style <> 1 OR (Z AND 4) = 0 THEN
                  POKE pixel, 16 + A
               END IF
            ELSE
               d = d + A
               IF d > 31 THEN d = 31
               IF Style = 1 AND (Z AND 4) = 0 THEN d = 0
               POKE pixel, d
            END IF
            'aaplot y + x * 320, 1 - fy!
            'aaplot y + 1 + x * 320, fy!
         END IF
      END IF
      Y! = Y! + gradient!
      Z = Z + 1
   NEXT
ELSE
   IF X2 >= 320 THEN X2 = 319
   FOR X = X1 TO X2
      IF X >= 0 THEN
         Y = INT(Y!): fy! = Y! - Y
         IF Y >= Top AND Y < Bottom THEN
            pixel = X + Y * 320: A = (1 - fy!) * 15: d = PEEK(pixel)
            IF d = 0 THEN
               IF Style <> 1 OR (Z AND 4) = 0 THEN
                  POKE pixel, 16 + A
               END IF
            ELSE
               d = d + A
               IF d > 31 THEN d = 31
               IF Style = 1 AND (Z AND 4) = 0 THEN d = 0
               POKE pixel, d
            END IF
            pixel = pixel + 320: A = 15 - A: d = PEEK(pixel)
            IF d = 0 THEN
               IF Style <> 1 OR (Z AND 4) = 0 THEN
                  POKE pixel, 16 + A
               END IF
            ELSE
               d = d + A
               IF d > 31 THEN d = 31
               IF Style = 1 AND (Z AND 4) = 0 THEN d = 0
               POKE pixel, d
            END IF
            'aaplot x + y * 320, 1 - fy!
            'aaplot x + (y + 1) * 320, fy!
         END IF
      END IF
      Y! = Y! + gradient!
      Z = Z + 1
   NEXT
END IF
END SUB

SUB FontPrintCenter (BYVAL X, BYVAL Y, Text$)
SHARED FontData AS ImageType, CharWidth(), CharOffs()
   TextWidth = 0
   FOR L = 1 TO LEN(Text$)
      TextWidth = TextWidth + CharWidth(ASC(MID$(Text$, L, 1)))
   NEXT L
   X = X - TextWidth \ 2
   FOR L = 1 TO LEN(Text$)
      Char = ASC(MID$(Text$, L, 1))
      CW = CharWidth(Char)
      FOR YL = 0 TO FontData.Height - 1
         CALL BlockMove(FontData.Segment, FontData.Offset + CharOffs(Char) + YL * FontData.Width, &HA000, X + (Y + YL) * 320, CW, 0)
      NEXT YL
      X = X + CW
   NEXT L
END SUB

REM $DYNAMIC
FUNCTION GetLibOffset& (File$)
   DIM LibHeader AS LibHeaderType
   GetLibOffset& = 0
   H = FREEFILE
   OPEN Lib$ FOR BINARY AS H
   SEEK H, 7: GET H, , F
   FOR L = 1 TO F
      GET H, , LibHeader
      IF UCASE$(File$) = RTRIM$(UCASE$(LibHeader.FileName)) THEN
         GetLibOffset& = LibHeader.Offset
         EXIT FOR
      END IF
   NEXT L
   CLOSE H
END FUNCTION

SUB GetSoundCardInfo
SHARED Dev, Port, IRQ, DMA
        IF INSTR(COMMAND$, "SETUP") THEN Setup = 1
        IF LEN(ENVIRON$("ULTRASND")) AND Setup = 0 THEN
                PRINT "Gravis Ultrasound detected."
                Dev = 1: Port = &HFFFF: IRQ = &HFF: DMA = &HFF
        ELSEIF LEN(ENVIRON$("BLASTER")) AND Setup = 0 THEN
                t$ = MID$(ENVIRON$("BLASTER"), INSTR(ENVIRON$("BLASTER"), "T") + 1, 1)
                SELECT CASE t$
                CASE "1"
                        PRINT "Sound Blaster 1.x detected."
                        Dev = 2
                CASE "2"
                        PRINT "Sound Blaster 2.x detected."
                        Dev = 3
                CASE "4"
                        PRINT "Sound Blaster Pro detected."
                        Dev = 4
                CASE "6"
                        PRINT "Sound Blaster 16 detected."
                        Dev = 5
                END SELECT
                Port = &HFFFF: IRQ = &HFF: DMA = &HFF
        ELSE
                PRINT "Select soundcard:"
                PRINT "1) Gravis Ultrasound"
                PRINT "2) Sound Blaster 1.x"
                PRINT "3) Sound Blaster 2.x"
                PRINT "4) Sound Blaster Pro"
                PRINT "5) Sound Blaster 16"
                PRINT "6) Pro Audio Spectrum"
                PRINT "0) Abort"
                DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "6"
                IF In$ = "0" THEN END ELSE Dev = ASC(In$) - 48
                PRINT "Port address (2x0h, 0 to autodetect):"
                DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "9"
                IF In$ = "0" THEN Port = &HFFFF ELSE Port = (16 * (ASC(In$) - 48)) + 512
                PRINT "IRQ (in hex, 0 to autodetect):"
                DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9") OR (In$ >= "a" AND In$ <= "f")
                IF In$ = "0" THEN
                        IRQ = &HFF
                ELSEIF In$ <= "9" THEN IRQ = ASC(In$) - 48
                ELSE IRQ = ASC(In$) - 87
                END IF
                PRINT "DMA (0 to autodetect):"
                DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9")
                IF In$ = "0" THEN DMA = &HFF ELSE DMA = ASC(In$) - 48
        END IF
END SUB

REM $STATIC
SUB LoadBMP (BMPFile$, Array() AS STRING * 1, PData AS ImageType)
   OPEN Lib$ FOR BINARY AS 1
   Offs& = GetLibOffset(BMPFile$) - 1&
   'OPEN BMPFile$ FOR BINARY AS 1
   TmpInt$ = "  ": TmpLong$ = "    ": TmpByte$ = " "
   Buffer$ = STRING$(5000, 0)
   GET 1, Offs& + 11, Offset
   GET 1, Offs& + 19, Wid
   GET 1, Offs& + 23, Hei&
   GET 1, Offs& + 47, PalCount
   REDIM Array(0 TO Wid - 1, 0 TO ABS(Hei&) - 1) AS STRING * 1
   SEEK 1, Offs& + 55
   FOR L = 0 TO PalCount - 1
      GET 1, , TmpLong$
      PData.Palett(L, 1) = ASC(MID$(TmpLong$, 3, 1)) \ 4
      PData.Palett(L, 2) = ASC(MID$(TmpLong$, 2, 1)) \ 4
      PData.Palett(L, 3) = ASC(MID$(TmpLong$, 1, 1)) \ 4
   NEXT L
   SEEK 1, Offs& + Offset + 1
   GET 1, , Buffer$
   BSeg = SSEG(Buffer$): BOff = SADD(Buffer$)
   DEF SEG = BSeg
   PData.Points = 0
   Byte = 0
   FOR Y = 0 TO ABS(Hei&) - 1
      IF Hei& < 0 THEN
         FOR X = 0 TO Wid - 1
            IF Byte >= 5000 THEN GET 1, , Buffer$: Byte = 0
            t = PEEK(BOff + Byte)
            Array(X, Y) = CHR$(t)
            IF Wid <= 320 AND t <> 0 THEN PData.Points = PData.Points + 1
            Byte = Byte + 1
         NEXT X
      ELSE
         FOR X = 0 TO Wid - 1
            IF Byte >= 5000 THEN GET 1, , Buffer$: Byte = 0
            t = PEEK(BOff + Byte)
            Array(X, ABS(Hei&) - Y - 1) = CHR$(t)
            IF Wid <= 320 AND t <> 0 THEN PData.Points = PData.Points + 1
            Byte = Byte + 1
         NEXT X
      END IF
      IF Wid MOD 2 = 1 THEN Byte = Byte + 1 'GET 1, , TmpByte$
      IF Wid MOD 4 = 1 THEN Byte = Byte + 2 'GET 1, , TmpByte$: GET 1, , TmpByte$
   NEXT Y
   Buffer$ = ""
   CLOSE 1
   PData.Height = Hei&: PData.Width = Wid: PData.Colors = PalCount

END SUB

SUB PreLoad
   ' Image pics
   RESTORE ImageList
   I = UBOUND(Image)
   TotalSize& = 0
   FOR L = 1 TO I
      READ Image(L).ImageName, Image(L).Title
      Image(L).Height = 200: Image(L).Width = 320
      Image(L).Size = Image(L).Height * Image(L).Width
      Image(L).XMSOffset = 0
      'IF L = 1 THEN Image(L).XMSOffset = 0 ELSE Image(L).XMSOffset = Image(L - 1).XMSOffset + Image(L - 1).Size
      TotalSize& = TotalSize& + Image(L).Size
      XMSItem(L).Handle = AllocateXMS(Image(L).Size)
   NEXT L
   'XMSItem(1).Handle = AllocateXMS(TotalSize&): PRINT XMSItem(1).Handle
   FOR L = 1 TO I
      REDIM Pic2(0 TO Image(L).Width - 1, 0 TO Image(L).Height - 1) AS STRING * 1
      'QTSetTimer 1, 1000
      'PRINT RTRIM$(Image(L).ImageName) + ".bmp";
      LoadBMP RTRIM$(Image(L).ImageName) + ".bmp", Pic2(), Image(L)
      LINE (0, 85)-((L / (I + 2)) * 320, 114), 4, BF
      'PRINT ", "; Image(L).Points
      MoveToXMS XMSItem(L).Handle, VARSEG(Pic2(0, 0)), VARPTR(Pic2(0, 0)), Image(L).Size, Image(L).XMSOffset
   NEXT L
   ERASE Pic2
END SUB

' SubRoutine by Andy Voss '94
' Sorts an array, quickly.
SUB Shellsort (Array(), BYVAL ubnd)
Span = ubnd \ 2
DO WHILE Span > 0
    FOR I = Span TO ubnd - 1
        FOR J = (I - Span + 1) TO 1 STEP -Span
            IF Array(J) <= Array(J + Span) THEN EXIT FOR
            SWAP Array(J), Array(J + Span)
            SWAP fsort(J), fsort(J + Span)
        NEXT J
    NEXT I
    Span = Span \ 2
LOOP

END SUB

SUB ShowBMP (BMPFile$, PData AS ImageType, BYVAL X0, BYVAL Y0)
   OPEN BMPFile$ FOR BINARY AS 1
   TmpInt$ = "  ": TmpLong$ = "    ": TmpByte$ = " "
   Buffer$ = STRING$(5000, 0)
   GET 1, 11, Offset
   GET 1, 19, Wid
   GET 1, 23, Hei&
   GET 1, 47, PalCount
   'REDIM Array(0 TO Wid - 1, 0 TO ABS(Hei&) - 1) AS STRING * 1
   SEEK 1, 55
   FOR L = 0 TO PalCount - 1
      GET 1, , TmpLong$
      PData.Palett(L, 1) = ASC(MID$(TmpLong$, 3, 1)) \ 4
      PData.Palett(L, 2) = ASC(MID$(TmpLong$, 2, 1)) \ 4
      PData.Palett(L, 3) = ASC(MID$(TmpLong$, 1, 1)) \ 4
   NEXT L
   SEEK 1, Offset + 1
   GET 1, , Buffer$
   BSeg = SSEG(Buffer$): BOff = SADD(Buffer$)
   DEF SEG = BSeg
   PData.Points = 0
   Byte = 0
   FOR Y = 0 TO ABS(Hei&) - 1
      IF Hei& < 0 THEN
         FOR X = 0 TO Wid - 1
            IF Byte >= 5000 THEN GET 1, , Buffer$: Byte = 0
            t = PEEK(BOff + Byte)
            PSET (X0 + X, 480 - (Y0 + Y)), t
            Byte = Byte + 1
         NEXT X
      ELSE
         FOR X = 0 TO Wid - 1
            IF Byte >= 5000 THEN GET 1, , Buffer$: Byte = 0
            t = PEEK(BOff + Byte)
            PSET (X0 + X, 480 - (Y0 + Y)), t
            Byte = Byte + 1
         NEXT X
      END IF
      IF Wid MOD 2 = 1 THEN Byte = Byte + 1 'GET 1, , TmpByte$
      IF Wid MOD 4 = 1 THEN Byte = Byte + 2 'GET 1, , TmpByte$: GET 1, , TmpByte$
   NEXT Y
   Buffer$ = ""
   CLOSE 1
   PData.Height = Hei&: PData.Width = Wid: PData.Colors = PalCount
END SUB

SUB TriFill (BYVAL X1, BYVAL y1, BYVAL X2, BYVAL y2, BYVAL x3, BYVAL y3, Col, BYVAL Style)
SHARED Top, Bottom
IF X1 < 0 AND X2 < 0 AND x3 < 0 THEN EXIT SUB
IF X1 > 319 AND X2 > 319 AND x3 > 319 THEN EXIT SUB
IF y1 < Top AND y2 < Top AND y3 < Top THEN EXIT SUB
IF y1 > Bottom AND y2 > Bottom AND y3 > Bottom THEN EXIT SUB

' sort point pairs top-to-bottom
IF y2 < y1 THEN SWAP y2, y1: SWAP X2, X1
IF y3 < y1 THEN SWAP y3, y1: SWAP x3, X1
IF y3 < y2 THEN SWAP y3, y2: SWAP x3, X2
Y21 = y2 - y1: Y31 = y3 - y1: X21 = X2 - X1: X31 = x3 - X1
Y23 = y2 - y3: Y13 = y1 - y3: X23 = X2 - x3: X13 = X1 - x3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF y1 <> y2 THEN
   xmint! = X21 / Y21: xbint! = X31 / Y31
   MidX! = X1: BottomX! = X1
   YRow = y1 * 320
   FOR Y = y1 TO y2
      IF Y > Bottom THEN EXIT FOR
      IF Y >= Top THEN
         X = MidX!: XE = BottomX!
         IF S < 0 THEN SWAP X, XE
         IF X < 320 AND XE >= 0 THEN
            IF X < 0 THEN X = 0
            IF XE >= 320 THEN XE = 319
            DO UNTIL X > XE
               IF Style = 1 THEN
                  POKE X + YRow, Col * SGN((X + Y) AND 4)
               ELSE POKE X + YRow, Col
               END IF
               X = X + 1
            LOOP
         END IF
      END IF
      MidX! = MidX! + xmint!: BottomX! = BottomX! + xbint!
      YRow = YRow + 320
   NEXT Y
END IF
IF y2 <> y3 THEN
   xmint! = X23 / Y23: xbint! = X13 / Y13
   MidX! = x3: TopX! = x3
   YRow = y3 * 320
   FOR Y = y3 TO y2 + 1 STEP -1
      IF Y < Top THEN EXIT FOR
      IF Y <= Bottom THEN
         X = MidX!: XE = TopX!
         IF S < 0 THEN SWAP X, XE
         IF X < 320 AND XE >= 0 THEN
            IF X < 0 THEN X = 0
            IF XE >= 320 THEN XE = 319
            DO UNTIL X > XE
               IF Style = 1 THEN
                  POKE X + YRow, Col * SGN((X + Y) AND 4)
               ELSE POKE X + YRow, Col
               END IF
               X = X + 1
            LOOP
         END IF
      END IF
      MidX! = MidX! - xmint!: TopX! = TopX! - xbint!
      YRow = YRow - 320
   NEXT Y
END IF
END SUB

