#ifndef _CAMERAS_
#define _CAMERAS_


#include "vectors.h"

#define MaxPathPoints 100

class TCamera {
	public:
			TVector location;
			TVector direction;
			int ax, ay, az;
			
			TCamera();
			void Rotate(int x, int y, int z);
			void Advance(double dist);
};


class TCameraPath {
	public:
			TCamera *Point[MaxPathPoints];
			int numpoints;
			int divisions_per_point;
			int total_frames;
			
			TCameraPath();
			~TCameraPath();
			void AddCurrentPosition();
			void SetDivisionsPerPoint(int divisions);
			void SetTotalFrames(long frames);
			int InterpolateFrame(long frame, TCamera *c);
			void Save(char *filename);
			void Load(char *filename);
};


extern TCamera *camera;


#endif
