#include <i86.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include "vesavbe.h"
#include "hires256.h"

// Entrar al modo grfico
unsigned char *SCREEN;
unsigned int SCREEN_OFF;
VBE_ModeInfoBlock modeinfo;

void SetHiresMode() {
        int mode = VBE_FindMode(640, 480, 8);
        if (mode == -1) {
                VBE_SetMode(3, 0, 1);
                printf("640 x 480 x 8bpp LFB mode not found\n");
                printf("Try loading UniVBE 5.x or higher\n");
                exit(1);
        }
        if (!VBE_IsModeLinear(mode)) {
                VBE_SetMode(3, 0, 1);
                printf("640 x 480 x 8bpp LFB mode not found\n");
                printf("Try loading UniVBE 5.x or higher\n");
                exit(1);
        }
        
        VBE_SetMode(mode, 1, 1);
        SCREEN = (unsigned char *)VBE_GetVideoPtr(mode);
        SCREEN_OFF = FP_OFF(SCREEN);

        if (!SCREEN) {
                VBE_SetMode(3, 0, 1);
                printf("Invalid LFB!\n");
                printf("Try loading UniVBE 5.x or higher\n");
                exit(1);
        }

        VBE_Mode_Information(mode, &modeinfo);
}



// Procedimientos de dibujo

void HDDALine(int x1, int y1, int x2, int y2, int color, unsigned int where) {
	int width = x2 - x1;
	int height = y2 - y1;
	if (width < 0) width = -width;
	if (height < 0) height = - height;
	if (width > height) {
		if (x1 > x2) {
			int temp = x1; x1 = x2; x2 = temp;
			temp = y1; y1 = y2; y2 = temp;
		}
		if (width == 0) width = 1;
		int dy = (height << 16) / width;
                int yinc = (y1 > y2) ? (-640) : (640);
                unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
		_asm {
			mov edi, [off]
			mov esi, [yinc]
			mov eax, [color]
			mov edx, [dy]
			xor ebx, ebx
			mov ecx, [width]
			lloop:  mov [edi], al
					add bx, dx
					jnc cont
					add edi, esi
			cont:   inc edi
					dec ecx
					jnz lloop
		}
		return;
	}
	if (width < height) {
		if (y1 > y2) {
			int temp = y1; y1 = y2; y2 = temp;
			temp = x1; x1 = x2; x2 = temp;
		}
		if (height == 0) height = 1;
		int ddx = (width << 16) / height;
		int xinc = (x1 > x2) ? (-1) : (1);
                unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
		_asm {
			mov edi, [off]
			mov esi, [xinc]
			mov eax, [color]
			mov edx, [ddx]
			xor ebx, ebx
			mov ecx, [height]
			lloop:  mov [edi], al
					add bx, dx
					jnc cont
					add edi, esi
                        cont:   add edi, 640
					dec ecx
					jnz lloop
		}
		return;
	}
	int dx = (x1 > x2) ? (-1) : (1);
        int dy = (y1 > y2) ? (-640 + dx) : (640 + dx);
        int off = where + (y1 << 9) + (y1 << 7) + x1;
	if (width == 0) width = 1;
	_asm {
		mov edi, [off]
		mov eax, [color]
		mov ebx, [dy]
		mov ecx, [width]
		lloop:  mov [edi], al
				add edi, ebx
				dec ecx
				jnz lloop
	}
}



// Manejo de paleta
void GetPal(int color, unsigned char *r, unsigned char *g, unsigned char *b) {
	unsigned char _r, _g, _b;
	int _color = color;
	_asm {
		mov edx, 0x03C7
		mov eax, [_color]
		out dx, al
		add edx, 2
		in al, dx
		mov [_r], al
		in al, dx
		mov [_g], al
		in al, dx
		mov [_b], al
	}
	*r = _r;
	*g = _g;
	*b = _b;
}


void GetPalette(TPalette pal) {
	unsigned int _ofs = FP_OFF(pal);
	_asm {
		mov edi, [_ofs]
		mov edx, 0x03C7
		xor eax, eax
		out dx, al
		add edx, 2
		mov ecx, 768
		rep insb
	}
}

void SetPalette(TPalette pal) {
	unsigned int _ofs = FP_OFF(pal);
	_asm {
		mov esi, [_ofs]
		mov edx, 0x03C8
		xor eax, eax
		out dx, al
		inc edx
		mov ecx, 768
		rep outsb
	}
}


// Efectos de paleta
void RotatePalette(TPalette pal, int first, int last) {
	int i;
	TColor c;
	memcpy(c, pal[last], 3);
	if (first < last) {
		for (i = last; i > first; i--) memcpy(pal[i], pal[i-1], 3);
	}
	else {
		for (i = last; i < first; i++) memcpy(pal[i], pal[i+1], 3);
	};
	memcpy(pal[first], c, 3);
}

void FadeOut(TPalette pal, int first, int last) {
	int j;
	for (j = first; j <= last; j++) {
		if (pal[j][0]) pal[j][0]--;
		if (pal[j][1]) pal[j][1]--;
		if (pal[j][2]) pal[j][2]--;
	}
}

void FadeTo(TPalette pal, TPalette dest, int first, int last) {
	int j;
	for (j = first; j <= last; j++) {
		if (pal[j][0] > dest[j][0]) pal[j][0]--;
		if (pal[j][0] < dest[j][0]) pal[j][0]++;
		if (pal[j][1] > dest[j][1]) pal[j][1]--;
		if (pal[j][1] < dest[j][1]) pal[j][1]++;
		if (pal[j][2] > dest[j][2]) pal[j][2]--;
		if (pal[j][2] < dest[j][2]) pal[j][2]++;
	}
}


// Pantallas virtuales
PTVirtual HSetupVirtual(PTVirtual *Vscr, unsigned int *Voff) {
        *Vscr = (PTVirtual)malloc(307200);
	if (*Vscr) *Voff = FP_OFF(*Vscr);
	return *Vscr;
}

void HShutDownVirtual(PTVirtual *Vscr) {
        if (*Vscr) free(*Vscr);
	*Vscr = NULL;
}



// Otros procs
void HLoadPCX(char *fn, unsigned int where, int dimX, int dimY,
             int offX,int offY, TPalette pal) {
	FILE *file;
	int x, y, flag;
        unsigned char c, a, i;
	
	if ((file = fopen(fn, "rb")) == NULL) return;
	fseek(file, 128, SEEK_SET);            
    flag = 1;
    x = y = 0;
    while (flag) {
    	c = fgetc(file);
    	if ((c & 0xC0) == 0xC0) {
    		a = fgetc(file);
    		c = c & 0x3F;
    		for (i = 0; i < c; i++) {
                        HPutPixel(offX + x, offY + y, a, where);
    			if (++x == dimX) {
    				x = 0;
    				if (++y == dimY) flag = 0;
    			}
    		}
    	}
    	else {
                HPutPixel(offX + x, offY + y, c, where);
    		if (++x == dimX) {
    			x = 0;
    			if (++y == dimY) flag = 0;
    		}
    	}
    }
    fseek(file, -768, SEEK_END);
    for (x = 0; x < 256; x++) {
    	pal[x][0] = ((unsigned char)fgetc(file)) >> 2;
    	pal[x][1] = ((unsigned char)fgetc(file)) >> 2;
    	pal[x][2] = ((unsigned char)fgetc(file)) >> 2;
    }
    fclose(file);
}

