#ifndef _HIRES_256_
#define _HIRES_256_

#include "vesavbe.h"

#define HiResPageSize 307200

extern "C" {

	// drawing procs
        void HClearScreen(int color, int where);
        #pragma aux HClearScreen parm caller [eax] [edi];

        void HPutPixel(int x, int y, int color, int where);
        #pragma aux HPutPixel parm caller [ebx] [eax] [edx] [edi];

        int HGetPixel(int x, int y, int where);
        #pragma aux HGetPixel parm caller [ebx] [eax] [edi];

        void HHLine(int x1, int x2, int y, int color, int where);
        #pragma aux HHLine parm caller [ebx] [ecx] [edi] [eax] [esi];
	
	// palette procs
	void SetPal(int color, int red, int green, int blue);
        #pragma aux SetPal parm caller [eax] [ebx] [ecx] [edi];
	
	// virtual screen procs
        void HCopyScreen(int source, int dest);
        #pragma aux HCopyScreen parm caller [esi] [edi];

	// other procs
	void VRetrace();

        void HCopyAndClear(int source, int dest);
        #pragma aux HCopyAndClear parm caller [esi] [edi];

        void HCopyAndCopy(int source, int dest, int back);
        #pragma aux HCopyAndCopy parm caller [esi] [edi] [edx];

        void HBlend(int source, int dest, int value);
        #pragma aux HBlend parm [esi] [edi] [ecx];

        void HBlend2(int source, int dest, char value1, char value2);
        #pragma aux HBlend2 parm [esi] [edi] [cl] [ch];
}

//  apuntadores a la pantalla
extern unsigned char *SCREEN;
extern unsigned int SCREEN_OFF;
extern VBE_ModeInfoBlock modeinfo;

// paleta

typedef unsigned char TColor[3];
typedef TColor TPalette[256];

typedef char TVirtual[480][640];
typedef char *PTVirtual;

void SetHiResMode();

void HDDALine(int x1, int y1, int x2, int y2, int color, unsigned int where);

void GetPal(int color, unsigned char *r, unsigned char *g, unsigned char *b);
void GetPalette(TPalette pal);
void SetPalette(TPalette pal);

void RotatePalette(TPalette pal, int first, int last);
void FadeOut(TPalette pal, int first, int last);
void FadeTo(TPalette pal, TPalette dest, int first, int last);

PTVirtual HSetupVirtual(PTVirtual *Vscr, unsigned int *Voff);
void HShutDownVirtual(PTVirtual *Vscr);

void HLoadPCX(char *fn, unsigned int where, int dimX, int dimY,
              int offX,int offY, TPalette pal);


#endif
