; HIRESASM.ASM   -- Use this shit with Watcom C++ --

.386P
.MODEL FLAT

_TEXT SEGMENT DWORD PUBLIC 'CODE'
		ASSUME  cs:_TEXT, ds:_DATA


; DECLARATIONS

; drawing procs
public HClearScreen_
public HPutPixel_
public HGetPixel_
public HHLine_

; palette procs
public SetPal_

; virtual screen procs
public HCopyScreen_

; other procs
public VRetrace_
public HCopyAndClear_
public HCopyAndCopy_
public HBlend_
public HBlend2_

; IMPLEMENTATION

; drawing procs

; void HClearScreen(int where);
; -> clears the fucking 640*480*256 screen

HClearScreen_     PROC    NEAR
mov ah, al
mov edx, eax
shl eax, 16
mov ecx, 76800
mov ax, dx
rep stosd
ret
HClearScreen_     ENDP


; void HPutPixel(int x, int y, int color, int where);
; -> plots a stupid pixel at (x, y) with some color

HPutPixel_        PROC    NEAR
lea eax, [eax + eax * 4]
shl eax, 7
add eax, ebx
mov BYTE PTR [edi + eax], dl
ret
HPutPixel_        ENDP


; int HGetPixel(int x, int y, int where);
; -> gets the damn pixel color at (x, y)

HGetPixel_        PROC    NEAR
lea eax, [eax + eax * 4]
shl eax, 7
add ebx, eax
xor eax, eax
mov al, BYTE PTR [edi + ebx]
ret
HGetPixel_        ENDP


; void HHLine(int x1, int x2, int y, int color, int where);
; -> draws an horizontal line from (x1, y) to (x2, y)

HHLine_   PROC    NEAR
lea edi, [edi + edi * 4]
shl edi, 7
sub ecx, ebx
add edi, ebx
mov ah, al
inc ecx
add edi, esi
shr ecx, 1
jnc hlstart
stosb
hlstart: rep stosw
ret
HHLine_   ENDP


; void SetPal(int index, int r, int g, int b);
; -> sets the indexth color rgb components

; palette procs
SetPal_  PROC    NEAR
mov edx, 03C8h
out dx, al
inc edx
mov eax, ebx
out dx, al
mov eax, ecx
out dx, al
mov eax, edi
out dx, al
ret
SetPal_  ENDP


; virtual screen procs

; void HCopyScreen(int source, int dest);
; -> Copies the whole fucking screen from source to dest

HCopyScreen_      PROC    NEAR
mov ecx, 76800
rep movsd
ret
HCopyScreen_      ENDP


; other procs

; void VRetrace();
; -> waits until the vertical retrace starts

VRetrace_        PROC    NEAR
mov edx, 03DAh
vloop1:	in al, dx
        test al, 08h
        jnz vloop1
vloop2:	in al, dx
        test al, 08h
        jz vloop2
ret
VRetrace_        ENDP

; void HCopyAndClear(int source, int dest);
; -> Copies the screen from source to dest and clears the source screen

HCopyAndClear_    PROC    NEAR
xor eax, eax
mov ebx, 1200
mov edx, esi
ccloop: mov ecx, 64
        rep movsd
        xchg edi, edx
        mov ecx, 64
        rep stosd
        xchg edx, edi
        dec ebx
        jnz ccloop
ret
HCopyAndClear_    ENDP


; void HCopyAndCopy(int source, int dest, int back);
; -> Copies the screen from source to dest and copies back to source

HCopyAndCopy_     PROC    NEAR
mov ebx, 1200
mov eax, esi
c2loop: mov ecx, 64
        rep movsd
        xchg edi, eax
        xchg esi, edx
        mov ecx, 64
        rep movsd
        xchg edi, eax
        xchg esi, edx
        dec ebx
        jnz c2loop
ret
HCopyAndCopy_     ENDP



; void Blend(int source, int dest, int value);
; -> Mixes 2 screens by adding their color values
; -> if value = 0 ==> the dest screen will be the source
; -> if value = 15 ==> the dest screen won't change
; -> intermediate values produce intermediate results

HBlend_           PROC    NEAR
mov ebx, 307199
mov edx, 0FFh
xor eax, eax
cmp ecx, 8
jb fdst
sub ecx, 8
fslp:  mov al, byte ptr [esi + ebx]
       shr eax, cl
       add byte ptr [edi + ebx], al
       jnc cont1
       mov [edi + ebx], dl
cont1: dec ebx
       jns fslp
       ret
fdst:  mov ch, 8
       sub ch, cl
       mov cl, ch
fdlp:  mov al, byte ptr [edi + ebx]
       shr eax, cl
       add al, byte ptr [esi + ebx]
       jnc cont2
       mov al, dl
cont2: mov [edi + ebx], al
       dec ebx
       jns fdlp
       ret
HBlend_           ENDP


; void Blend2(int source, int dest, char value1, char value2);
; -> Mixes 2 screen by adding their pixel colors
; -> The colors of the source screen are shifted right by value1
; -> The colors of the dest screen are shifted right by value2

HBlend2_          PROC    NEAR
mov ebx, 307199
mov edx, 0FF00h
xor eax, eax
bloop: mov al, [esi + ebx]
       mov dl, [edi + ebx]
       shr al, cl
       xchg cl, ch
       shr dl, cl
       xchg cl, ch
       add al, dl
       jnc nomax
       mov al, dh
nomax: mov [edi + ebx], al
       dec ebx
       jns bloop
       ret
HBlend2_          ENDP


_TEXT ENDS
	END
