#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "hires256.h"
#include "stuff.h"
#include "phongpal.h"
#include "obj3d.h"
#include "triangle.h"
#include "polygons.h"
#include "vectors.h"
#include "primitiv.h"
#include "scenes.h"
#include "cameras.h"
#include "rings.h"

// picture files
#include "p200x720.h"
#include "m1.h"
#include "m2.h"
#include "m3.h"
#include "m4.h"
#include "m5.h"
#include "m6.h"
#include "m7.h"
#include "m13.h"


// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


TScene *rings_scene;
char Rings_Table1[512];
unsigned char table1idx;
unsigned int table1 = 256 + (unsigned int)Rings_Table1;



#define NumRings 12

void Rings_Setup() {
        TPalette pal;
        TObject3D *obj;
        rings_scene = new TScene();
        for (int i = 0; i < NumRings; i++) {
                obj = new TObject3D();
                MakeTorus(obj, i + 1, 0.2, 6, 16, 0);
                obj->SetColor((i % 6) * 32, 15);
                obj->SetStyle(c_gouraudshaded);
                rings_scene->AddObject(obj);
        }
        rings_scene->own_camera.location.SetP(-4, -4, -15);
        rings_scene->own_light.SetP(-1, -1, -1.5);
        rings_scene->own_light.Normalize();

        for (i = 0; i < 144000; i++) P200X720[i] = 192 + P200X720[i] / 8;

        for (i = 0; i < 512; i++)
                Rings_Table1[i] = 17.0 + 7.0 * cos(i * Pi / 128.0)
                                       + 8.0 * cos(i * Pi / 64.0);

        for (i = 0; i < 16000; i++) {
                if (M1[i]) M1[i] = 224 + M1[i] / 8;
                if (M2[i]) M2[i] = 224 + M2[i] / 8;
                if (M3[i]) M3[i] = 224 + M3[i] / 8;
                if (M4[i]) M4[i] = 224 + M4[i] / 8;
                if (M5[i]) M5[i] = 224 + M5[i] / 8;
                if (M6[i]) M6[i] = 224 + M6[i] / 8;
                if (M7[i]) M7[i] = 224 + M7[i] / 8;
        }
}

void Rings_Free() {
        delete rings_scene;
}


void DrawScroller(int ypos, unsigned int source, unsigned int dest);
#pragma aux DrawScroller =      \
"       push esi"       \
"       mov eax, 200"   \
"       mul ebx"        \
"       add esi, eax"   \
"       mov edx, 720"   \
"       sub edx, ebx"   \
"       cmp edx, 480"   \
"       jb part2"       \
"       mov edx, 480"   \
"       lp1:    mov ecx, 42"    \
"               rep movsd"      \
"               push esi"       \
"               mov esi, [table1]"      \
"               movzx eax, byte ptr [table1idx]" \
"               movzx ecx, byte ptr [esi + eax]" \
"               mov eax, 32"    \
"               sub eax, ecx"   \
"               pop esi"        \
"               push eax"       \
"               rep movsb"      \
"               pop eax"        \
"               add edi, eax"   \
"               add esi, eax"   \
"               inc byte ptr [table1idx]"       \
"               add edi, 440"   \
"               dec edx"        \
"               jnz lp1"        \
"       pop esi"        \
"       jmp fin"        \
"       part2:  mov ecx, 42"    \
"               rep movsd"      \
"               push esi"       \
"               mov esi, [table1]"      \
"               movzx eax, byte ptr [table1idx]" \
"               movzx ecx, byte ptr [esi + eax]" \
"               mov eax, 32"    \
"               sub eax, ecx"   \
"               pop esi"        \
"               push eax"       \
"               rep movsb"      \
"               pop eax"        \
"               add edi, eax"   \
"               add esi, eax"   \
"               inc byte ptr [table1idx]"       \
"               add edi, 440"   \
"               dec edx"        \
"               jnz part2"      \
"       mov edx, ebx"   \
"       sub edx, 240"   \
"       pop esi"        \
"       lp2:    mov ecx, 42"    \
"               rep movsd"      \
"               push esi"       \
"               mov esi, [table1]"      \
"               movzx eax, byte ptr [table1idx]" \
"               movzx ecx, byte ptr [esi + eax]" \
"               mov eax, 32"    \
"               sub eax, ecx"   \
"               pop esi"        \
"               push eax"       \
"               rep movsb"      \
"               pop eax"        \
"               add edi, eax"   \
"               add esi, eax"   \
"               inc byte ptr [table1idx]"       \
"               add edi, 440"   \
"               dec edx"        \
"               jnz lp2"        \
"fin:   nop"    \
parm [ebx] [esi] [edi]  \
modify [eax ecx edx];


void RDrawLogo(unsigned int source, unsigned int dest, int x);
#pragma aux RDrawLogo = \
"       add edi, 243200"        \
"       mov edx, 100"   \
"       add edi, ebx"   \
"       ylp:    mov ecx, 160"   \
"       xlp:    mov al, [esi]"  \
"               inc esi"        \
"               or al, al"      \
"               jz nope"        \
"               mov [edi], al"  \
"       nope:   inc edi"        \
"               dec ecx"        \
"               jnz xlp"        \
"               add edi, 480"   \
"               dec edx"        \
"               jnz ylp"        \
parm [esi] [edi] [ebx]  \
modify [eax ecx edx];


void Rings() {
        unsigned int Sequence[3][3] = { {(unsigned int)M13, (unsigned int)M1, (unsigned int)M2},
                                        {(unsigned int)M3, (unsigned int)M4, (unsigned int)M5},
                                        {(unsigned int)M6, (unsigned int)M7, (unsigned int)M13} };
        TVirtual *vs = new TVirtual;
        int i = 0, y = 0;
        unsigned char t = 0;
        double ang, z, a = 0.0;
        TPalette pal;

        HClearScreen(0, SCREEN_OFF);
        HClearScreen(0, (unsigned int)vs);
        rings_scene->Setup(1);

        for (i = 0; i < 16000; i++) if (M13[i]) M13[i] = 224 + (M13[i] - 128) / 4;

        PhongPal(0.2, 0.7, 1.0, 0, 0.1, 1.0, 0.3, 0.2, 1.0, 50, pal, 0, 32);
        PhongPal(0.2, 0.1, 1.0, 0, 0.7, 1.0, 0.3, 0.2, 1.0, 50, pal, 32, 32);
        PhongPal(0.2, 0.1, 1.0, 0, 0.1, 1.0, 0.3, 0.8, 1.0, 50, pal, 64, 32);
        PhongPal(0.2, 0.7, 1.0, 0, 0.7, 1.0, 0.3, 0.2, 1.0, 50, pal, 96, 32);
        PhongPal(0.2, 0.7, 1.0, 0, 0.1, 1.0, 0.3, 0.8, 1.0, 50, pal, 128, 32);
        PhongPal(0.2, 0.1, 1.0, 0, 0.7, 1.0, 0.3, 0.8, 1.0, 50, pal, 160, 32);
        PhongPal(0.4, 0.6, 1.0, 0.0, 0.5, 0.5, 0.6, 0.4, 0.4, 1, pal, 192, 32);
        PhongPal(0.2, 0.8, 1.0, 0, 0.8, 1.0, 0.3, 0.8, 1.0, 10, pal, 224, 32);
        SetPalette(pal);
        SetLightPosition(-1, -1, -1.5);

        z = -13.5;
        GetMusicInfo();

        while (position < 20) {
                if (!(row & 7)) z = -13.5; else z -= 0.1;
                camera->location.SetP(-4, -4, z);

                rings_scene->Draw((unsigned int)vs);

                table1idx = t;
                t -= 4;
                DrawScroller( y, // (((position) * 128) + row * 2) % 720,
                                (unsigned int)P200X720, (unsigned int)vs);
                y = (y + 1) % 720;

                i = ((((position - 16) * 64) + row) >> 3) % 3;
                RDrawLogo(Sequence[i][0], (unsigned int) vs, 200);
                RDrawLogo(Sequence[i][1], (unsigned int) vs, 350);
                RDrawLogo(Sequence[i][2], (unsigned int) vs, 500);

                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                a = (((position) * 64) + row) * 0.02;
                for (i = 0; i < NumRings; i++) {
                        ang = a - i * 0.03;
                        rings_scene->obj[i]->Rotate(dtoi(8.0 * sin(ang)),
                                                        dtoi(8.0 * cos(ang * 1.5)),
                                                        -dtoi(8.0 * sin(ang * 2.0)));
                }
                Light.Rotate(0, 0, 4);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        delete vs;
}
