
#include "mode13.h"
#include <i86.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>

#define iAbs(x) (x<0) ? (-x) : x
#define iSgn(x) (x>0) ? 1 : ((x<0) ? -1 : 0)

// Procedimientos de dibujo

void Line(int x1, int y1, int x2, int y2, int color, unsigned int where) {
	int i, s, d1x, d1y, d2x, d2y, u, v, m, n;
	u = x2 - x1;
	v = y2 - y1;
    d1x = d2x = iSgn(u);
    d1y = iSgn(v);
    d2y = 0;
    m = iAbs(u);
    n = iAbs(v);
    if (!(m > n)) {
    	d2x = 0;
        d2y = iSgn(v);
        m = iAbs(v);
        n = iAbs(u);
    }
    s = m >> 1;
    for (i = 0; i <= m; i++) {
    	PutPixel(x1, y1, color, where);
        s += n;
        if (!(s < m)) {
        	s -= m;
            x1 += d1x;
            y1 += d1y;
        }
		else
		{
			x1 += d2x;
			y1 += d2y;
		}
	}
}


// Manejo de paleta
void GetPal(int color, unsigned char *r, unsigned char *g, unsigned char *b) {
	unsigned char _r, _g, _b;
	int _color = color;
	_asm {
		mov edx, 0x03C7
		mov eax, [_color]
		out dx, al
		add edx, 2
		in al, dx
		mov [_r], al
		in al, dx
		mov [_g], al
		in al, dx
		mov [_b], al
	}
	*r = _r;
	*g = _g;
	*b = _b;
}


void GetPalette(TPalette pal) {
	unsigned int _ofs = FP_OFF(pal);
	_asm {
		mov edi, [_ofs]
		mov edx, 0x03C7
		xor eax, eax
		out dx, al
		add edx, 2
		mov ecx, 768
		rep insb
	}
}

void SetPalette(TPalette pal) {
	unsigned int _ofs = FP_OFF(pal);
	_asm {
		mov esi, [_ofs]
		mov edx, 0x03C8
		xor eax, eax
		out dx, al
		inc edx
		mov ecx, 768
		rep outsb
	}
}


// Efectos de paleta
void RotatePalette(TPalette pal, int first, int last) {
	int i;
	TColor c;
	memcpy(c, pal[last], 3);
	if (first < last) {
		for (i = last; i > first; i--) memcpy(pal[i], pal[i-1], 3);
	}
	else {
		for (i = last; i < first; i++) memcpy(pal[i], pal[i+1], 3);
	};
	memcpy(pal[first], c, 3);
}

void FadeOut(TPalette pal, int first, int last) {
	int j;
	for (j = first; j <= last; j++) {
		if (pal[j][0]) pal[j][0]--;
		if (pal[j][1]) pal[j][1]--;
		if (pal[j][2]) pal[j][2]--;
	}
}

void FadeTo(TPalette pal, TPalette dest, int first, int last) {
	int j;
	for (j = first; j <= last; j++) {
		if (pal[j][0] > dest[j][0]) pal[j][0]--;
		if (pal[j][0] < dest[j][0]) pal[j][0]++;
		if (pal[j][1] > dest[j][1]) pal[j][1]--;
		if (pal[j][1] < dest[j][1]) pal[j][1]++;
		if (pal[j][2] > dest[j][2]) pal[j][2]--;
		if (pal[j][2] < dest[j][2]) pal[j][2]++;
	}
}


// Pantallas virtuales
PTVirtual SetupVirtual(PTVirtual *Vscr, unsigned int *Voff) {
	*Vscr = (PTVirtual)malloc(64000);
	if (*Vscr) *Voff = FP_OFF(*Vscr);
	return *Vscr;
}

void ShutDownVirtual(PTVirtual *Vscr) {
	free(*Vscr);
	*Vscr = NULL;
}



// Otros procs
void LoadPCX(char *fn, unsigned int where, int dimX, int dimY,
             int offX,int offY, TPalette pal) {
	FILE *file;
	int x, y, flag;
	unsigned char c, a, i, r, g, b;
	
	if ((file = fopen(fn, "rb")) == NULL) return;
	fseek(file, 128, SEEK_SET);            
    flag = 1;
    x = y = 0;
    while (flag) {
    	c = fgetc(file);
    	if ((c & 0xC0) == 0xC0) {
    		a = fgetc(file);
    		c = c & 0x3F;
    		for (i = 0; i < c; i++) {
    			PutPixel(offX + x, offY + y, a, where);
    			if (++x == dimX) {
    				x = 0;
    				if (++y == dimY) flag = 0;
    			}
    		}
    	}
    	else {
    		PutPixel(offX + x, offY + y, c, where);
    		if (++x == dimX) {
    			x = 0;
    			if (++y == dimY) flag = 0;
    		}
    	}
    }
    fseek(file, -768, SEEK_END);
    for (x = 0; x < 256; x++) {
    	pal[x][0] = ((unsigned char)fgetc(file)) >> 2;
    	pal[x][1] = ((unsigned char)fgetc(file)) >> 2;
    	pal[x][2] = ((unsigned char)fgetc(file)) >> 2;
    }
    fclose(file);
}

