
#include <stdlib.h>
#include "bitmaps.h"
#include "plasmafx.h"
#include "mymath.h"
#include "phongpal.h"
#include "globals.h"
#include "textures.h"

TBitmap8bpp *texture[NumTextures];

void GenerateTextures() {
        double a;

        for (int i = 0; i < NumTextures; i++)
                texture[i] = new TBitmap8bpp(256, 256);

        byte table1[256], table2[256];

        // texture 0
        GeneratePlasmaTable(table1, 0, 0, 0);
        GeneratePlasmaTable(table1, 1, 32, 2);
        GeneratePlasmaTable(table1, 4, 16, 1);
        GeneratePlasmaTable(table1, 5, 8, 4);
        GeneratePlasmaTable(table2, 0, 0, 0);
        GeneratePlasmaTable(table2, 7, 32, 1);
        GeneratePlasmaTable(table2, 3, 16, 4);
        GeneratePlasmaTable(table2, 2, 8, 2);

        GeneratePlasma(texture[0], table1, table2, 43, 7, 2, 67);

        for (i = 0; i < 256; i++) {
                a = i * PI / 128.0;
                texture[0]->paleta[i] = RGB(dtoi(192.0 + 63.0 * fsin(a * 2.0)),
                                         dtoi(127.0 + 127.0 * fcos(a)),
                                         dtoi(84 - 62 * fcos(a * 2.0)));
        }

        // texture 1
        GeneratePlasmaTable(table1, 0, 0, 0);
        GeneratePlasmaTable(table1, 5, 64, 1);
        GeneratePlasmaTable(table1, 7, 32, 2);
        GeneratePlasmaTable(table1, 8, 16, 4);
        GeneratePlasmaTable(table2, 0, 0, 0);
        GeneratePlasmaTable(table2, 6, 64, 1);
        GeneratePlasmaTable(table2, 8, 32, 2);
        GeneratePlasmaTable(table2, 7, 16, 4);

        GeneratePlasma(texture[1], table1, table2, 84, 103, 65, 1);

        PhongPal(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 100,
                texture[1]->paleta, 128);
        for (i = 0; i < 128; i++)
                texture[1]->paleta[255 - i] = texture[1]->paleta[i];

        // texture 2
        GeneratePlasmaTable(table1, 0, 0, 0);
        GeneratePlasmaTable(table1, 5, 64, 1);
        GeneratePlasmaTable(table1, 7, 32, 2);
        GeneratePlasmaTable(table1, 8, 16, 4);
        GeneratePlasmaTable(table1, 6, 8, 8);
        GeneratePlasmaTable(table1, 8, 4, 16);
        GeneratePlasmaTable(table1, 7, 2, 32);
        GeneratePlasma(texture[2], table1, table1, 11, 33, 77, 99);
        for (i = 0; i < 4; i++) texture[2]->Blur();
        int c;
        byte *off = texture[2]->datos;
        for (int y = 0; y < 256; y++)
                for (int x = 0; x < 256; x++) {
                        a = fsqrt(fsqr(x - 160) + fsqr(y - 100));
                        a = fpow(((230 - a) / 230.0), 2);
                        c = dtoi((*off) * 0.2 + dtoi(a * 255.0) * 0.8);
                        if (c > 255) c = 255;
                        *off++ = c;
                }

        PhongPal(0.0, 0.7, 0.9, 0.0, 0.3, 0.9, 0.0, 0.4, 0.4, 40,
                texture[2]->paleta, 256);

        // texture 3
        off = texture[3]->datos;
        for (i = 0; i < 256; i++) {
                _memset(off, i, 256);
                off += 256;
                a = i * PI / 128.0;
                texture[3]->paleta[i] = RGB(dtoi(127.0 + 100.0 * fcos(a * 1.7)),
                                         dtoi(83.0 - 78.0 * fsin(a * 2.5)),
                                         dtoi(120 - 120 * fcos(a * 4.3)));
        }

        // texture 4
        off = texture[4]->datos;
        for (i = 0; i < 65536; i++) *off++ = rand() % 0xFF;
        off = texture[4]->datos;
        for (i = 0; i < 5; i++) {
                texture[4]->Blur();
                for (int j = 0; j < 256; j++)
                        off[j] = ((int)off[(65536 + j - 1) & 0xFFFF] +
                                  (int)off[(65536 + j + 1) & 0xFFFF] +
                                  (int)off[(65536 + j - 320) & 0xFFFF] +
                                  (int)off[(65536 + j + 320) & 0xFFFF]) >> 2;
                for (j = 65280; j < 65536; j++)
                        off[j] = ((int)off[(65536 + j - 1) & 0xFFFF] +
                                  (int)off[(65536 + j + 1) & 0xFFFF] +
                                  (int)off[(65536 + j - 320) & 0xFFFF] +
                                  (int)off[(65536 + j + 320) & 0xFFFF]) >> 2;
        }
        off = texture[4]->datos;
        for (i = 0; i < 65536; i++) {
                c = dtoi((*off) * 1.2);
                if (c > 255) c = 255;
                *off++ = c;
        }
        off = texture[4]->datos;
        PhongPal(0.1, 0.7, 0.0, 0, 0.1, 1.0, 0.05, 0.2, 0.6, 10,
                texture[4]->paleta, 256);

        // texture 5
        off = texture[5]->datos;
        for (i = 0; i < 256; i++) {
                _memset(off, i, 256);
                off += 256;
                a = i * PI / 128.0;
                texture[5]->paleta[i] = RGB(dtoi(120.0 + 90.0 * fcos(a * 2.7)) & 0xF0,
                                         dtoi(80.0 - 78.0 * fsin(a * 1.3)) & 0xF0,
                                         dtoi(130 - 110 * fcos(a * 3.6)) & 0xF0);
        }
        off = texture[5]->datos;
        for (y = 0; y < 256; y++)
                for (int x = 0; x < 256; x++)
                        (*off++) += (x ^ y) >> 3;
}
