--      INTRO.PAS
--      does the introduction part of stupikeffyloopy
--
--      written by FAC / Delabu Alama
--
--      be sure to read README.TXT


unit Intro;

interface

{ this is the only procedure here }
procedure DoIntro;

implementation

uses Obj3D, Triangle, Mode13PM;


procedure DoIntro;
var ipal : TPalette;            { the intro palette }
    cuadro : PTObject3D;        { just a square }
    virscr : PTVirtual;         { a virtual screen }
    viroff : dword;             { an offset }
    ypos, i : integer;          { and some variables for loops }

begin
     GetPalette(ipal);          { get the current palette }
     cuadro := new(PTObject3D, Init); { initialize the square }
     Load3DObject('cuadro.vkx', cuadro);
     SetupVirtual(virscr, viroff); { initialize the virtual screen }
     GlobalStyle := TextureMapped; { change the 3d drawing style }
     cuadro^.Rotate(180, 0, 0);

     { bring the logo from top of the screen to the center }
     for ypos := -512 to 400 do
     begin
          ClearScreen(0, viroff);
          cuadro^.SetCenter(160, ypos div 4);
          cuadro^.Draw(viroff);
          cuadro^.NotFlatFastRot(0, 0, 1);
          CopyScreen(viroff, VGA);
     end;

     { zoom in the logo while fading the palette to white }
     for ypos := 0 to 480 do
     begin
          ClearScreen(0, viroff);
          cuadro^.Traslate(0, 0, 2);
          cuadro^.Draw(viroff);
          cuadro^.NotFlatFastRot(0, 0, 1);
          CopyScreen(viroff, VGA);
          SetPalette(ipal);
          if (ypos mod 8) = 7 then
             for i := 0 to 255 do
             begin
                  if ipal[i][0] < 63 then inc(ipal[i][0]);
                  if ipal[i][1] < 63 then inc(ipal[i][1]);
                  if ipal[i][2] < 63 then inc(ipal[i][2]);
             end;
     end;

     ClearScreen(0, VGA);

     { fade the palette from white to black }
     for ypos := 0 to 63 do
     begin
          for i := 0 to 255 do
          begin
               if ipal[i][0] > 0 then dec(ipal[i][0]);
               if ipal[i][1] > 0 then dec(ipal[i][1]);
               if ipal[i][2] > 0 then dec(ipal[i][2]);
          end;
          VRetrace; { make a little delay }
          SetPalette(ipal);
     end;
     ShutDownVirtual(virscr); { goodbye virtual screen! }
     dispose(cuadro, Done);   { goodbye square! }
end;

end.