//	blitter.cpp

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "blitter.h"
#include "globals.h"

VBE_ModeInfoBlock vesamodeinfo;
unsigned *SCREEN;

// color lookup tables
unsigned lut16bit[6][256];
unsigned lut16bitOFS;
unsigned ScreenSize;

//void Blit15(unsigned source);
void Blit16(unsigned source);
//void Blit24(unsigned source);
void Blit32(unsigned source);
void Blit32RGB(unsigned source);


void InitVideo() {
     int bpp;
     char k = 0;
     VBE_SetMode(3, 0, 1);
     printf("\n --> Choose a cool video mode (vesa 2.0 required):\n");
     printf("\n       1.- 320x240x15bpp");
     printf("\n       2.- 320x240x16bpp");
     printf("\n       3.- 320x240x32bpp");
     printf("\n       4.- Exit\n");

     while ((k < '1') || (k > '4')) k = getch();
     switch (k) {
            case '1':   bpp = 15; Blit = Blit16; break;
            case '2':   bpp = 16; Blit = Blit16; break;
            case '3':   bpp = 32; Blit = Blit32; break;
            default:  exit(EXIT_SUCCESS);
     }

     printf("\n\nBlur can be added to every frame to make the demo look nicer,\n");
     printf("however, this also slows down the program so it's recommended only\n");
     printf("if you have a fast processor (Pentium II, AMD K6-2, etc...)\n\n");
     printf("Do you want to add blur to every frame (y/n)?\n");
     k = 0;
     while ((k != 'y') && (k != 'n')) k = getch();
     blurflag = k == 'y';

     int mode = VBE_FindMode(ScreenWidth, ScreenHeight, bpp);
     if (mode == -1) {
        VBE_SetMode(3, 0, 1);
        printf("lfb mode not found. try univbe or something.\n");
        exit(1);
     }
     if (!VBE_IsModeLinear(mode)) {
        VBE_SetMode(3, 0, 1);
        printf("lfb mode not found. try univbe or something.\n");
        exit(1);
     }

     VBE_SetMode(mode, 1, 1);
     SCREEN = (unsigned *)VBE_GetVideoPtr(mode);
     if (!SCREEN) {
        VBE_SetMode(3, 0, 1);
        printf("lfb mode not found. try univbe or something.\n");
        exit(1);
     }

     VBE_Mode_Information(mode, &vesamodeinfo);

     // calculate color lookup tables
     for (unsigned i = 0; i < 256; i++) {
     	lut16bit[0][i] = (i >> (8 - vesamodeinfo.RedMaskSize)) << vesamodeinfo.RedFieldPosition;
     	lut16bit[1][i] = (i >> (8 - vesamodeinfo.GreenMaskSize)) << vesamodeinfo.GreenFieldPosition;
     	lut16bit[2][i] = (i >> (8 - vesamodeinfo.BlueMaskSize)) << vesamodeinfo.BlueFieldPosition;
     	lut16bit[3][i] = lut16bit[0][i] << 16;
     	lut16bit[4][i] = lut16bit[1][i] << 16;
     	lut16bit[5][i] = lut16bit[2][i] << 16;
     }
     
     lut16bitOFS = (unsigned)lut16bit;
     ScreenSize = ScreenWidth * ScreenHeight;
     
     if ((vesamodeinfo.RedFieldPosition == 16) &&
     	(vesamodeinfo.GreenFieldPosition == 8) &&
     	(vesamodeinfo.BlueFieldPosition == 0)) Blit = Blit32RGB;
}


void Blit16(unsigned source) {
	unsigned count = ScreenSize >> 1;
	_asm {
		mov esi, [source]
		mov edi, [SCREEN]
		mov ebx, [lut16bitOFS]
		xor ecx, ecx
		blah:   mov eax, [esi]
				mov cl, al
				mov edx, [ebx + ecx * 4 + 2048]
				mov cl, ah
				or edx, [ebx + ecx * 4 + 1024]
				shr eax, 16
//				mov cl, al
				or edx, [ebx + eax * 4]
//				mov [edi], dx
//				add edi, 2

//				shl edx, 16
				mov eax, [esi + 4]
				mov cl, al
				add esi, 8
				or edx, [ebx + ecx * 4 + 5120]
				mov cl, ah
				or edx, [ebx + ecx * 4 + 4096]
				shr eax, 16
//				mov cl, al
				or edx, [ebx + eax * 4 + 3072]
				mov [edi], edx
				add edi, 4

				dec [count]
				jnz blah
	}
}


void Blit32(unsigned source) {
	unsigned count = ScreenSize;
	_asm {
		mov esi, [source]
		mov edi, [SCREEN]
		mov ebx, [lut16bitOFS]
		xor ecx, ecx
		blah:   mov eax, [esi]
				mov cl, al
				add esi, 4
				mov edx, [ebx + ecx * 4 + 2048]
				mov cl, ah
				or edx, [ebx + ecx * 4 + 1024]
				shr eax, 16
//				mov cl, al
				or edx, [ebx + eax * 4]
				mov [edi], edx
				add edi, 4
				dec [count]
				jnz blah
	}
}


void Blit32RGB(unsigned source) {
	unsigned count = ScreenSize;
	_asm {
		mov esi, [source]
		mov edi, [SCREEN]
		mov ecx, [ScreenSize]
		rep movsd
	}
}
