
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <time.h>
#include "midas.h"
#include "vesavbe.h"
#include "blitter.h"
#include "obj3d.h"
#include "tunnel.h"
#include "globals.h"
#include "memavail.h"

#include "intro.h"
#include "part1.h"
#include "part2.h"
#include "part3.h"
#include "part4.h"
#include "part5.h"
#include "part6.h"
#include "part7.h"
#include "part8.h"
#include "part9.h"
#include "part10.h"
#include "part11.h"
#include "part12.h"
#include "part13.h"
#include "part14.h"
#include "part15.h"
#include "part16.h"
#include "part17.h"
#include "part18.h"


// globals
double Sin256[256];
TBitmap *vscr;
int blurflag, fpsflag, debugflag;
unsigned frames, mem_start, mem_end;


// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


void Initialize() {
        mem_start = memavail();
        VBE_Init();
        InitializeEngine();
	for (int i = 0; i < 256; i++) Sin256[i] = sin(i * 3.14159265 / 128.0);
        vscr = new TBitmap(ScreenWidth, ScreenHeight);
        if (!vscr->datos) {
                printf("Could not create back buffer\n");
                exit(EXIT_FAILURE);
        }
        vscr->Borra(0);
        LoadModule("luchador.xm");
        srand(time(NULL));

        VBE_SetMode(3, 0, 1); printf("\n .initializing\n");
        printf(" .a tribe called quest\n"); TFX_CalcTables();
        printf(" .beastie boys\n"); Part1_Setup();
        printf(" .beck\n");Part2_Setup();
        printf(" .blur\n");Part3_Setup();
        printf(" .cypress hill\n"); Part4_Setup();
        printf(" .das efx\n"); Part6_Setup();
        printf(" .de la soul\n"); Part7_Setup();
        printf(" .ice cube\n"); Part8_Setup();
        printf(" .ice t\n"); //Part9_Setup();
        printf(" .method man\n"); Part10_Setup();
        printf(" .nwa\n"); Part12_Setup();
        printf(" .public enemy\n"); Part15_Setup();
        printf(" .radiohead\n");

        InitVideo();
}


void Finalize() {
        VBE_SetMode(3, 0, 1);
        if (fpsflag) {
                printf("framerate: %5.2f fps\n", frames / GetElapsedTime());
                printf("time: %5.0f seconds\n", GetElapsedTime());
        }
        printf("\n...la arena estaba de bote en bote...\n\n");
        FreeModule();
//        delete vscr;
//        VBE_Done();

/*        mem_end = memavail();
        if (debugflag) {
                printf("Free memory at start: %lu\n", mem_start);
                printf("Free memory at end:   %lu\n", mem_end);
                printf("Unfreed memory: %lu bytes\n", mem_start - mem_end);
        }
*/        exit(EXIT_SUCCESS);
}


void main(int argc, char *argv[]) {
        frames = 0;
        fpsflag = 0;
        blurflag = 1;
        debugflag = 1;
        for (int i = 1; i < argc; i++) {
                if (!strcmp(argv[i], "noblur")) blurflag = 0;
                if (!strcmp(argv[i], "fps")) fpsflag = 1;
                if (!strcmp(argv[i], "nodebug")) debugflag = 0;
        }
        
        Initialize();
        PlayModule();

        luchador_Intro();
//        SetPosition(2);
        luchador_Part1();
//        SetPosition(4);
        luchador_Part2();
//        SetPosition(6);
        luchador_Part3();
//        SetPosition(10);
        luchador_Part4();
//        SetPosition(12);
        luchador_Part5();
//        SetPosition(16);
        luchador_Part6();
//        SetPosition(18);
        luchador_Part7();
//        SetPosition(20);
        luchador_Part8();
//        SetPosition(22);
        luchador_Part9();
//        SetPosition(25);
        luchador_Part10();
//        SetPosition(27);
        luchador_Part11();
//        SetPosition(29);
        luchador_Part12();
//        SetPosition(33);
        luchador_Part13();
//        SetPosition(37);
        luchador_Part14();
//        SetPosition(39);
        luchador_Part15();
//        SetPosition(45);
        luchador_Part16();
//        SetPosition(47);
        luchador_Part17();
//        SetPosition(49);
        luchador_Part18();

//        getch();
        Finalize();
}

