
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "bitmaps.h"
#include "blitter.h"
#include "obj3d.h"
#include "triangle.h"
#include "cameras.h"
#include "primitiv.h"
#include "plasmafx.h"
#include "globals.h"
#include "midas.h"
#include "part12.h"

#include "pmono1.h"
#include "text1.h"
#include "tex10.h"

#define P12_LETRAS_R 255
#define P12_LETRAS_G 255
#define P12_LETRAS_B 255
#define P12_LETRAS_ALPHA 0.7;

#define FX12xsections 29
#define FX12ysections 29
#define FX12depth 0.3

unsigned p12_ColorTable[256][64];
byte p12_table1[256], p12_table2[256];


void FX12(TObject3D *srcobj, TObject3D *obj, TBitmap8bpp *source) {
	byte *src = source->datos;
        int total = (FX12xsections + 1) * (FX12ysections + 1);
	for (int i = 0; i < total; i++) {
		obj->Vertex[i]->SetP(srcobj->Vertex[i]->x, srcobj->Vertex[i]->y, srcobj->Vertex[i]->z);
		*(obj->Vertex[i]) += srcobj->Vertex[i]->normal * 
                        (Sin256[*src++] * FX12depth);
	}
}


void Part12_Setup() {
        double r, dr, g, dg, b, db;
        for (int i = 0; i < 256; i++) {
                r = (PMONO1_PAL[i] >> 16) & 0xFF;
                g = (PMONO1_PAL[i] >> 8) & 0xFF;
                b = PMONO1_PAL[i] & 0xFF;
                dr = (P12_LETRAS_R - r) / 64.0 * P12_LETRAS_ALPHA;
                dg = (P12_LETRAS_G - g) / 64.0 * P12_LETRAS_ALPHA;
                db = (P12_LETRAS_B - b) / 64.0 * P12_LETRAS_ALPHA;
                for (int j = 0; j < 64; j++) {
                        p12_ColorTable[i][j] = RGB(dtoi(r), dtoi(g), dtoi(b));
                        r += dr;
                        g += dg;
                        b += db;
                }
        }

        GeneratePlasmaTable(p12_table1, 0, 0, 0);
        GeneratePlasmaTable(p12_table1, 5, 32, 2);
        GeneratePlasmaTable(p12_table1, 7, 64, 4);
        GeneratePlasmaTable(p12_table1, 2, 16, 8);
        GeneratePlasmaTable(p12_table2, 0, 0, 0);
        GeneratePlasmaTable(p12_table2, 4, 64, 1);
        GeneratePlasmaTable(p12_table2, 6, 32, 2);
        GeneratePlasmaTable(p12_table2, 8, 16, 4);
}


void BlitBanner(TBitmap8bpp *source, TBitmap8bpp *background, TBitmap *dest, int x0) {
        int xa = 0, ya = 0, width = source->ancho, height = source->alto, i;
        if (x0 >= dest->ancho) return;
        if ((x0 + width) > dest->ancho) width = dest->ancho - x0;
        if (height > dest->alto) height = dest->alto;
	if (x0 < 0) { xa = -x0; width += x0; x0 = 0; }
        byte *src = source->datos + xa;
        unsigned *dst = dest->datos + x0;
        byte *back = background->datos + x0;
        unsigned *ctbl = (unsigned *)p12_ColorTable;
        _asm {
                mov edx, [height]
        yloop:  mov esi, [src]
                mov edi, [dst]
                mov ebx, [back]
                mov ecx, [width]
        xloop:  movzx eax, byte ptr [esi]
                inc esi
                or al, al
                jz nope
                mov ah, [ebx]
                and al, 0FCh
                add eax, [ctbl]
                mov eax, [eax]
                mov [edi], eax
        nope:   inc ebx
                add edi, 4
                dec ecx
                jnz xloop
                add [src], 720
                add [dst], 1280
                add [back], 320
                dec edx
                jnz yloop
        }
}


void luchador_Part12() {
        TBitmap8bpp *fondo = new TBitmap8bpp(PMONO1_ANCHO, PMONO1_ALTO, PMONO1, PMONO1_PAL);
        TBitmap8bpp *texto = new TBitmap8bpp(TEXT1_ANCHO, TEXT1_ALTO, TEXT1, TEXT1_PAL);
        TBitmap8bpp *textura = new TBitmap8bpp(TEX10_ANCHO, TEX10_ALTO, TEX10, TEX10_PAL);
        TBitmap8bpp *plasma = new TBitmap8bpp(FX12xsections + 1, FX12ysections + 1);

	TObject3D *srcobj = new TObject3D();
        MakeQuadPatch(srcobj, FX12xsections, FX12ysections);

	TObject3D *obj = new TObject3D();
        MakeQuadPatch(obj, FX12xsections, FX12ysections);
	obj->SetStyle(c_texturemapped);
        obj->SetTexture(textura);

        camera->location.SetP(0, -0.7, -0.4);
        camera->ax = -320;
        camera->ay = 0;
	camera->az = 360;

        double a;
        m_timer = 0;
        while (m_position < 33) {
                fondo->BlitTo(vscr, 0, 0);

                if (m_timer < 2080)
                        BlitBanner(texto, fondo, vscr, 320 - (m_timer >> 1));

                a = m_timer / 500.0;
                GeneratePlasma(plasma, p12_table1, p12_table2, 128 + 127 * sin(a), 
                        128 + 127 * cos(a * 0.3), 255 * cos(a * 1.2) * cos(a * 0.9),
                        128 - 127 * sin(a * 0.7));

                FX12(srcobj, obj, plasma);
		obj->Draw(vscr);
                
                if (blurflag) srcobj->Rotate(0, 0, 4);
                else srcobj->Rotate(0, 0, 3);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        delete fondo;
        delete texto;
        delete textura;
        free(plasma->datos); delete plasma;
        delete srcobj;
        delete obj;
}
