
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include "bitmaps.h"
#include "blitter.h"
#include "globals.h"
#include "obj3d.h"
#include "scenes.h"
#include "cameras.h"
#include "lightsrc.h"
#include "triangle.h"
#include "primitiv.h"
#include "phongpal.h"
#include "plasmafx.h"
#include "midas.h"
#include "part3.h"

#include "p15.h"
#include "banner1.h"
#include "banner2.h"


#define FX3sides 20
#define FX3sections 20
#define FX3radius 1.4
#define FX3depth 0.4

byte p3_table1[256], p3_table2[256];


void FX3(TObject3D *srcobj, TObject3D *obj, TBitmap8bpp *source) {
	byte *src = source->datos;
	int total = srcobj->NumVertex;
	for (int i = 0; i < total; i++) {
		obj->Vertex[i]->SetP(srcobj->Vertex[i]->x, srcobj->Vertex[i]->y, srcobj->Vertex[i]->z);
		*(obj->Vertex[i]) += srcobj->Vertex[i]->normal * 
                        (Sin256[*src++] * FX3depth);
//                obj->Vertex[i]->u = srcobj->Vertex[i]->u;
//                obj->Vertex[i]->v = srcobj->Vertex[i]->v;
	}
	total = srcobj->NumPolygons;
	for (i = 0; i < total; i++) obj->Poly[i]->CalcNormal();
}


void Part3_Setup() {
        GeneratePlasmaTable(p3_table1, 0, 0, 0);
        GeneratePlasmaTable(p3_table1, 1, 64, 2);
        GeneratePlasmaTable(p3_table1, 3, 64, 4);
        GeneratePlasmaTable(p3_table1, 5, 16, 8);
        GeneratePlasmaTable(p3_table2, 0, 0, 0);
        GeneratePlasmaTable(p3_table2, 2, 64, 2);
        GeneratePlasmaTable(p3_table2, 4, 32, 4);
        GeneratePlasmaTable(p3_table2, 6, 16, 8);
}


void luchador_Part3() {
        TBitmap8bpp *fondo = new TBitmap8bpp(P15_ANCHO, P15_ALTO, P15, P15_PAL);
        TBitmap8bpp *plasma = new TBitmap8bpp(FX3sides, FX3sections);
        TBitmap8bpp *banner[2];

        banner[0] = new TBitmap8bpp(BANNER1_ANCHO, BANNER1_ALTO, BANNER1, BANNER1_PAL);
        banner[1] = new TBitmap8bpp(BANNER2_ANCHO, BANNER2_ALTO, BANNER2, BANNER2_PAL);

	unsigned colortable[256];
	PhongPal(0.0, 0.8, 1.0, 0.0, 0.3, 0.8, 0.0, 0.1, 0.5, 100, colortable, 256);

	TObject3D *srcobj = new TObject3D();
        MakeTorus(srcobj, FX3radius, FX3depth * 2, FX3sides, FX3sections, 0);
	srcobj->Rotate(360, 0, 0);
	srcobj->MapEnviroment();

        TObject3D *obj1 = new TObject3D();
        MakeTorus(obj1, FX3radius, FX3depth * 2, FX3sides, FX3sections, 0);
        obj1->SetStyle(c_flatshaded);
        obj1->SetColor(RGB(255, 255, 255), 127, (int *)colortable);

        TObject3D *obj2 = new TObject3D();
        MakeTorus(obj2, FX3radius, FX3depth * 3, FX3sides, FX3sections, 0);
        obj2->SetStyle(c_wireframe);
        obj2->SetColor(RGB(100, 200, 255), 0, NULL);

        TScene *scene = new TScene();
        scene->AddObject(obj1);
        scene->AddObject(obj2);

        camera->location.SetP(-FX3radius * 1.5, -FX3radius * 0.5, -FX3radius * 2.8);
        camera->ax = camera->ay = camera->az = 0;

        double a, b;
        int bx, by, bn;
        m_timer = 0;
        while (m_position < 10) {
                vscr->Borra(RGB(0, 66, 132));

                a = m_timer / 300.0;
                b = m_timer / 200.0;

                fondo->BlitTo(vscr, - 60 - dtoi(60.0 * cos(b * 4.0)), 0);

                GeneratePlasma(plasma, p3_table1, p3_table2, 128 + 127 * sin(a), 
			128 + 127 * cos(a * 0.5), 255 * cos(a) * cos(a),
			128 - 127 * sin(a * 0.5));

                FX3(srcobj, obj1, plasma);

                a += 0.02;

                GeneratePlasma(plasma, p3_table1, p3_table2, 128 + 127 * sin(a), 
			128 + 127 * cos(a * 0.5), 255 * cos(a) * cos(a),
			128 - 127 * sin(a * 0.5));

                FX3(srcobj, obj2, plasma);

                scene->Draw(vscr);
        
                if (((m_row & 15) >= 8) && ((m_row & 15) < 14)) {
                        bn = (m_row >> 4) & 1;
                        banner[bn]->TransBlitTo(vscr, bx + (rand() & 3), by + (rand() & 3), 255);
                }
                else {
                        bx = rand() % 170;
                        by = rand() % 128;
                }

		srcobj->Rotate(6 * sin(b), 6 * cos(b), 8 * sin(b * 2.0));

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
	}

        delete fondo;
        delete plasma;
        for (int i = 0; i < 2; i++) delete banner[i];
        delete scene;
}

