
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include "bitmaps.h"
#include "blitter.h"
#include "globals.h"
#include "obj3d.h"
#include "scenes.h"
#include "cameras.h"
#include "lightsrc.h"
#include "triangle.h"
#include "primitiv.h"
#include "circles.h"
#include "midas.h"
#include "part4.h"

#include "round1.h"
#include "ptecnico.h"
#include "banner6.h"
#include "knot2000.h"

TObject3D *p4_toro;


void Part4_Setup() {
        p4_toro = new TObject3D();
        Read3DObject(KNOT2000, p4_toro);
        p4_toro->Centre();
        p4_toro->FitSphere(10.0);
        p4_toro->SetStyle(c_wireframe);
        p4_toro->SetColor(RGB(255, 255, 255), 0, NULL);
}


void luchador_Part4() {
        TBitmap8bpp *fondo1 = new TBitmap8bpp(ROUND1_ANCHO, ROUND1_ALTO, ROUND1, ROUND1_PAL);
        TBitmap8bpp *fondo2 = new TBitmap8bpp(PTECNICO_ANCHO, PTECNICO_ALTO, PTECNICO, PTECNICO_PAL);
        TBitmap8bpp *banner = new TBitmap8bpp(BANNER6_ANCHO, BANNER6_ALTO, BANNER6, BANNER6_PAL);
        TBitmap *tecnicos = new TBitmap(PTECNICO_ANCHO, PTECNICO_ALTO);
        fondo2->BlitTo(tecnicos, 0, 0);
        TBitmap8bpp *mask = new TBitmap8bpp(20, 15);
        byte *maskoff = mask->datos + mask->tablay[3];
        mask->Borra(0);

        GetMusicStatus();

        camera->location.SetP(0, 0, -6);
        camera->ax = camera->ay = camera->az = 0;

        m_timer = 0;
        while (m_row < 40) {
                vscr->Borra(RGB(255, 255, 255));
                if (m_timer < 100) fondo1->BlitTo(vscr, 300 - m_timer * 3, 0);
                else fondo1->BlitTo(vscr, 0, 0);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        m_timer = 0;
        while (m_position < 11) {
                vscr->Borra(RGB(255, 255, 255));
                if (m_timer < 100) fondo1->BlitTo(vscr, 0, dtoi(m_timer * 2.4));

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        int size;
        double a;
        m_timer = 0;
        while (m_position < 12) {
                vscr->Borra(RGB(0, 165, 222));

                p4_toro->Draw(vscr);

                a = m_timer / 100.0;
                p4_toro->Rotate(8.0 * sin(a), 8.0 * cos(a), 8.0 * sin(a * 2.0));

                size = 128 - 127 * cos(m_timer / 30.0);
                _asm {
                        mov eax, [size]
                        mov edi, [maskoff]
                        mov ah, al
                        mov ecx, 35
                        mov dx, ax
                        shl eax, 16
                        mov ax, dx
                        rep stosd
                }

                DrawCircleFX2(mask, vscr, tecnicos, 12, RGB(0, 165, 222));

                banner->TransBlitTo(vscr, 40, 200, 126);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }


        delete fondo1;
        delete fondo2;
        delete tecnicos;
        delete banner;
        free(mask->datos); delete mask;
//      delete p4_toro; // also used in part 9
}
