
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include "bitmaps.h"
#include "blitter.h"
#include "globals.h"
#include "obj3d.h"
#include "triangle.h"
#include "cameras.h"
#include "primitiv.h"
#include "lightsrc.h"
#include "phongpal.h"
#include "plasmafx.h"
#include "midas.h"
#include "part8.h"

#include "p21.h"
#include "tex4.h"
#include "banner3.h"
#include "banner4.h"
#include "geo980.h"


#define FX8radius 10.0
#define FX8depth 2.0

byte p8_table1[256], p8_table2[256];
TObject3D *p8_srcobj, *p8_obj;

void FX8(TObject3D *srcobj, TObject3D *obj, TBitmap8bpp *source) {
	byte *src = source->datos + source->ancho + 1;
	int total = obj->NumVertex;
	for (int i = 0; i < total; i++) {
		obj->Vertex[i]->SetP(srcobj->Vertex[i]->x, srcobj->Vertex[i]->y, srcobj->Vertex[i]->z);
		*(obj->Vertex[i]) += srcobj->Vertex[i]->normal * 
                        (Sin256[*src++] * FX8depth);
	}
	total = obj->NumPolygons;
	for (i = 0; i < total; i++) obj->Poly[i]->CalcNormal();
}


void Part8_Setup() {
        GeneratePlasmaTable(p8_table1, 0, 0, 0);
        GeneratePlasmaTable(p8_table1, 1, 64, 2);
        GeneratePlasmaTable(p8_table1, 5, 16, 4);
        GeneratePlasmaTable(p8_table2, 0, 0, 0);
        GeneratePlasmaTable(p8_table2, 2, 64, 1);
        GeneratePlasmaTable(p8_table2, 6, 16, 2);
        p8_srcobj = new TObject3D();
        Read3DObject(GEO980, p8_srcobj);
        p8_srcobj->Centre();
        p8_srcobj->FitSphere(FX8radius);

        p8_obj = new TObject3D();
        Read3DObject(GEO980, p8_obj);
        p8_obj->Centre();
        p8_obj->FitSphere(FX8radius);
        p8_obj->SetStyle(c_flatshaded);
}


void luchador_Part8() {
        TBitmap8bpp *fondo = new TBitmap8bpp(P21_ANCHO, P21_ALTO, P21, P21_PAL);
        TBitmap8bpp *texmono = new TBitmap8bpp(TEX4_ANCHO, TEX4_ALTO, TEX4, TEX4_PAL);
        TBitmap8bpp *banner1 = new TBitmap8bpp(BANNER3_ANCHO, BANNER3_ALTO, BANNER3, BANNER3_PAL);
        TBitmap8bpp *banner2 = new TBitmap8bpp(BANNER4_ANCHO, BANNER4_ALTO, BANNER4, BANNER4_PAL);

	TBitmap8bpp *plasma;

        unsigned ColorTable[256];

        PhongPal(0.0, 0.0, 0.0, 0.0, 0.61, 0.0, 0.0, 0.6758, 0.0, 1.0, ColorTable, 256);
        for (int i = 0; i < 256; i++) {
                banner1->paleta[i] = ColorTable[255 - i];
                banner2->paleta[i] = ColorTable[255 - i];
        }

        PhongPal(0.0, 0.8, 1.0, 0.0, 0.0, 0.3, 0.0, 0.0, 0.3, 100, ColorTable, 256);
        p8_obj->SetColor(0, 127, (int *)ColorTable);

        if (p8_srcobj->NumVertex & 1) plasma = new TBitmap8bpp(p8_srcobj->NumVertex + 3, 4);
        else plasma = new TBitmap8bpp(p8_srcobj->NumVertex + 2, 4);
	
        TObject3D *bolita = new TObject3D();
        MakeQuadPatch(bolita, 1, 1);
        bolita->SetStyle(ca_texturemapped);
        bolita->SetTexture(texmono);
        bolita->Centre();
        bolita->FitSphere(FX8radius * 1.8);
        TransparentColor = 255;

        camera->location.SetP(0, 0, -FX8radius * 2.2);
        camera->ax = camera->ay = camera->az = 0;
        SetLightPosition(1, 1, -2);

        double a, b;
        m_timer = 0;
        p8_obj->origin.SetP(-FX8radius * 0.9, -FX8radius * 0.05, 0);
        while (m_position < 22) {
                fondo->BlitTo(vscr, 0, 0);

                a = m_timer / 200.0;
                b = m_timer / 80.0;

                if (m_position == 20)
                        banner1->TransBlitTo(vscr, 174, 80 - dtoi(16.0 * sin(b * 2.0)), 0);
                else banner2->TransBlitTo(vscr, 174, 80 - dtoi(16.0 * sin(b * 2.0)), 0);

                GeneratePlasma(plasma, p8_table1, p8_table2, 128 + 127 * sin(a), 
                        128 + 127 * cos(a * 0.7), 255 * cos(a * 1.2) * cos(a * 0.9),
                        128 - 127 * sin(a * 0.4));

                FX8(p8_srcobj, p8_obj, plasma);
                p8_obj->Draw(vscr);

                p8_srcobj->Rotate(dtoi(6.0 * sin(a * 1.2)), dtoi(6.0 * cos(a * 1.5)), dtoi(6.0 * sin(a * 0.7)));
                Light.Rotate(0, 0, 1);

                bolita->origin.SetP((1.2 - 0.5 * sin(b * 0.8)) * FX8radius,
                                (0.4 * cos(b * 1.1) - 0.2) * FX8radius,
                                0.4 * sin(b * 1.4) * FX8radius);
                bolita->Draw(vscr);
                bolita->Rotate(0, 0, dtoi(24.0 * cos(b)));

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        delete fondo;
        delete texmono;
        delete banner1;
        delete banner2;
        free(plasma->datos); delete plasma;
        delete p8_srcobj;
        delete p8_obj;
        delete bolita;
}

