//	tunnel.cpp

#include <math.h>
#include "tunnel.h"

#define Pi 3.141592654

byte TFX_dtable[ScreenHeight][ScreenWidth];
byte TFX_atable[ScreenHeight][ScreenWidth];
byte TFX_wtable[ScreenHeight][ScreenWidth];
byte TFX_rtable[ScreenHeight][ScreenWidth];
int TFX_count;
int *TFX_centers;


void TFX_CalcTables() {
	float d, a, w, r, t;
	int cx = ScreenWidth / 2;
	int cy = ScreenHeight / 2;
	for (int y = 0; y < ScreenHeight; y++)
		for (int x = 0; x < ScreenWidth; x++) {
			d = sqrt(x * x + y * y);
			if (x != cx) a = atan2(y - cy, x - cx) + Pi; else a = Pi / 2.0;
			if (x != cx) w = atan2(y - cy, x - cx); else w = Pi / 2;
			t = sqrt((x - cx) * (x - cx) + (y - cy) * (y - cy));
			w += t / 190.0;
			r = t + TFX_ripplesize * sin(a * TFX_ripplefreq);
			TFX_dtable[y][x] = (int)(TFX_tilefreq_y * TFX_perspective / d) & 0xFF;
			TFX_atable[y][x] = (int)(TFX_tilefreq_x * a * 256.0 / Pi) & 0xFF;
			TFX_wtable[y][x] = (int)(TFX_tilefreq_y * w * 256.0 / Pi) & 0xFF;
			TFX_rtable[y][x] = (int)(TFX_tilefreq_y * TFX_perspective / r) & 0xFF;
		}
}


void TFX_DrawTunnel(byte a, byte d, TBitmap8bpp *texture, TBitmap *where) {
	int scx = ScreenWidth >> 1;
	int scy = ScreenHeight >> 1;
	unsigned dtable = (unsigned)TFX_dtable;
	unsigned atable = (unsigned)TFX_atable;
	byte *texoff = texture->datos;
	unsigned *texpal = texture->paleta;
	unsigned *dst = where->datos;
	byte px, py;
	int x, y;
			_asm {
				mov [y], ScreenHeight
				dec [y]
				
			yl: mov [x], ScreenWidth
				dec [x] 
				
			xl: mov edi, [TFX_count]
				mov esi, [TFX_centers]
				mov al, [a]
				mov bl, [d]
				mov [px], al
				mov [py], bl
			
			b0: nop
				mov ecx, [esi]
				mov edx, [esi + 4]
				add esi, 8
			
				mov eax, [y]
				mov ebx, [x]
				sub eax, edx
				sub ebx, ecx
				sar eax, 1
				sar ebx, 1
				add eax, [scy]
				add ebx, [scx]
				imul eax, ScreenWidth
				add eax, ebx
				add eax, [atable]
				mov bl, [eax]
				add [px], bl
				
				mov eax, [y]
				mov ebx, [x]
				sub eax, edx
				jns b1
				neg eax
			b1: sub ebx, ecx
				jns b2
				neg ebx
			b2: imul eax, ScreenWidth
				add eax, ebx
				add eax, [dtable]
				mov bl, [eax]
				add [py], bl
				
				dec edi
				jnz b0
				
				xor ebx, ebx
				mov bh, [py]
				mov bl, [px]
				add ebx, [texoff]
				movzx eax, byte ptr [ebx]
				shl eax, 2
				add eax, [texpal]
				mov edi, [dst]
				mov ebx, [eax]
				mov [edi], ebx
				add [dst], 4
				
				dec [x]
				jns xl
				
				dec [y]
                                jns yl
			}
}


void TFX_DrawWobbler(byte a, byte d, TBitmap8bpp *texture, TBitmap *where) {
	int scx = ScreenWidth >> 1;
	int scy = ScreenHeight >> 1;
	unsigned wtable = (unsigned)TFX_wtable;
	unsigned atable = (unsigned)TFX_atable;
	byte *texoff = texture->datos;
	unsigned *texpal = texture->paleta;
	unsigned *dst = where->datos;
	byte px, py;
	int x, y;
			_asm {
				mov [y], ScreenHeight
				dec [y]
				
			yl: mov [x], ScreenWidth
				dec [x] 
				
			xl: mov edi, [TFX_count]
				mov esi, [TFX_centers]
				mov al, [a]
				mov bl, [d]
				mov [px], al
				mov [py], bl
			
			b0: nop
				mov ecx, [esi]
				mov edx, [esi + 4]
				add esi, 8
			
				mov eax, [y]
				mov ebx, [x]
				sub eax, edx
				sub ebx, ecx
				sar eax, 1
				sar ebx, 1
				add eax, [scy]
				add ebx, [scx]
				imul eax, ScreenWidth
				add eax, ebx
				add eax, [atable]
				mov bl, [eax]
				add bl, byte ptr [x]
				add [px], bl
				
				mov eax, [y]
				mov ebx, [x]
				sub eax, edx
				jns b1
				neg eax
			b1: sub ebx, ecx
				jns b2
				neg ebx
			b2: imul eax, ScreenWidth
				add eax, ebx
				add eax, [wtable]
				mov bl, [eax]
				add [py], bl
				
				dec edi
				jnz b0
				
				xor ebx, ebx
				mov bh, [py]
				mov bl, [px]
				add ebx, [texoff]
				movzx eax, byte ptr [ebx]
				shl eax, 2
				add eax, [texpal]
				mov edi, [dst]
				mov ebx, [eax]
				mov [edi], ebx
				add [dst], 4
				
				dec [x]
				jns xl
				
				dec [y]
                                jns yl
			}
}


void TFX_DrawRipples(byte a, byte d, TBitmap8bpp *texture, TBitmap *where) {
	int scx = ScreenWidth >> 1;
	int scy = ScreenHeight >> 1;
	unsigned rtable = (unsigned)TFX_rtable;
	unsigned atable = (unsigned)TFX_atable;
	byte *texoff = texture->datos;
	unsigned *texpal = texture->paleta;
	unsigned *dst = where->datos;
	byte px, py;
	int x, y;
			_asm {
				mov [y], ScreenHeight
				dec [y]
				
			yl: mov [x], ScreenWidth
				dec [x] 
				
			xl: mov edi, [TFX_count]
				mov esi, [TFX_centers]
				mov al, [a]
				mov bl, [d]
				mov [px], al
				mov [py], bl
			
			b0: nop
				mov ecx, [esi]
				mov edx, [esi + 4]
				add esi, 8
			
				mov eax, [y]
				mov ebx, [x]
				sub eax, edx
				sub ebx, ecx
				sar eax, 1
				sar ebx, 1
				add eax, [scy]
				add ebx, [scx]
				imul eax, ScreenWidth
				add eax, ebx
				add eax, [atable]
				mov bl, [eax]
				add [px], bl
				
				mov eax, [y]
				mov ebx, [x]
				sub eax, edx
				jns b1
				neg eax
			b1: sub ebx, ecx
				jns b2
				neg ebx
			b2: imul eax, ScreenWidth
				add eax, ebx
				add eax, [rtable]
				mov bl, [eax]
				add [py], bl
				
				dec edi
				jnz b0
				
				xor ebx, ebx
				mov bh, [py]
				mov bl, [px]
				add ebx, [texoff]
				movzx eax, byte ptr [ebx]
				shl eax, 2
				add eax, [texpal]
				mov edi, [dst]
				mov ebx, [eax]
				mov [edi], ebx
				add [dst], 4
				
				dec [x]
				jns xl
				
				dec [y]
                                jns yl
			}
}
