void WierdPolygon1(TPolygon *p, TBitmap *where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 239) || (ymax < 0)) return;
        if ((xmin > 319) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 240
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 240
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) GouraudScanSide(v0, p->Vertex[i]);
                else GouraudScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 239) ymax = 239;
        unsigned int off = (unsigned)(where->datos + where->tablay[ymin]);
        unsigned int bpsl = where->ancho << 2;
        unsigned int tableoff = (unsigned)p->ctable;
        int deltax, x, dcdx, c;
        for (i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dcdx = (C_MAX[i] - C_MIN[i]) / deltax;
                c = C_MIN[i];
                if (x < 0) { c -= x * dcdx; deltax += x; x = 0; }
                if (X_MAX[i] > 20905984) deltax = 320 - x;
                if (deltax > 0)
                _asm {
                        mov edi, [x]
                        mov ecx, [deltax]
                        shl edi, 2
                        mov eax, [c]
                        add edi, [off]
                        mov ebx, [dcdx]
                        mov esi, [tableoff]
                        ciclo:  movzx edx, ah
                                add eax, ebx
                        		mov edx, [esi + edx * 4]
                        		mov [edi], edx
                                inc edi
                                dec ecx
                                jnz ciclo
                }
                off += bpsl;
        }
}
