//      metabola.cpp

#include <conio.h>
#include <stdlib.h>
#include <math.h>
#include <malloc.h>
#include "mode13.h"
#include "obj3d.h"
#include "triangle.h"
#include "vectors.h"
#include "phongpal.h"
#include "mcubetbl.h"
#include "lightsrc.h"
#include "stuff.h"
#include "metabola.h"

#include "tex2.h"
#include "env2.h"
#include "banner3.h"
#include "banner4.h"
#include "spherei.h"

#define m_GridSizeX 16
#define m_GridSizeY 16
#define m_GridSizeZ 16
#define m_GridSizeXY 256	// m_GridSizeX * m_GridSizeY

#define m_ZSkip 4

#define m_CellSizeX 32
#define m_CellSizeY 32
#define m_CellSizeZ 40

#define m_StartPX 256	// m_CellSizeX * m_GridSizeX / 2
#define m_StartPY 256
#define m_StartPZ 160	// m_CellSizeZ * m_GridSizeZ / 2 - m_ZSkip * CellSize Z

#define m_radius 1.6

#define m_GX 15
#define m_GY 15
#define m_GZ 10		//  m_GridSizeZ - 2 - m_ZSkip

// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))
int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


typedef double m_TBlobArray[m_GridSizeZ][m_GridSizeY][m_GridSizeX];

typedef struct {
	double x, y, z;
	int x2d, y2d;
	double u, v;
	int c;
} m_TVertex;

static m_TVertex m_VertexPos[8];
static int m_PX, m_PY, m_PZ, m_bpos = 0;
double m_blobpos[9 * 256];
m_TBlobArray *m_blob;
unsigned int m_TextureOff;

double  m_paramtable[256 * 6];
double *m_parameter;
char m_paramidx = 0;

//	textured triangle rendering
m_TVertex m_larray[3], m_rarray[3];
int m_lsection, m_rsection, m_lheight, m_rheight;
double m_leftx, m_leftdx, m_rightx, m_rightdx;
double m_leftu, m_leftdu, m_leftv, m_leftdv;
double m_leftc, m_leftdc;

int m_DoRightSide() {
	m_TVertex tv1 = m_rarray[m_rsection];
	m_TVertex tv2 = m_rarray[m_rsection-1];
	int height = tv2.y2d - tv1.y2d;
	if (height == 0) return 0;
	m_rightdx = (tv2.x2d - tv1.x2d) / (double)height;
	m_rightx = tv1.x2d;
	m_rheight = height;
	return height;
}

int m_DoTextureLeftSide() {
	m_TVertex tv1 = m_larray[m_lsection];
	m_TVertex tv2 = m_larray[m_lsection-1];
	int height = tv2.y2d - tv1.y2d;
	if (height == 0) return 0;
	m_leftdx = (tv2.x2d - tv1.x2d) / (double)height;
	m_leftx = tv1.x2d;
	m_leftdu = (tv2.u - tv1.u) / (double)height;
	m_leftu = tv1.u;
	m_leftdv = (tv2.v - tv1.v) / (double)height;
	m_leftv = tv1.v;
	m_lheight = height;
	return height;
}

void m_TextureTriangle(m_TVertex tv1, m_TVertex tv2, m_TVertex tv3, unsigned int where) {
	int x1, x2, width;
	int u, v, du, dv;
	int clipflag;
	
	m_TVertex v1 = tv1;
	m_TVertex v2 = tv2;
	m_TVertex v3 = tv3;
	if (v1.y2d > v2.y2d) { m_TVertex vv = v1; v1 = v2; v2 = vv; }
	if (v1.y2d > v3.y2d) { m_TVertex vv = v1; v1 = v3; v3 = vv; }
	if (v2.y2d > v3.y2d) { m_TVertex vv = v2; v2 = v3; v3 = vv; }
	int height = v3.y2d - v1.y2d;
	if (height == 0) return;
	double temp = (v2.y2d - v1.y2d) / (double)height;
	double longest = temp * (v3.x2d - v1.x2d) + v1.x2d - v2.x2d;
	if (longest == 0.0) return;
	if (longest < 0) {
		m_rarray[0] = v3;
		m_rarray[1] = v2;
		m_rarray[2] = v1;
		m_rsection = 2;
		m_larray[0] = v3;
		m_larray[1] = v1;
		m_lsection = 1;
		if (m_DoTextureLeftSide() <= 0) return;
		if (m_DoRightSide() <= 0) {
			m_rsection--;
			if (m_DoRightSide() <= 0) return;
		}
		if (longest > -1.0) longest = -1.0;
	}
	else
	{
		m_larray[0] = v3;
		m_larray[1] = v2;
		m_larray[2] = v1;
		m_lsection = 2;
		m_rarray[0] = v3;
		m_rarray[1] = v1;
		m_rsection = 1;
		if (m_DoRightSide() <= 0) return;
		if (m_DoTextureLeftSide() <= 0) {
			m_lsection--;
			if (m_DoTextureLeftSide() <= 0) return;
		}
		if (longest < 1.0) longest = 1.0;
	}
	double dudx = (temp * (v3.u - v1.u) + v1.u - v2.u) / longest;
	double dvdx = (temp * (v3.v - v1.v) + v1.v - v2.v) / longest;
	unsigned int clipymax = where + 63680;
	unsigned int off = where + v1.y2d * 320;
	while (1) {
		if ((off >= where) && (off <= clipymax)) {
			x1 = dtoi(m_leftx);
			x2 = dtoi(m_rightx);
			width = x2 - x1;
			clipflag = 0;
			if (x1 < 0) {
				width = x2;
				clipflag = -x1;
				x1 = 0;
			}
			if (x2 > 319) width = 319 - x1;
			if (width > 0) {
				u = dtoi(m_leftu * 65536.0);
				v = dtoi(m_leftv * 65536.0);
				du = dtoi(dudx * 65536.0);
				dv = dtoi(dvdx * 65536.0);
				if (clipflag) {
					u += du * clipflag;
					v += dv * clipflag;
				}
				_asm {
					mov edi, [x1]
					mov esi, [v]
					mov edx, [u]
					add edi, [off]
					mov ecx, [width]
					dec edi
					loop1:
						movzx ebx, si
						add esi, [dv]
						mov bl, dh
						inc edi
						add ebx, [m_TextureOff]
						mov al, [ebx]
						add edx, [du]
						mov [edi], al
						dec ecx
						jnz loop1
				}
			}
		}
		off += 320;
		if (--m_lheight <= 0) {
			if (--m_lsection <= 0) return;
			if (m_DoTextureLeftSide() <= 0) return;
		}
		else {
			m_leftx += m_leftdx;
			m_leftu += m_leftdu;
			m_leftv += m_leftdv;
		}
		if (--m_rheight <= 0) {
			if (--m_rsection <= 0) return;
			if (m_DoRightSide() <= 0) return;
		}
		else m_rightx += m_rightdx;
	}
}

int m_DoGouraudLeftSide() {
	m_TVertex tv1 = m_larray[m_lsection];
	m_TVertex tv2 = m_larray[m_lsection-1];
	int height = tv2.y2d - tv1.y2d;
	if (height == 0) return 0;
	m_leftdx = (tv2.x2d - tv1.x2d) / (double)height;
	m_leftx = tv1.x2d;
	m_leftdc = (double)(tv2.c - tv1.c) / (double)height;
	m_leftc = tv1.c;
	m_lheight = height;
	return height;
}


void m_GouraudTriangle(m_TVertex tv1, m_TVertex tv2, m_TVertex tv3, unsigned int where) {
	int x1, x2, width;
	int c, dc;
	int clipflag;
	
	m_TVertex v1 = tv1;
	m_TVertex v2 = tv2;
	m_TVertex v3 = tv3;
	if (v1.y2d > v2.y2d) { m_TVertex vv = v1; v1 = v2; v2 = vv; }
	if (v1.y2d > v3.y2d) { m_TVertex vv = v1; v1 = v3; v3 = vv; }
	if (v2.y2d > v3.y2d) { m_TVertex vv = v2; v2 = v3; v3 = vv; }
	int height = v3.y2d - v1.y2d;
	if (height == 0) return;
	double temp = (v2.y2d - v1.y2d) / (double)height;
	double longest = temp * (v3.x2d - v1.x2d) + v1.x2d - v2.x2d;
	if (longest == 0.0) return;
	if (longest < 0) {
		m_rarray[0] = v3;
		m_rarray[1] = v2;
		m_rarray[2] = v1;
		m_rsection = 2;
		m_larray[0] = v3;
		m_larray[1] = v1;
		m_lsection = 1;
		if (m_DoGouraudLeftSide() <= 0) return;
		if (m_DoRightSide() <= 0) {
			m_rsection--;
			if (m_DoRightSide() <= 0) return;
		}
		if (longest > -1.0) longest = -1.0;
	}
	else
	{
		m_larray[0] = v3;
		m_larray[1] = v2;
		m_larray[2] = v1;
		m_lsection = 2;
		m_rarray[0] = v3;
		m_rarray[1] = v1;
		m_rsection = 1;
		if (m_DoRightSide() <= 0) return;
		if (m_DoGouraudLeftSide() <= 0) {
			m_lsection--;
			if (m_DoGouraudLeftSide() <= 0) return;
		}
		if (longest < 1.0) longest = 1.0;
	}
	double dcdx = (temp * (v3.c - v1.c) + v1.c - v2.c) / longest;
	unsigned int clipymax = where + 63680;
	unsigned int off = where + v1.y2d * 320;
	while (1) {
		if ((off >= where) && (off <= clipymax)) {
			x1 = dtoi(m_leftx);
			x2 = dtoi(m_rightx);
			width = x2 - x1;
			clipflag = 0;
			if (x1 < 0) {
				width = x2;
				clipflag = -x1;
				x1 = 0;
			}
			if (x2 > 319) width = 319 - x1;
			if (width > 0) {
				c = dtoi(m_leftc * 256.0);
				dc = dtoi(dcdx * 256.0);
				if (clipflag) c += dc * clipflag;
				_asm {
					mov edx, 0FFh
					mov edi, [x1]
					mov ebx, [dc]
					mov eax, [c]
					add edi, [off]
					mov ecx, [width]
					loop1:  add byte ptr [edi], ah
							jnc cont
							mov [edi], dl
					cont:   add eax, ebx
							inc edi
							dec ecx
							jnz loop1
				}
			}
		}
		off += 320;
		if (--m_lheight <= 0) {
			if (--m_lsection <= 0) return;
			if (m_DoGouraudLeftSide() <= 0) return;
		}
		else {
			m_leftx += m_leftdx;
			m_leftu += m_leftdu;
			m_leftv += m_leftdv;
		}
		if (--m_rheight <= 0) {
			if (--m_rsection <= 0) return;
			if (m_DoRightSide() <= 0) return;
		}
		else m_rightx += m_rightdx;
	}
}



void SetupVertexPos() {
	m_VertexPos[0].x = 0;
	m_VertexPos[0].y = 0;
	m_VertexPos[0].z = 0;
	
	m_VertexPos[1].x = m_CellSizeX;
	m_VertexPos[1].y = 0;
	m_VertexPos[1].z = 0;
	            
	m_VertexPos[2].x = m_CellSizeX;
	m_VertexPos[2].y = 0;
	m_VertexPos[2].z = m_CellSizeZ;
	
	m_VertexPos[3].x = 0;
	m_VertexPos[3].y = 0;
	m_VertexPos[3].z = m_CellSizeZ;
	
	m_VertexPos[4].x = 0;
	m_VertexPos[4].y = m_CellSizeY;
	m_VertexPos[4].z = 0;
	
	m_VertexPos[5].x = m_CellSizeX;
	m_VertexPos[5].y = m_CellSizeY;
	m_VertexPos[5].z = 0;
	
	m_VertexPos[6].x = m_CellSizeX;
	m_VertexPos[6].y = m_CellSizeY;
	m_VertexPos[6].z = m_CellSizeZ;
	
	m_VertexPos[7].x = 0;
	m_VertexPos[7].y = m_CellSizeY;
	m_VertexPos[7].z = m_CellSizeZ;
}


m_TVertex Interpola( m_TVertex p1, m_TVertex p2, int z1, int y1, int x1,
					int z2, int y2, int x2) {
	double *val1 = &((*m_blob)[z1][y1][x1]);
	double *val2 = &((*m_blob)[z2][y2][x2]);
	m_TVertex p;
	double mu = (1.0 - (*val1)) / ((*val2) - (*val1));
	p.x = m_PX + p1.x + mu * (p2.x - p1.x);
	p.y = m_PY + p1.y + mu * (p2.y - p1.y);
	p.z = m_PZ + p1.z + mu * (p2.z - p1.z);
	double perspective = 512.0 / (1024.0 - p.z);
	p.x2d = dtoi(p.x * perspective) + 160.0;
	p.y2d = dtoi(-p.y * perspective) + 100.0;
	double nx1 = *(val1 + 1) - (*val1);
	double ny1 = *(val1 + m_GridSizeX) - (*val1);
	double nz1 = *(val1 + m_GridSizeXY) - (*val1);
	double nx2 = *(val2 + 1) - (*val2);
	double ny2 = *(val2 + m_GridSizeX) - (*val2);
	double nz2 = *(val2 + m_GridSizeXY) - (*val2);
	double normx = nx1 + mu * (nx2 - nx1);
	double normy = ny1 + mu * (ny2 - ny1);
	double normz = nz1 + mu * (nz2 - nz1);
	double maginv = 0.5 / sqrt(normx * normx + normy * normy + normz * normz);
	p.u = (normx * maginv + 0.5);
	p.v = (normy * maginv + 0.5);
	p.c = dtoi(((normx * Light.x + normy * Light.y + normz * Light.z) 
			   * maginv + 1.0) * 96.0);
	return(p);
}


int Polygonize(int type, int x, int y, int z, unsigned int where) {
	int ntriang, cubeindex, i;
	m_TVertex vertlist[12];
	m_TVertex Vertex1, Vertex2, Vertex3;
	
	cubeindex = 0;
    if ((*m_blob)[z][y][x] < 1.0) cubeindex |= 1;
    if ((*m_blob)[z][y][x+1] < 1.0) cubeindex |= 2;
    if ((*m_blob)[z+1][y][x+1] < 1.0) cubeindex |= 4;
    if ((*m_blob)[z+1][y][x] < 1.0) cubeindex |= 8;
    if ((*m_blob)[z][y+1][x] < 1.0) cubeindex |= 16;
    if ((*m_blob)[z][y+1][x+1] < 1.0) cubeindex |= 32;
    if ((*m_blob)[z+1][y+1][x+1] < 1.0) cubeindex |= 64;
    if ((*m_blob)[z+1][y+1][x] < 1.0) cubeindex |= 128;

	if (!EdgeTable[cubeindex]) return 0;
	
	if (EdgeTable[cubeindex] & 1) vertlist[0] = 
		Interpola(m_VertexPos[0], m_VertexPos[1], z, y, x, z, y, x+1);
	
	if (EdgeTable[cubeindex] & 2) vertlist[1] = 
		Interpola(m_VertexPos[1], m_VertexPos[2], z, y, x+1, z+1, y, x+1);
	
	if (EdgeTable[cubeindex] & 4) vertlist[2] = 
		Interpola(m_VertexPos[2], m_VertexPos[3], z+1, y, x+1, z+1, y, x);
	
	if (EdgeTable[cubeindex] & 8) vertlist[3] = 
		Interpola(m_VertexPos[3], m_VertexPos[0], z+1, y, x, z, y, x);
	
	if (EdgeTable[cubeindex] & 16) vertlist[4] = 
		Interpola(m_VertexPos[4], m_VertexPos[5], z, y+1, x, z, y+1, x+1);
	
	if (EdgeTable[cubeindex] & 32) vertlist[5] = 
		Interpola(m_VertexPos[5], m_VertexPos[6], z, y+1, x+1, z+1, y+1, x+1);
	
	if (EdgeTable[cubeindex] & 64) vertlist[6] = 
		Interpola(m_VertexPos[6], m_VertexPos[7], z+1, y+1, x+1, z+1, y+1, x);
	
	if (EdgeTable[cubeindex] & 128) vertlist[7] = 
		Interpola(m_VertexPos[7], m_VertexPos[4], z+1, y+1, x, z, y+1, x);
	
	if (EdgeTable[cubeindex] & 256) vertlist[8] = 
		Interpola(m_VertexPos[0], m_VertexPos[4], z, y, x, z, y+1, x);
	
	if (EdgeTable[cubeindex] & 512) vertlist[9] = 
		Interpola(m_VertexPos[1], m_VertexPos[5], z, y, x+1, z, y+1, x+1);
	
	if (EdgeTable[cubeindex] & 1024) vertlist[10] = 
		Interpola(m_VertexPos[2], m_VertexPos[6], z+1, y, x+1, z+1, y+1, x+1);
	
	if (EdgeTable[cubeindex] & 2048) vertlist[11] = 
		Interpola(m_VertexPos[3], m_VertexPos[7], z+1, y, x, z+1, y+1, x);


	ntriang = 0;
	for (i = 0; TriTable[cubeindex][i] != -1; i += 3) {
		Vertex1 = vertlist[TriTable[cubeindex][i]];
		Vertex2 = vertlist[TriTable[cubeindex][i+1]];
		Vertex3 = vertlist[TriTable[cubeindex][i+2]];
		if (((Vertex2.x2d - Vertex1.x2d) * (Vertex3.y2d - Vertex1.y2d)) <=
			((Vertex2.y2d - Vertex1.y2d) * (Vertex3.x2d - Vertex1.x2d))) {
//			m_TextureTriangle(Vertex1, Vertex2, Vertex3, where);
			if (type) m_GouraudTriangle(Vertex1, Vertex2, Vertex3, where);
			else m_TextureTriangle(Vertex1, Vertex2, Vertex3, where);
			ntriang++;
		}
	}
	return ntriang;
}


void CalcBlobs() {
	int x, y, z;
	double *bp = m_blobpos + m_bpos;
	double x0 = *bp++, y0 = *bp++, z0 = *bp++;
	double x1 = *bp++, y1 = *bp++, z1 = *bp++;
	double x2 = *bp++, y2 = *bp++, z2 = *bp++;
	double *b = (double *)m_blob;
	int ZLimit = m_GridSizeZ - m_ZSkip + 1;  // SOLO SI m_ZSkip > 0  !!!!!
	for (z = 0; z < ZLimit; z++)
		for (y = 0; y < m_GridSizeY; y++)
			for (x = 0; x < m_GridSizeX; x++) 
				*b++ = m_radius / sqrt((x-x0)*(x-x0)+(y-y0)*(y-y0)+(z-z0)*(z-z0)) +
					   m_radius / sqrt((x-x1)*(x-x1)+(y-y1)*(y-y1)+(z-z1)*(z-z1)) +
					   m_radius / sqrt((x-x2)*(x-x2)+(y-y2)*(y-y2)+(z-z2)*(z-z2));
}


void CalcPaths() {
	int n = 0;
	double ang;
	for (int i = 0; i < 256; i++) {
		ang = i * 3.14159265 / 128.0;
		m_blobpos[n++] = -sin(ang * 2) * 2.8 + 5.7;
		m_blobpos[n++] = -sin(ang) * 5.1 + 7.1;
		m_blobpos[n++] = cos(ang * 2) * 4.3 + 8.5;
		m_blobpos[n++] = -cos(ang) * 4.0 + 8.5;
		m_blobpos[n++] = -sin(ang * 2) * 4.3 + 7.8;
		m_blobpos[n++] = sin(ang * 2) * 3.4 + 8.5;
		m_blobpos[n++] = cos(ang) * 2.6 + 10.0;
		m_blobpos[n++] = sin(ang*2) * 4.0 + 5.7;
		m_blobpos[n++] = cos(ang) * 2.8 + 7.8;
	}
}


void METABOLA_Setup() {
	m_TextureOff = (unsigned int)ENV2;
	SetupVertexPos();
	CalcPaths();
	for (int i = 0; i < 64; i++) {
		m_paramtable[i * 6 + 0] = 192;
		m_paramtable[i * 6 + 1] = 192 - i * 3;
		m_paramtable[i * 6 + 2] = i * 3;
		m_paramtable[i * 6 + 3] = 192;
		m_paramtable[i * 6 + 4] = 192 - i * 3;
		m_paramtable[i * 6 + 5] = 0;
	}
	for (i = 0; i < 64; i++) {
		m_paramtable[(64 + i) * 6 + 0] = 192 - i * 3;
		m_paramtable[(64 + i) * 6 + 1] = i * 3;
		m_paramtable[(64 + i) * 6 + 2] = 192;
		m_paramtable[(64 + i) * 6 + 3] = 192 - i * 3;
		m_paramtable[(64 + i) * 6 + 4] = 0;
		m_paramtable[(64 + i) * 6 + 5] = 0;
	}
	for (i = 0; i < 64; i++) {
		m_paramtable[(128 + i) * 6 + 0] = i * 3;
		m_paramtable[(128 + i) * 6 + 1] = 192;
		m_paramtable[(128 + i) * 6 + 2] = 192 - i * 3;
		m_paramtable[(128 + i) * 6 + 3] = i * 3;
		m_paramtable[(128 + i) * 6 + 4] = 0;
		m_paramtable[(128 + i) * 6 + 5] = i * 3;
	}
	for (i = 0; i < 64; i++) {
		m_paramtable[(192 + i) * 6 + 0] = 192;
		m_paramtable[(192 + i) * 6 + 1] = 192;
		m_paramtable[(192 + i) * 6 + 2] = 0;
		m_paramtable[(192 + i) * 6 + 3] = 192;
		m_paramtable[(192 + i) * 6 + 4] = i * 3;
		m_paramtable[(192 + i) * 6 + 5] = 192 - i * 3;
	}
}



void METABOLA_Run() {
	PTVirtual vscr;
	unsigned int voff;
	TObject3D *sphere = new TObject3D();
	int xx, yy, zz;
	TPalette pal;
	
	m_blob = (m_TBlobArray *)malloc(sizeof(m_TBlobArray));

	Read3DObject(SPHEREI_VKX, sphere);
	sphere->Scale(3.6, 3.6, 3.6);
	sphere->SetCenter(160, 100);
	sphere->MapEnviroment();
	TextureOffset = (unsigned int)TEX2;
	GlobalStyle = c_texturemapped;
	
	SetupVirtual(&vscr, &voff);
	SetLightPosition(0, 0, 1);

        m_parameter = m_paramtable;
        m_paramidx = 0;
        double ambient = 256.0;

        GetMusicInfo();
        while (position < 15) {
		ClearScreen(0, voff);
		sphere->Draw(voff);
        	if ((m_paramidx++) == 0) m_parameter = m_paramtable;
        	Fast256PhongPal( ambient, *(m_parameter++), *(m_parameter++),
                                 ambient, *(m_parameter++), *(m_parameter++),
                                 ambient, *(m_parameter++), *(m_parameter++), pal);

		CalcBlobs();
		
		m_PZ = m_StartPZ;
		for (zz = m_GZ; zz >= 0; zz--) {
			m_PY = -m_StartPY;
			for (yy = 0; yy < m_GY; yy++) {
				m_PX = -m_StartPX;
				for (xx = 0; xx < m_GX; xx++) {
					Polygonize(1, xx, yy, zz, voff);
					m_PX += m_CellSizeX;
				}
				m_PY += m_CellSizeY;
			}
			m_PZ -= m_CellSizeZ;
		}
		Blur(voff);
                if (row >= 32)
                        DrawBanner((unsigned int)BANNER4, 240, 136, 0, 0, voff);
		VRetrace();
		SetPalette(pal);
		CopyScreen(voff, VGA);
		if (m_bpos < 2286) m_bpos += 18; else m_bpos = 0;  // inc = 9
		sphere->Rotate(-1, 1, -1);
                if (ambient > 0.0) ambient -= 8.0;
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
	}

        ambient = 192.0;
        while (position < 16) {
                if (rowflag && (row >= 48) && ((row & 1) == 0)) ambient = row * 4.0;
		ClearScreen(0, voff);
		sphere->Draw(voff);
        	if ((m_paramidx++) == 0) m_parameter = m_paramtable;
        	Fast256PhongPal( ambient, *(m_parameter++), *(m_parameter++),
                                 ambient, *(m_parameter++), *(m_parameter++),
                                 ambient, *(m_parameter++), *(m_parameter++), pal);

		CalcBlobs();
		
		m_PZ = m_StartPZ;
		for (zz = m_GZ; zz >= 0; zz--) {
			m_PY = -m_StartPY;
			for (yy = 0; yy < m_GY; yy++) {
				m_PX = -m_StartPX;
				for (xx = 0; xx < m_GX; xx++) {
                                        Polygonize(0, xx, yy, zz, voff);
					m_PX += m_CellSizeX;
				}
				m_PY += m_CellSizeY;
			}
			m_PZ -= m_CellSizeZ;
		}
		Blur(voff);
                if (row < 48)
                        DrawBanner((unsigned int)BANNER4, 240, 136, 0, 0, voff);
                if (row < 56)
                        DrawBanner((unsigned int)BANNER3, 116, 100, 203, 99, voff);
		VRetrace();
		SetPalette(pal);
		CopyScreen(voff, VGA);
		if (m_bpos < 2286) m_bpos += 18; else m_bpos = 0;  // inc = 9
                sphere->Rotate(1, 0, 2);
                if (ambient > 0.0) ambient -= 8.0;
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
	}

	ShutDownVirtual(&vscr);
	free(m_blob);
}

