; MODE13.ASM

.386P
.MODEL FLAT

_TEXT SEGMENT DWORD PUBLIC 'CODE'
		ASSUME  cs:_TEXT, ds:_DATA


; DECLARATIONS

; mode change procs
public SetMode13_
public SetTextMode_

; drawing procs
public ClearScreen_
public PutPixel_
public GetPixel_
public HLine_

; palette procs
public SetPal_

; virtual screen procs
public CopyScreen_

; other procs
public VRetrace_
public Blur_

; IMPLEMENTATION

; mode change procs

SetMode13_       PROC    NEAR
mov eax, 0013h
int 10h
ret
SetMode13_       ENDP

SetTextMode_     PROC    NEAR
mov eax, 0003h
int 10h
ret
SetTextMode_     ENDP

; drawing procs

ClearScreen_     PROC    NEAR
mov ah, al
mov edx, eax
shl eax, 16
mov ecx, 16000
mov ax, dx
rep stosd
ret
ClearScreen_     ENDP


PutPixel_        PROC    NEAR
mov ecx, eax
shl eax, 8
shl ecx, 6
add eax, ecx
add eax, ebx
mov BYTE PTR [edi + eax], dl
ret
PutPixel_        ENDP


GetPixel_        PROC    NEAR
mov ecx, eax
shl eax, 8
shl ecx, 6
add ebx, eax
add ebx, ecx
xor eax, eax
mov al, BYTE PTR [edi + ebx]
ret
GetPixel_        ENDP


HLine_   PROC    NEAR
lea edi, [edi + edi * 4]
shl edi, 6
sub ecx, ebx
add edi, ebx
mov ah, al
inc ecx
add edi, esi
shr ecx, 1
jnc hlstart
stosb
hlstart: rep stosw
ret
HLine_   ENDP


; palette procs
SetPal_  PROC    NEAR
mov edx, 03C8h
out dx, al
inc edx
mov eax, ebx
out dx, al
mov eax, ecx
out dx, al
mov eax, edi
out dx, al
ret
SetPal_  ENDP


; virtual screen procs
CopyScreen_      PROC    NEAR
mov ecx, 16000
rep movsd
ret
CopyScreen_      ENDP


; other procs

VRetrace_        PROC    NEAR
mov edx, 03DAh
vloop1:	in al, dx
		   test al, 08h
		   jnz vloop1
vloop2:	in al, dx
		   test al, 08h
		   jz vloop2
ret
VRetrace_        ENDP


Blur_            PROC    NEAR
add edi, 320
xor ebx, ebx
mov ecx, 63360
bloop:  movzx eax, byte ptr [edi-1]
        mov bl, [edi+1]
        add eax, ebx
        mov bl, [edi-320]
        add eax, ebx
        mov bl, [edi+320]
        add eax, ebx
        shr eax, 2
        mov [edi], al
        inc edi
        dec ecx
        jnz bloop
        ret
Blur_           ENDP


_TEXT ENDS
	END
