//	obj3d.cpp

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include "triangle.h"
#include "vectors.h"
#include "lightsrc.h"
#include "obj3d.h"

#define _TrianglesOnly_

#define INV65536 0.00001525878906

// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif

// TPolygon implementation
TPolygon::TPolygon() {
	Vertex = (TVertex **)malloc(MaxPolyVertex * sizeof(TVertex *));
	NumVertex = 0;
}

TPolygon::~TPolygon() {
	free(Vertex);
	NumVertex = 0;
}

void TPolygon::AddVertex(TVertex *v) {
	if (NumVertex < MaxPolyVertex) Vertex[NumVertex++] = v;
}

void TPolygon::Draw(unsigned int where) {
	unsigned int c;
	if ((GlobalStyle == c_flatshaded) || (GlobalStyle == nc_flatshaded)) {
		c = StartCol;
		StartCol += dtoi((DotProduct(normal, Light) + 1) * WidthCol);
	}
	DrawTriangle(Vertex[0], Vertex[1], Vertex[2], where);
	if ((GlobalStyle == c_flatshaded) || (GlobalStyle == nc_flatshaded)) StartCol = c;
}





void TPolygon::CalcNormal() {
	TVector a = (*Vertex[0]) - (*Vertex[1]);
	TVector b = (*Vertex[2]) - (*Vertex[1]);
	normal = b * a;
	normal.Normalize();
}

int TPolygon::Visible() {
	return ((Vertex[1]->x2d - Vertex[0]->x2d) *
			(Vertex[2]->y2d - Vertex[0]->y2d)) <=
		   ((Vertex[1]->y2d - Vertex[0]->y2d) *
			(Vertex[2]->x2d - Vertex[0]->x2d));
}                                                                           


void TPolygon::CalcZOrder() {
	double z = 2147483648.0;
	for (int v = 0; v < NumVertex; v++) z += Vertex[v]->z;
	zorder = dtoi(z);
}


// TObject3D implementation

TObject3D::TObject3D() {
	Vertex = (TVertex **)malloc(MaxObjectVertex * sizeof(TVertex *));
	Poly = (TPolygon **)malloc(MaxObjectPoly * sizeof(TPolygon *));
	XCenter = YCenter = NumVertex = NumPolygons = 0;
	Style = nc_wireframe;
	for (int v = 0; v < MaxObjectVertex; v++) Vertex[v] = NULL;
	for (int p = 0; p < MaxObjectPoly; p++) Poly[p] = NULL;
}


TObject3D::~TObject3D() {
	for (int v = 0; v < NumVertex; v++) if (Vertex[v]) delete Vertex[v];
	for (int p = 0; p < NumPolygons; p++) if (Poly[p]) delete Poly[p];
	free(Vertex);
	free(Poly);
	NumVertex = 0;
	NumPolygons = 0;
}


void TObject3D::AddVertex(double nx, double ny, double nz) {
	if (NumVertex < MaxObjectVertex) 
		Vertex[NumVertex++] = new TVertex(nx, ny, nz);
}

void TObject3D::AddVertexUV(double nx, double ny, double nz, double nu, double nv) {
	if (NumVertex < MaxObjectVertex) {
		Vertex[NumVertex] = new TVertex(nx, ny, nz);
		Vertex[NumVertex]->u = nu;
		Vertex[NumVertex++]->v = nv;
	}
}

void TObject3D::AddPolygon(TPolygon *poly) {
	if ((poly) && (NumPolygons < MaxObjectPoly)) Poly[NumPolygons++] = poly;
}

void TObject3D::CalcNormals() {
	int v, p;
	for (p = 0; p < NumPolygons; p++) Poly[p]->CalcNormal();
	for (v = 0; v < NumVertex; v++) {
		Vertex[v]->normal.SetP(0, 0, 0);
		for (p = 0; p < NumPolygons; p++) 
			for (int n = 0; n < Poly[p]->NumVertex; n++)
				if (Vertex[v] == Poly[p]->Vertex[n])
					Vertex[v]->normal += Poly[p]->normal;
		Vertex[v]->normal.Normalize();
	}
}

void TObject3D::MapEnviroment() {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->CalcEnvUV();
}

void TObject3D::Traslate(double nx, double ny, double nz) {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->Traslate(nx, ny, nz);
}

void TObject3D::Rotate(int ax, int ay, int az) {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->VRotate(ax, ay, az);
	for (int p = 0; p < NumPolygons; p++) Poly[p]->normal.Rotate(ax, ay, az);
}

void TObject3D::FlatFastRotate(int ax, int ay, int az) {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->Rotate(ax, ay, az);
	for (int p = 0; p < NumPolygons; p++) Poly[p]->normal.Rotate(ax, ay, az);
}

void TObject3D::NotFlatFastRotate(int ax, int ay, int az) {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->Rotate(ax, ay, az);
}

void TObject3D::Scale(double sx, double sy, double sz) {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->Scale(sx, sy, sz);
}




     void radix (int byte, long N, TPolygon **source, TPolygon **dest)
     {
       long count[256];
       long index[256];
       memset (count, 0, sizeof (count));
       for ( int i=0; i<N; i++ ) count[((source[i]->zorder)>>(byte<<3))&0xff]++;

       index[0]=0;
       for ( i=1; i<256; i++ ) index[i]=index[i-1]+count[i-1];
       for ( i=0; i<N; i++ ) dest[index[((source[i]->zorder)>>(byte<<3))&0xff]++] = source[i];
     }

     void radixsort (TPolygon **source, TPolygon **temp, long N)
     {
       radix (0, N, source, temp);
       radix (1, N, temp, source);
       radix (2, N, source, temp);
       radix (3, N, temp, source);
     }


void TObject3D::Draw(unsigned int where) {
	TPolygon **visiblepoly;
	TPolygon **temp;
	int n = 0;
	visiblepoly = (TPolygon **)malloc(sizeof(TPolygon *) * NumPolygons);
	for (int v = 0; v < NumVertex; v++) Vertex[v]->Calc2D(XCenter, YCenter);
	if ((GlobalStyle == nc_gouraudshaded) || (GlobalStyle == c_gouraudshaded))
		for (v = 0; v < NumVertex; v++)
			Vertex[v]->c = dtoi((DotProduct(Vertex[v]->normal, Light) + 1) * WidthCol) + StartCol;
	for (int p = 0; p < NumPolygons; p++) 
		if (Poly[p]->Visible()) {
			Poly[p]->CalcZOrder();
			visiblepoly[n++] = Poly[p];
		}
	temp = (TPolygon **)malloc(sizeof(TPolygon *) * n);
	radixsort(visiblepoly, temp, n);
	for (p = 0; p < n; p++) visiblepoly[p]->Draw(where);
	free(visiblepoly);
	free(temp);
}


void TObject3D::DrawCylinder(unsigned int where) {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->Calc2D(XCenter, YCenter);
	for (int p = 0; p < NumPolygons; p++) 
		if ((Poly[p]->normal.x != 0.0) || (Poly[p]->normal.y != 0.0))
			Poly[p]->Draw(where);
}



void TObject3D::DrawParticles(unsigned int where) {
	for (int v = 0; v < NumVertex; v++) {
		Vertex[v]->Calc2D(XCenter, YCenter);
		Vertex[v]->c = StartCol - dtoi((DotProduct(Vertex[v]->normal, Light) + 1) * WidthCol);
	}
	for (int p = 0; p < NumPolygons; p++) Poly[p]->Draw(where);
}



int fgetint(FILE *file) {
	int b1 = (int)fgetc(file);
	int b2 = ((int)fgetc(file)) << 8;
	int b3 = ((int)fgetc(file)) << 16;
	int b4 = ((int)fgetc(file)) << 24;
	return b1 | b2 | b3 | b4;
}

void Load3DObject(char *filename, TObject3D *obj) {
	FILE *file;
	int i, j, nv, np, x, y, z, u, v;
	TPolygon *p;
	
	if ((file = fopen(filename, "rb")) == NULL) return;
	if ((fgetint(file) & 0xFFFF0000) != 0x1FAC0000) {
		fclose(file);
		return;
	}
	for (i = 0; i < obj->NumVertex; i++) 
		if (obj->Vertex[i]) { delete obj->Vertex[i]; obj->Vertex[i] = NULL; }
	for (i = 0; i < obj->NumPolygons; i++) 
		if (obj->Poly[i]) { delete obj->Poly[i]; obj->Poly[i] = NULL; }
	nv = fgetint(file);
	np = fgetint(file);
	for (i = 0; i < 5; i++) fgetint(file);
	for (i = 0; i < nv; i++) {
		x = fgetint(file);
		y = fgetint(file);
		z = fgetint(file);
		u = fgetint(file);
		v = fgetint(file);
		obj->AddVertexUV(x / 65536.0, y / 65536.0, z / 65536.0, u / 65536.0, v / 65536.0);
	}
	for (i = 0; i < np; i++) {
		p = new TPolygon();
		u = fgetint(file);
		for (j = 0; j < u; j++) {
			v = fgetint(file);
			if (obj->Vertex[v]) p->AddVertex(obj->Vertex[v]);
		}
		obj->AddPolygon(p);
	}
	fclose(file);
	obj->CalcNormals();
}

void e(int p, int v, int i) {
	_asm {
		mov eax, 3
		int 10h
	}
	printf("triangle: %d,    object vertex: %d,        triangle vertex: %i\n", p, v, i);
	exit(EXIT_FAILURE);
}


void Read3DObject(int *vkx, TObject3D *obj) {
	int i, nv, np, x, y, z, u, v;
//        int idx = 0;
        int *data = vkx;
	TPolygon *p;        
	
	for (i = 0; i < obj->NumVertex; i++) 
		if (obj->Vertex[i]) { delete obj->Vertex[i]; obj->Vertex[i] = NULL; }
	for (i = 0; i < obj->NumPolygons; i++) 
		if (obj->Poly[i]) { delete obj->Poly[i]; obj->Poly[i] = NULL; }
	obj->NumVertex = 0;
	obj->NumPolygons = 0;
//        nv = vkx[idx++];
//        np = vkx[idx++];
        nv = *data++;
        np = *data++;
	for (i = 0; i < nv; i++) {
//                x = vkx[idx++];
//                y = vkx[idx++];
//                z = vkx[idx++];
//                u = vkx[idx++];
//                v = vkx[idx++];
                x = *data++;
                y = *data++;
                z = *data++;
                u = *data++;
                v = *data++;
                obj->AddVertexUV(x * INV65536, y * INV65536, z * INV65536,
                                 u * INV65536, v * INV65536);
	}
	for (i = 0; i < np; i++) {
		p = new TPolygon();
//                v = vkx[idx++];
                v = *data++;
		if (obj->Vertex[v]) p->AddVertex(obj->Vertex[v]); else e(i, v, 0);
//                v = vkx[idx++];
                v = *data++;
		if (obj->Vertex[v]) p->AddVertex(obj->Vertex[v]); else e(i, v, 1);
//                v = vkx[idx++];
                v = *data++;
		if (obj->Vertex[v]) p->AddVertex(obj->Vertex[v]); else e(i, v, 2);
		obj->AddPolygon(p);
	}
	obj->CalcNormals();
}
