#include <stdio.h>

#define R( c )	( ( ((unsigned short)c>>3) & 0x1F) << 11 )
#define G( c )	( ( ((unsigned short)c>>3) & 0x1F) <<  6 )
#define B( c )	( ( ((unsigned short)c>>3) & 0x1F)       )
#define packRGB(r,g,b) (unsigned short)( R(r) | G(g) | B(b) )

typedef struct RGB {
    unsigned char r;
    unsigned char g;
    unsigned char b;
    unsigned char i;
} RGB;

int	insertpalette();
int	ncols=0;

main(argc,argv,envp)
int	argc;
char	*argv[];
char	*envp;
{
    FILE *image,*outc;
    RGB *rgb;
    int x,y,xres,yres,num,dopalette,index;
    char line[256],name[256],*dot,*infile,*outfile,pal[256*3];
    unsigned	short outshort;

    if ( argc < 3 ) {
        fprintf(stderr,"%s: [-p] input.pbm out.c\n",argv[0]);
        fprintf(stderr,"-p : make a CI palette image\n",argv[0]);
        exit(1);
    }

	if ( strcmp(argv[1],"-p") == 0 ) {
		dopalette = 1;
		infile = argv[2];
		outfile = argv[3];
	}
	else {
		dopalette = 0;
		infile = argv[1];
		outfile = argv[2];
	}

    if( (image=fopen(infile,"r")) == NULL ) {
        fprintf(stderr,"can't open input file %s\n",infile);
        exit(1);
    }

    if( (outc=fopen(outfile,"w")) == NULL ) {
        fprintf(stderr,"can't open input file %s\n",outfile);
        exit(1);
    }

    fscanf(image,"P%d\n",&num);

    fgets(line,80,image);
	while (line[0] == '#')
    	fgets(line,80,image);

    sscanf(line,"%d %d\n",&xres,&yres);
    fscanf(image,"%d",&num);
	/* read CR */
	num = fgetc(image);

    rgb = (RGB *)malloc( xres*yres*sizeof(RGB) );

    for (y=0; y<yres; y++) {
        for (x=0; x<xres; x++) {
			index = y * xres +x;
            rgb[index].r = (unsigned char)fgetc(image);
            rgb[index].g = (unsigned char)fgetc(image);
            rgb[index].b = (unsigned char)fgetc(image);
			if ( dopalette )
				rgb[index].i = insertpalette( rgb[index].r, 
					rgb[index].g, rgb[index].b, pal );
        }
    }
    fprintf(stderr,"Map res %d %d\n",xres,yres);

	dot = (char *)basename(argv[2]);
    strcpy(name,dot);
    dot = (char *)strchr(name,'.');
    *dot = '\0';

    fprintf(outc,"#include <ultra64.h>\n");

	if ( !dopalette ) {
    	fprintf(outc,"static u64 _pad_%s;\n",name);
    	fprintf(outc,"unsigned short %s[]={\n",name);

    	for (y=0; y<yres; y++) {
        	for (x=0; x<xres; x++) {
				index = y*xres+x;
	  			outshort = (unsigned short)packRGB( rgb[index].r,
				rgb[index].g,rgb[index].b) | 1;

          		fprintf(outc,"0x%04hx,",outshort);
        	}
        	fprintf(outc,"\n");
    	}
    	fprintf(outc,"};\n");
	}
	else {
    	fprintf(outc,"static u64 _pad_pal_%s;\n",name);
    	fprintf(outc,"unsigned short %s_pal[]={\n",name);
       	for (x=0; x<256; x++) {
  			outshort = (unsigned short)packRGB( 
					pal[x*3], pal[x*3+1], pal[x*3+2]) | 1;
     		fprintf(outc,"0x%04hx,\n",outshort);
		}
    	fprintf(outc,"};\n");

    	fprintf(outc,"static u64 _pad_%s;\n",name);
    	fprintf(outc,"unsigned char %s[]={\n",name);

    	for (y=0; y<yres; y++) {
        	for (x=0; x<xres; x++) {
          		fprintf(outc,"0x%02hx,",rgb[y*xres+x].i);
			}
    		fprintf(outc,"\n");
		}
    	fprintf(outc,"};\n");
	}

    close(image);
    close(outc);

    exit(0);
}

int	insertpalette( r,g,b, pal)
unsigned char	r,g,b,*pal;
{
    int	i,n;

    for (i=0;i<ncols;i++)	/* skip black */
    {
			n = i*3;
			if (( r == pal[n]   )
			&&  ( g == pal[n+1] )
			&&  ( b == pal[n+2] ))
				return( i );
    }
    /* ok make an entry and fill it in - update used */
    n = (ncols)*3;
    pal[n]   = r;
    pal[n+1] = g;
    pal[n+2] = b;
    ncols++;
    if ( ncols > 255 ) 	/* oops */
    {
		fprintf(stdout,"Palette overflow > 256 colors Dump:\n");
		for (i=0;i<256;i++)
		{
			n = i*3;
			fprintf(stdout,"%d %d %d\n",pal[n],pal[n+1],pal[n+2]);
		}
		exit(1);
    }

    return( ((ncols)-1) );
}
