#ifndef LINUX
#include "ultra64.h"
#else
#include <stdio.h>
#endif

#include "stdio.h"
#include "math.h"
#include "gfxlib.h"

extern FB	fb;

void	mkmat_rotx(m, a)
Mtx	*m;
register	float	a;
{
	Mtx_i	*Mi;	/* Matrix int portion */
	Mtx_f	*Mf;	/* Matrix frac portion */
	register	float	sa,ca;
	register	s32		t_sa,t_nsa,t_ca;
	register	s16		sai,cai,nsai,ncai;
	register	u16		saf,caf,nsaf;

	/* pointer abuse */
	Mi = (Mtx_i *)&(m->m[0][0]);
	Mf = (Mtx_f *)&(m->m[2][0]);

	sa = sinf((float)a);
	ca = cosf((float)a);

	t_sa = (sa * 65536.0);
	sai = ( t_sa >> 16 ) & 0xFFFF;
	saf = t_sa & 0xFFFF;

	t_nsa = (-sa * 65536.0);
	nsai = ( t_nsa >> 16 ) & 0xFFFF;
	nsaf = t_nsa & 0xFFFF;

	t_ca = (ca * 65536.0);
	cai = ( t_ca >> 16 ) & 0xFFFF;
	caf = t_ca & 0xFFFF;

	Mi->x0 = 1;  Mi->y0 =    0;  Mi->z0 =    0;  Mi->w0 = 0;
	Mi->x1 = 0;  Mi->y1 =  cai;  Mi->z1 =  sai;  Mi->w1 = 0;
	Mi->x2 = 0;  Mi->y2 = nsai;  Mi->z2 =  cai;  Mi->w2 = 0;
	Mi->xt = 0;  Mi->yt =    0;  Mi->zt =    0;  Mi->w  = 1;

	Mf->x0 = 0;  Mf->y0 =    0;  Mf->z0 =    0;  Mf->w0 = 0;
	Mf->x1 = 0;  Mf->y1 =  caf;  Mf->z1 =  saf;  Mf->w1 = 0;
	Mf->x2 = 0;  Mf->y2 = nsaf;  Mf->z2 =  caf;  Mf->w2 = 0;
	Mf->xt = 0;  Mf->yt =    0;  Mf->zt =    0;  Mf->w  = 0;
}

void	mkmat_roty(m, a)
Mtx	*m;
register	float	a;
{
	Mtx_i	*Mi;	/* Matrix int portion */
	Mtx_f	*Mf;	/* Matrix frac portion */
	register	float	sa,ca;
	register	s32		t_sa,t_nsa,t_ca;
	register	s16		sai,cai,nsai,ncai;
	register	u16		saf,caf,nsaf;

	/* pointer abuse */
	Mi = (Mtx_i *)&(m->m[0][0]);
	Mf = (Mtx_f *)&(m->m[2][0]);

	sa = sinf((float)a);
	ca = cosf((float)a);

	t_sa = (sa * 65536.0);
	sai = ( t_sa >> 16 ) & 0xFFFF;
	saf = t_sa & 0xFFFF;

	t_nsa = (-sa * 65536.0);
	nsai = ( t_nsa >> 16 ) & 0xFFFF;
	nsaf = t_nsa & 0xFFFF;

	t_ca = (ca * 65536.0);
	cai = ( t_ca >> 16 ) & 0xFFFF;
	caf = t_ca & 0xFFFF;

	Mi->x0 =  cai;  Mi->y0 =    0;  Mi->z0 = nsai;  Mi->w0 = 0;
	Mi->x1 =    0;  Mi->y1 =    1;  Mi->z1 =    0;  Mi->w1 = 0;
	Mi->x2 =  sai;  Mi->y2 =    0;  Mi->z2 =  cai;  Mi->w2 = 0;
	Mi->xt =    0;  Mi->yt =    0;  Mi->zt =    0;  Mi->w  = 1;

	Mf->x0 =  caf;  Mf->y0 =    0;  Mf->z0 = nsaf;  Mf->w0 = 0;
	Mf->x1 =    0;  Mf->y1 =    0;  Mf->z1 =    0;  Mf->w1 = 0;
	Mf->x2 =  saf;  Mf->y2 =    0;  Mf->z2 =  caf;  Mf->w2 = 0;
	Mf->xt =    0;  Mf->yt =    0;  Mf->zt =    0;  Mf->w  = 0;
}

void	mkmat_rotz(m, a)
Mtx	*m;
register	float	a;
{
	Mtx_i	*Mi;	/* Matrix int portion */
	Mtx_f	*Mf;	/* Matrix frac portion */
	register	float	sa,ca;
	register	s32		t_sa,t_nsa,t_ca;
	register	s16		sai,cai,nsai,ncai;
	register	u16		saf,caf,nsaf;

	/* pointer abuse */
	Mi = (Mtx_i *)&(m->m[0][0]);
	Mf = (Mtx_f *)&(m->m[2][0]);

	sa = sinf((float)a);
	ca = cosf((float)a);

	t_sa = (sa * 65536.0);
	sai = ( t_sa >> 16 ) & 0xFFFF;
	saf = t_sa & 0xFFFF;

	t_nsa = (-sa * 65536.0);
	nsai = ( t_nsa >> 16 ) & 0xFFFF;
	nsaf = t_nsa & 0xFFFF;

	t_ca = (ca * 65536.0);
	cai = ( t_ca >> 16 ) & 0xFFFF;
	caf = t_ca & 0xFFFF;

	Mi->x0 =  cai;  Mi->y0 =  sai;  Mi->z0 =    0;  Mi->w0 = 0;
	Mi->x1 = nsai;  Mi->y1 =  cai;  Mi->z1 =    0;  Mi->w1 = 0;
	Mi->x2 =    0;  Mi->y2 =    0;  Mi->z2 =    1;  Mi->w2 = 0;
	Mi->xt =    0;  Mi->yt =    0;  Mi->zt =    0;  Mi->w  = 1;

	Mf->x0 =  caf;  Mf->y0 =  saf;  Mf->z0 =    0;  Mf->w0 = 0;
	Mf->x1 = nsaf;  Mf->y1 =  caf;  Mf->z1 =    0;  Mf->w1 = 0;
	Mf->x2 =    0;  Mf->y2 =    0;  Mf->z2 =    0;  Mf->w2 = 0;
	Mf->xt =    0;  Mf->yt =    0;  Mf->zt =    0;  Mf->w  = 0;
}

void	mkmat_trans(m,x,y,z)
Mtx	*m;
register	float	x,y,z;
{
	Mtx_i	*Mi;	/* Matrix int portion */
	Mtx_f	*Mf;	/* Matrix frac portion */
	register	s32		t_x,t_y,t_z;
	register	s16		xi,yi,zi;
	register	u16		xf,yf,zf;

	Mi = (Mtx_i *)&(m->m[0][0]);
	Mf = (Mtx_f *)&(m->m[2][0]);

	t_x = (x * 65536.0);
	xi = ( t_x >> 16 ) & 0xFFFF;
	xf = t_x & 0xFFFF;

	t_y = (y * 65536.0);
	yi = ( t_y >> 16 ) & 0xFFFF;
	yf = t_y & 0xFFFF;

	t_z = (z * 65536.0);
	zi = ( t_z >> 16 ) & 0xFFFF;
	zf = t_z & 0xFFFF;

	Mi->x0 =    1;  Mi->y0 =    0;  Mi->z0 =    0;  Mi->w0 = 0;
	Mi->x1 =    0;  Mi->y1 =    1;  Mi->z1 =    0;  Mi->w1 = 0;
	Mi->x2 =    0;  Mi->y2 =    0;  Mi->z2 =    1;  Mi->w2 = 0;
	Mi->xt =   xi;  Mi->yt =   yi;  Mi->zt =   zi;  Mi->w  = 1;

	Mf->x0 =    0;  Mf->y0 =    0;  Mf->z0 =    0;  Mf->w0 = 0;
	Mf->x1 =    0;  Mf->y1 =    0;  Mf->z1 =    0;  Mf->w1 = 0;
	Mf->x2 =    0;  Mf->y2 =    0;  Mf->z2 =    0;  Mf->w2 = 0;
	Mf->xt =   xf;  Mf->yt =   yf;  Mf->zt =   zf;  Mf->w  = 0;
}

void	mkmat_scale(m,x,y,z)
Mtx	*m;
register	float	x,y,z;
{
	Mtx_i	*Mi;	/* Matrix int portion */
	Mtx_f	*Mf;	/* Matrix frac portion */
	register	s32		t_x,t_y,t_z;
	register	s16		xi,yi,zi;
	register	u16		xf,yf,zf;

	Mi = (Mtx_i *)&(m->m[0][0]);
	Mf = (Mtx_f *)&(m->m[2][0]);

	t_x = (x * 65536.0);
	xi = ( t_x >> 16 ) & 0xFFFF;
	xf = t_x & 0xFFFF;

	t_y = (y * 65536.0);
	yi = ( t_y >> 16 ) & 0xFFFF;
	yf = t_y & 0xFFFF;

	t_z = (z * 65536.0);
	zi = ( t_z >> 16 ) & 0xFFFF;
	zf = t_z & 0xFFFF;

	Mi->x0 =   xi;  Mi->y0 =    0;  Mi->z0 =    0;  Mi->w0 = 0;
	Mi->x1 =    0;  Mi->y1 =   yi;  Mi->z1 =    0;  Mi->w1 = 0;
	Mi->x2 =    0;  Mi->y2 =    0;  Mi->z2 =   zi;  Mi->w2 = 0;
	Mi->xt =    0;  Mi->yt =    0;  Mi->zt =    0;  Mi->w  = 1;

	Mf->x0 =   xf;  Mf->y0 =    0;  Mf->z0 =    0;  Mf->w0 = 0;
	Mf->x1 =    0;  Mf->y1 =   yf;  Mf->z1 =    0;  Mf->w1 = 0;
	Mf->x2 =    0;  Mf->y2 =    0;  Mf->z2 =   zf;  Mf->w2 = 0;
	Mf->xt =    0;  Mf->yt =    0;  Mf->zt =    0;  Mf->w  = 0;
}

void	mkmat_srt( dst, sx,sy,sz, rx,ry,rz, tx,ty,tz )
Mtx		*dst;
float	sx,sy,sz;
float	rx,ry,rz;
float	tx,ty,tz;
{
	register	float	c, s;
	register	float	t;
	register	u32		i,ti;
	float	m[4][4];
	Mtx_i	*Mi;
	Mtx_f	*Mf;

	          m[0][1] = m[0][2] =           0.0;
	m[1][0] =           m[1][2] =           0.0;
	m[2][0] = m[2][1] =                     0.0;

	/* scale */
	m[0][0] = sx; m[1][1] = sy; m[2][2] = sz; m[3][3] = 1.0;

	/* rot x */
	c = cosf((float)DTOR(rx)); s = sinf((float)DTOR(rx));

   	t = m[0][1];
   	m[0][1] = t*c - m[0][2]*s;
   	m[0][2] = t*s + m[0][2]*c;

   	t = m[1][1];
   	m[1][1] = t*c - m[1][2]*s;
   	m[1][2] = t*s + m[1][2]*c;

   	t = m[2][1];
   	m[2][1] = t*c - m[2][2]*s;
   	m[2][2] = t*s + m[2][2]*c;

	/* rot x */
	c = cosf((float)DTOR(ry));	s = sinf((float)DTOR(ry));

   	t = m[0][0];
   	m[0][0] = t*c + m[0][2]*s;
   	m[0][2] = m[0][2]*c - t*s;

   	t = m[1][0];
   	m[1][0] = t*c + m[1][2]*s;
   	m[1][2] = m[1][2]*c - t*s;

   	t = m[2][0];
   	m[2][0] = t*c + m[2][2]*s;
   	m[2][2] = m[2][2]*c - t*s;

	/* rotz */
	c = cosf((float)DTOR(rz));	s = sinf((float)DTOR(rz));

   	t = m[0][0];
   	m[0][0] = t*c - m[0][1]*s;
   	m[0][1] = t*s + m[0][1]*c;

   	t = m[1][0];
   	m[1][0] = t*c - m[1][1]*s;
   	m[1][1] = t*s + m[1][1]*c;

   	t = m[2][0];
   	m[2][0] = t*c - m[2][1]*s;
   	m[2][1] = t*s + m[2][1]*c;

	m[3][0] = tx; m[3][1] = ty; m[3][2] = tz;

	mtx_F_to_i(m, dst);
}

void	mkmat_rot( dst, rx,ry,rz )
Mtx		*dst;
float	rx,ry,rz;
{
	register	float	c, s;
	register	float	t;
	register	u32		i,ti;
	float	m[4][4];
	Mtx_i	*Mi;
	Mtx_f	*Mf;

	          m[0][1] = m[0][2] =           0.0;
	m[1][0] =           m[1][2] =           0.0;
	m[2][0] = m[2][1] =                     0.0;

	/* ident */
	m[0][0] = 1.0; m[1][1] = 1.0; m[2][2] = 1.0; m[3][3] = 1.0;

	/* rot x */
	c = cosf((float)DTOR(rx)); s = sinf((float)DTOR(rx));

   	t = m[0][1];
   	m[0][1] = t*c - m[0][2]*s;
   	m[0][2] = t*s + m[0][2]*c;

   	t = m[1][1];
   	m[1][1] = t*c - m[1][2]*s;
   	m[1][2] = t*s + m[1][2]*c;

   	t = m[2][1];
   	m[2][1] = t*c - m[2][2]*s;
   	m[2][2] = t*s + m[2][2]*c;

	/* rot x */
	c = cosf((float)DTOR(ry));	s = sinf((float)DTOR(ry));

   	t = m[0][0];
   	m[0][0] = t*c + m[0][2]*s;
   	m[0][2] = m[0][2]*c - t*s;

   	t = m[1][0];
   	m[1][0] = t*c + m[1][2]*s;
   	m[1][2] = m[1][2]*c - t*s;

   	t = m[2][0];
   	m[2][0] = t*c + m[2][2]*s;
   	m[2][2] = m[2][2]*c - t*s;

	/* rotz */
	c = cosf((float)DTOR(rz));	s = sinf((float)DTOR(rz));

   	t = m[0][0];
   	m[0][0] = t*c - m[0][1]*s;
   	m[0][1] = t*s + m[0][1]*c;

   	t = m[1][0];
   	m[1][0] = t*c - m[1][1]*s;
   	m[1][1] = t*s + m[1][1]*c;

   	t = m[2][0];
   	m[2][0] = t*c - m[2][1]*s;
   	m[2][1] = t*s + m[2][1]*c;

	mtx_F_to_i(m, dst);
}

void	mkmat_srtF( m, sx,sy,sz, rx,ry,rz, tx,ty,tz )
float	m[4][4];
float	sx,sy,sz;
float	rx,ry,rz;
float	tx,ty,tz;
{
	register	float	c, s;
	register	float	t;
	register	u32		i,ti;
	Mtx_i	*Mi;
	Mtx_f	*Mf;

	          m[0][1] = m[0][2] =           0.0;
	m[1][0] =           m[1][2] =           0.0;
	m[2][0] = m[2][1] =                     0.0;

	/* scale */
	m[0][0] = sx; m[1][1] = sy; m[2][2] = sz; m[3][3] = 1.0;

	/* rot x */
	c = cosf((float)DTOR(rx)); s = sinf((float)DTOR(rx));

   	t = m[0][1];
   	m[0][1] = t*c - m[0][2]*s;
   	m[0][2] = t*s + m[0][2]*c;

   	t = m[1][1];
   	m[1][1] = t*c - m[1][2]*s;
   	m[1][2] = t*s + m[1][2]*c;

   	t = m[2][1];
   	m[2][1] = t*c - m[2][2]*s;
   	m[2][2] = t*s + m[2][2]*c;

	/* rot x */
	c = cosf((float)DTOR(ry));	s = sinf((float)DTOR(ry));

   	t = m[0][0];
   	m[0][0] = t*c + m[0][2]*s;
   	m[0][2] = m[0][2]*c - t*s;

   	t = m[1][0];
   	m[1][0] = t*c + m[1][2]*s;
   	m[1][2] = m[1][2]*c - t*s;

   	t = m[2][0];
   	m[2][0] = t*c + m[2][2]*s;
   	m[2][2] = m[2][2]*c - t*s;

	/* rotz */
	c = cosf((float)DTOR(rz));	s = sinf((float)DTOR(rz));

   	t = m[0][0];
   	m[0][0] = t*c - m[0][1]*s;
   	m[0][1] = t*s + m[0][1]*c;

   	t = m[1][0];
   	m[1][0] = t*c - m[1][1]*s;
   	m[1][1] = t*s + m[1][1]*c;

   	t = m[2][0];
   	m[2][0] = t*c - m[2][1]*s;
   	m[2][1] = t*s + m[2][1]*c;

	m[3][0] = tx; m[3][1] = ty; m[3][2] = tz;
}

void	mtx_F_to_i(src, dst)
float	src[4][4];
Mtx		*dst;
{
	Mtx_i	*Mi;
	Mtx_f	*Mf;
	register	u32		ti;

	Mi = (Mtx_i *)&(dst->m[0][0]);
	Mf = (Mtx_f *)&(dst->m[2][0]);

	ti = (src[0][0] * 65536.0);
	Mi->x0 = ( ti >> 16 ) & 0xFFFF;
	Mf->x0 = ti & 0xFFFF;

	ti = (src[1][0] * 65536.0);
	Mi->x1 = ( ti >> 16 ) & 0xFFFF;
	Mf->x1 = ti & 0xFFFF;

	ti = (src[2][0] * 65536.0);
	Mi->x2 = ( ti >> 16 ) & 0xFFFF;
	Mf->x2 = ti & 0xFFFF;

	ti = (src[3][0] * 65536.0);
	Mi->xt = ( ti >> 16 ) & 0xFFFF;
	Mf->xt = ti & 0xFFFF;

	ti = (src[0][1] * 65536.0);
	Mi->y0 = ( ti >> 16 ) & 0xFFFF;
	Mf->y0 = ti & 0xFFFF;

	ti = (src[1][1] * 65536.0);
	Mi->y1 = ( ti >> 16 ) & 0xFFFF;
	Mf->y1 = ti & 0xFFFF;

	ti = (src[2][1] * 65536.0);
	Mi->y2 = ( ti >> 16 ) & 0xFFFF;
	Mf->y2 = ti & 0xFFFF;

	ti = (src[3][1] * 65536.0);
	Mi->yt = ( ti >> 16 ) & 0xFFFF;
	Mf->yt = ti & 0xFFFF;

	ti = (src[0][2] * 65536.0);
	Mi->z0 = ( ti >> 16 ) & 0xFFFF;
	Mf->z0 = ti & 0xFFFF;

	ti = (src[1][2] * 65536.0);
	Mi->z1 = ( ti >> 16 ) & 0xFFFF;
	Mf->z1 = ti & 0xFFFF;

	ti = (src[2][2] * 65536.0);
	Mi->z2 = ( ti >> 16 ) & 0xFFFF;
	Mf->z2 = ti & 0xFFFF;

	ti = (src[3][2] * 65536.0);
	Mi->zt = ( ti >> 16 ) & 0xFFFF;
	Mf->zt = ti & 0xFFFF;

	Mi->w0 = Mi->w1 = Mi->w2 = 0; Mi->w = 1;
	Mf->w0 = Mf->w1 = Mf->w2 = 0; Mf->w = 0;
}
