#define	STATIC_SEGMENT		1
#define	OBJECT_SEGMENT          3
#define	CFB_SEGMENT		2

#define	SCREEN_WD	320
#define	SCREEN_HT	240

/* this stack size is in bytes, and is a lot larger
 * than this program needs.
 */
#define	STACKSIZE	0x1000

#define	GLIST_LEN	2048

/*
 * Layout of dynamic data.
 *
 * This structure holds the things which change per frame. It is advantageous
 * to keep dynamic data together so that we may selectively write back dirty
 * data cache lines to DRAM prior to processing by the RCP.
 *
 */
typedef struct {
	Mtx	projection;
	Mtx	viewing;
	Gfx	glist[GLIST_LEN];
} Dynamic ;

extern Dynamic dynamic;

/* these are the static display lists */

extern Gfx rspinit_dl[];
extern Gfx rdpinit_dl[];
extern Gfx clearcfb_dl[];
extern Gfx setupcfb_dl[];
extern Gfx clearZbfr_dl[];

extern Gfx cam_proj[];
extern Gfx cam_viewing[];

extern Gfx lits_dl[];
extern Gfx M_breakup_dl[];

/* RSP task data that is modified by the RSP and read the the CPU */

extern u64 dram_stack[];	/* used for matrix stack */
extern u64 rdp_output_len;	/* RSP writes back size of RDP data */
extern u64 rdp_output[];	/* RSP writes back RDP data */

/* CPU addresses for the color frame buffer */

extern u16	cfb[][SCREEN_WD*SCREEN_HT];

/* RSP address for the color frame buffer */

extern u16	rsp_cfb[];
extern u16  zbuffer[];
