//MIT licensed
//Copyright (C) 2014 Jaume Sanchez Elias
//https://github.com/spite/Wagner/blob/master/fragment-shaders/chromatic-aberration-fs.glsl

uniform sampler2D tInput;
//uniform vec2 resolution;
const float zoom=1.0f;
const vec2 resolution=vec2(1920.0f/zoom,1080.0f/zoom);

vec2 barrelDistortion(vec2 coord, float amt) {

    vec2 coord2=coord/1.1f;

	vec2 cc = coord2 - 0.5;
	float dist = dot(cc, cc);

	vec2 res=coord2 + cc * dist * amt;
	//res.x=clamp(res.x,0.0f,1.0f-1.0f/1920.0f);
	//res.y=clamp(res.y,0.0f,1.0f-1.0f/1080.0f);
	return res;

	//return coord;
}

float sat( float t )
{
	return clamp( t, 0.0, 1.0 );
}

float linterp( float t ) {
	return sat( 1.0 - abs( 2.0*t - 1.0 ) );
}

float remap( float t, float a, float b ) {
	return sat( (t - a) / (b - a) );
}

vec4 spectrum_offset( float t ) {
	vec4 ret;
	float lo = step(t,0.5);
	float hi = 1.0-lo;
	float w = linterp( remap( t, 1.0/6.0, 5.0/6.0 ) );
	ret = vec4(lo,1.0,hi, 1.) * vec4(1.0-w, w, 1.0-w, 1.);

	return pow( ret, vec4(1.0/2.2) );
}

const float max_distort = 0.33;//2.2
const int num_iter = 12;
const float reci_num_iter_f = 1.0 / float(num_iter);

void main()
{
    //resolution.x=resolutionx; resolution.y=resolutiony;

	//vec2 uv=(gl_FragCoord.xy/resolution.xy*.5)+.25;
	//vec2 uv=(gl_FragCoord.xy/resolution.xy);//-.25/64.0;//.25/8.0
	vec2 uv=(gl_FragCoord.xy/resolution.xy)+.25/12.5*2.0f;//.25/8.0

	vec4 sumcol = vec4(0.0);
	vec4 sumw = vec4(0.0);
	for ( int i=0; i<num_iter;++i )
	{
		float t = float(i) * reci_num_iter_f;
		vec4 w = spectrum_offset( t );
		sumw += w;
		sumcol += w * texture2D( tInput, barrelDistortion(uv, .6 * max_distort*t ) );
	}

	gl_FragColor = sumcol / sumw;
}
