#version 120
// It was expressed that some drivers required this next line to function properly
precision highp float;
#define MAX_LIGHTS 8
uniform vec4 glColor;

in vec3 alightVec[MAX_LIGHTS];
in vec3 aeyeVec[MAX_LIGHTS];
in vec2 texCoord;

in float ShadowAngle;
in vec4 ShadowCoord;

in float fogFactor;

uniform float bias;

uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];
uniform sampler2D colorMap;
uniform sampler2D normalMap;
//uniform sampler2D lightMap;

//uniform sampler2D specularMap;
uniform sampler2D shadowMap;
uniform sampler2D glenzMap;
//uniform float invRadius;
//out vec4 gl_FragColor;

void main (void)
{

vec3 lightVec;
vec3 eyeVec;
vec4 accvDiffuse = vec4(0.0);
vec4 accvSpecular = vec4(0.0);
float distSqr;
vec3 lVec;
vec3 vVec;
float att;
vec4 base;
vec4 vAmbient;
vec3 bump;
float diffuse;
vec4 vDiffuse;
vec4 vSpecular;
float specular;
vec3 nrmltexture;

	base = texture2D(colorMap, texCoord);
	vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
for (int i=0; i<4; i++)
   {
	if (lightsEnabled[i]>0.0)
	{
        lightVec=alightVec[i];
        eyeVec=aeyeVec[i];
	distSqr = dot(lightVec, lightVec);
	att = clamp(1.0 - lightsinvRadius[i] * sqrt(distSqr), 0.0, 1.0);
	lVec = lightVec * inversesqrt(distSqr);
	vVec = normalize(eyeVec);

    //nrmltexture= texture2D(normalMap, texCoord).xyz;
    //nrmltexture.z=nrmltexture.z*-1.0f;
	//bump = normalize(nrmltexture * 2.0f - 1.0);
	bump = normalize( texture2D(normalMap, texCoord).xyz * 2.0f - 1.0);
	//bump = vec3(0.0,0.0,1.0);

	//diffuse = max( dot(lVec, bump), 0.0 );
	diffuse = clamp( dot(lVec, bump), 0.0, 1.0 );
//	vDiffuse = gl_LightSource[i].diffuse * gl_FrontMaterial.diffuse * diffuse *
	vDiffuse = gl_LightSource[i].diffuse * diffuse * diffuse;
		//texture2D(lightMap, vec2(diffuse-0.01,lightMapSelect[i]));
	accvDiffuse = accvDiffuse + vDiffuse;

	//specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0),
	           //gl_FrontMaterial.shininess );

	//specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), gl_FrontMaterial.shininess ) * texture2D(specularMap, texCoord).r;
	specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), 32.0 ) * 1.0f;//texture2D(specularMap, texCoord).r; //here shiness is replaced with 1.0, should introduce material functionality in obj loader //16.0

	//vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;
//	vSpecular = gl_LightSource[i].specular * gl_FrontMaterial.specular * specular *
	vSpecular = gl_LightSource[i].specular * specular * specular;//texture2D(lightMap, vec2(specular-0.01,lightMapSelect[i]));
	accvSpecular = accvSpecular + vSpecular;
	}
   }
	//gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular) * att;
	//gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular);

//float bias = 0.005;
//float bias = 0.005;
float biasx=bias;
float visibility = 1.0;
vec4 v1;
ShadowAngle=clamp(ShadowAngle,0.0f,1.0f);
//if (ShadowAngle<0.25f||ShadowAngle>0.75f) visibility=0.5f+ShadowAngle; else
if ( texture2D( shadowMap, ShadowCoord.xy ).z  <  ShadowCoord.z-biasx){ //.x should be .z but since we also do coloring in pass1, we can get away with it
    visibility = 0.5;
}
float glenzup=0.0;
if ( texture2D( glenzMap, ShadowCoord.xy ).z  <  ShadowCoord.z-biasx){ //.x should be .z but since we also do coloring in pass1, we can get away with it
    glenzup = 0.5;
}

if (ShadowCoord.x<0.0f) {visibility=1.0; glenzup=0.0;}
if (ShadowCoord.x>1.0f) {visibility=1.0; glenzup=0.0;}
if (ShadowCoord.y<0.0f) {visibility=1.0; glenzup=0.0;}
if (ShadowCoord.y>1.0f) {visibility=1.0; glenzup=0.0;}

    float r1=ShadowAngle;
    float g1=ShadowAngle;
    float b1=ShadowAngle;//0.5f;
    v1 = vec4((vec4(r1,g1,b1,1.0f)*visibility).rgb,1.0f);

vec4 v2 = vec4((vec4(r1,g1,b1,1.0f)*glenzup).rgb,1.0f);
//v2=v2*-1.0f;

	vec4 finalColor = (( vAmbient*base + accvDiffuse*base + accvSpecular)*v1+v2)*glColor;
    const vec4 fogColor = vec4(0.0f,0.0f,0.0f,0.0f);

//fogFactor = clamp(fogFactor, 0.0, 1.0);

//gl_FragColor = mix(gl_Fog.color, finalColor, fogFactor );
    //fogFactor=0.5f;
	gl_FragColor=mix(finalColor,fogColor,fogFactor);
}
